/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.gui.JRDataSourceProviderConnectionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JasperReport;

public class JRDataSourceProviderConnection
extends IReportConnection {
    private JRDataSourceProvider dsp;
    private JRDataSource ds;
    private HashMap properties = new HashMap();

    public JRDataSourceProvider getDataSourceProvider() {
        if (this.dsp == null && this.getProperties().get("JRDataSourceProvider") != null) {
            try {
                this.dsp = (JRDataSourceProvider)Class.forName((String)this.getProperties().get("JRDataSourceProvider"), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
            }
            catch (NoClassDefFoundError ex) {
                this.showErrorMessage(I18n.getString("messages.JRDataSourceProviderConnection.noClassDefFoundError", "No class definition found error!!\nCheck your classpath!"), I18n.getString("message.title.exception", "Exception"));
            }
            catch (ClassNotFoundException ex) {
                this.showErrorMessage(I18n.getString("messages.JRDataSourceProviderConnection.classNotFoundError", "Class not found error!!\nCheck your classpath!"), I18n.getString("message.title.exception", "Exception"));
            }
            catch (Exception ex) {
                this.showErrorMessage("" + ex.getMessage(), I18n.getString("message.title.exception", "Exception"));
            }
        }
        return this.dsp;
    }

    private void showErrorMessage(final String errorMsg, final String title) {
        Runnable r = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(MainFrame.getMainInstance(), errorMsg, title, 0);
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } else {
            r.run();
        }
    }

    public JRDataSource getJRDataSource() {
        return this.getJRDataSource(null);
    }

    public JRDataSource getJRDataSource(JasperReport jasper) {
        if (this.ds != null) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.JRDataSourceProviderConnection.datasourceInUse", "This datasource is already in use by another filling process!!"), I18n.getString("message.title.error", "Error"), 0);
            return null;
        }
        try {
            this.ds = this.getDataSourceProvider().create(jasper);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.JRDataSourceProviderConnection.problemsCreatingDatasource", "Problems occurred creating the new datasource!!\n{0}", new Object[]{"" + ex.getMessage()}), I18n.getString("message.title.error", "Error"), 0);
        }
        return this.ds;
    }

    public void disposeDataSource() {
        if (this.dsp != null) {
            try {
                this.dsp.dispose(this.ds);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ds = null;
        }
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void loadProperties(HashMap map) {
        this.properties = map;
    }

    public void save(PrintWriter pw) {
        HashMap hm = this.getProperties();
        pw.println("\t<iReportConnection name=\"" + this.getName() + "\" connectionClass=\"" + this.getClass().getName() + "\">");
        for (String key : hm.keySet()) {
            pw.println("\t\t<connectionParameter name=\"" + key + "\"><![CDATA[" + hm.get(key) + "]]></connectionParameter>");
        }
        pw.println("\t</iReportConnection>");
    }

    public String getDescription() {
        return I18n.getString("connectionType.datasourceProvider", "JRDataSourceProvider");
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JRDataSourceProviderConnectionEditor();
    }

    public void test() throws Exception {
        try {
            Class<?> c = Class.forName((String)this.getProperties().get("JRDataSourceProvider"), true, MainFrame.getMainInstance().getReportClassLoader());
            if (!JRDataSourceProvider.class.isAssignableFrom(c)) {
                JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.connectionDialog.invalidJRDataSourceProvider", "\"{0}\" is not a subclass of\nnet.sf.jasperreports.engine.JRDataSourceProvider.", new Object[]{this.getProperties().get("JRDataSourceProvider")}), I18n.getString("message.title.error", "Error"), 0);
                return;
            }
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.connectionDialog.connectionTestSuccessful", "Connection test successful!"), "", 1);
            return;
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.connection.noClassDefFoundError", "{0}\nNoClassDefFoundError!!\nCheck your classpath!\n{1}", new Object[]{"", "" + ex.getMessage()}), I18n.getString("message.title.exception", "Exception"), 0);
            return;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.connection.classNotFoundError", "{0}\nClassNotFoundError!\nMsg: {1}\nPossible not found class: {2}\nCheck your classpath!", new Object[]{"", "" + ex.getMessage(), "" + this.getProperties().get("JRDataSourceProvider")}), I18n.getString("message.title.exception", "Exception"), 0);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.connection.generalError2", "{0}\nGeneral problem:\n {1}", new Object[]{"", "" + ex.getMessage()}), I18n.getString("message.title.exception", "Exception"), 0);
            return;
        }
    }
}

