/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.skeleton;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import java.util.Iterator;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import net.charabia.jsmoothgen.skeleton.SkeletonPersistency;

public class SkeletonList {
    Hashtable m_skelsToDirs = new Hashtable();
    Hashtable m_nameToSkel = new Hashtable();
    Hashtable m_nameToDebugSkel = new Hashtable();
    Hashtable m_nameToNoDebugSkel = new Hashtable();

    public SkeletonList(File directoryToScan) {
        File[] subdirs = directoryToScan.listFiles();
        SkelSuffixFilter filter = new SkelSuffixFilter();
        for (int i = 0; i < subdirs.length; ++i) {
            if (!subdirs[i].isDirectory()) continue;
            File[] skeldescs = subdirs[i].listFiles(filter);
            for (int si = 0; si < skeldescs.length; ++si) {
                this.addSkeletonDirectory(subdirs[i], skeldescs[si]);
            }
        }
    }

    public void addSkeletonDirectory(File dir, File desc) {
        try {
            SkeletonBean skel = SkeletonPersistency.loadWithJox(desc);
            if (skel != null && skel.getShortName() != null) {
                this.m_skelsToDirs.put(skel, dir);
                if (!skel.isDebug()) {
                    this.m_nameToNoDebugSkel.put(skel.getShortName(), skel);
                } else {
                    this.m_nameToDebugSkel.put(skel.getShortName(), skel);
                }
                this.m_nameToSkel.put(skel.getShortName(), skel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.m_skelsToDirs.toString();
    }

    public Iterator getIteratorSkel() {
        return this.m_nameToSkel.values().iterator();
    }

    public Iterator getIteratorDebugSkel() {
        return this.m_nameToDebugSkel.values().iterator();
    }

    public File getDirectory(SkeletonBean skel) {
        return (File)this.m_skelsToDirs.get(skel);
    }

    public Iterator getIteratorName() {
        return this.m_nameToSkel.keySet().iterator();
    }

    public Iterator getIteratorDebugName() {
        return this.m_nameToDebugSkel.keySet().iterator();
    }

    public Iterator getIteratorNoDebugName() {
        return this.m_nameToNoDebugSkel.keySet().iterator();
    }

    public SkeletonBean getSkeleton(String name) {
        try {
            return new SkeletonBean((SkeletonBean)this.m_nameToSkel.get(name));
        }
        catch (Exception exc) {
            return null;
        }
    }

    public class SkelSuffixFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return pathname.toString().toLowerCase().endsWith(".skel");
        }
    }
}

