/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * TranslationOptionsDialog.java
 * 
 * Created on 22 maggio 2005, 0.39
 *
 */

package it.businesslogic.ireport.plugin.locale;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LocaleAdapter;
import it.businesslogic.ireport.util.Misc;
import java.awt.Cursor;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/**
 *
 * @author  Administrator
 */
public class QueryLocalesDialog extends javax.swing.JDialog implements JasperBabylonRunnerListener {
    
    private int dialogResult = JOptionPane.CANCEL_OPTION;
    private java.util.Properties localeProperties = null;
    private String locale_code = null;
    
    /**
     * Creates new form TranslationOptionsDialog
     */
    public QueryLocalesDialog(java.awt.Dialog parent, boolean modal) {
        super(parent, modal);
        initComponents();
        applyI18n();
        
        it.businesslogic.ireport.util.Misc.centerFrame(this);
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
            javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    jButton2ActionPerformed(e);
                }
            };

            getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, "ESCAPE");
            getRootPane().getActionMap().put("ESCAPE", escapeAction);


            this.jButtonImport.setEnabled(false);
            jList1.setModel(new DefaultListModel());
            
            //to make the default button ...
            this.getRootPane().setDefaultButton(this.jButton2);
    }
    
    public void setVisible(boolean b)
    {
        super.setVisible(b);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelJasperBabylon = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jSeparator1 = new javax.swing.JSeparator();
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jButtonImport = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jLabelJasperBabylon.setText("Available locales:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jLabelJasperBabylon, gridBagConstraints);

        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 200));
        jList1.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });

        jScrollPane1.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        jSeparator1.setMinimumSize(new java.awt.Dimension(0, 4));
        jSeparator1.setPreferredSize(new java.awt.Dimension(0, 4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 0);
        getContentPane().add(jSeparator1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jPanel2, gridBagConstraints);

        jButtonImport.setText("Import");
        jButtonImport.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonImportActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        jPanel1.add(jButtonImport, gridBagConstraints);

        jButton2.setText("Cancel");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 10);
        jPanel1.add(jButton2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged

        if (jList1.getSelectedIndex() >= 0 &&
            jList1.getSelectedValue() instanceof LocaleAdapter)
        {
            jButtonImport.setEnabled(true);
        }
        else
        {
            jButtonImport.setEnabled(false);
        }
        
    }//GEN-LAST:event_jList1ValueChanged

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        setVisible(false);
        dispose();
    }//GEN-LAST:event_jButton2ActionPerformed
    
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened

        JasperBabylonRunner jbr = new JasperBabylonRunner();
            jbr.setRunnerListener(this);
            ((DefaultListModel)jList1.getModel()).clear();
            ((DefaultListModel)jList1.getModel()).addElement("Reading locales...");     
            jList1.updateUI();
            jbr.listLocales();
    }//GEN-LAST:event_formWindowOpened
    
    private void jButtonImportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonImportActionPerformed

        
        JasperBabylonRunner jbr = new JasperBabylonRunner();
        jbr.setRunnerListener(this);
        LocaleAdapter la = (LocaleAdapter)jList1.getSelectedValue();
        
        String code = la.getLocale().getLanguage();
        if (la.getLocale().getCountry().length() > 0)
        {
            code += "_" + la.getLocale().getCountry();
        }
        if (la.getLocale().getVariant().length() > 0)
        {
            code += "_" + la.getLocale().getVariant();
        }
        
        
        this.setLocale_code(code);
        jbr.getLocale(code);

        this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR) );
        jButtonImport.setEnabled(false);
        
    }//GEN-LAST:event_jButtonImportActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButtonImport;
    private javax.swing.JLabel jLabelJasperBabylon;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables
    
    public void applyI18n(){
                
    }
    
    public void listLocalesComplete(java.util.List list)
    {
       ((DefaultListModel)jList1.getModel()).clear();
       Object[] ar = list.toArray();
       Arrays.sort(ar);
        
       for (int i=0; i<ar.length; ++i)
       {
           String code = "" + ar[i];
           Locale loc = Misc.getLocaleFromString(code);
           LocaleAdapter la = new LocaleAdapter(loc);
           ((DefaultListModel)jList1.getModel()).addElement(la);           
       }
       
       try {
       SwingUtilities.invokeAndWait(new Runnable() {
           public void run() {
                 jList1.updateUI();
           }
       });
       } catch (Exception ex){}
       
    }
    
    public void getLocaleComplete(java.util.Properties props)
    {
        setLocaleProperties(props);
        try {
        SwingUtilities.invokeAndWait(new Runnable() {
            public void run() {
                setCursor(Cursor.getDefaultCursor());
                setDialogResult(JOptionPane.OK_OPTION);
                setVisible(false);
                dispose();
            }
        });
        } catch (Exception ex){
            ex.printStackTrace();
        }
    }
    
    public void putLocaleComplete(String returnMessage)
    {
        
    }
    
    public void operationError(int operation, String message)
    {
        if (operation == JasperBabylonRunner.OP_GET_LOCALE)
        {
            try {
                final String msg = message;
                SwingUtilities.invokeAndWait(new Runnable() {
                    public void run() {
                        setCursor(Cursor.getDefaultCursor());
                        jList1ValueChanged(null);
                        JOptionPane.showMessageDialog(QueryLocalesDialog.this,msg);
                    }
                });
            } catch (Exception ex)
            {}
        }
        else
        {
            ((DefaultListModel)jList1.getModel()).clear();
            ((DefaultListModel)jList1.getModel()).addElement(message);
                        
            try {
                SwingUtilities.invokeAndWait(new Runnable() {
                    public void run() {
                        jList1.updateUI();
                    }
                });
            } catch (Exception ex)
            {}
        }
        
    }



    public java.util.Properties getLocaleProperties() {
        return localeProperties;
    }

    public void setLocaleProperties(java.util.Properties localeProperties) {
        this.localeProperties = localeProperties;
    }

    public String getLocale_code() {
        return locale_code;
    }

    public void setLocale_code(String locale_code) {
        this.locale_code = locale_code;
    }

    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}
