/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * FontSheetPropertyComponent.java
 * 
 * Created on 15 agosto 2005, 13.32
 *
 */

package it.businesslogic.ireport.gui.sheet;


import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.PropertiesDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import javax.swing.JOptionPane;

/**
 *
 * @author  Administrator
 */
public class PropertiesSheetPropertyComponent extends javax.swing.JPanel {
    
    private java.util.List propertiesList = null;

    public java.util.List getPropertiesList() {
        return propertiesList;
    }

    public void setPropertiesList(java.util.List propertiesList) {
        this.propertiesList = propertiesList;
        updateLabel();
    }
        
    /** Creates new form ExpressionSheetPanel */
    public PropertiesSheetPropertyComponent() {
        initComponents();
        
        
        I18n.addOnLanguageChangedListener(new LanguageChangedListener() {

            public void languageChanged(LanguageChangedEvent evt) {
                applyI18n();
            }
        });
        
        
        applyI18n();
    }
    
    public void listChanged()
    {
        java.awt.event.ActionEvent event = new java.awt.event.ActionEvent(this,0,"");
        fireActionListenerActionPerformed(event);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelList = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        setBackground(new java.awt.Color(255, 255, 255));
        setLayout(new java.awt.GridBagLayout());

        jLabelList.setBackground(new java.awt.Color(255, 255, 255));
        jLabelList.setOpaque(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        add(jLabelList, gridBagConstraints);

        jButton1.setText("...");
        jButton1.setMaximumSize(new java.awt.Dimension(19, 10));
        jButton1.setMinimumSize(new java.awt.Dimension(19, 10));
        jButton1.setPreferredSize(new java.awt.Dimension(19, 10));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(jButton1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

        PropertiesDialog pd = new PropertiesDialog(MainFrame.getMainInstance()  , true);
        pd.setProperties( getPropertiesList() );
        pd.setVisible(true);
        
        if (pd.getDialogResult() == JOptionPane.OK_OPTION)
        {
            this.setPropertiesList(pd.getProperties());
            listChanged();
        }
        
         
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabelList;
    // End of variables declaration//GEN-END:variables

    /**
     * Utility field used by event firing mechanism.
     */
    private javax.swing.event.EventListenerList listenerList =  null;

    /**
     * Registers ActionListener to receive events.
     * @param listener The listener to register.
     */
    public synchronized void addActionListener(java.awt.event.ActionListener listener) {

        if (listenerList == null ) {
            listenerList = new javax.swing.event.EventListenerList();
        }
        listenerList.add (java.awt.event.ActionListener.class, listener);
    }

    /**
     * Removes ActionListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public synchronized void removeActionListener(java.awt.event.ActionListener listener) {

        listenerList.remove (java.awt.event.ActionListener.class, listener);
    }

    /**
     * Notifies all registered listeners about the event.
     * 
     * @param event The event to be fired
     */
    private void fireActionListenerActionPerformed(java.awt.event.ActionEvent event) {

        if (listenerList == null) return;
        Object[] listeners = listenerList.getListenerList ();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i]==java.awt.event.ActionListener.class) {
                ((java.awt.event.ActionListener)listeners[i+1]).actionPerformed (event);
            }
        }
    }
 
    public void applyI18n(){
                // Start autogenerated code ----------------------
               // jButton1.setText(I18n.getString("fontSheetPropertyComponent.button1","..."));
                // End autogenerated code ----------------------
                updateLabel();
    }
    
    
     public void updateLabel()
     {
        try {
                    java.util.List list = getPropertiesList();
                    if (list == null)
                    {
                        jLabelList.setText("<null>");
                    }
                    else
                    {
                        jLabelList.setText( I18n.getFormattedString("listSheetPropertyComponent.label","{0} item(s)", new Object[]{new Integer(list.size())}) );
                    }    
                    
                    jLabelList.updateUI();

            } catch (Exception ex)
            {

            }
      }
}
