/*
 * ProblemsPanel.java
 *
 * Created on February 27, 2007, 10:55 AM
 */

package it.businesslogic.ireport.gui.logpane;

import it.businesslogic.ireport.compiler.ErrorLocator;
import it.businesslogic.ireport.compiler.xml.SourceLocation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author  gtoffoli
 */
public class ProblemsPanel extends javax.swing.JPanel implements ReportFrameActivatedListener{
    
    
    private ErrorLocator errorLocator = null;

            
            
    /** Creates new form ProblemsPanel */
    public ProblemsPanel() {
        initComponents();
        errorLocator = new ErrorLocator();
        jTable1.getColumnModel().getColumn(0).setMinWidth(20);
        jTable1.getColumnModel().getColumn(0).setMaxWidth(20);
        jTable1.getColumnModel().getColumn(0).setPreferredWidth(20);
        
        jTable1.getColumnModel().getColumn(0).setCellRenderer( new ProblemIconTableCellRenderer());
        jTable1.getColumnModel().getColumn(1).setPreferredWidth(300);
        jTable1.getColumnModel().getColumn(2).setPreferredWidth(150);
        jTable1.getColumnModel().getColumn(3).setPreferredWidth(550);
        
        
        
        MainFrame.getMainInstance().addReportFrameActivatedListener(this);
        setName( I18n.getFormattedString("problems","Problems ({0,number})", new Object[]{new Integer(0) }) );
        
        
        I18n.addOnLanguageChangedListener(new LanguageChangedListener() {
            public void languageChanged(LanguageChangedEvent evt) {
                applyI18n();
            }
        });

    }
    
    public void updateProblemsList()
    {
        JReportFrame rf = MainFrame.getMainInstance().getActiveReportFrame();
        
        if (rf != null)
        {
            setProblems( rf.getReportProblems() );
        }
        else
        {
            DefaultTableModel dtm = (DefaultTableModel) jTable1.getModel();
            dtm.setRowCount(0);
        }
        this.updateUI();
    }
    
    public void setProblems(java.util.List problems)
    {
        DefaultTableModel dtm = (DefaultTableModel) jTable1.getModel();
        dtm.setRowCount(0);
        for (int i=0; i<problems.size(); ++i)
        {
            ProblemItem pi = (ProblemItem) problems.get(i);
            addProblem(pi);
        }
        
        updateName();
    }
    
    public void addProblem(ProblemItem pi)
    {
        String pWhere = pi.getWhere();
        String location = "";
        if (pi.getProblemReference() != null &&
            pi.getProblemReference() instanceof SourceLocation)
        {
           SourceLocation sl = (SourceLocation)pi.getProblemReference();
           location = I18n.getFormattedString("LineColumn",
                        "Line {0,number,integer}, Column {1,number,integer}", 
                        new Object[]{new Integer(sl.getLineNumber()), new Integer(sl.getColumnNumber()) });
        }
        DefaultTableModel dtm = (DefaultTableModel) jTable1.getModel();
        dtm.addRow( new Object[]{ pi, pi.getDescription(), location, pWhere});
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                " ", "Description", "Location", "Element"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Object.class, java.lang.String.class, java.lang.Object.class, java.lang.Object.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTable1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTable1MouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void jTable1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTable1MouseClicked

        System.out.flush();
            if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt))
            {
               
                if (jTable1.getSelectedRow() >= 0)
                {
                    ProblemItem pi = (ProblemItem)jTable1.getValueAt(jTable1.getSelectedRow(),0);
                    errorLocator.parseError( pi.getWhere(), pi.getDescription() );
               }
            }
    }//GEN-LAST:event_jTable1MouseClicked

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        if (evt.getReportFrame() != null)
        {
            setProblems( evt.getReportFrame().getReportProblems() );
        }
        else
        {
            DefaultTableModel dtm = (DefaultTableModel) jTable1.getModel();
            dtm.setRowCount(0);
        }

        errorLocator.setJReportFrame(evt.getReportFrame());
    }
    
    
    public void updateName()
    {
        setName( I18n.getFormattedString("problems","Problems ({0,number})", new Object[]{new Integer(jTable1.getRowCount()) }) );
        
        if (this.getParent() != null && this.getParent() instanceof JTabbedPane)
        {
            JTabbedPane tp = (JTabbedPane)this.getParent();
            try {
                
                
                if (jTable1.getRowCount() > 0)
                {
                    tp.setIconAt(1, ProblemIconTableCellRenderer.errorIcon );
                    tp.setTitleAt(1, "<html><font color=\"red\">" + getName());
                }
                else
                {
                    tp.setIconAt(1, null );
                    tp.setTitleAt(1, getName());
                }
        
            
            } catch (Exception ex)
            {
                
            }
        }
    }
    
    public void applyI18n()
    {
        jTable1.getColumnModel().getColumn(1).setHeaderValue( I18n.getString("problemsPanel.table.description","Description") );
        jTable1.getColumnModel().getColumn(2).setHeaderValue( I18n.getString("problemsPanel.table.location","JRXML location") );
        jTable1.getColumnModel().getColumn(3).setHeaderValue( I18n.getString("problemsPanel.table.object","Object") );
    }

     
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables
    
}
