/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * ToolbarFormatPanel.java
 * 
 * Created on 7 mei 2005, 13:27
 *
 */

package it.businesslogic.ireport.gui;
import javax.swing.JToolBar;
import it.businesslogic.ireport.OperationType;
import it.businesslogic.ireport.gui.actions.ActionShrinkSelected;
import it.businesslogic.ireport.gui.command.FormatCommand;
import javax.swing.Action;
import javax.swing.KeyStroke;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;

/**
 *
 * @author Robert Lamping
 */
public class ToolbarFormatPanel extends javax.swing.JPanel implements LanguageChangedListener
{

    private MainFrame mainFrame; // MainFrame.getMainInstance();;

    /** Creates new form ToolbarFormatPanel */
    public ToolbarFormatPanel(MainFrame mainFrame )
    {
        setMainFrame( mainFrame );
        initComponents();



    }

    public JToolBar getToolBar()
    {
        // Make toolbar available to e.g. MainFrame
        return jToolBarFormat;
    }


    /**
     * enable/disable tools that can't be used in a crosstab...
     */
    public void setCrosstabMode(boolean bMode)
    {
        jButtonFormatAlignToBandBottom.setEnabled(bMode);
        jButtonFormatAlignToBandTop.setEnabled(bMode);
        //jButtonFormatCenterHRight.setEnabled(bMode);
        //jButtonFormatCenterInBand.setEnabled(bMode);
        //jButtonFormatCenterInBandH.setEnabled(bMode);
        //jButtonFormatCenterInBandV.setEnabled(bMode);
        jButtonFormatAlignToLeftMargin.setEnabled(bMode);
        jButtonFormatAlignToRightMargin.setEnabled(bMode);
        //jButtonFormatCenterVRight.setEnabled(bMode);
        jButtonFormatOrganize.setEnabled(bMode);
        jButtonFormatShrink.setEnabled(bMode);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jToolBarFormat = new javax.swing.JToolBar();
        jButtonFormatAlignTop = new javax.swing.JButton();
        jButtonFormatAlignBottom = new javax.swing.JButton();
        jButtonFormatAlignLeft = new javax.swing.JButton();
        jButtonFormatAlignRight = new javax.swing.JButton();
        jButtonFormatCenterHRight = new javax.swing.JButton();
        jButtonFormatCenterVRight = new javax.swing.JButton();
        Filler = new javax.swing.JButton();
        jButtonFormatAlignToBandTop = new javax.swing.JButton();
        jButtonFormatAlignToBandBottom = new javax.swing.JButton();
        jButtonFormatAlignToLeftMargin = new javax.swing.JButton();
        jButtonFormatAlignToRightMargin = new javax.swing.JButton();
        Filler1 = new javax.swing.JButton();
        jButtonFormatOrganize = new javax.swing.JButton();
        jButtonFormatJoinLeft = new javax.swing.JButton();
        jButtonFormatJoinRight = new javax.swing.JButton();
        Filler4 = new javax.swing.JButton();
        jButtonFormatEqualsSpaceH = new javax.swing.JButton();
        jButtonFormatIncreaseSpaceH = new javax.swing.JButton();
        jButtonFormatDecreaseSpaceH = new javax.swing.JButton();
        jButtonFormatRemoveSpaceH = new javax.swing.JButton();
        Filler5 = new javax.swing.JButton();
        jButtonFormatEqualsSpaceV = new javax.swing.JButton();
        jButtonFormatIncreaseSpaceV = new javax.swing.JButton();
        jButtonFormatDecreaseSpaceV = new javax.swing.JButton();
        jButtonFormatDecreaseSpaceV1 = new javax.swing.JButton();
        Filler6 = new javax.swing.JButton();
        jButtonFormatSameWidth = new javax.swing.JButton();
        jButtonFormatSameWidthMax = new javax.swing.JButton();
        jButtonFormatSameWidthMin = new javax.swing.JButton();
        Filler2 = new javax.swing.JButton();
        jButtonFormatSameHeight = new javax.swing.JButton();
        jButtonFormatSameHeightMin = new javax.swing.JButton();
        jButtonFormatSameHeightMax = new javax.swing.JButton();
        Filler3 = new javax.swing.JButton();
        jButtonFormatSameSize = new javax.swing.JButton();
        Filler9 = new javax.swing.JButton();
        jButtonFormatElementMaximizeH = new javax.swing.JButton();
        jButtonFormatElementMaximizeV = new javax.swing.JButton();
        jButtonFormatElementMaximize = new javax.swing.JButton();
        Filler7 = new javax.swing.JButton();
        jButtonFormatCenterInBandH = new javax.swing.JButton();
        jButtonFormatCenterInBandV = new javax.swing.JButton();
        jButtonFormatCenterInBand = new javax.swing.JButton();
        Filler8 = new javax.swing.JButton();
        jButtonFormatShrink = new javax.swing.JButton();
        jButtonFormatShrink.putClientProperty("hideActionText", Boolean.TRUE);

        jToggleButton1 = new javax.swing.JToggleButton();

        setLayout(new java.awt.BorderLayout());

        setAutoscrolls(true);
        setName("ToolbarFormatPanel");
        getAccessibleContext().setAccessibleName("ToolbarFormatPanel");
        jToolBarFormat.setAutoscrolls(true);
        jToolBarFormat.setMaximumSize(new java.awt.Dimension(934, 48));
        jToolBarFormat.setMinimumSize(new java.awt.Dimension(814, 27));
        jToolBarFormat.setPreferredSize(new java.awt.Dimension(814, 27));
        jButtonFormatAlignTop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_top.png")));
        jButtonFormatAlignTop.setToolTipText("Align Top");
        jButtonFormatAlignTop.setBorder(null);
        jButtonFormatAlignTop.setBorderPainted(false);
        jButtonFormatAlignTop.setEnabled(false);
        jButtonFormatAlignTop.setFocusPainted(false);
        jButtonFormatAlignTop.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignTop.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignTop.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignTop.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignTop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignTopActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignTop);

        jButtonFormatAlignBottom.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_bottom.png")));
        jButtonFormatAlignBottom.setToolTipText("Align bottom");
        jButtonFormatAlignBottom.setBorder(null);
        jButtonFormatAlignBottom.setBorderPainted(false);
        jButtonFormatAlignBottom.setEnabled(false);
        jButtonFormatAlignBottom.setFocusPainted(false);
        jButtonFormatAlignBottom.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignBottom.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignBottom.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignBottom.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignBottom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignBottomActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignBottom);

        jButtonFormatAlignLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_left.png")));
        jButtonFormatAlignLeft.setToolTipText("Align left");
        jButtonFormatAlignLeft.setBorder(null);
        jButtonFormatAlignLeft.setBorderPainted(false);
        jButtonFormatAlignLeft.setEnabled(false);
        jButtonFormatAlignLeft.setFocusPainted(false);
        jButtonFormatAlignLeft.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignLeft.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignLeft.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignLeft.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignLeftActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignLeft);

        jButtonFormatAlignRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_right.png")));
        jButtonFormatAlignRight.setToolTipText("Align right");
        jButtonFormatAlignRight.setBorder(null);
        jButtonFormatAlignRight.setBorderPainted(false);
        jButtonFormatAlignRight.setEnabled(false);
        jButtonFormatAlignRight.setFocusPainted(false);
        jButtonFormatAlignRight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignRight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignRight.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignRight.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatAlignRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignRightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignRight);

        jButtonFormatCenterHRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/center_h.png")));
        jButtonFormatCenterHRight.setToolTipText("Align horizontal axis");
        jButtonFormatCenterHRight.setBorder(null);
        jButtonFormatCenterHRight.setBorderPainted(false);
        jButtonFormatCenterHRight.setEnabled(false);
        jButtonFormatCenterHRight.setFocusPainted(false);
        jButtonFormatCenterHRight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterHRight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterHRight.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatCenterHRight.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatCenterHRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterHRightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterHRight);

        jButtonFormatCenterVRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/center_v.png")));
        jButtonFormatCenterVRight.setToolTipText("Align vertical axis");
        jButtonFormatCenterVRight.setBorder(null);
        jButtonFormatCenterVRight.setBorderPainted(false);
        jButtonFormatCenterVRight.setEnabled(false);
        jButtonFormatCenterVRight.setFocusPainted(false);
        jButtonFormatCenterVRight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterVRight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterVRight.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatCenterVRight.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatCenterVRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterVRightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterVRight);

        Filler.setBackground(new java.awt.Color(255, 255, 255));
        Filler.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler.setBorderPainted(false);
        Filler.setContentAreaFilled(false);
        Filler.setEnabled(false);
        Filler.setFocusPainted(false);
        Filler.setFocusable(false);
        Filler.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler);

        jButtonFormatAlignToBandTop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_top_band.png")));
        jButtonFormatAlignToBandTop.setToolTipText("Align to band top");
        jButtonFormatAlignToBandTop.setBorder(null);
        jButtonFormatAlignToBandTop.setBorderPainted(false);
        jButtonFormatAlignToBandTop.setEnabled(false);
        jButtonFormatAlignToBandTop.setFocusPainted(false);
        jButtonFormatAlignToBandTop.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignToBandTop.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignToBandTop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignToBandTopActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignToBandTop);

        jButtonFormatAlignToBandBottom.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_bottom_band.png")));
        jButtonFormatAlignToBandBottom.setToolTipText("Align to band bottom");
        jButtonFormatAlignToBandBottom.setBorder(null);
        jButtonFormatAlignToBandBottom.setBorderPainted(false);
        jButtonFormatAlignToBandBottom.setEnabled(false);
        jButtonFormatAlignToBandBottom.setFocusPainted(false);
        jButtonFormatAlignToBandBottom.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignToBandBottom.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignToBandBottom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignToBandBottomActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignToBandBottom);

        jButtonFormatAlignToLeftMargin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_margin_left.png")));
        jButtonFormatAlignToLeftMargin.setToolTipText("Align to left margin");
        jButtonFormatAlignToLeftMargin.setBorder(null);
        jButtonFormatAlignToLeftMargin.setBorderPainted(false);
        jButtonFormatAlignToLeftMargin.setEnabled(false);
        jButtonFormatAlignToLeftMargin.setFocusPainted(false);
        jButtonFormatAlignToLeftMargin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignToLeftMargin.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignToLeftMargin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignToLeftMarginActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignToLeftMargin);

        jButtonFormatAlignToRightMargin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/align_margin_right.png")));
        jButtonFormatAlignToRightMargin.setToolTipText("Align to right margin");
        jButtonFormatAlignToRightMargin.setBorder(null);
        jButtonFormatAlignToRightMargin.setBorderPainted(false);
        jButtonFormatAlignToRightMargin.setEnabled(false);
        jButtonFormatAlignToRightMargin.setFocusPainted(false);
        jButtonFormatAlignToRightMargin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatAlignToRightMargin.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatAlignToRightMargin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatAlignToRightMarginActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatAlignToRightMargin);

        Filler1.setBackground(new java.awt.Color(255, 255, 255));
        Filler1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler1.setBorderPainted(false);
        Filler1.setContentAreaFilled(false);
        Filler1.setEnabled(false);
        Filler1.setFocusPainted(false);
        Filler1.setFocusable(false);
        Filler1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler1.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler1.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler1.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler1);

        jButtonFormatOrganize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/organize.png")));
        jButtonFormatOrganize.setToolTipText("Organize as a table: [CTRL+SHIFT+O]");
        jButtonFormatOrganize.setBorder(null);
        jButtonFormatOrganize.setBorderPainted(false);
        jButtonFormatOrganize.setEnabled(false);
        jButtonFormatOrganize.setFocusPainted(false);
        jButtonFormatOrganize.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatOrganize.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatOrganize.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatOrganize.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatOrganize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatOrganizeActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatOrganize);

        jButtonFormatJoinLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/joinleft.png")));
        jButtonFormatJoinLeft.setToolTipText("Join sides Left: [CTRL+SHIFT+L]");
        jButtonFormatJoinLeft.setBorder(null);
        jButtonFormatJoinLeft.setBorderPainted(false);
        jButtonFormatJoinLeft.setEnabled(false);
        jButtonFormatJoinLeft.setFocusPainted(false);
        jButtonFormatJoinLeft.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatJoinLeft.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatJoinLeft.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatJoinLeft.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatJoinLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatJoinLeftActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatJoinLeft);

        jButtonFormatJoinRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/joinright.png")));
        jButtonFormatJoinRight.setToolTipText("Join sides right: [CTRL+SHIFT+R]");
        jButtonFormatJoinRight.setBorder(null);
        jButtonFormatJoinRight.setBorderPainted(false);
        jButtonFormatJoinRight.setEnabled(false);
        jButtonFormatJoinRight.setFocusPainted(false);
        jButtonFormatJoinRight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatJoinRight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatJoinRight.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatJoinRight.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatJoinRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatJoinRightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatJoinRight);

        Filler4.setBackground(new java.awt.Color(255, 255, 255));
        Filler4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler4.setBorderPainted(false);
        Filler4.setContentAreaFilled(false);
        Filler4.setEnabled(false);
        Filler4.setFocusPainted(false);
        Filler4.setFocusable(false);
        Filler4.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler4.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler4.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler4.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler4);

        jButtonFormatEqualsSpaceH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_hspace.png")));
        jButtonFormatEqualsSpaceH.setToolTipText("Horizontal space: Make equal");
        jButtonFormatEqualsSpaceH.setBorder(null);
        jButtonFormatEqualsSpaceH.setBorderPainted(false);
        jButtonFormatEqualsSpaceH.setEnabled(false);
        jButtonFormatEqualsSpaceH.setFocusPainted(false);
        jButtonFormatEqualsSpaceH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatEqualsSpaceH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatEqualsSpaceH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatEqualsSpaceHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatEqualsSpaceH);

        jButtonFormatIncreaseSpaceH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_hspace_plus.png")));
        jButtonFormatIncreaseSpaceH.setToolTipText("Horizontal space: Increase");
        jButtonFormatIncreaseSpaceH.setBorder(null);
        jButtonFormatIncreaseSpaceH.setBorderPainted(false);
        jButtonFormatIncreaseSpaceH.setEnabled(false);
        jButtonFormatIncreaseSpaceH.setFocusPainted(false);
        jButtonFormatIncreaseSpaceH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatIncreaseSpaceH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatIncreaseSpaceH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatIncreaseSpaceHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatIncreaseSpaceH);

        jButtonFormatDecreaseSpaceH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_hspace_min.png")));
        jButtonFormatDecreaseSpaceH.setToolTipText("Horizontal space: Decrease");
        jButtonFormatDecreaseSpaceH.setBorder(null);
        jButtonFormatDecreaseSpaceH.setBorderPainted(false);
        jButtonFormatDecreaseSpaceH.setEnabled(false);
        jButtonFormatDecreaseSpaceH.setFocusPainted(false);
        jButtonFormatDecreaseSpaceH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatDecreaseSpaceH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatDecreaseSpaceH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatDecreaseSpaceHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatDecreaseSpaceH);

        jButtonFormatRemoveSpaceH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_hspace_zero.png")));
        jButtonFormatRemoveSpaceH.setToolTipText("Horizontal space: Remove");
        jButtonFormatRemoveSpaceH.setBorder(null);
        jButtonFormatRemoveSpaceH.setBorderPainted(false);
        jButtonFormatRemoveSpaceH.setEnabled(false);
        jButtonFormatRemoveSpaceH.setFocusPainted(false);
        jButtonFormatRemoveSpaceH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatRemoveSpaceH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatRemoveSpaceH.setMinimumSize(new java.awt.Dimension(22, 22));
        jButtonFormatRemoveSpaceH.setPreferredSize(new java.awt.Dimension(22, 22));
        jButtonFormatRemoveSpaceH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatRemoveSpaceHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatRemoveSpaceH);

        Filler5.setBackground(new java.awt.Color(255, 255, 255));
        Filler5.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler5.setBorderPainted(false);
        Filler5.setContentAreaFilled(false);
        Filler5.setEnabled(false);
        Filler5.setFocusPainted(false);
        Filler5.setFocusable(false);
        Filler5.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler5.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler5.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler5.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler5);

        jButtonFormatEqualsSpaceV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_vspace.png")));
        jButtonFormatEqualsSpaceV.setToolTipText("Vertical space: Make equal");
        jButtonFormatEqualsSpaceV.setBorder(null);
        jButtonFormatEqualsSpaceV.setBorderPainted(false);
        jButtonFormatEqualsSpaceV.setEnabled(false);
        jButtonFormatEqualsSpaceV.setFocusPainted(false);
        jButtonFormatEqualsSpaceV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatEqualsSpaceV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatEqualsSpaceV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatEqualsSpaceVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatEqualsSpaceV);

        jButtonFormatIncreaseSpaceV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_vspace_plus.png")));
        jButtonFormatIncreaseSpaceV.setToolTipText("Vertical space: Increase");
        jButtonFormatIncreaseSpaceV.setBorder(null);
        jButtonFormatIncreaseSpaceV.setBorderPainted(false);
        jButtonFormatIncreaseSpaceV.setEnabled(false);
        jButtonFormatIncreaseSpaceV.setFocusPainted(false);
        jButtonFormatIncreaseSpaceV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatIncreaseSpaceV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatIncreaseSpaceV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatIncreaseSpaceVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatIncreaseSpaceV);

        jButtonFormatDecreaseSpaceV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_vspace_min.png")));
        jButtonFormatDecreaseSpaceV.setToolTipText("Vertical space: Decrease");
        jButtonFormatDecreaseSpaceV.setBorder(null);
        jButtonFormatDecreaseSpaceV.setBorderPainted(false);
        jButtonFormatDecreaseSpaceV.setEnabled(false);
        jButtonFormatDecreaseSpaceV.setFocusPainted(false);
        jButtonFormatDecreaseSpaceV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatDecreaseSpaceV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatDecreaseSpaceV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatDecreaseSpaceVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatDecreaseSpaceV);

        jButtonFormatDecreaseSpaceV1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_add_vspace_zero.png")));
        jButtonFormatDecreaseSpaceV1.setToolTipText("Vertical space: remove");
        jButtonFormatDecreaseSpaceV1.setBorder(null);
        jButtonFormatDecreaseSpaceV1.setBorderPainted(false);
        jButtonFormatDecreaseSpaceV1.setEnabled(false);
        jButtonFormatDecreaseSpaceV1.setFocusPainted(false);
        jButtonFormatDecreaseSpaceV1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatDecreaseSpaceV1.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatDecreaseSpaceV1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatDecreaseSpaceV1ActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatDecreaseSpaceV1);

        Filler6.setBackground(new java.awt.Color(255, 255, 255));
        Filler6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler6.setBorderPainted(false);
        Filler6.setContentAreaFilled(false);
        Filler6.setEnabled(false);
        Filler6.setFocusPainted(false);
        Filler6.setFocusable(false);
        Filler6.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler6.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler6.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler6.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler6);

        jButtonFormatSameWidth.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize.png")));
        jButtonFormatSameWidth.setToolTipText("Same width");
        jButtonFormatSameWidth.setBorder(null);
        jButtonFormatSameWidth.setBorderPainted(false);
        jButtonFormatSameWidth.setEnabled(false);
        jButtonFormatSameWidth.setFocusPainted(false);
        jButtonFormatSameWidth.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameWidth.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameWidth.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameWidthActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameWidth);

        jButtonFormatSameWidthMax.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_plus.png")));
        jButtonFormatSameWidthMax.setToolTipText("Same width (max)");
        jButtonFormatSameWidthMax.setBorder(null);
        jButtonFormatSameWidthMax.setBorderPainted(false);
        jButtonFormatSameWidthMax.setEnabled(false);
        jButtonFormatSameWidthMax.setFocusPainted(false);
        jButtonFormatSameWidthMax.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameWidthMax.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameWidthMax.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameWidthMaxActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameWidthMax);

        jButtonFormatSameWidthMin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_min.png")));
        jButtonFormatSameWidthMin.setToolTipText("Same width (min)");
        jButtonFormatSameWidthMin.setBorder(null);
        jButtonFormatSameWidthMin.setBorderPainted(false);
        jButtonFormatSameWidthMin.setEnabled(false);
        jButtonFormatSameWidthMin.setFocusPainted(false);
        jButtonFormatSameWidthMin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameWidthMin.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameWidthMin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameWidthMinActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameWidthMin);

        Filler2.setBackground(new java.awt.Color(255, 255, 255));
        Filler2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler2.setBorderPainted(false);
        Filler2.setContentAreaFilled(false);
        Filler2.setEnabled(false);
        Filler2.setFocusPainted(false);
        Filler2.setFocusable(false);
        Filler2.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler2.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler2.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler2.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler2);

        jButtonFormatSameHeight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize.png")));
        jButtonFormatSameHeight.setToolTipText("Same height");
        jButtonFormatSameHeight.setBorder(null);
        jButtonFormatSameHeight.setBorderPainted(false);
        jButtonFormatSameHeight.setEnabled(false);
        jButtonFormatSameHeight.setFocusPainted(false);
        jButtonFormatSameHeight.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameHeight.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameHeight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameHeightActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameHeight);

        jButtonFormatSameHeightMin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_min.png")));
        jButtonFormatSameHeightMin.setToolTipText("Same height (min)");
        jButtonFormatSameHeightMin.setBorder(null);
        jButtonFormatSameHeightMin.setBorderPainted(false);
        jButtonFormatSameHeightMin.setEnabled(false);
        jButtonFormatSameHeightMin.setFocusPainted(false);
        jButtonFormatSameHeightMin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameHeightMin.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameHeightMin.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameHeightMinActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameHeightMin);

        jButtonFormatSameHeightMax.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_plus.png")));
        jButtonFormatSameHeightMax.setToolTipText("Same heigt (max)");
        jButtonFormatSameHeightMax.setBorder(null);
        jButtonFormatSameHeightMax.setBorderPainted(false);
        jButtonFormatSameHeightMax.setEnabled(false);
        jButtonFormatSameHeightMax.setFocusPainted(false);
        jButtonFormatSameHeightMax.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameHeightMax.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameHeightMax.setOpaque(false);
        jButtonFormatSameHeightMax.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameHeightMaxActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameHeightMax);

        Filler3.setBackground(new java.awt.Color(255, 255, 255));
        Filler3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler3.setBorderPainted(false);
        Filler3.setContentAreaFilled(false);
        Filler3.setEnabled(false);
        Filler3.setFocusPainted(false);
        Filler3.setFocusable(false);
        Filler3.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler3.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler3.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler3.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler3);

        jButtonFormatSameSize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_size.png")));
        jButtonFormatSameSize.setToolTipText("Same size");
        jButtonFormatSameSize.setBorder(null);
        jButtonFormatSameSize.setBorderPainted(false);
        jButtonFormatSameSize.setEnabled(false);
        jButtonFormatSameSize.setFocusPainted(false);
        jButtonFormatSameSize.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatSameSize.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatSameSize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatSameSizeActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatSameSize);

        Filler9.setBackground(new java.awt.Color(255, 255, 255));
        Filler9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler9.setBorderPainted(false);
        Filler9.setContentAreaFilled(false);
        Filler9.setEnabled(false);
        Filler9.setFocusPainted(false);
        Filler9.setFocusable(false);
        Filler9.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler9.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler9.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler9.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler9);

        jButtonFormatElementMaximizeH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_hmaximise.png")));
        jButtonFormatElementMaximizeH.setToolTipText("Enlarge between margins");
        jButtonFormatElementMaximizeH.setBorder(null);
        jButtonFormatElementMaximizeH.setBorderPainted(false);
        jButtonFormatElementMaximizeH.setEnabled(false);
        jButtonFormatElementMaximizeH.setFocusPainted(false);
        jButtonFormatElementMaximizeH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatElementMaximizeH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatElementMaximizeH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatElementMaximizeHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatElementMaximizeH);

        jButtonFormatElementMaximizeV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vmaximise.png")));
        jButtonFormatElementMaximizeV.setToolTipText("Enlarge to band height");
        jButtonFormatElementMaximizeV.setBorder(null);
        jButtonFormatElementMaximizeV.setBorderPainted(false);
        jButtonFormatElementMaximizeV.setEnabled(false);
        jButtonFormatElementMaximizeV.setFocusPainted(false);
        jButtonFormatElementMaximizeV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatElementMaximizeV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatElementMaximizeV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatElementMaximizeVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatElementMaximizeV);

        jButtonFormatElementMaximize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_maximise.png")));
        jButtonFormatElementMaximize.setToolTipText("Enlarge between margins and to band height");
        jButtonFormatElementMaximize.setBorder(null);
        jButtonFormatElementMaximize.setBorderPainted(false);
        jButtonFormatElementMaximize.setEnabled(false);
        jButtonFormatElementMaximize.setFocusPainted(false);
        jButtonFormatElementMaximize.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatElementMaximize.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatElementMaximize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatElementMaximizeActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatElementMaximize);

        Filler7.setBackground(new java.awt.Color(255, 255, 255));
        Filler7.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler7.setBorderPainted(false);
        Filler7.setContentAreaFilled(false);
        Filler7.setEnabled(false);
        Filler7.setFocusPainted(false);
        Filler7.setFocusable(false);
        Filler7.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler7.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler7.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler7.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler7);

        jButtonFormatCenterInBandH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_hcenter.png")));
        jButtonFormatCenterInBandH.setToolTipText("Center between margins or in the cell");
        jButtonFormatCenterInBandH.setBorder(null);
        jButtonFormatCenterInBandH.setBorderPainted(false);
        jButtonFormatCenterInBandH.setEnabled(false);
        jButtonFormatCenterInBandH.setFocusPainted(false);
        jButtonFormatCenterInBandH.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterInBandH.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterInBandH.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterInBandHActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterInBandH);

        jButtonFormatCenterInBandV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vcenter.png")));
        jButtonFormatCenterInBandV.setToolTipText("Vertically center in band/cell");
        jButtonFormatCenterInBandV.setBorder(null);
        jButtonFormatCenterInBandV.setBorderPainted(false);
        jButtonFormatCenterInBandV.setEnabled(false);
        jButtonFormatCenterInBandV.setFocusPainted(false);
        jButtonFormatCenterInBandV.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterInBandV.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterInBandV.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterInBandVActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterInBandV);

        jButtonFormatCenterInBand.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_ccenter.png")));
        jButtonFormatCenterInBand.setToolTipText("Center in band/cell");
        jButtonFormatCenterInBand.setBorder(null);
        jButtonFormatCenterInBand.setBorderPainted(false);
        jButtonFormatCenterInBand.setEnabled(false);
        jButtonFormatCenterInBand.setFocusPainted(false);
        jButtonFormatCenterInBand.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatCenterInBand.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatCenterInBand.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFormatCenterInBandActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jButtonFormatCenterInBand);

        Filler8.setBackground(new java.awt.Color(255, 255, 255));
        Filler8.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
        Filler8.setBorderPainted(false);
        Filler8.setContentAreaFilled(false);
        Filler8.setEnabled(false);
        Filler8.setFocusPainted(false);
        Filler8.setFocusable(false);
        Filler8.setMargin(new java.awt.Insets(0, 0, 0, 0));
        Filler8.setMaximumSize(new java.awt.Dimension(4, 22));
        Filler8.setMinimumSize(new java.awt.Dimension(4, 22));
        Filler8.setPreferredSize(new java.awt.Dimension(4, 22));
        jToolBarFormat.add(Filler8);

        jButtonFormatShrink.setAction(new ActionShrinkSelected());
        jButtonFormatShrink.setEnabled(false);
        jButtonFormatShrink.setFocusPainted(false);
        jButtonFormatShrink.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButtonFormatShrink.setMaximumSize(new java.awt.Dimension(24, 23));
        jButtonFormatShrink.setMinimumSize(new java.awt.Dimension(22, 21));
        jButtonFormatShrink.setPreferredSize(new java.awt.Dimension(22, 21));
        jButtonFormatShrink.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                jButtonFormatShrinkAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });

        jToolBarFormat.add(jButtonFormatShrink);

        jToggleButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/magnet.png")));
        jToggleButton1.setBorder(null);
        jToggleButton1.setBorderPainted(false);
        jToggleButton1.setEnabled(false);
        jToggleButton1.setFocusPainted(false);
        jToggleButton1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jToggleButton1.setMaximumSize(new java.awt.Dimension(24, 23));
        jToggleButton1.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/toolbars/format/magnet2.png")));
        jToggleButton1.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButton1ItemStateChanged(evt);
            }
        });
        jToggleButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton1ActionPerformed(evt);
            }
        });

        jToolBarFormat.add(jToggleButton1);

        add(jToolBarFormat, java.awt.BorderLayout.NORTH);

    }// </editor-fold>//GEN-END:initComponents

    private void jToggleButton1ItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButton1ItemStateChanged
        MainFrame.getMainInstance().setMagnetEnabled( !jToggleButton1.isSelected() );
    }//GEN-LAST:event_jToggleButton1ItemStateChanged

    private void jToggleButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton1ActionPerformed

         
        
    }//GEN-LAST:event_jToggleButton1ActionPerformed

    private void jButtonFormatShrinkAncestorAdded(javax.swing.event.AncestorEvent evt)//GEN-FIRST:event_jButtonFormatShrinkAncestorAdded
    {//GEN-HEADEREND:event_jButtonFormatShrinkAncestorAdded
// TODO add your handling code here:
    }//GEN-LAST:event_jButtonFormatShrinkAncestorAdded

    private void jButtonFormatCenterInBandActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterInBandActionPerformed
        FormatCommand.getCommand( OperationType.CENTER_IN_BAND).execute();
    }//GEN-LAST:event_jButtonFormatCenterInBandActionPerformed

    private void jButtonFormatCenterInBandVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterInBandVActionPerformed
        FormatCommand.getCommand( OperationType.CENTER_IN_BAND_V).execute();
    }//GEN-LAST:event_jButtonFormatCenterInBandVActionPerformed

    private void jButtonFormatCenterInBandHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterInBandHActionPerformed
        FormatCommand.getCommand( OperationType.CENTER_IN_BAND_H).execute();

    }//GEN-LAST:event_jButtonFormatCenterInBandHActionPerformed

    private void jButtonFormatElementMaximizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatElementMaximizeActionPerformed
        FormatCommand.getCommand( OperationType.ELEMENT_MAXIMIZE).execute();
    }//GEN-LAST:event_jButtonFormatElementMaximizeActionPerformed

    private void jButtonFormatElementMaximizeVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatElementMaximizeVActionPerformed
        FormatCommand.getCommand( OperationType.ELEMENT_MAXIMIZE_V).execute();
    }//GEN-LAST:event_jButtonFormatElementMaximizeVActionPerformed

    private void jButtonFormatElementMaximizeHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatElementMaximizeHActionPerformed
        FormatCommand.getCommand( OperationType.ELEMENT_MAXIMIZE_H).execute();
    }//GEN-LAST:event_jButtonFormatElementMaximizeHActionPerformed

    private void jButtonFormatDecreaseSpaceV1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatDecreaseSpaceV1ActionPerformed
        FormatCommand.getCommand( OperationType.REMOVE_SPACE_V).execute();
    }//GEN-LAST:event_jButtonFormatDecreaseSpaceV1ActionPerformed

    private void jButtonFormatDecreaseSpaceVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatDecreaseSpaceVActionPerformed
        FormatCommand.getCommand( OperationType.DECREASE_SPACE_V).execute();
    }//GEN-LAST:event_jButtonFormatDecreaseSpaceVActionPerformed

    private void jButtonFormatIncreaseSpaceVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatIncreaseSpaceVActionPerformed
        FormatCommand.getCommand( OperationType.INCREASE_SPACE_V).execute();
    }//GEN-LAST:event_jButtonFormatIncreaseSpaceVActionPerformed

    private void jButtonFormatEqualsSpaceVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatEqualsSpaceVActionPerformed
        FormatCommand.getCommand( OperationType.EQUALS_SPACE_V).execute();
    }//GEN-LAST:event_jButtonFormatEqualsSpaceVActionPerformed

    private void jButtonFormatRemoveSpaceHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatRemoveSpaceHActionPerformed
        FormatCommand.getCommand( OperationType.JOIN_LEFT).execute();
    }//GEN-LAST:event_jButtonFormatRemoveSpaceHActionPerformed

    private void jButtonFormatDecreaseSpaceHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatDecreaseSpaceHActionPerformed
        FormatCommand.getCommand( OperationType.DECREASE_SPACE_H).execute();
    }//GEN-LAST:event_jButtonFormatDecreaseSpaceHActionPerformed

    private void jButtonFormatIncreaseSpaceHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatIncreaseSpaceHActionPerformed
        FormatCommand.getCommand( OperationType.INCREASE_SPACE_H).execute();
    }//GEN-LAST:event_jButtonFormatIncreaseSpaceHActionPerformed

    private void jButtonFormatEqualsSpaceHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatEqualsSpaceHActionPerformed
        FormatCommand.getCommand( OperationType.EQUALS_SPACE_H).execute();
    }//GEN-LAST:event_jButtonFormatEqualsSpaceHActionPerformed

    private void jButtonFormatJoinRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatJoinRightActionPerformed
        FormatCommand.getCommand( OperationType.JOIN_RIGHT).execute();
    }//GEN-LAST:event_jButtonFormatJoinRightActionPerformed

    private void jButtonFormatJoinLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatJoinLeftActionPerformed
        FormatCommand.getCommand( OperationType.JOIN_LEFT).execute();
    }//GEN-LAST:event_jButtonFormatJoinLeftActionPerformed

    private void jButtonFormatOrganizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatOrganizeActionPerformed
        FormatCommand.getCommand( OperationType.ORGANIZE_AS_A_TABLE).execute();
    }//GEN-LAST:event_jButtonFormatOrganizeActionPerformed

    private void jButtonFormatSameHeightMaxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameHeightMaxActionPerformed
        FormatCommand.getCommand( OperationType.SAME_HEIGHT_MAX).execute();
    }//GEN-LAST:event_jButtonFormatSameHeightMaxActionPerformed

    private void jButtonFormatSameHeightMinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameHeightMinActionPerformed
        FormatCommand.getCommand( OperationType.SAME_HEIGHT_MIN).execute();
    }//GEN-LAST:event_jButtonFormatSameHeightMinActionPerformed

    private void jButtonFormatSameWidthMinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameWidthMinActionPerformed
        FormatCommand.getCommand( OperationType.SAME_WIDTH_MIN).execute();
    }//GEN-LAST:event_jButtonFormatSameWidthMinActionPerformed

    private void jButtonFormatSameWidthMaxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameWidthMaxActionPerformed
        FormatCommand.getCommand( OperationType.SAME_WIDTH_MAX).execute();
    }//GEN-LAST:event_jButtonFormatSameWidthMaxActionPerformed

    private void jButtonFormatSameWidthActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameWidthActionPerformed
        FormatCommand.getCommand( OperationType.SAME_WIDTH).execute();
    }//GEN-LAST:event_jButtonFormatSameWidthActionPerformed

    private void jButtonFormatAlignToLeftMarginActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignToLeftMarginActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_TO_LEFT_MARGIN).execute();
    }//GEN-LAST:event_jButtonFormatAlignToLeftMarginActionPerformed

    private void jButtonFormatAlignToBandBottomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignToBandBottomActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_BOTTOM_TO_BAND).execute();
    }//GEN-LAST:event_jButtonFormatAlignToBandBottomActionPerformed

    private void jButtonFormatSameSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameSizeActionPerformed
        FormatCommand.getCommand( OperationType.SAME_SIZE).execute();
    }//GEN-LAST:event_jButtonFormatSameSizeActionPerformed

    private void jButtonFormatSameHeightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatSameHeightActionPerformed
        FormatCommand.getCommand( OperationType.SAME_HEIGHT).execute();
    }//GEN-LAST:event_jButtonFormatSameHeightActionPerformed

    private void jButtonFormatAlignToRightMarginActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignToRightMarginActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_TO_RIGHT_MARGIN).execute();
    }//GEN-LAST:event_jButtonFormatAlignToRightMarginActionPerformed

    private void jButtonFormatAlignToBandTopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignToBandTopActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_TOP_TO_BAND).execute();
    }//GEN-LAST:event_jButtonFormatAlignToBandTopActionPerformed

    private void jButtonFormatCenterVRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterVRightActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_VERTICAL_AXIS).execute();
    }//GEN-LAST:event_jButtonFormatCenterVRightActionPerformed

    private void jButtonFormatCenterHRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatCenterHRightActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_HORIZONTAL_AXIS).execute();
    }//GEN-LAST:event_jButtonFormatCenterHRightActionPerformed

    private void jButtonFormatAlignRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignRightActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_RIGHT).execute();
    }//GEN-LAST:event_jButtonFormatAlignRightActionPerformed

    private void jButtonFormatAlignLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignLeftActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_LEFT).execute();
    }//GEN-LAST:event_jButtonFormatAlignLeftActionPerformed

    private void jButtonFormatAlignBottomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFormatAlignBottomActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_BOTTOM).execute();
    }//GEN-LAST:event_jButtonFormatAlignBottomActionPerformed

    private void jButtonFormatAlignTopActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonFormatAlignTopActionPerformed
    {//GEN-HEADEREND:event_jButtonFormatAlignTopActionPerformed
        FormatCommand.getCommand( OperationType.ALIGN_TOP).execute();
    }//GEN-LAST:event_jButtonFormatAlignTopActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton Filler;
    private javax.swing.JButton Filler1;
    private javax.swing.JButton Filler2;
    private javax.swing.JButton Filler3;
    private javax.swing.JButton Filler4;
    private javax.swing.JButton Filler5;
    private javax.swing.JButton Filler6;
    private javax.swing.JButton Filler7;
    private javax.swing.JButton Filler8;
    private javax.swing.JButton Filler9;
    private javax.swing.JButton jButtonFormatAlignBottom;
    private javax.swing.JButton jButtonFormatAlignLeft;
    private javax.swing.JButton jButtonFormatAlignRight;
    private javax.swing.JButton jButtonFormatAlignToBandBottom;
    private javax.swing.JButton jButtonFormatAlignToBandTop;
    private javax.swing.JButton jButtonFormatAlignToLeftMargin;
    private javax.swing.JButton jButtonFormatAlignToRightMargin;
    private javax.swing.JButton jButtonFormatAlignTop;
    private javax.swing.JButton jButtonFormatCenterHRight;
    private javax.swing.JButton jButtonFormatCenterInBand;
    private javax.swing.JButton jButtonFormatCenterInBandH;
    private javax.swing.JButton jButtonFormatCenterInBandV;
    private javax.swing.JButton jButtonFormatCenterVRight;
    private javax.swing.JButton jButtonFormatDecreaseSpaceH;
    private javax.swing.JButton jButtonFormatDecreaseSpaceV;
    private javax.swing.JButton jButtonFormatDecreaseSpaceV1;
    private javax.swing.JButton jButtonFormatElementMaximize;
    private javax.swing.JButton jButtonFormatElementMaximizeH;
    private javax.swing.JButton jButtonFormatElementMaximizeV;
    private javax.swing.JButton jButtonFormatEqualsSpaceH;
    private javax.swing.JButton jButtonFormatEqualsSpaceV;
    private javax.swing.JButton jButtonFormatIncreaseSpaceH;
    private javax.swing.JButton jButtonFormatIncreaseSpaceV;
    private javax.swing.JButton jButtonFormatJoinLeft;
    private javax.swing.JButton jButtonFormatJoinRight;
    private javax.swing.JButton jButtonFormatOrganize;
    private javax.swing.JButton jButtonFormatRemoveSpaceH;
    private javax.swing.JButton jButtonFormatSameHeight;
    private javax.swing.JButton jButtonFormatSameHeightMax;
    private javax.swing.JButton jButtonFormatSameHeightMin;
    private javax.swing.JButton jButtonFormatSameSize;
    private javax.swing.JButton jButtonFormatSameWidth;
    private javax.swing.JButton jButtonFormatSameWidthMax;
    private javax.swing.JButton jButtonFormatSameWidthMin;
    private javax.swing.JButton jButtonFormatShrink;
    private javax.swing.JToggleButton jToggleButton1;
    private javax.swing.JToolBar jToolBarFormat;
    // End of variables declaration//GEN-END:variables

    /**
     * Returns the value of mainFrame.
     */
    public MainFrame getMainFrame()
    {
        return mainFrame;
    }

    /**
     * Sets the value of mainFrame.
     * @param mainFrame The value to assign mainFrame.
     */
    public void setMainFrame(MainFrame mainFrame)
    {
        this.mainFrame = mainFrame;
    }
    //added by Felix Firgau on Feb 07th 2006
          public void applyI18n(){
                // Start autogenerated code ----------------------
                // End autogenerated code ----------------------

              jButtonFormatAlignTop.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignTop", "Align top"));
              jButtonFormatAlignBottom.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignBottom", "Align bottom"));
              jButtonFormatAlignLeft.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignLeft", "Align left"));
              jButtonFormatAlignRight.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignRight", "Align right"));
              jButtonFormatCenterHRight.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignHorizontalAxis", "Align on horizontal axis"));
              jButtonFormatCenterVRight.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignVerticalAxis", "Align on vertical axis"));
              jButtonFormatAlignToBandTop.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignToBandTop", "Align to band top"));
              jButtonFormatAlignToBandBottom.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignToBandBottom", "Align to band bottom"));
              jButtonFormatAlignToLeftMargin.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignToMarginLeft", "Align to left margin"));
              jButtonFormatAlignToRightMargin.setToolTipText(it.businesslogic.ireport.util.I18n.getString("alignToMarginRight", "Align to right margin"));
              jButtonFormatOrganize.setToolTipText(it.businesslogic.ireport.util.I18n.getString("organizeAsTable", "Organize as table"));
              jButtonFormatJoinLeft.setToolTipText(it.businesslogic.ireport.util.I18n.getString("joinSidesLeft", "Join sides left"));
              jButtonFormatJoinRight.setToolTipText(it.businesslogic.ireport.util.I18n.getString("joinSidesRight", "Join sides right"));
              jButtonFormatEqualsSpaceH.setToolTipText(it.businesslogic.ireport.util.I18n.getString("horizontalSpaceEqual", "Equal horizontal space"));
              jButtonFormatIncreaseSpaceH.setToolTipText(it.businesslogic.ireport.util.I18n.getString("horizontalSpaceIncrease", "Increase horizontal space"));
              jButtonFormatDecreaseSpaceH.setToolTipText(it.businesslogic.ireport.util.I18n.getString("horizontalSpaceDecrease", "Decrease horizontal space"));
              jButtonFormatRemoveSpaceH.setToolTipText(it.businesslogic.ireport.util.I18n.getString("horizontalSpaceRemove", "Remove horizontal space"));
              jButtonFormatEqualsSpaceV.setToolTipText(it.businesslogic.ireport.util.I18n.getString("verticalSpaceEqual", "Equal vertical space"));
              jButtonFormatIncreaseSpaceV.setToolTipText(it.businesslogic.ireport.util.I18n.getString("verticalSpaceIncrease", "Increase vertical space"));
              jButtonFormatDecreaseSpaceV.setToolTipText(it.businesslogic.ireport.util.I18n.getString("verticalSpaceDecrease", "Decrease vertical space"));
              jButtonFormatDecreaseSpaceV1.setToolTipText(it.businesslogic.ireport.util.I18n.getString("verticalSpaceRemove", "Remove vertical space"));
              jButtonFormatSameWidth.setToolTipText(it.businesslogic.ireport.util.I18n.getString("sameWidth", "Same width"));
              jButtonFormatSameWidthMax.setToolTipText(it.businesslogic.ireport.util.I18n.getString("sameWidthMax", "Same width max"));
              jButtonFormatSameWidthMin.setToolTipText(it.businesslogic.ireport.util.I18n.getString("sameWidthMin", "Same width min"));
              jButtonFormatSameHeight.setToolTipText(it.businesslogic.ireport.util.I18n.getString("sameHeight", "Same height"));
              jButtonFormatSameHeightMin.setToolTipText(it.businesslogic.ireport.util.I18n.getString("sameHeightMin", "Same height min"));
              jButtonFormatSameHeightMax.setToolTipText(it.businesslogic.ireport.util.I18n.getString("sameHeightMax", "Same height max"));
              jButtonFormatSameSize.setToolTipText(it.businesslogic.ireport.util.I18n.getString("sameSize", "Same size"));
              jButtonFormatElementMaximizeH.setToolTipText(it.businesslogic.ireport.util.I18n.getString("enlargeBetweenMargin", "Enlarge between margin"));
              jButtonFormatElementMaximizeV.setToolTipText(it.businesslogic.ireport.util.I18n.getString("enlargeBetweenBands", "Enlarge between bands"));
              jButtonFormatElementMaximize.setToolTipText(it.businesslogic.ireport.util.I18n.getString("elementMaximize", "Element maximize"));
              jButtonFormatCenterInBandH.setToolTipText(it.businesslogic.ireport.util.I18n.getString("centerInBandHorizontal", "Center in band horizontal"));
              jButtonFormatCenterInBandV.setToolTipText(it.businesslogic.ireport.util.I18n.getString("centerInBandVertical", "Center in band vertical"));
              jButtonFormatCenterInBand.setToolTipText(it.businesslogic.ireport.util.I18n.getString("centerInBand", "Center in band"));
          }

           //added by Felix Firgau on Feb 07th 2006
           public void languageChanged(LanguageChangedEvent evt) {
             this.applyI18n();
           }
           //Modification end



}
