/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRFillFrame
extends JRFillElement
implements JRFrame {
    protected final JRFrame parentFrame;
    private JRFillFrameElements frameContainer;
    private Map bottomTemplateFrames;
    private Map topTemplateFrames;
    private Map topBottomTemplateFrames;
    private boolean first;
    private boolean fillBottomBorder;
    private boolean filling;

    public JRFillFrame(JRBaseFiller filler, JRFrame frame, JRFillObjectFactory factory) {
        super(filler, frame, factory);
        this.parentFrame = frame;
        this.frameContainer = new JRFillFrameElements(factory);
        this.bottomTemplateFrames = new HashMap();
        this.topTemplateFrames = new HashMap();
        this.topBottomTemplateFrames = new HashMap();
        this.setShrinkable(true);
    }

    protected JRFillFrame(JRFillFrame frame, JRFillCloneFactory factory) {
        super(frame, factory);
        this.parentFrame = frame.parentFrame;
        this.frameContainer = new JRFillFrameElements(frame.frameContainer, factory);
        this.bottomTemplateFrames = frame.bottomTemplateFrames;
        this.topTemplateFrames = frame.topTemplateFrames;
        this.topBottomTemplateFrames = frame.topBottomTemplateFrames;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.frameContainer.evaluate(evaluation);
            boolean repeating = true;
            JRFillElement[] elements = (JRFillElement[])this.getElements();
            for (int i = 0; repeating && i < elements.length; repeating &= elements[i].isValueRepeating(), ++i) {
            }
            this.setValueRepeating(repeating);
        }
        this.filling = false;
    }

    protected void rewind() throws JRException {
        this.frameContainer.rewind();
        this.filling = false;
    }

    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        this.first = !isOverflow || !this.filling;
        int topPadding = this.first ? this.getTopPadding() : 0;
        int bottomPadding = this.getBottomPadding();
        if (availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY() - topPadding) {
            this.setToPrint(false);
            return true;
        }
        if (!(this.filling || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            this.setToPrint(false);
            return false;
        }
        if (!this.filling && isOverflow && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setToPrint(false);
                return false;
            }
        }
        int stretchHeight = availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.frameContainer.initFill();
        this.frameContainer.resetElements();
        int frameElemsAvailableHeight = stretchHeight + bottomPadding + this.getTopPadding() - topPadding;
        this.frameContainer.prepareElements(frameElemsAvailableHeight, true);
        boolean willOverflow = this.frameContainer.willOverflow();
        if (willOverflow) {
            this.fillBottomBorder = false;
            this.setStretchHeight(this.getHeight() + stretchHeight);
        } else {
            int neededStretch = this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding;
            if (neededStretch <= this.getHeight() + stretchHeight) {
                this.fillBottomBorder = true;
                this.setStretchHeight(neededStretch);
            } else {
                this.fillBottomBorder = false;
                this.setStretchHeight(this.getHeight() + stretchHeight);
            }
        }
        this.filling = willOverflow;
        return willOverflow;
    }

    protected void setStretchHeight(int stretchHeight) {
        super.setStretchHeight(stretchHeight);
        int topPadding = this.first ? this.getTopPadding() : 0;
        int bottomPadding = this.fillBottomBorder ? this.getBottomPadding() : 0;
        this.frameContainer.setStretchHeight(stretchHeight + this.frameContainer.getFirstY() - topPadding - bottomPadding);
    }

    protected void stretchHeightFinal() {
        this.frameContainer.stretchElements();
        this.frameContainer.moveBandBottomElements();
        this.frameContainer.removeBlankElements();
        int topPadding = this.first ? this.getTopPadding() : 0;
        int bottomPadding = this.fillBottomBorder ? this.getBottomPadding() : 0;
        super.setStretchHeight(this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding);
    }

    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getTemplate());
        printFrame.setX(this.getX());
        printFrame.setY(this.getRelativeY());
        printFrame.setWidth(this.getWidth());
        this.frameContainer.fillElements(printFrame);
        printFrame.setHeight(this.getStretchHeight());
        return printFrame;
    }

    protected JRTemplateFrame getTemplate() {
        JRStyle style = this.getStyle();
        Map templatesMap = this.first ? (this.fillBottomBorder ? this.templates : this.bottomTemplateFrames) : (this.fillBottomBorder ? this.topTemplateFrames : this.topBottomTemplateFrames);
        JRTemplateFrame boxTemplate = (JRTemplateFrame)templatesMap.get(style);
        if (boxTemplate == null) {
            boxTemplate = new JRTemplateFrame(this.band == null ? null : this.band.getOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            if (this.first) {
                if (!this.fillBottomBorder) {
                    JRBaseBox bottomBox = new JRBaseBox(this, false, false, false, true);
                    boxTemplate.setBox(bottomBox);
                }
            } else if (this.fillBottomBorder) {
                JRBaseBox topBox = new JRBaseBox(this, false, false, true, false);
                boxTemplate.setBox(topBox);
            } else {
                JRBaseBox topBottomBox = new JRBaseBox(this, false, false, true, true);
                boxTemplate.setBox(topBottomBox);
            }
            templatesMap.put(style, boxTemplate);
        }
        return boxTemplate;
    }

    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    public JRElement[] getElements() {
        return this.frameContainer.getElements();
    }

    public List getChildren() {
        return this.frameContainer.getChildren();
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitFrame(this);
    }

    public JRElement getElementByKey(String key) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), key);
    }

    public JRCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillFrame(this, factory);
    }

    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    public Byte getOwnBorder() {
        return this.parentFrame.getOwnBorder();
    }

    public void setBorder(byte border) {
    }

    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    public Color getOwnBorderColor() {
        return this.parentFrame.getOwnBorderColor();
    }

    public void setBorderColor(Color borderColor) {
    }

    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    public Integer getOwnPadding() {
        return this.parentFrame.getOwnPadding();
    }

    public void setPadding(int padding) {
    }

    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    public Byte getOwnTopBorder() {
        return this.parentFrame.getOwnTopBorder();
    }

    public void setTopBorder(byte topBorder) {
    }

    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    public Color getOwnTopBorderColor() {
        return this.parentFrame.getOwnTopBorderColor();
    }

    public void setTopBorderColor(Color topBorderColor) {
    }

    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    public Integer getOwnTopPadding() {
        return this.parentFrame.getOwnTopPadding();
    }

    public void setTopPadding(int topPadding) {
    }

    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    public Byte getOwnLeftBorder() {
        return this.parentFrame.getOwnLeftBorder();
    }

    public void setLeftBorder(byte leftBorder) {
    }

    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    public Color getOwnLeftBorderColor() {
        return this.parentFrame.getOwnLeftBorderColor();
    }

    public void setLeftBorderColor(Color leftBorderColor) {
    }

    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    public Integer getOwnLeftPadding() {
        return this.parentFrame.getOwnLeftPadding();
    }

    public void setLeftPadding(int leftPadding) {
    }

    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    public Byte getOwnBottomBorder() {
        return this.parentFrame.getOwnBottomBorder();
    }

    public void setBottomBorder(byte bottomBorder) {
    }

    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    public Color getOwnBottomBorderColor() {
        return this.parentFrame.getOwnBottomBorderColor();
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
    }

    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    public Integer getOwnBottomPadding() {
        return this.parentFrame.getOwnBottomPadding();
    }

    public void setBottomPadding(int bottomPadding) {
    }

    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    public Byte getOwnRightBorder() {
        return this.parentFrame.getOwnRightBorder();
    }

    public void setRightBorder(byte rightBorder) {
    }

    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    public Color getOwnRightBorderColor() {
        return this.parentFrame.getOwnRightBorderColor();
    }

    public void setRightBorderColor(Color rightBorderColor) {
    }

    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    public Integer getOwnRightPadding() {
        return this.parentFrame.getOwnRightPadding();
    }

    public void setRightPadding(int rightPadding) {
    }

    public void setBorder(Byte border) {
    }

    public void setPadding(Integer padding) {
    }

    public void setTopBorder(Byte topBorder) {
    }

    public void setTopPadding(Integer topPadding) {
    }

    public void setLeftBorder(Byte leftBorder) {
    }

    public void setLeftPadding(Integer leftPadding) {
    }

    public void setBottomBorder(Byte bottomBorder) {
    }

    public void setBottomPadding(Integer bottomPadding) {
    }

    public void setRightBorder(Byte rightBorder) {
    }

    public void setRightPadding(Integer rightPadding) {
    }

    protected class JRFillFrameElements
    extends JRFillElementContainer {
        JRFillFrameElements(JRFillObjectFactory factory) {
            super(JRFillFrame.this.filler, JRFillFrame.this.parentFrame, factory);
            this.initElements();
        }

        JRFillFrameElements(JRFillFrameElements frameElements, JRFillCloneFactory factory) {
            super(frameElements, factory);
            this.initElements();
        }

        protected int getContainerHeight() {
            return JRFillFrame.this.getHeight() - JRFillFrame.this.getTopPadding() - JRFillFrame.this.getBottomPadding();
        }
    }
}

