/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.record.AreaFormatRecord;
import org.apache.poi.hssf.record.AreaRecord;
import org.apache.poi.hssf.record.AxisLineFormatRecord;
import org.apache.poi.hssf.record.AxisOptionsRecord;
import org.apache.poi.hssf.record.AxisParentRecord;
import org.apache.poi.hssf.record.AxisRecord;
import org.apache.poi.hssf.record.AxisUsedRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.BarRecord;
import org.apache.poi.hssf.record.BeginRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BookBoolRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BottomMarginRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.CategorySeriesAxisRecord;
import org.apache.poi.hssf.record.ChartFormatRecord;
import org.apache.poi.hssf.record.ChartRecord;
import org.apache.poi.hssf.record.CodepageRecord;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.CountryRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DSFRecord;
import org.apache.poi.hssf.record.DatRecord;
import org.apache.poi.hssf.record.DataFormatRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.DefaultColWidthRecord;
import org.apache.poi.hssf.record.DefaultDataLabelTextPropertiesRecord;
import org.apache.poi.hssf.record.DefaultRowHeightRecord;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.DrawingRecordForBiffViewer;
import org.apache.poi.hssf.record.DrawingSelectionRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.EndRecord;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.FilePassRecord;
import org.apache.poi.hssf.record.FnGroupCountRecord;
import org.apache.poi.hssf.record.FontBasisRecord;
import org.apache.poi.hssf.record.FontIndexRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FooterRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.FrameRecord;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.HCenterRecord;
import org.apache.poi.hssf.record.HeaderRecord;
import org.apache.poi.hssf.record.HideObjRecord;
import org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import org.apache.poi.hssf.record.IndexRecord;
import org.apache.poi.hssf.record.InterfaceEndRecord;
import org.apache.poi.hssf.record.InterfaceHdrRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.LeftMarginRecord;
import org.apache.poi.hssf.record.LegendRecord;
import org.apache.poi.hssf.record.LineFormatRecord;
import org.apache.poi.hssf.record.LinkedDataRecord;
import org.apache.poi.hssf.record.MMSRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.ObjectLinkRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.record.PaneRecord;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.record.PasswordRev4Record;
import org.apache.poi.hssf.record.PlotAreaRecord;
import org.apache.poi.hssf.record.PlotGrowthRecord;
import org.apache.poi.hssf.record.PrecisionRecord;
import org.apache.poi.hssf.record.PrintGridlinesRecord;
import org.apache.poi.hssf.record.PrintHeadersRecord;
import org.apache.poi.hssf.record.PrintSetupRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.ProtectionRev4Record;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RefreshAllRecord;
import org.apache.poi.hssf.record.RightMarginRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SCLRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.SeriesIndexRecord;
import org.apache.poi.hssf.record.SeriesListRecord;
import org.apache.poi.hssf.record.SeriesRecord;
import org.apache.poi.hssf.record.SeriesTextRecord;
import org.apache.poi.hssf.record.SeriesToChartGroupRecord;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.SheetPropertiesRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.hssf.record.TabIdRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.TextRecord;
import org.apache.poi.hssf.record.TickRecord;
import org.apache.poi.hssf.record.TopMarginRecord;
import org.apache.poi.hssf.record.UnitsRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.UseSelFSRecord;
import org.apache.poi.hssf.record.VCenterRecord;
import org.apache.poi.hssf.record.ValueRangeRecord;
import org.apache.poi.hssf.record.VerticalPageBreakRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowOneRecord;
import org.apache.poi.hssf.record.WindowProtectRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;
import org.apache.poi.hssf.record.WriteAccessRecord;
import org.apache.poi.hssf.record.WriteProtectRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.HexDump;

public class BiffViewer {
    String filename;
    private boolean dump;

    public BiffViewer(String[] args) {
        if (args.length > 0) {
            this.filename = args[0];
        } else {
            System.out.println("BIFFVIEWER REQUIRES A FILENAME***");
        }
    }

    public void run() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(this.filename));
            DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
            BiffViewer.createRecords(stream, this.dump);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Record[] createRecords(InputStream in, boolean dump) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>();
        RecordDetails activeRecord = null;
        try {
            BiffviewRecordInputStream recStream = new BiffviewRecordInputStream(in);
            while (recStream.hasNextRecord()) {
                recStream.nextRecord();
                if (recStream.getSid() == 0) continue;
                Record record = BiffViewer.createRecord(recStream);
                if (record.getSid() != 60) {
                    records.add(record);
                    if (activeRecord != null) {
                        activeRecord.dump();
                    }
                    activeRecord = new RecordDetails(recStream.getSid(), recStream.getLength(), (int)recStream.getPos(), record);
                }
                if (!dump) continue;
                recStream.dumpBytes();
            }
            activeRecord.dump();
        }
        catch (IOException e) {
            throw new RecordFormatException("Error reading bytes", e);
        }
        Record[] retval = new Record[records.size()];
        retval = records.toArray(retval);
        return retval;
    }

    private static void dumpNormal(Record record, int startloc, short rectype, short recsize) {
        System.out.println("Offset 0x" + Integer.toHexString(startloc) + " (" + startloc + ")");
        System.out.println("recordid = 0x" + Integer.toHexString(rectype) + ", size = " + recsize);
        System.out.println(record.toString());
    }

    private static Record createRecord(RecordInputStream in) {
        Record retval = null;
        switch (in.getSid()) {
            case 4098: {
                retval = new ChartRecord(in);
                break;
            }
            case 4116: {
                retval = new ChartFormatRecord(in);
                break;
            }
            case 4099: {
                retval = new SeriesRecord(in);
                break;
            }
            case 4147: {
                retval = new BeginRecord(in);
                break;
            }
            case 4148: {
                retval = new EndRecord(in);
                break;
            }
            case 2057: {
                retval = new BOFRecord(in);
                break;
            }
            case 225: {
                retval = new InterfaceHdrRecord(in);
                break;
            }
            case 193: {
                retval = new MMSRecord(in);
                break;
            }
            case 226: {
                retval = new InterfaceEndRecord(in);
                break;
            }
            case 92: {
                retval = new WriteAccessRecord(in);
                break;
            }
            case 66: {
                retval = new CodepageRecord(in);
                break;
            }
            case 353: {
                retval = new DSFRecord(in);
                break;
            }
            case 317: {
                retval = new TabIdRecord(in);
                break;
            }
            case 156: {
                retval = new FnGroupCountRecord(in);
                break;
            }
            case 25: {
                retval = new WindowProtectRecord(in);
                break;
            }
            case 18: {
                retval = new ProtectRecord(in);
                break;
            }
            case 19: {
                retval = new PasswordRecord(in);
                break;
            }
            case 431: {
                retval = new ProtectionRev4Record(in);
                break;
            }
            case 444: {
                retval = new PasswordRev4Record(in);
                break;
            }
            case 61: {
                retval = new WindowOneRecord(in);
                break;
            }
            case 64: {
                retval = new BackupRecord(in);
                break;
            }
            case 141: {
                retval = new HideObjRecord(in);
                break;
            }
            case 34: {
                retval = new DateWindow1904Record(in);
                break;
            }
            case 14: {
                retval = new PrecisionRecord(in);
                break;
            }
            case 439: {
                retval = new RefreshAllRecord(in);
                break;
            }
            case 218: {
                retval = new BookBoolRecord(in);
                break;
            }
            case 49: {
                retval = new FontRecord(in);
                break;
            }
            case 1054: {
                retval = new FormatRecord(in);
                break;
            }
            case 224: {
                retval = new ExtendedFormatRecord(in);
                break;
            }
            case 659: {
                retval = new StyleRecord(in);
                break;
            }
            case 352: {
                retval = new UseSelFSRecord(in);
                break;
            }
            case 133: {
                retval = new BoundSheetRecord(in);
                break;
            }
            case 140: {
                retval = new CountryRecord(in);
                break;
            }
            case 252: {
                retval = new SSTRecord(in);
                break;
            }
            case 255: {
                retval = new ExtSSTRecord(in);
                break;
            }
            case 10: {
                retval = new EOFRecord(in);
                break;
            }
            case 523: {
                retval = new IndexRecord(in);
                break;
            }
            case 13: {
                retval = new CalcModeRecord(in);
                break;
            }
            case 12: {
                retval = new CalcCountRecord(in);
                break;
            }
            case 15: {
                retval = new RefModeRecord(in);
                break;
            }
            case 17: {
                retval = new IterationRecord(in);
                break;
            }
            case 16: {
                retval = new DeltaRecord(in);
                break;
            }
            case 95: {
                retval = new SaveRecalcRecord(in);
                break;
            }
            case 42: {
                retval = new PrintHeadersRecord(in);
                break;
            }
            case 43: {
                retval = new PrintGridlinesRecord(in);
                break;
            }
            case 130: {
                retval = new GridsetRecord(in);
                break;
            }
            case 235: {
                retval = new DrawingGroupRecord(in);
                break;
            }
            case 236: {
                retval = new DrawingRecordForBiffViewer(in);
                break;
            }
            case 237: {
                retval = new DrawingSelectionRecord(in);
                break;
            }
            case 128: {
                retval = new GutsRecord(in);
                break;
            }
            case 549: {
                retval = new DefaultRowHeightRecord(in);
                break;
            }
            case 129: {
                retval = new WSBoolRecord(in);
                break;
            }
            case 20: {
                retval = new HeaderRecord(in);
                break;
            }
            case 21: {
                retval = new FooterRecord(in);
                break;
            }
            case 131: {
                retval = new HCenterRecord(in);
                break;
            }
            case 132: {
                retval = new VCenterRecord(in);
                break;
            }
            case 161: {
                retval = new PrintSetupRecord(in);
                break;
            }
            case 85: {
                retval = new DefaultColWidthRecord(in);
                break;
            }
            case 512: {
                retval = new DimensionsRecord(in);
                break;
            }
            case 520: {
                retval = new RowRecord(in);
                break;
            }
            case 253: {
                retval = new LabelSSTRecord(in);
                break;
            }
            case 638: {
                retval = new RKRecord(in);
                break;
            }
            case 515: {
                retval = new NumberRecord(in);
                break;
            }
            case 215: {
                retval = new DBCellRecord(in);
                break;
            }
            case 574: {
                retval = new WindowTwoRecord(in);
                break;
            }
            case 29: {
                retval = new SelectionRecord(in);
                break;
            }
            case 60: {
                retval = new ContinueRecord(in);
                break;
            }
            case 516: {
                retval = new LabelRecord(in);
                break;
            }
            case 189: {
                retval = new MulRKRecord(in);
                break;
            }
            case 190: {
                retval = new MulBlankRecord(in);
                break;
            }
            case 513: {
                retval = new BlankRecord(in);
                break;
            }
            case 517: {
                retval = new BoolErrRecord(in);
                break;
            }
            case 125: {
                retval = new ColumnInfoRecord(in);
                break;
            }
            case 229: {
                retval = new MergeCellsRecord(in);
                break;
            }
            case 4122: {
                retval = new AreaRecord(in);
                break;
            }
            case 4102: {
                retval = new DataFormatRecord(in);
                break;
            }
            case 4119: {
                retval = new BarRecord(in);
                break;
            }
            case 4195: {
                retval = new DatRecord(in);
                break;
            }
            case 4196: {
                retval = new PlotGrowthRecord(in);
                break;
            }
            case 4097: {
                retval = new UnitsRecord(in);
                break;
            }
            case 4146: {
                retval = new FrameRecord(in);
                break;
            }
            case 4127: {
                retval = new ValueRangeRecord(in);
                break;
            }
            case 4118: {
                retval = new SeriesListRecord(in);
                break;
            }
            case 4192: {
                retval = new FontBasisRecord(in);
                break;
            }
            case 4134: {
                retval = new FontIndexRecord(in);
                break;
            }
            case 4103: {
                retval = new LineFormatRecord(in);
                break;
            }
            case 4106: {
                retval = new AreaFormatRecord(in);
                break;
            }
            case 4177: {
                retval = new LinkedDataRecord(in);
                break;
            }
            case 6: {
                retval = new FormulaRecord(in);
                break;
            }
            case 4164: {
                retval = new SheetPropertiesRecord(in);
                break;
            }
            case 4132: {
                retval = new DefaultDataLabelTextPropertiesRecord(in);
                break;
            }
            case 4133: {
                retval = new TextRecord(in);
                break;
            }
            case 4161: {
                retval = new AxisParentRecord(in);
                break;
            }
            case 4129: {
                retval = new AxisLineFormatRecord(in);
                break;
            }
            case 430: {
                retval = new SupBookRecord(in);
                break;
            }
            case 23: {
                retval = new ExternSheetRecord(in);
                break;
            }
            case 160: {
                retval = new SCLRecord(in);
                break;
            }
            case 4165: {
                retval = new SeriesToChartGroupRecord(in);
                break;
            }
            case 4166: {
                retval = new AxisUsedRecord(in);
                break;
            }
            case 4125: {
                retval = new AxisRecord(in);
                break;
            }
            case 4128: {
                retval = new CategorySeriesAxisRecord(in);
                break;
            }
            case 4194: {
                retval = new AxisOptionsRecord(in);
                break;
            }
            case 4126: {
                retval = new TickRecord(in);
                break;
            }
            case 4109: {
                retval = new SeriesTextRecord(in);
                break;
            }
            case 4135: {
                retval = new ObjectLinkRecord(in);
                break;
            }
            case 4149: {
                retval = new PlotAreaRecord(in);
                break;
            }
            case 4197: {
                retval = new SeriesIndexRecord(in);
                break;
            }
            case 4117: {
                retval = new LegendRecord(in);
                break;
            }
            case 38: {
                retval = new LeftMarginRecord(in);
                break;
            }
            case 39: {
                retval = new RightMarginRecord(in);
                break;
            }
            case 40: {
                retval = new TopMarginRecord(in);
                break;
            }
            case 41: {
                retval = new BottomMarginRecord(in);
                break;
            }
            case 146: {
                retval = new PaletteRecord(in);
                break;
            }
            case 519: {
                retval = new StringRecord(in);
                break;
            }
            case 24: {
                retval = new NameRecord(in);
                break;
            }
            case 65: {
                retval = new PaneRecord(in);
                break;
            }
            case 1212: {
                retval = new SharedFormulaRecord(in);
                break;
            }
            case 93: {
                retval = new ObjRecord(in);
                break;
            }
            case 438: {
                retval = new TextObjectRecord(in);
                break;
            }
            case 27: {
                retval = new HorizontalPageBreakRecord(in);
                break;
            }
            case 26: {
                retval = new VerticalPageBreakRecord(in);
                break;
            }
            case 134: {
                retval = new WriteProtectRecord(in);
                break;
            }
            case 47: {
                retval = new FilePassRecord(in);
                break;
            }
            case 28: {
                retval = new NoteRecord(in);
                break;
            }
            default: {
                retval = new UnknownRecord(in);
            }
        }
        return retval;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public static void main(String[] args) {
        try {
            System.setProperty("poi.deserialize.escher", "true");
            if (args.length == 0) {
                System.out.println("Biff viewer needs a filename");
            } else {
                BiffViewer viewer = new BiffViewer(args);
                if (args.length > 1 && args[1].equals("on")) {
                    viewer.setDump(true);
                }
                if (args.length > 1 && args[1].equals("bfd")) {
                    POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(args[0]));
                    DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
                    int size = ((InputStream)stream).available();
                    byte[] data = new byte[size];
                    ((InputStream)stream).read(data);
                    HexDump.dump(data, 0L, System.out, 0);
                } else {
                    viewer.run();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class BiffviewRecordInputStream
    extends RecordInputStream {
        public BiffviewRecordInputStream(InputStream in) {
            super(in);
        }

        public void dumpBytes() {
            HexDump.dump(this.data, 0L, this.currentLength);
        }
    }

    static class RecordDetails {
        short rectype;
        short recsize;
        int startloc;
        Record record;

        public RecordDetails(short rectype, short recsize, int startloc, Record record) {
            this.rectype = rectype;
            this.recsize = recsize;
            this.startloc = startloc;
            this.record = record;
        }

        public short getRectype() {
            return this.rectype;
        }

        public short getRecsize() {
            return this.recsize;
        }

        public Record getRecord() {
            return this.record;
        }

        public void dump() throws IOException {
            BiffViewer.dumpNormal(this.record, this.startloc, this.rectype, this.recsize);
        }
    }
}

