/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;
import mondrian.gui.SchemaExplorer;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.Query;
import mondrian.olap.Result;

public class QueryPanel
extends JPanel {
    Connection connection;
    JMenuItem queryMenuItem;
    int windowMenuIndex;
    Map schemaWindowMap;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane2;
    private JTextPane resultTextPane;
    private JScrollPane jScrollPane1;
    private JTextPane queryTextPane;
    private JSplitPane jSplitPane1;
    private JButton executeButton;
    private JComboBox schemaList;
    private JLabel schemaLabel;
    private JPanel schemaPanel;
    private JScrollPane schemaScrollPane1;
    private JButton connectButton;
    private JPopupMenu jPopupMenu;

    public QueryPanel() {
        this.initComponents();
    }

    public void setConnection(Connection c) {
        this.connection = c;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setMenuItem(JMenuItem mi) {
        this.queryMenuItem = mi;
    }

    public void setSchemaWindowMap(Map swindowMap) {
        this.schemaWindowMap = swindowMap;
        this.setCatalogs();
    }

    private void setCatalogs() {
        Vector<String> v = new Vector<String>();
        for (JMenuItem elem : this.schemaWindowMap.values()) {
            v.add(elem.getText());
        }
        DefaultComboBoxModel cCatalogs = new DefaultComboBoxModel(v);
        this.schemaList.setModel(cCatalogs);
    }

    public void setWindowMenuIndex(int i) {
        this.windowMenuIndex = i;
    }

    public void initConnection(String smenutext) {
        this.schemaList.setSelectedItem(smenutext);
        this.connectButtonActionPerformed(null);
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.executeButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.queryTextPane = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.resultTextPane = new JTextPane();
        this.connectButton = new JButton();
        this.jPopupMenu = new JPopupMenu();
        this.jPopupMenu.add(new DefaultEditorKit.CutAction());
        this.jPopupMenu.add(new DefaultEditorKit.CopyAction());
        this.jPopupMenu.add(new DefaultEditorKit.PasteAction());
        this.schemaScrollPane1 = new JScrollPane();
        this.schemaLabel = new JLabel();
        this.schemaList = new JComboBox<String>(new String[]{"Join", "Table"});
        this.schemaPanel = new JPanel();
        this.schemaPanel.setLayout(new FlowLayout(0, 10, 0));
        this.setLayout(new BorderLayout());
        this.schemaLabel.setFont(new Font("Dialog", 1, 12));
        this.schemaLabel.setForeground((Color)UIManager.getDefaults().get("CheckBoxMenuItem.acceleratorForeground"));
        this.schemaLabel.setHorizontalAlignment(0);
        this.schemaLabel.setText(" Schema ");
        this.schemaList.setBackground(Color.white);
        QueryPanel qpanel = this;
        this.schemaList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.connectButton.setText("Connect");
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryPanel.this.connectButtonActionPerformed(evt);
            }
        });
        this.schemaPanel.add(this.schemaLabel);
        this.schemaPanel.add(this.schemaList);
        this.schemaPanel.add(this.connectButton);
        this.add((Component)this.schemaPanel, "North");
        this.executeButton.setText("Execute");
        this.executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryPanel.this.executeButtonActionPerformed(evt);
            }
        });
        this.add((Component)this.executeButton, "South");
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setOrientation(0);
        this.queryTextPane.setFont(new Font("Courier New", 0, 12));
        this.queryTextPane.setText("");
        this.queryTextPane.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int x = e.getX();
                    int y = e.getY();
                    QueryPanel.this.jPopupMenu.show(QueryPanel.this.queryTextPane, x, y);
                }
            }
        });
        this.jScrollPane1.setViewportView(this.queryTextPane);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.resultTextPane.setEditable(false);
        this.resultTextPane.setFont(new Font("Courier New", 0, 12));
        this.jScrollPane2.setViewportView(this.resultTextPane);
        this.jSplitPane1.setBottomComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.connection == null) {
                JOptionPane.showMessageDialog(this, "No Mondrian connection. Select a Schema to connect.", "Alert", 2);
                return;
            }
            Query q = this.connection.parseQuery(this.queryTextPane.getText());
            Result r = this.connection.execute(q);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            r.print(pw);
            this.resultTextPane.setText(sw.getBuffer().toString());
        }
        catch (Exception ex) {
            this.resultTextPane.setText(ex.getMessage());
        }
    }

    private void connectButtonActionPerformed(ActionEvent evt) {
        File sfile = null;
        try {
            JInternalFrame sf = null;
            String sfname = (String)this.schemaList.getSelectedItem();
            for (Map.Entry elem : this.schemaWindowMap.entrySet()) {
                if (!((JMenuItem)elem.getValue()).getText().equals(sfname)) continue;
                sf = (JInternalFrame)elem.getKey();
                break;
            }
            if (sf == null) {
                JOptionPane.showMessageDialog(this, "Schema file is not open.", "Error", 0);
                return;
            }
            SchemaExplorer se = (SchemaExplorer)sf.getContentPane().getComponent(0);
            if (se.isNewFile()) {
                JOptionPane.showMessageDialog(this, "You must first save the Schema to open a Mondrian comnnection.", "Alert", 2);
                sf.setSelected(true);
                return;
            }
            sfile = se.getSchemaFile();
            String connectString = "Provider=mondrian;Jdbc=" + se.getJdbcConnectionUrl() + ";" + "Catalog=" + se.getSchemaFile().toURL().toString();
            Connection con = DriverManager.getConnection(connectString, null, false);
            if (con != null) {
                this.connection = con;
                this.queryMenuItem.setText(this.windowMenuIndex + " MDX - " + se.getSchemaFile().getName());
                for (Container o = this; o != null; o = o.getParent()) {
                    if (o.getClass() != JInternalFrame.class) continue;
                    ((JInternalFrame)o).setTitle("MDX Query - connected to " + se.getSchemaFile().getName());
                    break;
                }
                JOptionPane.showMessageDialog(this, "Mondrian connection Successful.", "Information", 1);
            } else {
                JOptionPane.showMessageDialog(this, "Mondrian connection could not be done for - " + se.getSchemaFile().getName(), "Error", 0);
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getMessage());
            JOptionPane.showMessageDialog(this, "Mondrian connection could not be done for " + (sfile == null ? "selected Schema." : sfile.getName()), "Error", 0);
        }
    }
}

