/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.calendar;

import com.michaelbaranov.microba.Microba;
import com.michaelbaranov.microba.calendar.CalendarPane;
import com.michaelbaranov.microba.calendar.ui.DatePickerUI;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DatePicker
extends CalendarPane {
    public static final String PROPERTY_NAME_DATE_STYLE = "dateStyle";
    public static final String PROPERTY_NAME_FIELD_EDITABLE = "fieldEditable";
    private static final String uiClassID = "microba.DatePickerUI";
    private int dateStyle;
    private boolean fieldEditable;

    public DatePicker() {
        this(new Date(), 2, Locale.getDefault(), TimeZone.getDefault());
    }

    public DatePicker(Date initialDate) {
        this(initialDate, 2, Locale.getDefault(), TimeZone.getDefault());
    }

    public DatePicker(Date initialDate, int dateStyle) {
        this(initialDate, dateStyle, Locale.getDefault(), TimeZone.getDefault());
    }

    public DatePicker(Date initialDate, int dateStyle, Locale locale) {
        this(initialDate, dateStyle, locale, TimeZone.getDefault());
    }

    public DatePicker(Date initialDate, int dateStyle, Locale locale, TimeZone zone) {
        super(initialDate, 32, locale, zone);
        this.checkDateStyle(dateStyle);
        this.dateStyle = dateStyle;
        this.fieldEditable = true;
        this.updateUI();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(int dateStyle) {
        this.checkDateStyle(dateStyle);
        int old = this.dateStyle;
        this.dateStyle = dateStyle;
        this.firePropertyChange(PROPERTY_NAME_DATE_STYLE, old, dateStyle);
    }

    public boolean isFieldEditable() {
        return this.fieldEditable;
    }

    public void setFieldEditable(boolean fieldEditable) {
        boolean old = this.fieldEditable;
        this.fieldEditable = fieldEditable;
        this.firePropertyChange(PROPERTY_NAME_FIELD_EDITABLE, old, fieldEditable);
    }

    public void showPopup() {
        ((DatePickerUI)this.getUI()).showPopup(true);
    }

    public void hidePopup() {
        ((DatePickerUI)this.getUI()).showPopup(false);
    }

    public boolean commitEdit() {
        try {
            ((DatePickerUI)this.getUI()).commit();
            this.fireCommitEvent(true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void revertEdit() {
        ((DatePickerUI)this.getUI()).revert();
        this.fireCommitEvent(false);
    }

    private void checkDateStyle(int style) {
        if (style != 3 && style != 2 && style != 1) {
            throw new IllegalArgumentException("dateStyle: unrecognized style");
        }
    }

    static {
        Microba.init();
    }
}

