/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.BorderLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.util.FileSelectionTextField;
import net.charabia.util.codec.IcoCodec;

public class ExecutableIcon
extends Editor {
    private FileSelectionTextField m_selector = new FileSelectionTextField();
    private JLabel m_iconDisplay = new JLabel("(no image)");

    public ExecutableIcon() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.m_selector);
        this.add("South", this.m_iconDisplay);
        this.m_iconDisplay.setHorizontalAlignment(0);
        this.m_selector.addListener(new FileSelectionTextField.FileSelected(){

            public void fileSelected(String filename) {
                System.out.println("new icon: " + filename);
                ExecutableIcon.this.setIconLocation(new File(filename));
            }
        });
    }

    public void dataChanged() {
        if (this.getBaseDir() != null) {
            this.m_selector.setBaseDir(this.getBaseDir());
        }
        if (this.m_model.getIconLocation() != null) {
            this.m_selector.setFile(this.getAbsolutePath(new File(this.m_model.getIconLocation())));
            this.setIconLocation(this.getAbsolutePath(new File(this.m_model.getIconLocation())));
        } else {
            this.m_selector.setFile(null);
            this.setIconLocation(new File(""));
        }
    }

    public void updateModel() {
        File f = this.m_selector.getFile();
        if (f != null) {
            this.m_model.setIconLocation(this.m_selector.getFile().toString());
        } else {
            this.m_model.setIconLocation(null);
        }
    }

    public String getLabel() {
        return "ICONLOCATION_LABEL";
    }

    public String getDescription() {
        return "ICONLOCATION_HELP";
    }

    private void setIconLocation(File iconfile) {
        if (!iconfile.isAbsolute()) {
            iconfile = new File(this.m_basedir, iconfile.toString());
        }
        ImageIcon icon = null;
        System.out.println("setIconLocation: " + iconfile);
        if (iconfile.toString().toUpperCase().endsWith(".ICO")) {
            try {
                BufferedImage[] images = IcoCodec.loadImages(iconfile);
                if (images != null && images.length > 0) {
                    BufferedImage img = images[0];
                    icon = new ImageIcon(img);
                }
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        } else {
            icon = new ImageIcon(iconfile.getAbsolutePath(), "default icon");
        }
        if (icon != null) {
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            this.m_iconDisplay.setIcon(icon);
            this.m_iconDisplay.setText("");
            this.m_model.setIconLocation(iconfile.getAbsolutePath());
            this.validate();
            this.invalidate();
        } else {
            this.m_iconDisplay.setIcon(null);
            this.m_iconDisplay.setText("(no image)");
            this.m_model.setIconLocation(null);
        }
        this.doLayout();
        this.invalidate();
        this.validate();
        this.repaint();
    }
}

