/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class listclass {
    boolean code;
    boolean constants;
    boolean verbose;
    boolean classdep;
    boolean nocontents;
    boolean recurse;
    Hashtable listedClasses;
    Vector exclude_name;

    public static void main(String[] argv) {
        Vector<String> file_name = new Vector<String>();
        Vector<String> exclude_name = new Vector<String>();
        boolean code = false;
        boolean constants = false;
        boolean verbose = true;
        boolean classdep = false;
        boolean nocontents = false;
        boolean recurse = false;
        boolean exclude = false;
        String name = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].charAt(0) == '-') {
                if (argv[i].equals("-constants")) {
                    constants = true;
                    continue;
                }
                if (argv[i].equals("-code")) {
                    code = true;
                    continue;
                }
                if (argv[i].equals("-brief")) {
                    verbose = false;
                    continue;
                }
                if (argv[i].equals("-dependencies")) {
                    classdep = true;
                    continue;
                }
                if (argv[i].equals("-nocontents")) {
                    nocontents = true;
                    continue;
                }
                if (argv[i].equals("-recurse")) {
                    recurse = true;
                    continue;
                }
                if (argv[i].equals("-exclude")) {
                    exclude = true;
                    continue;
                }
                if (argv[i].equals("-help")) {
                    System.out.println("Usage: java listclass [-constants] [-code] [-brief] [-dependencies] [-nocontents] [-recurse] class... [-exclude <list>]\n-constants       Print constants table (constant pool)\n-code            Dump byte code of methods\n-brief           Brief listing\n-dependencies    Show class dependencies\n-nocontents      Do not print field/method information\n-recurse         Recurse into dependent classes\n-exclude <list>  Do not list classes beginning with strings in <list>");
                    System.exit(0);
                    continue;
                }
                System.err.println("Unknown switch " + argv[i] + " ignored.");
                continue;
            }
            if (exclude) {
                exclude_name.addElement(argv[i]);
                continue;
            }
            file_name.addElement(argv[i]);
        }
        if (file_name.size() == 0) {
            System.err.println("list: No input files specified");
        } else {
            listclass listClass = new listclass(code, constants, verbose, classdep, nocontents, recurse, exclude_name);
            for (int i = 0; i < file_name.size(); ++i) {
                name = (String)file_name.elementAt(i);
                listClass.list(name);
            }
        }
    }

    public listclass(boolean code, boolean constants, boolean verbose, boolean classdep, boolean nocontents, boolean recurse, Vector exclude_name) {
        this.code = code;
        this.constants = constants;
        this.verbose = verbose;
        this.classdep = classdep;
        this.nocontents = nocontents;
        this.recurse = recurse;
        this.listedClasses = new Hashtable();
        this.exclude_name = exclude_name;
    }

    public void list(String name) {
        try {
            if (this.listedClasses.get(name) != null || name.startsWith("[")) {
                return;
            }
            for (int idx = 0; idx < this.exclude_name.size(); ++idx) {
                if (!name.startsWith((String)this.exclude_name.elementAt(idx))) continue;
                return;
            }
            JavaClass java_class = name.endsWith(".class") ? new ClassParser(name).parse() : Repository.lookupClass(name);
            if (this.nocontents) {
                System.out.println(java_class.getClassName());
            } else {
                System.out.println(java_class);
            }
            if (this.constants) {
                System.out.println(java_class.getConstantPool());
            }
            if (this.code) {
                listclass.printCode(java_class.getMethods(), this.verbose);
            }
            if (this.classdep) {
                listclass.printClassDependencies(java_class.getConstantPool());
            }
            this.listedClasses.put(name, name);
            if (this.recurse) {
                String[] dependencies = listclass.getClassDependencies(java_class.getConstantPool());
                for (int idx = 0; idx < dependencies.length; ++idx) {
                    this.list(dependencies[idx]);
                }
            }
        }
        catch (IOException e) {
            System.out.println("Error loading class " + name + " (" + e.getMessage() + ")");
        }
        catch (Exception e) {
            System.out.println("Error processing class " + name + " (" + e.getMessage() + ")");
        }
    }

    public static void printClassDependencies(ConstantPool pool) {
        String[] names = listclass.getClassDependencies(pool);
        System.out.println("Dependencies:");
        for (int idx = 0; idx < names.length; ++idx) {
            System.out.println("\t" + names[idx]);
        }
    }

    public static String[] getClassDependencies(ConstantPool pool) {
        String[] tempArray = new String[pool.getLength()];
        int size = 0;
        StringBuffer buf = new StringBuffer();
        for (int idx = 0; idx < pool.getLength(); ++idx) {
            Constant c = pool.getConstant(idx);
            if (c == null || c.getTag() != 7) continue;
            ConstantUtf8 c1 = (ConstantUtf8)pool.getConstant(((ConstantClass)c).getNameIndex());
            buf.setLength(0);
            buf.append(new String(c1.getBytes()));
            for (int n = 0; n < buf.length(); ++n) {
                if (buf.charAt(n) != '/') continue;
                buf.setCharAt(n, '.');
            }
            tempArray[size++] = buf.toString();
        }
        String[] dependencies = new String[size];
        System.arraycopy(tempArray, 0, dependencies, 0, size);
        return dependencies;
    }

    public static void printCode(Method[] methods, boolean verbose) {
        for (int i = 0; i < methods.length; ++i) {
            System.out.println(methods[i]);
            Code code = methods[i].getCode();
            if (code == null) continue;
            System.out.println(code.toString(verbose));
        }
    }
}

