/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public abstract class JRXlsAbstractExporter
extends JRAbstractExporter {
    protected List loadedFonts = new ArrayList();
    protected boolean isOnePagePerSheet;
    protected boolean isRemoveEmptySpace;
    protected boolean isWhitePageBackground;
    protected boolean isAutoDetectCellType = true;
    protected boolean isDetectCellType;
    protected boolean isFontSizeFixEnabled;
    protected boolean isIgnoreGraphics;
    protected boolean isCollapseRowSpan;
    protected boolean isIgnoreCellBorder;
    protected int maxRowsPerSheet;
    protected JRHyperlinkProducerFactory hyperlinkProducerFactory;
    protected String[] sheetNames = null;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected Map fontMap = null;
    protected JRFont defaultFont = null;
    protected int sheetIndex = 0;
    protected Map sheetNamesMap = null;
    protected String currentSheetName = null;

    protected JRFont getDefaultFont() {
        return this.defaultFont;
    }

    protected JRHyperlinkProducer getCustomHandler(JRPrintHyperlink link) {
        return this.hyperlinkProducerFactory == null ? null : this.hyperlinkProducerFactory.getHandler(link.getLinkType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block18: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.setParameters();
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    this.exportReportToStream(os);
                    break block18;
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToStream(os);
                    os.flush();
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    protected void setParameters() {
        this.isOnePagePerSheet = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, "net.sf.jasperreports.export.xls.one.page.per.sheet", false);
        this.isRemoveEmptySpace = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, "net.sf.jasperreports.export.xls.remove.empty.space.between.rows", false);
        this.isWhitePageBackground = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, "net.sf.jasperreports.export.xls.white.page.background", false);
        this.setBackground();
        Boolean isAutoDetectCellTypeParameter = (Boolean)this.parameters.get(JRXlsAbstractExporterParameter.IS_AUTO_DETECT_CELL_TYPE);
        if (isAutoDetectCellTypeParameter != null) {
            this.isAutoDetectCellType = isAutoDetectCellTypeParameter;
        }
        this.isWhitePageBackground = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, "net.sf.jasperreports.export.xls.detect.cell.type", false);
        this.isFontSizeFixEnabled = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, "net.sf.jasperreports.export.xls.font.size.fix.enabled", false);
        this.isIgnoreGraphics = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, "net.sf.jasperreports.export.xls.ignore.graphics", false);
        this.isCollapseRowSpan = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, "net.sf.jasperreports.export.xls.collapse.row.span", false);
        this.isIgnoreCellBorder = this.getBooleanParameter(JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, "net.sf.jasperreports.export.xls.ignore.cell.border", false);
        this.sheetNames = (String[])this.parameters.get(JRXlsAbstractExporterParameter.SHEET_NAMES);
        this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
        this.hyperlinkProducerFactory = (JRHyperlinkProducerFactory)this.parameters.get(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY);
        this.maxRowsPerSheet = this.getIntegerParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, "net.sf.jasperreports.export.xls.max.rows.per.sheet", 0);
    }

    protected abstract void setBackground();

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.openWorkbook(os);
        this.sheetNamesMap = new HashMap();
        this.sheetNamesMap.put("Page", new Integer(0));
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
            this.defaultFont = new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider());
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                if (this.isOnePagePerSheet) {
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                        if (this.sheetNames != null && this.sheetIndex < this.sheetNames.length) {
                            this.createSheet(this.getSheetName(this.sheetNames[this.sheetIndex]));
                        } else {
                            this.createSheet(this.getSheetName("Page"));
                        }
                        ++this.sheetIndex;
                        this.exportPage(page, null, 0);
                    }
                } else {
                    if (this.sheetNames != null && this.sheetIndex < this.sheetNames.length) {
                        this.createSheet(this.getSheetName(this.sheetNames[this.sheetIndex]));
                    } else {
                        this.createSheet(this.getSheetName(this.jasperPrint.getName()));
                    }
                    ++this.sheetIndex;
                    List xCuts = JRGridLayout.calculateXCuts(this.getNature(), pages, this.startPageIndex, this.endPageIndex, this.jasperPrint.getPageWidth(), this.globalOffsetX);
                    this.setColumnWidths(xCuts);
                    int startRow = 0;
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                        startRow = this.exportPage(page, xCuts, startRow);
                    }
                }
            }
            ++this.reportIndex;
        }
        this.closeWorkbook(os);
    }

    protected int exportPage(JRPrintPage page, List xCuts, int startRow) throws JRException {
        JRGridLayout layout = new JRGridLayout(this.getNature(), page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, xCuts);
        JRExporterGridCell[][] grid = layout.getGrid();
        if (xCuts == null) {
            xCuts = layout.getXCuts();
            this.setColumnWidths(xCuts);
        }
        int skippedRows = 0;
        int rowIndex = startRow;
        for (int y = 0; y < grid.length; ++y) {
            rowIndex = y - skippedRows + startRow;
            if (this.maxRowsPerSheet > 0 && rowIndex >= this.maxRowsPerSheet) {
                this.createSheet(this.getSheetName(this.currentSheetName));
                startRow = 0;
                rowIndex = 0;
                skippedRows = y;
                this.setColumnWidths(xCuts);
            }
            if (layout.isRowNotEmpty(y) || (!this.isRemoveEmptySpace || layout.isRowSpanned(y)) && !this.isCollapseRowSpan) {
                JRExporterGridCell[] gridRow = grid[y];
                int emptyCellColSpan = 0;
                int emptyCellWidth = 0;
                this.setRowHeight(rowIndex, this.isCollapseRowSpan ? JRGridLayout.getMaxRowHeight(gridRow) : JRGridLayout.getRowHeight(gridRow));
                for (int x = 0; x < gridRow.length; ++x) {
                    this.setCell(x, rowIndex);
                    JRExporterGridCell gridCell = gridRow[x];
                    if (gridCell.getWrapper() != null) {
                        JRPrintElement element;
                        if (emptyCellColSpan > 0) {
                            if (emptyCellColSpan > 1) {
                                // empty if block
                            }
                            emptyCellColSpan = 0;
                            emptyCellWidth = 0;
                        }
                        if ((element = gridCell.getWrapper().getElement()) instanceof JRPrintLine) {
                            this.exportLine((JRPrintLine)element, gridCell, x, rowIndex);
                        } else if (element instanceof JRPrintRectangle) {
                            this.exportRectangle(element, gridCell, x, rowIndex);
                        } else if (element instanceof JRPrintEllipse) {
                            this.exportRectangle(element, gridCell, x, rowIndex);
                        } else if (element instanceof JRPrintImage) {
                            this.exportImage((JRPrintImage)element, gridCell, x, rowIndex);
                        } else if (element instanceof JRPrintText) {
                            this.exportText((JRPrintText)element, gridCell, x, rowIndex);
                        } else if (element instanceof JRPrintFrame) {
                            this.exportFrame((JRPrintFrame)element, gridCell, x, y);
                        }
                        x += gridCell.getColSpan() - 1;
                        continue;
                    }
                    ++emptyCellColSpan;
                    emptyCellWidth += gridCell.getWidth();
                    this.addBlankCell(gridCell, x, rowIndex);
                }
                if (emptyCellColSpan > 0 && emptyCellColSpan <= 1) continue;
            }
            ++skippedRows;
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
        return rowIndex;
    }

    protected void setColumnWidths(List xCuts) {
        int width = 0;
        for (int i = 1; i < xCuts.size(); ++i) {
            width = (Integer)xCuts.get(i) - (Integer)xCuts.get(i - 1);
            this.setColumnWidth((short)(i - 1), (short)(width * 43));
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(null, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(null, 0, text.length()));
            }
        }
        return styledText;
    }

    protected static TextAlignHolder getTextAlignHolder(JRPrintText textElement) {
        short horizontalAlignment;
        short verticalAlignment;
        short rotation = textElement.getRotation();
        block0 : switch (textElement.getRotation()) {
            case 1: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 3;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                }
                horizontalAlignment = 1;
                break;
            }
            case 2: {
                switch (textElement.getHorizontalAlignment()) {
                    case 1: {
                        verticalAlignment = 1;
                        break;
                    }
                    case 2: {
                        verticalAlignment = 2;
                        break;
                    }
                    case 3: {
                        verticalAlignment = 3;
                        break;
                    }
                    case 4: {
                        verticalAlignment = 4;
                        break;
                    }
                    default: {
                        verticalAlignment = 1;
                    }
                }
                switch (textElement.getVerticalAlignment()) {
                    case 1: {
                        horizontalAlignment = 3;
                        break block0;
                    }
                    case 2: {
                        horizontalAlignment = 2;
                        break block0;
                    }
                    case 3: {
                        horizontalAlignment = 1;
                        break block0;
                    }
                }
                horizontalAlignment = 3;
                break;
            }
            default: {
                horizontalAlignment = textElement.getHorizontalAlignment();
                verticalAlignment = textElement.getVerticalAlignment();
            }
        }
        return new TextAlignHolder(horizontalAlignment, verticalAlignment, rotation);
    }

    private String getSheetName(String sheetName) {
        this.currentSheetName = sheetName;
        if (!this.sheetNamesMap.containsKey(sheetName)) {
            this.sheetNamesMap.put(sheetName, new Integer(1));
            return sheetName;
        }
        int currentIndex = (Integer)this.sheetNamesMap.get(sheetName) + 1;
        this.sheetNamesMap.put(sheetName, new Integer(currentIndex));
        return sheetName + " " + currentIndex;
    }

    protected abstract ExporterNature getNature();

    protected abstract void openWorkbook(OutputStream var1) throws JRException;

    protected abstract void createSheet(String var1);

    protected abstract void closeWorkbook(OutputStream var1) throws JRException;

    protected abstract void setColumnWidth(short var1, short var2);

    protected abstract void setRowHeight(int var1, int var2) throws JRException;

    protected abstract void setCell(int var1, int var2);

    protected abstract void addBlankCell(JRExporterGridCell var1, int var2, int var3) throws JRException;

    protected abstract void exportText(JRPrintText var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportImage(JRPrintImage var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportRectangle(JRPrintElement var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportLine(JRPrintLine var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected abstract void exportFrame(JRPrintFrame var1, JRExporterGridCell var2, int var3, int var4) throws JRException;

    protected static class TextAlignHolder {
        public final short horizontalAlignment;
        public final short verticalAlignment;
        public final short rotation;

        public TextAlignHolder(short horizontalAlignment, short verticalAlignment, short rotation) {
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
        }
    }
}

