/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.table;

import it.businesslogic.ireport.gui.dnd.TransferableObject;
import it.businesslogic.ireport.gui.table.SortChangedEvent;
import it.businesslogic.ireport.gui.table.SortChangedListener;
import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.table.TableColumnExt;

public class JDragTable
extends JXTable
implements DragGestureListener,
DragSourceListener {
    private EventListenerList listenerList = null;

    public JDragTable() {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 1, this);
        this.setColumnControlVisible(true);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        TransferableObject to = new TransferableObject(this.getValueAt(this.getSelectedRow(), this.getSelectedColumn()));
        try {
            if (to != null) {
                e.startDrag(DragSource.DefaultCopyDrop, to);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void toggleSortOrder(int columnIndex) {
        super.toggleSortOrder(columnIndex);
        int index = this.convertColumnIndexToModel(columnIndex);
        SortOrder so = SortOrder.UNSORTED;
        SortController sortController = this.getSortController();
        if (sortController != null) {
            so = sortController.getSortOrder(index);
        }
        this.fireSortChangedListenerSortChanged(new SortChangedEvent(this, index, so));
    }

    public void toggleSortOrder(Object identifier) {
        super.toggleSortOrder(identifier);
        TableColumnExt columnExt = this.getColumnExt(identifier);
        int index = columnExt.getModelIndex();
        SortOrder so = SortOrder.UNSORTED;
        SortController sortController = this.getSortController();
        if (sortController != null) {
            so = sortController.getSortOrder(index);
        }
        this.fireSortChangedListenerSortChanged(new SortChangedEvent(this, index, so));
    }

    public void setSortOrder(Object identifier, SortOrder arg1) {
        super.setSortOrder(identifier, arg1);
        TableColumnExt columnExt = this.getColumnExt(identifier);
        int index = columnExt.getModelIndex();
        SortOrder so = SortOrder.UNSORTED;
        SortController sortController = this.getSortController();
        if (sortController != null) {
            so = sortController.getSortOrder(index);
        }
        this.fireSortChangedListenerSortChanged(new SortChangedEvent(this, index, so));
    }

    public void resetSortOrder() {
        super.resetSortOrder();
        this.fireSortChangedListenerSortChanged(new SortChangedEvent(this, -1, SortOrder.UNSORTED));
    }

    public synchronized void addSortChangedListener(SortChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(SortChangedListener.class, listener);
    }

    public synchronized void removeSortChangedListener(SortChangedListener listener) {
        this.listenerList.remove(SortChangedListener.class, listener);
    }

    private void fireSortChangedListenerSortChanged(SortChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SortChangedListener.class) continue;
            ((SortChangedListener)listeners[i + 1]).sortChanged(event);
        }
    }
}

