/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportBandsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.event.ReportObjectsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedEvent;
import it.businesslogic.ireport.gui.event.ReportSubDatasetChangedListener;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedEvent;
import it.businesslogic.ireport.gui.event.SubDatasetObjectChangedListener;
import it.businesslogic.ireport.gui.sheet.ReportBandSheetPanel;
import it.businesslogic.ireport.gui.sheet.ReportElementSheetPanel;
import it.businesslogic.ireport.gui.sheet.ReportObjectSheetPanel;
import it.businesslogic.ireport.gui.sheet.ReportSheetPanel;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DocumentSheetPanel
extends JPanel
implements ReportListener,
LanguageChangedListener,
ReportFrameActivatedListener,
SubDatasetObjectChangedListener,
ReportSubDatasetChangedListener {
    private ReportElementSheetPanel reportElementSheetPanel = null;
    private ReportBandSheetPanel reportBandSheetPanel = null;
    private ReportSheetPanel reportSheetPanel = null;
    private ReportObjectSheetPanel reportObjectSheetPanel = null;
    public static final int SHOW_NOTHING = -1;
    public static final int SHOW_DOCUMENT_SHEET = 0;
    public static final int SHOW_BAND_SHEET = 1;
    public static final int SHOW_REPORTELEMENT_SHEET = 2;
    public static final int SHOW_REPORTOBJECT_SHEET = 3;
    int currentMode = -2;
    private JReportFrame jReportFrame = null;

    public DocumentSheetPanel() {
        this.initComponents();
        this.setReportElementSheetPanel(new ReportElementSheetPanel());
        this.setReportBandSheetPanel(new ReportBandSheetPanel());
        this.setReportSheetPanel(new ReportSheetPanel());
        this.setReportObjectSheetPanel(new ReportObjectSheetPanel());
        this.getReportBandSheetPanel().setResizeWeight(0.4);
        this.getReportElementSheetPanel().setResizeWeight(0.4);
        this.getReportSheetPanel().setResizeWeight(0.4);
        this.getReportObjectSheetPanel().setResizeWeight(0.4);
        MainFrame mf = MainFrame.getMainInstance();
        mf.addReportListener(this);
        mf.addReportFrameActivatedListener(this);
        this.setCurrentMode(-1);
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        if (this.jReportFrame != jReportFrame) {
            this.jReportFrame = jReportFrame;
            this.updateView();
        }
    }

    public void updateView() {
        if (this.jReportFrame == null) {
            this.setCurrentMode(-1);
            return;
        }
        if (this.jReportFrame.getSelectedCrosstabEditorPanel() != null && this.jReportFrame.getSelectedCrosstabEditorPanel().getSelectedElements().size() > 0 || this.jReportFrame.getSelectedCrosstabEditorPanel() == null && this.jReportFrame.getSelectedElements().size() > 0) {
            this.setCurrentMode(2);
        } else if (this.jReportFrame.getSelectedObjects().size() > 0) {
            this.setCurrentMode(3);
        } else if (this.jReportFrame.getSelectedBands().size() > 0) {
            this.setCurrentMode(1);
        } else {
            this.setCurrentMode(0);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
        this.updateView();
    }

    public void reportBandsSelectionChanged(ReportElementsSelectionEvent evt) {
        this.updateView();
    }

    public void reportObjectsSelectionChanged(ReportObjectsSelectionEvent evt) {
        this.updateView();
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
    }

    public void languageChanged(LanguageChangedEvent evt) {
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        this.setJReportFrame(evt.getReportFrame());
    }

    public void reportBandsSelectionChanged(ReportBandsSelectionEvent evt) {
        this.updateView();
    }

    public int getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(int newMode) {
        if (newMode == this.currentMode) {
            return;
        }
        this.removeAll();
        this.currentMode = newMode;
        switch (this.currentMode) {
            case -1: {
                JLabel label = new JLabel(I18n.getString("properties", "Properties"));
                label.setHorizontalAlignment(0);
                this.add((Component)label, "Center");
                break;
            }
            case 0: {
                this.add((Component)this.getReportSheetPanel(), "Center");
                break;
            }
            case 1: {
                this.add((Component)this.getReportBandSheetPanel(), "Center");
                break;
            }
            case 2: {
                this.add((Component)this.getReportElementSheetPanel(), "Center");
                break;
            }
            case 3: {
                this.add((Component)this.getReportObjectSheetPanel(), "Center");
            }
        }
        this.updateUI();
    }

    public ReportElementSheetPanel getReportElementSheetPanel() {
        return this.reportElementSheetPanel;
    }

    public void setReportElementSheetPanel(ReportElementSheetPanel reportElementSheetPanel) {
        this.reportElementSheetPanel = reportElementSheetPanel;
    }

    public ReportBandSheetPanel getReportBandSheetPanel() {
        return this.reportBandSheetPanel;
    }

    public void setReportBandSheetPanel(ReportBandSheetPanel reportBandSheetPanel) {
        this.reportBandSheetPanel = reportBandSheetPanel;
    }

    public ReportSheetPanel getReportSheetPanel() {
        return this.reportSheetPanel;
    }

    public void setReportSheetPanel(ReportSheetPanel reportSheetPanel) {
        this.reportSheetPanel = reportSheetPanel;
    }

    public ReportObjectSheetPanel getReportObjectSheetPanel() {
        return this.reportObjectSheetPanel;
    }

    public void setReportObjectSheetPanel(ReportObjectSheetPanel reportObjectSheetPanel) {
        this.reportObjectSheetPanel = reportObjectSheetPanel;
    }

    public void setPropertyLabelError(String propertyName, String error) {
        switch (this.getCurrentMode()) {
            case 0: {
                this.getReportSheetPanel().setPropertyLabelError(propertyName, error);
                break;
            }
            case 1: {
                this.getReportBandSheetPanel().setPropertyLabelError(propertyName, error);
                break;
            }
            case 2: {
                this.getReportElementSheetPanel().setPropertyLabelError(propertyName, error);
                break;
            }
            case 3: {
                this.getReportObjectSheetPanel().setPropertyLabelError(propertyName, error);
            }
        }
    }

    public void subDatasetObjectChanged(SubDatasetObjectChangedEvent evt) {
        if (this.getCurrentMode() == 3 && this.getReportObjectSheetPanel().getSelection().contains(evt.getNewValue()) && !this.getReportObjectSheetPanel().isInit()) {
            this.getReportObjectSheetPanel().updateSelection();
        }
    }

    public void reportSubDatasetChanged(ReportSubDatasetChangedEvent evt) {
        if (this.getCurrentMode() == 3) {
            if (evt.getAction() == 8) {
                boolean needUpdate = false;
                if (this.getReportObjectSheetPanel().getSelection().contains(evt.getSubDataset())) {
                    needUpdate = true;
                }
                for (int i = 0; !needUpdate && i < evt.getElements().size(); ++i) {
                    if (!this.getReportObjectSheetPanel().getSelection().contains(evt.getElements().get(i))) continue;
                    needUpdate = true;
                }
                if (needUpdate && !this.getReportObjectSheetPanel().isInit()) {
                    this.getReportObjectSheetPanel().updateSelection();
                }
            }
        }
    }
}

