/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.docking;

import it.businesslogic.ireport.gui.docking.DockingContainer;
import it.businesslogic.ireport.gui.docking.ExtendedTabbedPane;
import it.businesslogic.ireport.gui.docking.GenericDragTargetListener;
import it.businesslogic.ireport.gui.docking.PanelTransferable;
import it.businesslogic.ireport.gui.docking.PanelView;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class JDraggableTabbedPane
extends ExtendedTabbedPane
implements LanguageChangedListener {
    private JMenuItem jMenuItemMerge;
    private JMenuItem jMenuItemUnmerge;
    private JPopupMenu jPopupMenu;
    private DockingContainer dockingContainer = null;
    private int position = 0;
    private DragSource dragSource;
    private DragGestureListener dgListener;
    private DragSourceListener dsListener;
    private DropTarget dropTarget;
    private DropTargetListener dtListener;
    private int dragAction = 2;
    private int acceptableActions = 2;

    public JDraggableTabbedPane() {
        I18n.setCurrentLocale(System.getProperty("Language"), System.getProperty("Country"));
        this.dragSource = DragSource.getDefaultDragSource();
        this.dgListener = new DGListener();
        this.dsListener = new DSListener((int)(1000.0 * Math.random()));
        this.dtListener = new GenericDragTargetListener();
        this.dropTarget = new DropTarget(this, this.acceptableActions, this.dtListener, true);
        this.dragSource.createDefaultDragGestureRecognizer(this, this.dragAction, this.dgListener);
        this.jPopupMenu = new JPopupMenu();
        this.jMenuItemMerge = new JMenuItem();
        this.jMenuItemMerge.setText("Merge panels");
        this.jMenuItemMerge.setEnabled(true);
        this.jMenuItemMerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDraggableTabbedPane.this.jMenuItemMergeActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemMerge);
        this.jMenuItemUnmerge = new JMenuItem();
        this.jMenuItemUnmerge.setText("Separate panel");
        this.jMenuItemUnmerge.setEnabled(true);
        this.jMenuItemUnmerge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDraggableTabbedPane.this.jMenuItemUnmergeActionPerformed(evt);
            }
        });
        this.jPopupMenu.add(this.jMenuItemUnmerge);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JDraggableTabbedPane.this.onMouseClicked(evt);
            }
        });
        this.setOpaque(true);
        I18n.addOnLanguageChangedListener(this);
    }

    private void jMenuItemUnmergeActionPerformed(ActionEvent evt) {
        PanelView pv = new PanelView(this.getTitleAt(this.getSelectedIndex()), this.getSelectedComponent(), this.getPosition(), this.isClosable(this.getSelectedIndex()));
        this.getDockingContainer().moveComponent(pv, pv.getPosition(), 1);
    }

    private void jMenuItemMergeActionPerformed(ActionEvent evt) {
        this.getDockingContainer().mergePosition(this.getPosition());
    }

    public void onMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            this.jPopupMenu.show(this, evt.getPoint().x, evt.getPoint().y);
        }
    }

    public DockingContainer getDockingContainer() {
        return this.dockingContainer;
    }

    public void setDockingContainer(DockingContainer dockingContainer) {
        this.dockingContainer = dockingContainer;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void applyI18n() {
        this.jMenuItemMerge.setText(I18n.getString("mergePanels", "Merge panels"));
        this.jMenuItemUnmerge.setText(I18n.getString("unmergePanel", "Seperate panel"));
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    class DSListener
    implements DragSourceListener {
        public int myId = 0;

        public DSListener(int id) {
            this.myId = id;
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            if (GenericDragTargetListener.lastDp != null) {
                GenericDragTargetListener.lastDp.repaint();
                GenericDragTargetListener.lastDp = null;
            }
        }

        public void dragEnter(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int myaction = e.getDropAction();
            if ((myaction & JDraggableTabbedPane.this.dragAction) != 0) {
                context.setCursor(DragSource.DefaultCopyDrop);
            } else {
                context.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        public void dragOver(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            int sa = context.getSourceActions();
            int ua = e.getUserAction();
            int da = e.getDropAction();
            int ta = e.getTargetActions();
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
            DragSourceContext context = e.getDragSourceContext();
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    class DGListener
    implements DragGestureListener {
        DGListener() {
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            if ((e.getDragAction() & JDraggableTabbedPane.this.dragAction) == 0) {
                return;
            }
            if (JDraggableTabbedPane.this.getSelectedIndex() < 0) {
                return;
            }
            PanelView pv = new PanelView(JDraggableTabbedPane.this.getTitleAt(JDraggableTabbedPane.this.getSelectedIndex()), JDraggableTabbedPane.this.getSelectedComponent(), JDraggableTabbedPane.this.getPosition(), JDraggableTabbedPane.this.isClosable(JDraggableTabbedPane.this.getSelectedIndex()));
            pv.setDockingContainer(JDraggableTabbedPane.this.getDockingContainer());
            PanelTransferable transferable = new PanelTransferable(pv);
            try {
                e.startDrag(DragSource.DefaultCopyNoDrop, transferable, JDraggableTabbedPane.this.dsListener);
            }
            catch (InvalidDnDOperationException idoe) {
                // empty catch block
            }
        }
    }
}

