/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.gui.PropertiesDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class JRParameterDialog
extends JDialog {
    JRParameter tmpParameter = null;
    private SubDataset subDataset = null;
    String originalName = null;
    private List properties = new ArrayList();
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonParameterProperties;
    private JCheckBox jCheckBoxIsForPrompting;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JRTextExpressionArea jRTextExpressionAreaDefaultExpression;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_DEFAULT_EXPRESSION = 1;

    public JRParameterDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.jRTextExpressionAreaDefaultExpression.setText("");
        this.setClassTypes();
        this.jComboBoxType.setSelectedItem("java.lang.String");
        this.jComboBoxType.setEditable(true);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRParameterDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setClassTypes() {
        this.jComboBoxType.addItem("java.lang.String");
        this.jComboBoxType.addItem("java.lang.Object");
        this.jComboBoxType.addItem("java.lang.Boolean");
        this.jComboBoxType.addItem("java.lang.Byte");
        this.jComboBoxType.addItem("java.util.Date");
        this.jComboBoxType.addItem("java.sql.Timestamp");
        this.jComboBoxType.addItem("java.sql.Time");
        this.jComboBoxType.addItem("java.lang.Double");
        this.jComboBoxType.addItem("java.lang.Float");
        this.jComboBoxType.addItem("java.lang.Integer");
        this.jComboBoxType.addItem("java.io.InputStream");
        this.jComboBoxType.addItem("java.lang.Long");
        this.jComboBoxType.addItem("java.lang.Short");
        this.jComboBoxType.addItem("java.math.BigDecimal");
        this.jComboBoxType.addItem("net.sf.jasperreports.engine.JREmptyDataSource");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jCheckBoxIsForPrompting = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionAreaDefaultExpression = new JRTextExpressionArea();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jButtonParameterProperties = new JButton();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify parameter");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRParameterDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Parameter name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel2.setText("Parameter class type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBoxType.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxType, gridBagConstraints);
        this.jCheckBoxIsForPrompting.setText("Is for prompting");
        this.jCheckBoxIsForPrompting.setNextFocusableComponent(this.jRTextExpressionAreaDefaultExpression);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jCheckBoxIsForPrompting, gridBagConstraints);
        this.jLabel3.setText("Default value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaDefaultExpression.setCaretVisible(false);
        this.jRTextExpressionAreaDefaultExpression.setElectricScroll(0);
        this.jRTextExpressionAreaDefaultExpression.setMinimumSize(new Dimension(0, 60));
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(310, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.jLabel4.setText("Parameter description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(22, 50));
        this.jScrollPane1.setPreferredSize(new Dimension(3, 50));
        this.jTextAreaDescription.setMinimumSize(new Dimension(0, 32));
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonParameterProperties.setText("Edit parameter properties...");
        this.jButtonParameterProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRParameterDialog.this.jButtonParameterPropertiesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.jButtonParameterProperties, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jSeparator1.setMinimumSize(new Dimension(2, 2));
        this.jSeparator1.setPreferredSize(new Dimension(2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 4, 0);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRParameterDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRParameterDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonParameterPropertiesActionPerformed(ActionEvent evt) {
        PropertiesDialog pd = new PropertiesDialog((Dialog)this, true);
        pd.setProperties(this.getProperties());
        pd.setVisible(true);
        if (pd.getDialogResult() == 0) {
            this.setProperties(pd.getProperties());
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRParameterDialog.notValidParameterName", "Please insert a valid parameter name!"), I18n.getString("messages.jRParameterDialog.notValidParameterNameCaption", "Invalid parameter!"), 2);
            return;
        }
        if (this.getSubDataset() != null) {
            String newName = this.jTextFieldName.getText();
            if (this.originalName == null || !this.originalName.equals(newName)) {
                for (int i = 0; i < this.getSubDataset().getParameters().size(); ++i) {
                    JRParameter f = (JRParameter)this.getSubDataset().getParameters().get(i);
                    if (!f.getName().equals(newName)) continue;
                    JOptionPane.showMessageDialog(this, I18n.getString("messages.jRParameterDialog.DuplicatedParameterName", "A parameter with this name already exists!"), I18n.getString("messages.jRParameterDialog.notValidParameterNameCaption", "Invalid parameter!"), 2);
                    return;
                }
            }
        }
        this.tmpParameter = new JRParameter(this.jTextFieldName.getText(), "java.lang.String", this.jCheckBoxIsForPrompting.isSelected(), this.jTextAreaDescription.getText());
        this.tmpParameter.setProperties(this.properties);
        if (this.jComboBoxType.getSelectedItem().toString().trim().length() != 0) {
            this.tmpParameter.setClassType(this.jComboBoxType.getSelectedItem().toString().trim());
        }
        this.tmpParameter.setDefaultValueExpression(this.jRTextExpressionAreaDefaultExpression.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRParameter getParameter() {
        return this.tmpParameter;
    }

    public void setParameter(JRParameter tmpParameter) {
        this.originalName = tmpParameter.getName();
        this.jTextFieldName.setText(new String(tmpParameter.getName()));
        this.jComboBoxType.setSelectedItem(new String(tmpParameter.getClassType()));
        this.jCheckBoxIsForPrompting.setSelected(tmpParameter.isIsForPrompting());
        this.jTextAreaDescription.setText(new String(tmpParameter.getDescription()));
        this.jRTextExpressionAreaDefaultExpression.setText(new String(tmpParameter.getDefaultValueExpression()));
        this.properties = new ArrayList();
        for (JRProperty p : tmpParameter.getProperties()) {
            this.properties.add(p.cloneMe());
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
        this.jRTextExpressionAreaDefaultExpression.setSubDataset(subDataset);
        this.jRTextExpressionAreaDefaultExpression.getTokenMarker().setKeywordLookup(subDataset.getKeywordLookup());
    }

    public void applyI18n() {
        this.jCheckBoxIsForPrompting.setText(I18n.getString("jRParameterDialog.checkBoxIsForPrompting", "Is for prompting"));
        this.jButtonCancel.setText(I18n.getString("jRParameterDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRParameterDialog.buttonOK", "OK"));
        this.jButtonParameterProperties.setText(I18n.getString("jRParameterDialog.buttonParameterProperties", "Edit parameter properties..."));
        this.jLabel1.setText(I18n.getString("jRParameterDialog.label1", "Parameter name"));
        this.jLabel2.setText(I18n.getString("jRParameterDialog.label2", "Parameter class type"));
        this.jLabel3.setText(I18n.getString("jRParameterDialog.label3", "Default value expression"));
        this.jLabel4.setText(I18n.getString("jRParameterDialog.label4", "Parameter description"));
        this.setTitle(I18n.getString("jRParameterDialog.title", "Add/modify parameter"));
        this.jButtonCancel.setMnemonic(I18n.getString("jRParameterDialog.buttonCancelMnemonic", "c").charAt(0));
        this.jButtonOK.setMnemonic(I18n.getString("jRParameterDialog.buttonOKMnemonic", "o").charAt(0));
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setFocusedExpression(int expID) {
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionAreaDefaultExpression);
            }
        }
    }

    public List getProperties() {
        return this.properties;
    }

    public void setProperties(List properties) {
        this.properties = properties;
    }
}

