/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.FrameReportElement;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.ReportElementFactory;
import it.businesslogic.ireport.StaticTextReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabParameter;
import it.businesslogic.ireport.crosstab.CrosstabRowGroup;
import it.businesslogic.ireport.crosstab.GroupTotal;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.crosstab.gui.CellAnimationEffect;
import it.businesslogic.ireport.crosstab.gui.CrosstabCellDialog;
import it.businesslogic.ireport.crosstab.gui.CrosstabEditor;
import it.businesslogic.ireport.crosstab.gui.CrosstabPropertiesDialog;
import it.businesslogic.ireport.gui.FieldPatternDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.command.FormatCommand;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.library.AbstractLibraryObject;
import it.businesslogic.ireport.undo.ChangeEmentsOrderOperation;
import it.businesslogic.ireport.undo.CrosstabColumnDraggedOperation;
import it.businesslogic.ireport.undo.CrosstabRowDraggedOperation;
import it.businesslogic.ireport.undo.DeleteElementsOperation;
import it.businesslogic.ireport.undo.InsertElementOperation;
import it.businesslogic.ireport.undo.PasteStyleOperation;
import it.businesslogic.ireport.undo.ReplacedElementsOperation;
import it.businesslogic.ireport.undo.TransformElementsOperation;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CrosstabEditorPanel
extends JPanel
implements DropTargetListener {
    private JMenu jMenuAlign;
    private JMenuItem jMenuItemAlignLeft;
    private JMenuItem jMenuItemAlignRight;
    private JMenuItem jMenuItemAlignTop;
    private JMenuItem jMenuItemAlignBottom;
    private JSeparator jSeparator19;
    private JMenuItem jMenuItemAlignVerticalAxis;
    private JMenuItem jMenuItemAlignHorizontalAxis;
    private JMenu jMenuSize;
    private JMenuItem jMenuItemSameWidth;
    private JMenuItem jMenuItemSameWidthMax;
    private JMenuItem jMenuItemSameWidthMin;
    private JSeparator jSeparator17;
    private JMenuItem jMenuItemSameHeight;
    private JMenuItem jMenuItemSameHeightMax;
    private JMenuItem jMenuItemSameHeightMin;
    private JSeparator jSeparator18;
    private JMenuItem jMenuItemSameSize;
    private JMenu jMenuPosition;
    private JMenuItem jMenuItemCenterH;
    private JMenuItem jMenuItemCenterV;
    private JMenuItem jMenuItemCenterInCell;
    private JMenuItem jMenuItemJoinLeft;
    private JMenuItem jMenuItemJoinRight;
    private JSeparator jSeparator5;
    private JMenuItem jMenuHSpacing;
    private JMenuItem jMenuItemHSMakeEqual;
    private JMenuItem jMenuItemHSIncrease;
    private JMenuItem jMenuItemHSDecrease;
    private JMenuItem jMenuItemHSRemove;
    private JMenuItem jMenuVSpacing;
    private JMenuItem jMenuItemVSMakeEqual;
    private JMenuItem jMenuItemVSIncrease;
    private JMenuItem jMenuItemVSDecrease;
    private JMenuItem jMenuItemVSRemove;
    private JSeparator jSeparator8;
    private JMenuItem jMenuItemBringToFront;
    private JMenuItem jMenuItemSendToBack;
    private JMenuItem jMenuItemFillCell;
    private JMenuItem jMenuItemFillCellH;
    private JMenuItem jMenuItemFillCellV;
    private double zoomFactor = 2.0;
    private boolean animation = false;
    private List openedNodesDocumentStructure = null;
    private boolean defaultCellMode = false;
    private int readyToDragCellVertically = -1;
    private int readyToDragCellHorizontally = -1;
    private Point dragging_origin = null;
    private boolean cell_dragging = false;
    private int newObjectType = -1;
    private boolean resistenceExceeded = false;
    private boolean trasforming = false;
    private int transformation_type = TransformationType.TRANSFORMATION_NONE;
    private Point transformation_origin = null;
    private Point transformation_origin_end = null;
    private Point transformation_undo_delta = null;
    private boolean firstXORDrawTransforming = true;
    private boolean firstXORDraw = true;
    private Rectangle transformationOldBound = null;
    private JReportFrame parentReportFrame = null;
    private Point newObjectOrigin = null;
    private boolean drag_selection_mode = false;
    private Point drag_selection_origin = null;
    private Point drag_selection_end = null;
    private boolean first_draw_selection_rect = true;
    private Stroke selectionStroke = null;
    private Point mouse = new Point(0, 0);
    private Vector rowBands = new Vector();
    private Vector columnBands = new Vector();
    private List columns = new ArrayList();
    private List rows = new ArrayList();
    private Vector selectedElements = new Vector();
    private CrosstabCell selectedCell = null;
    private static final ImageIcon crosstabCornerImage = new ImageIcon(CrosstabEditorPanel.class.getResource("/it/businesslogic/ireport/icons/crosstabcorner.png"));
    private static final ImageIcon crosstabBorderImage = new ImageIcon(CrosstabEditorPanel.class.getResource("/it/businesslogic/ireport/icons/crosstabborder.png"));
    private static final ImageIcon crosstabBorderHImage = new ImageIcon(CrosstabEditorPanel.class.getResource("/it/businesslogic/ireport/icons/crosstabborderh.png"));
    private CrosstabEditor editor = null;
    private JCheckBoxMenuItem jCheckBoxMenuItemDefaultCellEdit;
    private JCheckBoxMenuItem jCheckBoxMenuItemDefaultCellEdit1;
    private JMenuItem jMenuItemCellProperties;
    private JMenuItem jMenuItemCellProperties1;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemCopyStyle;
    private JMenuItem jMenuItemCrosstabProperties;
    private JMenuItem jMenuItemCrosstabProperties1;
    private JMenuItem jMenuItemCut;
    private JMenuItem jMenuItemDelete;
    private JMenuItem jMenuItemElementProperties;
    private JMenuItem jMenuItemPaste;
    private JMenuItem jMenuItemPaste1;
    private JMenuItem jMenuItemPasteStyle;
    private JMenuItem jMenuItemPattern;
    private JMenuItem jMenuItemTransformStaticText;
    private JPopupMenu jPopupMenuCrosstab;
    private JPopupMenu jPopupMenuCrosstabReporteElement;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;

    public CrosstabEditorPanel() {
        this.initComponents();
        this.selectionStroke = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        this.addFormatItemsToMenu(this.jPopupMenuCrosstabReporteElement);
        new DropTarget(this, 3, this);
        I18n.addOnLanguageChangedListener(new LanguageChangedListener(){

            public void languageChanged(LanguageChangedEvent evt) {
                CrosstabEditorPanel.this.applyI18n();
            }
        });
        this.applyI18n();
    }

    public void updateSize() {
        int maxWidth = 0;
        int maxHeight = 0;
        if (this.getColumns().size() > 0) {
            maxWidth = (Integer)this.getColumns().get(this.getColumns().size() - 1);
        }
        if (this.getRows().size() > 0) {
            maxHeight = (Integer)this.getRows().get(this.getRows().size() - 1);
        }
        if (this.getRows().size() == 0) {
            maxHeight += this.getRowHeight("");
        }
        if (this.getColumns().size() == 0) {
            maxWidth += this.getColumnWidth("");
        }
        if (this.getCrosstabElement().getHeight() > maxHeight) {
            maxHeight = this.getCrosstabElement().getHeight();
        }
        if (this.getCrosstabElement().getWidth() > maxWidth) {
            maxWidth = this.getCrosstabElement().getWidth();
        }
        Dimension d = new Dimension((int)((double)maxWidth * this.getZoomFactor() + 20.0), (int)((double)maxHeight * this.getZoomFactor() + 20.0));
        this.setSize(d);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
    }

    public CrosstabReportElement getCrosstabElement() {
        if (this.getEditor() != null) {
            return this.getEditor().getCrosstabElement();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void paintDocument(Graphics2D g2) {
        crosstabElement = this.getCrosstabElement();
        if (crosstabElement == null) {
            return;
        }
        g2.setPaint(Color.WHITE);
        maxWidth = 0;
        maxHeight = 0;
        if (this.getColumns().size() > 0) {
            maxWidth = (Integer)this.getColumns().get(this.getColumns().size() - 1);
        }
        if (this.getRows().size() > 0) {
            maxHeight = (Integer)this.getRows().get(this.getRows().size() - 1);
        }
        if (this.getRows().size() == 0) {
            maxHeight += this.getRowHeight("");
        }
        if (this.getColumns().size() == 0) {
            maxWidth += this.getColumnWidth("");
        }
        if (this.getCrosstabElement().getHeight() > maxHeight) {
            maxHeight = this.getCrosstabElement().getHeight();
        }
        if (this.getCrosstabElement().getWidth() > maxWidth) {
            maxWidth = this.getCrosstabElement().getWidth();
        }
        zoomedCrosstabWidth = this.getZoomedDim(maxWidth);
        zoomedCrosstabHeight = this.getZoomedDim(maxHeight);
        g2.fillRect(10, 10, zoomedCrosstabWidth, zoomedCrosstabHeight);
        at = new AffineTransform();
        at.translate(17.0, 0.0);
        at.scale(zoomedCrosstabWidth - 14, 1.0);
        g2.drawImage(CrosstabEditorPanel.crosstabBorderImage.getImage(), at, this);
        at = new AffineTransform();
        at.translate(17.0, zoomedCrosstabHeight + 20);
        at.scale(zoomedCrosstabWidth - 14, 1.0);
        at.scale(1.0, -1.0);
        g2.drawImage(CrosstabEditorPanel.crosstabBorderImage.getImage(), at, this);
        at = new AffineTransform();
        at.translate(0.0, 17.0);
        at.scale(1.0, zoomedCrosstabHeight - 14);
        g2.drawImage(CrosstabEditorPanel.crosstabBorderHImage.getImage(), at, this);
        at = new AffineTransform();
        at.translate(zoomedCrosstabWidth + 20, 17.0);
        at.scale(1.0, zoomedCrosstabHeight - 14);
        at.scale(-1.0, 1.0);
        g2.drawImage(CrosstabEditorPanel.crosstabBorderHImage.getImage(), at, this);
        g2.drawImage(CrosstabEditorPanel.crosstabCornerImage.getImage(), 0, 0, this);
        at = new AffineTransform();
        at.translate(0.0, zoomedCrosstabHeight + CrosstabEditorPanel.crosstabCornerImage.getIconHeight() + 3);
        at.scale(1.0, -1.0);
        g2.drawImage(CrosstabEditorPanel.crosstabCornerImage.getImage(), at, this);
        at = new AffineTransform();
        at.translate(zoomedCrosstabWidth + CrosstabEditorPanel.crosstabCornerImage.getIconWidth() + 3, 0.0);
        at.scale(-1.0, 1.0);
        g2.drawImage(CrosstabEditorPanel.crosstabCornerImage.getImage(), at, this);
        at.translate(0.0, zoomedCrosstabHeight + CrosstabEditorPanel.crosstabCornerImage.getIconHeight() + 3);
        at.scale(1.0, -1.0);
        g2.drawImage(CrosstabEditorPanel.crosstabCornerImage.getImage(), at, this);
        maxWidth = 0;
        maxHeight = 0;
        g2.setColor(new Color(220, 220, 255));
        if (this.getColumns().size() > 0) {
            maxWidth = (Integer)this.getColumns().get(this.getColumns().size() - 1);
        }
        if (this.getRows().size() > 0) {
            maxHeight = (Integer)this.getRows().get(this.getRows().size() - 1);
        }
        for (i = 0; i < this.getColumns().size(); ++i) {
            x = (Integer)this.getColumns().get(i);
            if (x <= 0) continue;
            g2.drawLine(10 + this.getZoomedDim(x) - 1, 10, 10 + this.getZoomedDim(x) - 1, this.getZoomedDim(maxHeight) - 1 + 10);
        }
        for (i = 0; i < this.getRows().size(); ++i) {
            y = (Integer)this.getRows().get(i);
            if (y <= 0) continue;
            g2.drawLine(10, 10 + this.getZoomedDim(y) - 1, this.getZoomedDim(maxWidth) - 1 + 10, 10 + this.getZoomedDim(y) - 1);
        }
        for (i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
            block23: {
                block22: {
                    cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
                    if (cell.getType() == 2 || cell.getWidth() <= 0 || cell.getHeight() <= 0) continue;
                    cell.drawCell(g2, this.getZoomFactor());
                    v0 = this.getZoomFactor();
                    if (cell.getType() == 1) break block22;
                    if (cell.getType() != 3) ** GOTO lbl-1000
                }
                if (cell.getTop() == ((Integer)this.rows.get(this.getCrosstabElement().getColumnGroups().size())).intValue()) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (cell.getType() == 1) break block23;
                if (cell.getType() != 3) ** GOTO lbl-1000
            }
            if (cell.getLeft() == ((Integer)this.columns.get(this.getCrosstabElement().getRowGroups().size())).intValue()) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            cell.drawCellBox(g2, v0, v1, v2);
        }
        for (i = 0; i < this.getCrosstabElement().getElements().size(); ++i) {
            re = (ReportElement)this.getCrosstabElement().getElements().elementAt(i);
            if (re.getCell().getType() == 2) continue;
            re.drawObject(g2, this.getZoomFactor(), 0, 0);
        }
        for (i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
            cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
            if (cell.getType() != 2 && cell.getWidth() > 0 && cell.getHeight() <= 0) continue;
        }
        if (this.isDefaultCellMode()) {
            for (i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
                cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
                if (cell.getType() != 2) continue;
                cell.drawCell(g2, this.getZoomFactor());
                cell.drawCellBox(g2, this.getZoomFactor(), false, false);
                for (j = 0; j < this.getCrosstabElement().getElements().size(); ++j) {
                    re = (ReportElement)this.getCrosstabElement().getElements().elementAt(j);
                    if (re.getCell() != cell) continue;
                    re.drawObject(g2, this.getZoomFactor(), 0, 0);
                }
            }
        }
        for (i = 0; i < this.getCrosstabElement().getElements().size(); ++i) {
            re = (ReportElement)this.getCrosstabElement().getElements().elementAt(i);
            if (!this.getSelectedElements().contains(re)) continue;
            re.drawCorona(g2, this.getZoomFactor(), 0, 0, re == this.getSelectedElements().firstElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.animation) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Shape s = g2.getClip();
        AffineTransform at = g2.getTransform();
        try {
            super.paint(g);
            if (this.getCrosstabElement() == null) {
                return;
            }
            if (MainFrame.getMainInstance().getProperties().getProperty("Antialias", "true").equals("false")) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            }
            this.paintDocument(g2);
            g2.setClip(s);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            if (s != null && g2 != null) {
                g2.setClip(s);
            }
            if (at != null && g2 != null) {
                g2.setTransform(at);
            }
        }
    }

    public CrosstabEditor getEditor() {
        return this.editor;
    }

    public void setEditor(CrosstabEditor editor) {
        this.editor = editor;
        this.updateGrid();
        this.invalidate();
        this.repaint();
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.updateSize();
        this.repaint();
    }

    public int getZoomedDim(int dim) {
        if (this.zoomFactor == 1.0 || dim == 0) {
            return dim;
        }
        return (int)((double)dim * this.zoomFactor);
    }

    public int getRealDim(int dim) {
        if (this.zoomFactor == 1.0 || dim == 0) {
            return dim;
        }
        return (int)((double)dim / this.zoomFactor);
    }

    public void updateGrid() {
        if (this.getCrosstabElement() == null) {
            return;
        }
        try {
            CrosstabCell cell;
            int k;
            int i;
            CrosstabCell cell2;
            CrosstabCell cell3;
            int k2;
            int i2;
            CrosstabGroup cg;
            int i3;
            this.getColumns().clear();
            this.getRows().clear();
            int current_x = 0;
            int current_y = 0;
            CrosstabCell mainCell = this.findCell("", "");
            for (int k3 = 0; k3 < this.getCrosstabElement().getCells().size(); ++k3) {
                CrosstabCell cell4 = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(k3);
                cell4.setParent(this.getCrosstabElement());
                if (cell4.getType() != 0) continue;
                if (cell4.getHeight() == 0) {
                    cell4.setHeight(this.getRowHeight(cell4.getRowTotalGroup()));
                }
                if (cell4.getWidth() != 0) continue;
                cell4.setWidth(this.getColumnWidth(cell4.getColumnTotalGroup()));
            }
            this.addNotDefinedCells();
            this.getColumns().add(new Integer(current_x));
            for (int i4 = 0; i4 < this.getCrosstabElement().getRowGroups().size(); ++i4) {
                CrosstabGroup cg2 = (CrosstabGroup)this.getCrosstabElement().getRowGroups().elementAt(i4);
                cg2.getHeaderCell().setLeft(current_x);
                cg2.getTotalCell().setLeft(current_x);
                this.getColumns().add(new Integer(current_x += cg2.getSize()));
            }
            ArrayList<Integer> columnWidths = new ArrayList<Integer>();
            for (i3 = this.getCrosstabElement().getColumnGroups().size() - 1; i3 >= 0; --i3) {
                cg = (CrosstabGroup)this.getCrosstabElement().getColumnGroups().elementAt(i3);
                if (i3 == this.getCrosstabElement().getColumnGroups().size() - 1) {
                    columnWidths.add(new Integer(this.getColumnWidth("")));
                }
                if (!cg.getTotalPosition().equals("Start")) {
                    columnWidths.add(new Integer(this.getColumnWidth(cg.getName())));
                    continue;
                }
                columnWidths.add(0, new Integer(this.getColumnWidth(cg.getName())));
            }
            for (i3 = 0; i3 < columnWidths.size(); ++i3) {
                this.getColumns().add(new Integer(current_x += ((Integer)columnWidths.get(i3)).intValue()));
            }
            if (this.getCrosstabElement().getColumnGroups().size() == 0) {
                this.getColumns().add(new Integer(current_x += this.getColumnWidth("")));
            }
            this.getRows().add(new Integer(current_y));
            for (i3 = 0; i3 < this.getCrosstabElement().getColumnGroups().size(); ++i3) {
                cg = (CrosstabGroup)this.getCrosstabElement().getColumnGroups().elementAt(i3);
                cg.getHeaderCell().setTop(current_y);
                cg.getTotalCell().setTop(current_y);
                this.getRows().add(new Integer(current_y += cg.getSize()));
            }
            ArrayList<Integer> rowHeights = new ArrayList<Integer>();
            for (i2 = this.getCrosstabElement().getRowGroups().size() - 1; i2 >= 0; --i2) {
                CrosstabGroup cg3 = (CrosstabGroup)this.getCrosstabElement().getRowGroups().elementAt(i2);
                if (i2 == this.getCrosstabElement().getRowGroups().size() - 1) {
                    rowHeights.add(new Integer(this.getRowHeight("")));
                }
                if (!cg3.getTotalPosition().equals("Start")) {
                    rowHeights.add(new Integer(this.getRowHeight(cg3.getName())));
                    continue;
                }
                rowHeights.add(0, new Integer(this.getRowHeight(cg3.getName())));
            }
            for (i2 = 0; i2 < rowHeights.size(); ++i2) {
                this.getRows().add(new Integer(current_y += ((Integer)rowHeights.get(i2)).intValue()));
            }
            if (this.getCrosstabElement().getRowGroups().size() == 0) {
                this.getRows().add(new Integer(current_y += this.getRowHeight("")));
            }
            int columnGroups = this.getCrosstabElement().getColumnGroups().size();
            int rowGroups = this.getCrosstabElement().getRowGroups().size();
            int currentTopRowNumber = columnGroups;
            int currentBottomRowNumber = columnGroups + rowGroups + 1;
            for (int i5 = 0; i5 < this.getCrosstabElement().getRowGroups().size(); ++i5) {
                CrosstabGroup cg4 = (CrosstabGroup)this.getCrosstabElement().getRowGroups().elementAt(i5);
                cg4.getHeaderCell().setLeftIndex(i5);
                cg4.getHeaderCell().setLeft((Integer)this.getColumns().get(i5));
                cg4.getHeaderCell().setTopIndex(cg4.getTotalPosition().equals("Start") ? currentTopRowNumber + 1 : currentTopRowNumber);
                cg4.getHeaderCell().setTop((Integer)this.getRows().get(cg4.getHeaderCell().getTopIndex()));
                cg4.getHeaderCell().setRightIndex(i5 + 1);
                cg4.getHeaderCell().setWidth(cg4.getSize());
                cg4.getHeaderCell().setBottomIndex(cg4.isHasTotal() && cg4.getTotalPosition().equals("Start") ? currentBottomRowNumber : currentBottomRowNumber - 1);
                cg4.getHeaderCell().setHeight((Integer)this.getRows().get(cg4.getHeaderCell().getBottomIndex()) - cg4.getHeaderCell().getTop());
                cg4.getTotalCell().setLeftIndex(i5);
                cg4.getTotalCell().setLeft(cg4.getHeaderCell().getLeft());
                cg4.getTotalCell().setTopIndex(cg4.getTotalPosition().equals("Start") ? currentTopRowNumber : currentBottomRowNumber - 1);
                cg4.getTotalCell().setTop((Integer)this.getRows().get(cg4.getTotalCell().getTopIndex()));
                cg4.getTotalCell().setRightIndex(rowGroups);
                cg4.getTotalCell().setWidth((Integer)this.getColumns().get(rowGroups) - cg4.getTotalCell().getLeft());
                cg4.getTotalCell().setBottomIndex(cg4.isHasTotal() && cg4.getTotalPosition().equals("Start") ? currentTopRowNumber + 1 : currentBottomRowNumber);
                cg4.getTotalCell().setHeight((Integer)this.getRows().get(cg4.getTotalCell().getBottomIndex()) - cg4.getTotalCell().getTop());
                if (cg4.getTotalPosition().equals("Start")) {
                    ++currentTopRowNumber;
                } else {
                    --currentBottomRowNumber;
                }
                for (k2 = 0; k2 < this.getCrosstabElement().getCells().size(); ++k2) {
                    cell3 = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(k2);
                    if (!cell3.getRowTotalGroup().equals(cg4.getName())) continue;
                    cell3.setTop(cg4.getTotalCell().getTop());
                    cell3.setHeight(cg4.getTotalCell().getHeight());
                }
            }
            int currentLeftColumnNumber = rowGroups;
            int currentRightColumnNumber = columnGroups + rowGroups + 1;
            for (int i6 = 0; i6 < this.getCrosstabElement().getColumnGroups().size(); ++i6) {
                CrosstabGroup cg5 = (CrosstabGroup)this.getCrosstabElement().getColumnGroups().elementAt(i6);
                cg5.getHeaderCell().setLeftIndex(cg5.getTotalPosition().equals("Start") ? currentLeftColumnNumber + 1 : currentLeftColumnNumber);
                cg5.getHeaderCell().setLeft((Integer)this.getColumns().get(cg5.getHeaderCell().getLeftIndex()));
                cg5.getHeaderCell().setTopIndex(i6);
                cg5.getHeaderCell().setTop((Integer)this.getRows().get(i6));
                cg5.getHeaderCell().setRightIndex(cg5.isHasTotal() && cg5.getTotalPosition().equals("Start") ? currentRightColumnNumber : currentRightColumnNumber - 1);
                cg5.getHeaderCell().setWidth((Integer)this.getColumns().get(cg5.getHeaderCell().getRightIndex()) - cg5.getHeaderCell().getLeft());
                cg5.getHeaderCell().setBottomIndex(i6 + 1);
                cg5.getHeaderCell().setHeight(cg5.getSize());
                cg5.getTotalCell().setLeftIndex(cg5.getTotalPosition().equals("Start") ? currentLeftColumnNumber : currentRightColumnNumber - 1);
                cg5.getTotalCell().setLeft((Integer)this.getColumns().get(cg5.getTotalCell().getLeftIndex()));
                cg5.getTotalCell().setTopIndex(i6);
                cg5.getTotalCell().setTop((Integer)this.getRows().get(i6));
                cg5.getTotalCell().setRightIndex(cg5.isHasTotal() && cg5.getTotalPosition().equals("Start") ? currentLeftColumnNumber + 1 : currentRightColumnNumber);
                cg5.getTotalCell().setWidth((Integer)this.getColumns().get(cg5.getTotalCell().getRightIndex()) - cg5.getTotalCell().getLeft());
                cg5.getTotalCell().setBottomIndex(columnGroups);
                cg5.getTotalCell().setHeight((Integer)this.getRows().get(columnGroups) - cg5.getTotalCell().getTop());
                if (cg5.getTotalPosition().equals("Start")) {
                    ++currentLeftColumnNumber;
                } else {
                    --currentRightColumnNumber;
                }
                for (int k4 = 0; k4 < this.getCrosstabElement().getCells().size(); ++k4) {
                    cell2 = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(k4);
                    if (!cell2.getColumnTotalGroup().equals(cg5.getName())) continue;
                    cell2.setLeft(cg5.getTotalCell().getLeft());
                    cell2.setWidth(cg5.getTotalCell().getWidth());
                }
            }
            if (this.getCrosstabElement().getRowGroups().size() > 0) {
                mainCell.setTopIndex(((CrosstabGroup)this.getCrosstabElement().getRowGroups().lastElement()).getHeaderCell().getTopIndex());
                mainCell.setTop(((CrosstabGroup)this.getCrosstabElement().getRowGroups().lastElement()).getHeaderCell().getTop());
            } else {
                mainCell.setTop(this.getCrosstabElement().getColumnGroups().size());
                mainCell.setTop((Integer)this.getRows().get(this.getCrosstabElement().getColumnGroups().size()));
            }
            mainCell.setBottomIndex(mainCell.getTopIndex() + 1);
            if (this.getCrosstabElement().getColumnGroups().size() > 0) {
                mainCell.setLeftIndex(((CrosstabGroup)this.getCrosstabElement().getColumnGroups().lastElement()).getHeaderCell().getLeftIndex());
                mainCell.setLeft(((CrosstabGroup)this.getCrosstabElement().getColumnGroups().lastElement()).getHeaderCell().getLeft());
            } else {
                mainCell.setLeftIndex(this.getCrosstabElement().getRowGroups().size());
                mainCell.setLeft((Integer)this.getColumns().get(this.getCrosstabElement().getRowGroups().size()));
            }
            mainCell.setRightIndex(mainCell.getLeftIndex() + 1);
            for (k2 = 0; k2 < this.getCrosstabElement().getCells().size(); ++k2) {
                cell3 = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(k2);
                if (cell3.getType() != 0) continue;
                if (cell3.getRowTotalGroup().equals("")) {
                    cell3.setTop(mainCell.getTop());
                    cell3.setTopIndex(mainCell.getTopIndex());
                    cell3.setBottomIndex(mainCell.getBottomIndex());
                }
                if (cell3.getColumnTotalGroup().equals("")) {
                    cell3.setLeft(mainCell.getLeft());
                    cell3.setLeftIndex(mainCell.getLeftIndex());
                    cell3.setRightIndex(mainCell.getRightIndex());
                }
                cell3.setTopIndex(this.getTotalRowTopIndex(cell3.getRowTotalGroup()));
                cell3.setBottomIndex(cell3.getTopIndex() + 1);
                cell3.setLeftIndex(this.getTotalColumnLeftIndex(cell3.getColumnTotalGroup()));
                cell3.setRightIndex(cell3.getLeftIndex() + 1);
            }
            CrosstabCell detailCell = this.findCell("", "");
            boolean found = false;
            for (int i7 = 0; i7 < this.getCrosstabElement().getCells().size(); ++i7) {
                cell2 = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i7);
                if (cell2.getType() != 2) continue;
                cell2.setTop(0);
                cell2.setLeft(0);
                cell2.setWidth(this.getCrosstabElement().getWidth());
                cell2.setHeight(this.getCrosstabElement().getHeight());
                cell2.setTopIndex(0);
                cell2.setLeftIndex(0);
                cell2.setBottomIndex(0);
                cell2.setRightIndex(0);
                found = true;
                break;
            }
            if (!found) {
                CrosstabCell defaultWhenNoDataCell = detailCell.cloneMe();
                defaultWhenNoDataCell.setType(2);
                defaultWhenNoDataCell.setParent(this.getCrosstabElement());
                defaultWhenNoDataCell.setName(null);
                defaultWhenNoDataCell.setTop(0);
                defaultWhenNoDataCell.setLeft(0);
                defaultWhenNoDataCell.setWidth(this.getCrosstabElement().getWidth());
                defaultWhenNoDataCell.setHeight(this.getCrosstabElement().getHeight());
                defaultWhenNoDataCell.setTopIndex(0);
                defaultWhenNoDataCell.setLeftIndex(0);
                defaultWhenNoDataCell.setBottomIndex(0);
                defaultWhenNoDataCell.setRightIndex(0);
                this.getCrosstabElement().getCells().add(defaultWhenNoDataCell);
            }
            found = false;
            for (int i8 = 0; i8 < this.getCrosstabElement().getCells().size(); ++i8) {
                cell2 = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i8);
                if (cell2.getType() != 3) continue;
                cell2.setTop(0);
                cell2.setTopIndex(0);
                cell2.setLeft(0);
                cell2.setLeftIndex(0);
                cell2.setRightIndex(this.getCrosstabElement().getRowGroups().size());
                cell2.setWidth((Integer)this.getColumns().get(cell2.getRightIndex()));
                cell2.setBottomIndex(this.getCrosstabElement().getColumnGroups().size());
                cell2.setHeight((Integer)this.getRows().get(cell2.getBottomIndex()));
                found = true;
                break;
            }
            if (!found) {
                CrosstabCell crossTabHeaderCell = new CrosstabCell();
                crossTabHeaderCell.setType(3);
                crossTabHeaderCell.setParent(this.getCrosstabElement());
                crossTabHeaderCell.setName(null);
                crossTabHeaderCell.setTop(0);
                crossTabHeaderCell.setTopIndex(0);
                crossTabHeaderCell.setLeft(0);
                crossTabHeaderCell.setLeftIndex(0);
                crossTabHeaderCell.setRightIndex(this.getCrosstabElement().getRowGroups().size());
                crossTabHeaderCell.setWidth((Integer)this.getColumns().get(crossTabHeaderCell.getRightIndex()));
                crossTabHeaderCell.setBottomIndex(this.getCrosstabElement().getColumnGroups().size());
                crossTabHeaderCell.setHeight((Integer)this.getRows().get(crossTabHeaderCell.getBottomIndex()));
                this.getCrosstabElement().getCells().add(crossTabHeaderCell);
            }
            this.getRowBands().clear();
            for (i = 1; i < this.getRows().size(); ++i) {
                Vector<CrosstabCell> rowBandContents = new Vector<CrosstabCell>();
                for (k = 0; k < this.getCrosstabElement().getCells().size(); ++k) {
                    cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(k);
                    if (cell.getBottomIndex() != i) continue;
                    rowBandContents.add(cell);
                }
                this.getRowBands().add(rowBandContents);
            }
            this.getColumnBands().clear();
            for (i = 1; i < this.getColumns().size(); ++i) {
                Vector<CrosstabCell> columnBandContents = new Vector<CrosstabCell>();
                for (k = 0; k < this.getCrosstabElement().getCells().size(); ++k) {
                    cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(k);
                    if (cell.getRightIndex() != i) continue;
                    columnBandContents.add(cell);
                }
                this.getColumnBands().add(columnBandContents);
            }
            for (i = 0; i < this.getCrosstabElement().getElements().size(); ++i) {
                ReportElement re = (ReportElement)this.getCrosstabElement().getElements().elementAt(i);
                re.getPosition().x = re.getRelativePosition().x + re.getCell().getLeft() + 10;
                re.getPosition().y = re.getRelativePosition().y + re.getCell().getTop() + 10;
                re.setPosition(re.position);
                re.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateSize();
    }

    public CrosstabCell findCell(String rowGroup, String columnGroup) {
        if (this.getCrosstabElement() == null) {
            return null;
        }
        for (int i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
            CrosstabCell cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
            if (cell.getType() != 0 || !cell.getRowTotalGroup().equals(rowGroup) || !cell.getColumnTotalGroup().equals(columnGroup)) continue;
            return cell;
        }
        return null;
    }

    public int getColumnWidth(String columnTotalGroup) {
        int tmpWidth = -1;
        for (int i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
            CrosstabCell cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
            if (cell.getType() != 0 || !cell.getColumnTotalGroup().equals(columnTotalGroup) || cell.getWidth() <= tmpWidth) continue;
            tmpWidth = cell.getWidth();
        }
        if (tmpWidth < 0) {
            return this.getColumnWidth("");
        }
        return tmpWidth;
    }

    public int getRowHeight(String rowTotalGroup) {
        int tmpHeight = -1;
        for (int i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
            CrosstabCell cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
            if (cell.getType() != 0 || !cell.getRowTotalGroup().equals(rowTotalGroup) || cell.getHeight() <= tmpHeight) continue;
            tmpHeight = cell.getHeight();
        }
        if (tmpHeight < 0 && !rowTotalGroup.equals("")) {
            return this.getRowHeight("");
        }
        if (tmpHeight < 0 && rowTotalGroup.equals("")) {
            return 0;
        }
        return tmpHeight;
    }

    public int getTotalRowTopIndex(String rowTotalGroup) {
        for (int i = 0; i < this.getCrosstabElement().getRowGroups().size(); ++i) {
            CrosstabGroup group = (CrosstabGroup)this.getCrosstabElement().getRowGroups().elementAt(i);
            if (!group.getName().equals(rowTotalGroup)) continue;
            return group.getTotalCell().getTopIndex();
        }
        return this.findCell("", "").getTopIndex();
    }

    public int getTotalColumnLeftIndex(String columnTotalGroup) {
        for (int i = 0; i < this.getCrosstabElement().getColumnGroups().size(); ++i) {
            CrosstabGroup group = (CrosstabGroup)this.getCrosstabElement().getColumnGroups().elementAt(i);
            if (!group.getName().equals(columnTotalGroup)) continue;
            return group.getTotalCell().getLeftIndex();
        }
        return this.findCell("", "").getLeftIndex();
    }

    private void initComponents() {
        this.jPopupMenuCrosstabReporteElement = new JPopupMenu();
        this.jMenuItemElementProperties = new JMenuItem();
        this.jMenuItemCrosstabProperties = new JMenuItem();
        this.jMenuItemCellProperties = new JMenuItem();
        this.jCheckBoxMenuItemDefaultCellEdit = new JCheckBoxMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemCut = new JMenuItem();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jMenuItemDelete = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItemCopyStyle = new JMenuItem();
        this.jMenuItemPasteStyle = new JMenuItem();
        this.jMenuItemTransformStaticText = new JMenuItem();
        this.jMenuItemPattern = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jPopupMenuCrosstab = new JPopupMenu();
        this.jMenuItemCrosstabProperties1 = new JMenuItem();
        this.jMenuItemCellProperties1 = new JMenuItem();
        this.jCheckBoxMenuItemDefaultCellEdit1 = new JCheckBoxMenuItem();
        this.jMenuItemPaste1 = new JMenuItem();
        this.jMenuItemElementProperties.setText(I18n.getString("elementProperties", "Element properties"));
        this.jMenuItemElementProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemElementPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemElementProperties);
        this.jMenuItemCrosstabProperties.setText("Crosstab properties");
        this.jMenuItemCrosstabProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemCrosstabPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemCrosstabProperties);
        this.jMenuItemCellProperties.setText("Cell properties");
        this.jMenuItemCellProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemCellPropertiesActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemCellProperties);
        this.jCheckBoxMenuItemDefaultCellEdit.setText("Edit When-No-Data default cell");
        this.jCheckBoxMenuItemDefaultCellEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jCheckBoxMenuItemDefaultCellEditActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jCheckBoxMenuItemDefaultCellEdit);
        this.jPopupMenuCrosstabReporteElement.add(this.jSeparator1);
        this.jMenuItemCut.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.png")));
        this.jMenuItemCut.setText("Cut");
        this.jMenuItemCut.setEnabled(false);
        this.jMenuItemCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemCutActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemCut);
        this.jMenuItemCopy.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.png")));
        this.jMenuItemCopy.setText("Copy");
        this.jMenuItemCopy.setEnabled(false);
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.png")));
        this.jMenuItemPaste.setText("Paste");
        this.jMenuItemPaste.setEnabled(false);
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemPaste);
        this.jMenuItemDelete.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.png")));
        this.jMenuItemDelete.setText("Delete");
        this.jMenuItemDelete.setEnabled(false);
        this.jMenuItemDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemDeleteActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemDelete);
        this.jPopupMenuCrosstabReporteElement.add(this.jSeparator3);
        this.jMenuItemCopyStyle.setEnabled(false);
        this.jMenuItemCopyStyle.setLabel("Copy style");
        this.jMenuItemCopyStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemCopyStyleActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemCopyStyle);
        this.jMenuItemPasteStyle.setEnabled(false);
        this.jMenuItemPasteStyle.setLabel("Paste style");
        this.jMenuItemPasteStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemPasteStyleActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemPasteStyle);
        this.jMenuItemTransformStaticText.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.jMenuItemTransformStaticText.setLabel("Transform in Textfield");
        this.jMenuItemTransformStaticText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemTransformStaticTextActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemTransformStaticText);
        this.jMenuItemPattern.setText("Field pattern");
        this.jMenuItemPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemPatternActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstabReporteElement.add(this.jMenuItemPattern);
        this.jPopupMenuCrosstabReporteElement.add(this.jSeparator4);
        this.jMenuItemCrosstabProperties1.setText("Crosstab properties");
        this.jMenuItemCrosstabProperties1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemCrosstabPropertiesActionPerformed1(evt);
            }
        });
        this.jPopupMenuCrosstab.add(this.jMenuItemCrosstabProperties1);
        this.jMenuItemCellProperties1.setText("Cell properties");
        this.jMenuItemCellProperties1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemCellPropertiesActionPerformed1(evt);
            }
        });
        this.jPopupMenuCrosstab.add(this.jMenuItemCellProperties1);
        this.jCheckBoxMenuItemDefaultCellEdit1.setText("Edit When-No-Data default cell");
        this.jCheckBoxMenuItemDefaultCellEdit1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jCheckBoxMenuItemDefaultCellEdit1ActionPerformed(evt);
            }
        });
        this.jPopupMenuCrosstab.add(this.jCheckBoxMenuItemDefaultCellEdit1);
        this.jMenuItemPaste1.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.png")));
        this.jMenuItemPaste1.setText("Paste");
        this.jMenuItemPaste1.setEnabled(false);
        this.jMenuItemPaste1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.jMenuItemPasteActionPerformed1(evt);
            }
        });
        this.jPopupMenuCrosstab.add(this.jMenuItemPaste1);
        this.setLayout(null);
        this.setBackground(new Color(204, 204, 204));
        this.setFocusCycleRoot(true);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                CrosstabEditorPanel.this.formMouseDragged(evt);
            }

            public void mouseMoved(MouseEvent evt) {
                CrosstabEditorPanel.this.formMouseMoved(evt);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                CrosstabEditorPanel.this.formFocusGained(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                CrosstabEditorPanel.this.formKeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                CrosstabEditorPanel.this.formKeyTyped(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CrosstabEditorPanel.this.formMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                CrosstabEditorPanel.this.formMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                CrosstabEditorPanel.this.formMouseReleased(evt);
            }
        });
    }

    private void jCheckBoxMenuItemDefaultCellEdit1ActionPerformed(ActionEvent evt) {
        this.setDefaultCellMode(this.jCheckBoxMenuItemDefaultCellEdit1.isSelected());
    }

    private void jCheckBoxMenuItemDefaultCellEditActionPerformed(ActionEvent evt) {
        this.setDefaultCellMode(this.jCheckBoxMenuItemDefaultCellEdit.isSelected());
    }

    private void jMenuItemPasteActionPerformed1(ActionEvent evt) {
        this.getParentReportFrame().paste();
    }

    private void jMenuItemCellPropertiesActionPerformed1(ActionEvent evt) {
        this.jMenuItemCellPropertiesActionPerformed(evt);
    }

    private void jMenuItemCrosstabPropertiesActionPerformed1(ActionEvent evt) {
        this.jMenuItemCrosstabPropertiesActionPerformed(evt);
    }

    private void jMenuItemPatternActionPerformed(ActionEvent evt) {
        String pattern = "";
        FieldPatternDialog pd = new FieldPatternDialog((Frame)MainFrame.getMainInstance(), true);
        pd.setVisible(true);
        if (pd.getDialogResult() == 0) {
            Enumeration selectedElementEnum = this.getSelectedElements().elements();
            while (selectedElementEnum.hasMoreElements()) {
                ReportElement re = (ReportElement)selectedElementEnum.nextElement();
                if (!(re instanceof TextFieldReportElement)) continue;
                ((TextFieldReportElement)re).setPattern(pd.getPattern());
            }
        }
    }

    private void jMenuItemTransformStaticTextActionPerformed(ActionEvent evt) {
        this.transformStaticInTextFields();
    }

    private void jMenuItemPasteStyleActionPerformed(ActionEvent evt) {
        this.pasteStyle();
    }

    private void jMenuItemCopyStyleActionPerformed(ActionEvent evt) {
        this.copyStyle();
    }

    private void jMenuItemDeleteActionPerformed(ActionEvent evt) {
        this.deleteSelectedElements();
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        this.getParentReportFrame().paste();
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        this.getParentReportFrame().copy();
    }

    private void jMenuItemCutActionPerformed(ActionEvent evt) {
        this.getParentReportFrame().cut();
    }

    private void jMenuItemElementPropertiesActionPerformed(ActionEvent evt) {
        this.getParentReportFrame().openElementPropertiesDialog();
    }

    private void jMenuItemCellPropertiesActionPerformed(ActionEvent evt) {
        if (this.selectedCell != null) {
            this.editCell(this.selectedCell);
        }
    }

    public void editCell(CrosstabCell editCell) {
        CrosstabCellDialog ctd = new CrosstabCellDialog((Frame)MainFrame.getMainInstance(), true);
        ctd.setTmpCell(editCell);
        ctd.setVisible(true);
        if (ctd.getDialogResult() == 0) {
            ReportElement re;
            int j;
            int i;
            int delta;
            editCell.setBackcolor(ctd.getTmpCell().getBackcolor());
            editCell.setBox(ctd.getTmpCell().getBox());
            editCell.setMode(ctd.getTmpCell().getMode());
            editCell.setStyle(ctd.getTmpCell().getStyle());
            if (editCell.getWidth() != ctd.getTmpCell().getWidth()) {
                int columnIndex = editCell.getLeftIndex();
                delta = ctd.getTmpCell().getWidth() - editCell.getWidth();
                for (i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
                    CrosstabCell cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
                    if (cell.getLeftIndex() == columnIndex || cell.getRightIndex() == columnIndex + 1) {
                        cell.setWidth(cell.getWidth() + delta);
                    }
                    if (cell.getLeftIndex() <= columnIndex) continue;
                    cell.setLeft(cell.getLeft() + delta);
                    for (j = 0; j < this.getCrosstabElement().getElements().size(); ++j) {
                        re = (ReportElement)this.getCrosstabElement().getElements().elementAt(j);
                        if (re.getCell() != cell) continue;
                        re.trasform(new Point(delta, 0), TransformationType.TRANSFORMATION_MOVE);
                    }
                }
                for (i = columnIndex + 1; i < this.columns.size(); ++i) {
                    int columnPosition = (Integer)this.columns.get(i);
                    columnPosition += delta;
                    this.columns.set(i, new Integer(columnPosition));
                }
            }
            if (editCell.getHeight() != ctd.getTmpCell().getHeight()) {
                int rowIndex = editCell.getTopIndex();
                delta = ctd.getTmpCell().getHeight() - editCell.getHeight();
                for (i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
                    CrosstabCell cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
                    if (cell.getTopIndex() == rowIndex || cell.getBottomIndex() == rowIndex + 1) {
                        cell.setHeight(cell.getHeight() + delta);
                        continue;
                    }
                    if (cell.getTopIndex() <= rowIndex) continue;
                    cell.setTop(cell.getTop() + delta);
                    for (j = 0; j < this.getCrosstabElement().getElements().size(); ++j) {
                        re = (ReportElement)this.getCrosstabElement().getElements().elementAt(j);
                        if (re.getCell() != cell) continue;
                        re.trasform(new Point(0, delta), TransformationType.TRANSFORMATION_MOVE);
                    }
                }
                for (i = rowIndex + 1; i < this.rows.size(); ++i) {
                    int rowPosition = (Integer)this.rows.get(i);
                    rowPosition += delta;
                    this.rows.set(i, new Integer(rowPosition));
                }
            }
            this.repaint();
            this.getCrosstabElement().notifyChange();
        }
    }

    private void formFocusGained(FocusEvent evt) {
    }

    private void formKeyTyped(KeyEvent evt) {
    }

    public void panelKeyPressed(KeyEvent evt) {
        this.formKeyPressed(evt);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void formKeyPressed(KeyEvent evt) {
        if (this.getSelectedElements().size() > 0) {
            evt.consume();
        }
        int x = 1;
        int y = 1;
        if ((evt.getModifiers() & 1) != 0) {
            x = 10;
            y = 10;
        }
        if (evt.getKeyCode() == 127) {
            this.deleteSelectedElements();
            return;
        }
        if ((evt.getModifiers() & 1) != 0) {
            if ((evt.getModifiers() & 2) != 0) {
                switch (evt.getKeyCode()) {
                    case 83: {
                        FormatCommand.getCommand(44).execute();
                        return;
                    }
                }
                return;
            }
        }
        if (evt.getKeyCode() == 38) {
            y *= -1;
            x = 0;
            Vector<ReportElement> changed_elements = new Vector<ReportElement>();
            Iterator i = this.selectedElements.iterator();
            while (true) {
                if (!i.hasNext()) {
                    this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), changed_elements, 3));
                    this.getMainFrame().getElementPropertiesDialog().updateSelection();
                    this.repaint();
                    return;
                }
                ReportElement element = (ReportElement)i.next();
                element.trasform(new Point(x, y), TransformationType.TRANSFORMATION_MOVE);
                element.adjustCell(this.getCrosstabElement().getCells());
                changed_elements.add(element);
            }
        }
        if (evt.getKeyCode() == 37) {
            x *= -1;
            y = 0;
            Vector<ReportElement> changed_elements = new Vector<ReportElement>();
            Iterator i = this.selectedElements.iterator();
            while (true) {
                if (!i.hasNext()) {
                    this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), changed_elements, 3));
                    this.getMainFrame().getElementPropertiesDialog().updateSelection();
                    this.repaint();
                    return;
                }
                ReportElement element = (ReportElement)i.next();
                element.trasform(new Point(x, y), TransformationType.TRANSFORMATION_MOVE);
                element.adjustCell(this.getCrosstabElement().getCells());
                changed_elements.add(element);
            }
        }
        if (evt.getKeyCode() == 39) {
            y = 0;
            Vector<ReportElement> changed_elements = new Vector<ReportElement>();
            Iterator i = this.selectedElements.iterator();
            while (true) {
                if (!i.hasNext()) {
                    this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), changed_elements, 3));
                    this.getMainFrame().getElementPropertiesDialog().updateSelection();
                    this.repaint();
                    return;
                }
                ReportElement element = (ReportElement)i.next();
                element.trasform(new Point(x, y), TransformationType.TRANSFORMATION_MOVE);
                element.adjustCell(this.getCrosstabElement().getCells());
                changed_elements.add(element);
            }
        }
        if (evt.getKeyCode() == 40) {
            x = 0;
            Vector<ReportElement> changed_elements = new Vector<ReportElement>();
            Iterator i = this.selectedElements.iterator();
            while (true) {
                if (!i.hasNext()) {
                    this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), changed_elements, 3));
                    this.getMainFrame().getElementPropertiesDialog().updateSelection();
                    this.repaint();
                    return;
                }
                ReportElement element = (ReportElement)i.next();
                element.trasform(new Point(x, y), TransformationType.TRANSFORMATION_MOVE);
                element.adjustCell(this.getCrosstabElement().getCells());
                changed_elements.add(element);
            }
        }
        if (evt.getKeyCode() == 113) {
            DeleteElementsOperation undoOp = new DeleteElementsOperation(this.getParentReportFrame(), this.getCrosstabElement());
            Iterator i = this.selectedElements.iterator();
            while (true) {
                if (!i.hasNext()) {
                    this.getParentReportFrame().addUndoOperation(undoOp);
                    this.getMainFrame().getElementPropertiesDialog().updateSelection();
                    this.repaint();
                    return;
                }
                ReportElement re = (ReportElement)i.next();
                if (!(re instanceof TextReportElement)) continue;
                String te = ((TextReportElement)re).getText();
                String result = JOptionPane.showInputDialog(this, I18n.getString("messages.enterNewValue", "Please enter a new Value"), te);
                if (result == null || result.equals("")) continue;
                ((TextReportElement)re).setText(result);
                undoOp.addElement(re, this.getCrosstabElement().getElements().indexOf(re));
                this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), re, 3));
            }
        }
        if (evt.getKeyCode() == 114) {
            this.getParentReportFrame().transformStaticInTextFields();
            this.getMainFrame().getElementPropertiesDialog().updateSelection();
            return;
        }
        if ((evt.getModifiers() & 2) != 0 && evt.getKeyCode() == 155) {
            this.getParentReportFrame().copy();
            return;
        }
        if ((evt.getModifiers() & 1) == 0) return;
        if (evt.getKeyCode() != 155) return;
        this.getParentReportFrame().paste();
    }

    private void jMenuItemCrosstabPropertiesActionPerformed(ActionEvent evt) {
        CrosstabPropertiesDialog cpd = new CrosstabPropertiesDialog((Frame)MainFrame.getMainInstance(), true);
        cpd.setCurrentCrosstabReportElement(this.getCrosstabElement());
        cpd.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void formMouseReleased(MouseEvent evt) {
        int mouseY;
        int mouseX;
        block41: {
            block52: {
                ReportElement re;
                block51: {
                    int i;
                    int delta;
                    block47: {
                        int oldPosition;
                        block48: {
                            int i2;
                            int delta2;
                            block44: {
                                int oldPosition2;
                                block45: {
                                    block49: {
                                        block50: {
                                            CrosstabCell bname;
                                            block46: {
                                                block43: {
                                                    block42: {
                                                        mouseX = (int)evt.getPoint().getX();
                                                        mouseY = (int)evt.getPoint().getY();
                                                        if (!this.drag_selection_mode) break block42;
                                                        if (evt.getButton() != 1) break block42;
                                                        this.drag_selection_mode = false;
                                                        Graphics2D gg = (Graphics2D)this.getGraphics();
                                                        gg.setXORMode(Color.GREEN);
                                                        Stroke s = gg.getStroke();
                                                        gg.setStroke(this.selectionStroke);
                                                        if (!this.first_draw_selection_rect) {
                                                            gg.drawRect(Math.min(this.drag_selection_origin.x, this.drag_selection_end.x), Math.min(this.drag_selection_origin.y, this.drag_selection_end.y), Math.abs(this.drag_selection_origin.x - this.drag_selection_end.x), Math.abs(this.drag_selection_origin.y - this.drag_selection_end.y));
                                                        }
                                                        gg.setPaintMode();
                                                        if (s != null) {
                                                            gg.setStroke(s);
                                                        }
                                                        this.drag_selection_mode = false;
                                                        this.first_draw_selection_rect = true;
                                                        if ((evt.getModifiers() & 1) == 0) {
                                                            this.setSelectedElement(null);
                                                        }
                                                        int delta_w = evt.getX() - this.drag_selection_origin.x;
                                                        int delta_h = evt.getY() - this.drag_selection_origin.y;
                                                        int delta_x = delta_w < 0 ? delta_w : 0;
                                                        int delta_y = delta_h < 0 ? delta_h : 0;
                                                        int originX = this.getRealDim(Math.min(this.drag_selection_origin.x, this.drag_selection_end.x) - 10) + 10;
                                                        int originY = this.getRealDim(Math.min(this.drag_selection_origin.y, this.drag_selection_end.y) - 10) + 10;
                                                        int width = this.getRealDim(Math.abs(delta_w));
                                                        int height = this.getRealDim(Math.abs(delta_h));
                                                        Rectangle rect = new Rectangle(originX, originY, width, height);
                                                        boolean selection_changed = false;
                                                        for (ReportElement re2 : this.getCrosstabElement().getElements()) {
                                                            if (!re2.intersects(rect)) continue;
                                                            if (!selection_changed) {
                                                                selection_changed = true;
                                                            }
                                                            this.addSelectedElement(re2, false);
                                                        }
                                                        if (selection_changed) {
                                                            this.fireSelectionChangedEvent();
                                                        }
                                                        break block41;
                                                    }
                                                    if (evt.getButton() != 1 || !this.cell_dragging || this.readyToDragCellVertically <= 0) break block43;
                                                    Graphics gg = this.getGraphics();
                                                    gg.setXORMode(Color.WHITE);
                                                    gg.drawLine(0, this.mouse.y, this.getWidth(), this.mouse.y);
                                                    gg.setPaintMode();
                                                    oldPosition2 = (Integer)this.getRows().get(this.readyToDragCellVertically);
                                                    delta2 = this.getRealDim(mouseY - 10 - this.getZoomedDim(oldPosition2));
                                                    if (oldPosition2 + delta2 <= (Integer)this.getRows().get(this.readyToDragCellVertically - 1)) {
                                                        delta2 = (Integer)this.getRows().get(this.readyToDragCellVertically - 1) - oldPosition2;
                                                    }
                                                    int maxHeight = this.getParentReportFrame().getReport().getHeight() - this.getCrosstabElement().getPosition().y;
                                                    if ((Integer)this.getRows().get(this.getRows().size() - 1) + delta2 > maxHeight) {
                                                        delta2 = maxHeight - (Integer)this.getRows().get(this.getRows().size() - 1);
                                                    }
                                                    if (delta2 == 0) {
                                                        return;
                                                    }
                                                    int newPosition = (Integer)this.getRows().get(this.readyToDragCellVertically) + delta2;
                                                    for (int j = 0; j < this.getCrosstabElement().getElements().size(); ++j) {
                                                        ReportElement re3 = (ReportElement)this.getCrosstabElement().getElements().elementAt(j);
                                                        re3.setRelativePosition(new Point(re3.getPosition().x - re3.getCell().getLeft() - 10, re3.getPosition().y - re3.getCell().getTop() - 10));
                                                    }
                                                    if ((evt.getModifiers() & 1) == 0) break block44;
                                                    break block45;
                                                }
                                                if (evt.getButton() != 1 || !this.cell_dragging || this.readyToDragCellHorizontally <= 0) break block46;
                                                Graphics gg = this.getGraphics();
                                                gg.setXORMode(Color.WHITE);
                                                gg.drawLine(this.mouse.x, 0, this.mouse.x, this.getHeight());
                                                gg.setPaintMode();
                                                oldPosition = (Integer)this.getColumns().get(this.readyToDragCellHorizontally);
                                                delta = this.getRealDim(mouseX - 10 - this.getZoomedDim(oldPosition));
                                                if (oldPosition + delta <= (Integer)this.getColumns().get(this.readyToDragCellHorizontally - 1)) {
                                                    delta = (Integer)this.getColumns().get(this.readyToDragCellHorizontally - 1) - oldPosition;
                                                }
                                                int maxWidth = this.getParentReportFrame().getReport().getWidth() - this.getCrosstabElement().getPosition().x;
                                                if ((Integer)this.getColumns().get(this.getColumns().size() - 1) + delta > maxWidth) {
                                                    delta = maxWidth - (Integer)this.getColumns().get(this.getColumns().size() - 1);
                                                }
                                                if (delta == 0) {
                                                    return;
                                                }
                                                int newPosition = (Integer)this.getColumns().get(this.readyToDragCellHorizontally) + delta;
                                                for (int j = 0; j < this.getCrosstabElement().getElements().size(); ++j) {
                                                    ReportElement re4 = (ReportElement)this.getCrosstabElement().getElements().elementAt(j);
                                                    re4.setRelativePosition(new Point(re4.getPosition().x - re4.getCell().getLeft() - 10, re4.getPosition().y - re4.getCell().getTop() - 10));
                                                }
                                                if ((evt.getModifiers() & 1) == 0) break block47;
                                                break block48;
                                            }
                                            if (evt.getButton() != 1) break block41;
                                            if (this.newObjectType == -1) break block49;
                                            this.firstXORDraw = true;
                                            int delta_w = evt.getX() - this.newObjectOrigin.x;
                                            int delta_h = evt.getY() - this.newObjectOrigin.y;
                                            int delta_x = delta_w < 0 ? delta_w : 0;
                                            int delta_y = delta_h < 0 ? delta_h : 0;
                                            int originX = this.getRealDim(Math.min(this.newObjectOrigin.x - 10, this.newObjectOrigin.x + delta_x - 10)) + 10;
                                            int originY = this.getRealDim(Math.min(this.newObjectOrigin.y - 10, this.newObjectOrigin.y + delta_y - 10)) + 10;
                                            int width = this.getRealDim(Math.abs(delta_w));
                                            int height = this.getRealDim(Math.abs(delta_h));
                                            if (this.newObjectType == 5) {
                                                if ((evt.getModifiers() & 1) != 0) {
                                                    Point straight = this.straighten(delta_w, delta_h);
                                                    delta_w = straight.x;
                                                    delta_h = straight.y;
                                                }
                                            }
                                            if ((bname = this.getCellByPoint(new Point(this.getRealDim(evt.getX() - 10), this.getRealDim(evt.getY() - 10)))) == null) break block50;
                                            re = ReportElementFactory.create(this.newObjectType, originX, originY, this.getRealDim(delta_w), this.getRealDim(delta_h));
                                            if (this.getParentReportFrame().getReport().getStyles().size() > 0) {
                                                for (int i3 = 0; i3 < this.getParentReportFrame().getReport().getStyles().size(); ++i3) {
                                                    Style s = (Style)this.getParentReportFrame().getReport().getStyles().elementAt(i3);
                                                    if (!s.getAttributeBoolean("isDefault", false)) continue;
                                                    re.setStyle(s);
                                                }
                                            }
                                            re.setKey(this.getParentReportFrame().getNextElementKey(re.getKey()));
                                            re.setCell(bname);
                                            re.setRelativePosition(new Point(re.getPosition().x - re.getCell().getLeft() - 10, re.getPosition().y - re.getCell().getTop() - 10));
                                            break block51;
                                        }
                                        this.setSelectedElement(null);
                                        break block52;
                                    }
                                    if (this.trasforming) {
                                        this.trasforming = false;
                                        this.setCursor(Cursor.getDefaultCursor());
                                        if (this.transformation_type != TransformationType.TRANSFORMATION_MOVE || this.resistenceExceeded) {
                                            Point p = new Point(this.transformation_origin_end);
                                            p.x = this.getRealDim(p.x);
                                            p.y = this.getRealDim(p.y);
                                            p.x -= this.getRealDim(this.transformation_origin.x);
                                            p.y -= this.getRealDim(this.transformation_origin.y);
                                            Enumeration e = this.getSelectedElements().elements();
                                            this.getMainFrame();
                                            TransformElementsOperation undoOp = new TransformElementsOperation(MainFrame.getMainInstance().getActiveReportFrame(), this.getCrosstabElement());
                                            Vector<ReportElement> changed_elements = new Vector<ReportElement>();
                                            while (e.hasMoreElements()) {
                                                ReportElement re5 = (ReportElement)e.nextElement();
                                                undoOp.addElement(re5);
                                                re5.trasform(p, this.transformation_type);
                                                re5.adjustCell(this.getCrosstabElement().getCells());
                                                undoOp.captureUniqueModified(re5);
                                                this.getParentReportFrame().addUndoOperation(undoOp);
                                                changed_elements.add(re5);
                                            }
                                            if (changed_elements.size() > 0) {
                                                this.getMainFrame();
                                                JReportFrame jReportFrame = MainFrame.getMainInstance().getActiveReportFrame();
                                                this.getMainFrame();
                                                jReportFrame.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(MainFrame.getMainInstance().getActiveReportFrame(), this.getCrosstabElement(), changed_elements, 3));
                                            }
                                            this.repaint();
                                        }
                                        this.transformation_undo_delta = new Point(0, 0);
                                        this.transformation_type = TransformationType.TRANSFORMATION_NONE;
                                        this.getMainFrame().getElementPropertiesDialog().updateSelection();
                                    }
                                    break block41;
                                }
                                for (int i4 = this.getRows().size() - 1; i4 > 0; --i4) {
                                    int position = (Integer)this.getRows().get(i4);
                                    if (oldPosition2 != position) continue;
                                    this.readyToDragCellVertically = i4;
                                    break;
                                }
                            }
                            Vector cells = (Vector)this.getRowBands().elementAt(this.readyToDragCellVertically - 1);
                            for (i2 = 0; i2 < cells.size(); ++i2) {
                                CrosstabCell cell = (CrosstabCell)cells.elementAt(i2);
                                cell.setHeight(cell.getHeight() + delta2);
                            }
                            int j = this.readyToDragCellVertically;
                            while (true) {
                                if (j >= this.getRowBands().size()) {
                                    for (i2 = 0; i2 < this.getCrosstabElement().getColumnGroups().size(); ++i2) {
                                        CrosstabGroup group = (CrosstabGroup)this.getCrosstabElement().getColumnGroups().elementAt(i2);
                                        group.setSize(group.getHeaderCell().getHeight());
                                    }
                                    for (j = 0; j < this.getCrosstabElement().getElements().size(); ++j) {
                                        ReportElement re6 = (ReportElement)this.getCrosstabElement().getElements().elementAt(j);
                                        re6.getPosition().x = re6.getRelativePosition().x + re6.getCell().getLeft() + 10;
                                        re6.getPosition().y = re6.getRelativePosition().y + re6.getCell().getTop() + 10;
                                        re6.setPosition(re6.position);
                                        re6.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                                    }
                                    for (i2 = this.readyToDragCellVertically; i2 < this.getRows().size(); ++i2) {
                                        int rowPosition = (Integer)this.getRows().get(i2) + delta2;
                                        this.getRows().set(i2, new Integer(rowPosition));
                                    }
                                    this.cell_dragging = false;
                                    this.updateSize();
                                    this.repaint();
                                    this.getParentReportFrame().addUndoOperation(new CrosstabRowDraggedOperation(this, this.getCrosstabElement(), this.readyToDragCellVertically, delta2));
                                    break block41;
                                }
                                cells = (Vector)this.getRowBands().elementAt(j);
                                for (int i5 = 0; i5 < cells.size(); ++i5) {
                                    CrosstabCell cell = (CrosstabCell)cells.elementAt(i5);
                                    if (cell.getTopIndex() >= this.readyToDragCellVertically) {
                                        cell.setTop(cell.getTop() + delta2);
                                        continue;
                                    }
                                    cell.setHeight(cell.getHeight() + delta2);
                                }
                                ++j;
                            }
                        }
                        for (int i6 = this.getColumns().size() - 1; i6 > 0; --i6) {
                            int position = (Integer)this.getColumns().get(i6);
                            if (oldPosition != position) continue;
                            this.readyToDragCellHorizontally = i6;
                            break;
                        }
                    }
                    Vector cells = (Vector)this.getColumnBands().elementAt(this.readyToDragCellHorizontally - 1);
                    for (i = 0; i < cells.size(); ++i) {
                        CrosstabCell cell = (CrosstabCell)cells.elementAt(i);
                        cell.setWidth(cell.getWidth() + delta);
                    }
                    int j = this.readyToDragCellHorizontally;
                    while (true) {
                        if (j >= this.getRowBands().size()) {
                            for (i = 0; i < this.getCrosstabElement().getRowGroups().size(); ++i) {
                                CrosstabGroup group = (CrosstabGroup)this.getCrosstabElement().getRowGroups().elementAt(i);
                                group.setSize(group.getHeaderCell().getWidth());
                            }
                            for (j = 0; j < this.getCrosstabElement().getElements().size(); ++j) {
                                ReportElement re7 = (ReportElement)this.getCrosstabElement().getElements().elementAt(j);
                                re7.getPosition().x = re7.getRelativePosition().x + re7.getCell().getLeft() + 10;
                                re7.getPosition().y = re7.getRelativePosition().y + re7.getCell().getTop() + 10;
                                re7.setPosition(re7.position);
                                re7.trasform(new Point(0, 0), TransformationType.TRANSFORMATION_RESIZE_SE);
                            }
                            for (i = this.readyToDragCellHorizontally; i < this.getColumns().size(); ++i) {
                                int rowPosition = (Integer)this.getColumns().get(i) + delta;
                                this.getColumns().set(i, new Integer(rowPosition));
                            }
                            this.cell_dragging = false;
                            this.updateSize();
                            this.repaint();
                            this.getParentReportFrame().addUndoOperation(new CrosstabColumnDraggedOperation(this, this.getCrosstabElement(), this.readyToDragCellHorizontally, delta));
                            break block41;
                        }
                        cells = (Vector)this.getColumnBands().elementAt(j);
                        for (int i7 = 0; i7 < cells.size(); ++i7) {
                            CrosstabCell cell = (CrosstabCell)cells.elementAt(i7);
                            if (cell.getLeftIndex() >= this.readyToDragCellHorizontally) {
                                cell.setLeft(cell.getLeft() + delta);
                                continue;
                            }
                            cell.setWidth(cell.getWidth() + delta);
                        }
                        ++j;
                    }
                }
                for (int elnum = this.getCrosstabElement().getElements().size() - 1; elnum >= 0; --elnum) {
                    ReportElement container_re = (ReportElement)this.getCrosstabElement().getElements().elementAt(elnum);
                    if (!(container_re instanceof FrameReportElement) || container_re.getCell() != re.getCell() || !container_re.getBounds().contains(re.getBounds())) continue;
                    re.setParentElement(container_re);
                    break;
                }
                this.getCrosstabElement().getElements().addElement(re);
                this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), re, 2));
                this.getParentReportFrame().addUndoOperation(new InsertElementOperation(this.getParentReportFrame(), this.getCrosstabElement(), re));
                this.setSelectedElement(re);
            }
            this.newObjectOrigin = null;
            this.newObjectType = -1;
            this.setCursor(Cursor.getDefaultCursor());
            this.getMainFrame().setActiveTool(0);
        }
        this.mouse.y = mouseY;
        this.mouse.x = mouseX;
    }

    private void formMouseDragged(MouseEvent evt) {
        int mouseX = (int)evt.getPoint().getX();
        int mouseY = (int)evt.getPoint().getY();
        if (this.drag_selection_mode) {
            Graphics2D gg = (Graphics2D)this.getGraphics();
            gg.setXORMode(Color.GREEN);
            Stroke s = gg.getStroke();
            gg.setStroke(this.selectionStroke);
            if (!this.first_draw_selection_rect) {
                gg.drawRect(Math.min(this.drag_selection_origin.x, this.drag_selection_end.x), Math.min(this.drag_selection_origin.y, this.drag_selection_end.y), Math.abs(this.drag_selection_origin.x - this.drag_selection_end.x), Math.abs(this.drag_selection_origin.y - this.drag_selection_end.y));
            }
            this.drag_selection_end = new Point(evt.getX(), evt.getY());
            gg.drawRect(Math.min(this.drag_selection_origin.x, this.drag_selection_end.x), Math.min(this.drag_selection_origin.y, this.drag_selection_end.y), Math.abs(this.drag_selection_origin.x - this.drag_selection_end.x), Math.abs(this.drag_selection_origin.y - this.drag_selection_end.y));
            gg.setPaintMode();
            this.first_draw_selection_rect = false;
            if (s != null) {
                gg.setStroke(s);
            }
        } else if (this.cell_dragging && this.readyToDragCellVertically > 0) {
            Graphics gg = this.getGraphics();
            gg.setXORMode(Color.WHITE);
            gg.drawLine(0, this.mouse.y, this.getWidth(), this.mouse.y);
            gg.drawLine(0, mouseY, this.getWidth(), mouseY);
            gg.setPaintMode();
        } else if (this.cell_dragging && this.readyToDragCellHorizontally > 0) {
            Graphics gg = this.getGraphics();
            gg.setXORMode(Color.WHITE);
            gg.drawLine(this.mouse.x, 0, this.mouse.x, this.getHeight());
            gg.drawLine(mouseX, 0, mouseX, this.getHeight());
            gg.setPaintMode();
        } else if (this.newObjectType != -1 && this.newObjectOrigin != null) {
            Graphics gg = this.getGraphics();
            gg.setXORMode(Color.WHITE);
            int delta_x = 0;
            int delta_y = 0;
            if (this.newObjectType != 5 && !this.firstXORDraw) {
                delta_x = this.mouse.x - this.newObjectOrigin.x;
                delta_y = this.mouse.y - this.newObjectOrigin.y;
                delta_x = delta_x < 0 ? delta_x : 0;
                delta_y = delta_y < 0 ? delta_y : 0;
            }
            int delta_w = 0;
            int delta_h = 0;
            if (!this.firstXORDraw) {
                delta_w = this.mouse.x - this.newObjectOrigin.x;
                delta_h = this.mouse.y - this.newObjectOrigin.y;
                delta_x = delta_w < 0 ? delta_w : 0;
                int n = delta_y = delta_h < 0 ? delta_h : 0;
            }
            if (this.newObjectType == 5) {
                Point straight;
                if ((evt.getModifiers() & 1) != 0) {
                    straight = this.straighten(delta_w, delta_h);
                    delta_w = straight.x;
                    delta_h = straight.y;
                }
                if (!this.firstXORDraw) {
                    gg.drawLine(this.newObjectOrigin.x, this.newObjectOrigin.y, this.newObjectOrigin.x + delta_w, this.newObjectOrigin.y + delta_h);
                }
                delta_w = evt.getX() - this.newObjectOrigin.x;
                delta_h = evt.getY() - this.newObjectOrigin.y;
                if ((evt.getModifiers() & 1) != 0) {
                    straight = this.straighten(delta_w, delta_h);
                    delta_w = straight.x;
                    delta_h = straight.y;
                }
                gg.drawLine(this.newObjectOrigin.x, this.newObjectOrigin.y, this.newObjectOrigin.x + delta_w, this.newObjectOrigin.y + delta_h);
                this.mouse.x = this.newObjectOrigin.x + delta_w;
                this.mouse.y = this.newObjectOrigin.x + delta_y;
            } else if (this.newObjectType == 7) {
                if (!this.firstXORDraw) {
                    gg.drawOval(this.newObjectOrigin.x + delta_x, this.snapToGridVertically(this.newObjectOrigin.y + delta_y), Math.abs(delta_w), Math.abs(delta_h));
                }
                delta_w = this.gridMultiple(evt.getX() - this.newObjectOrigin.x);
                delta_h = this.gridMultiple(evt.getY() - this.newObjectOrigin.y);
                delta_x = delta_w < 0 ? delta_w : 0;
                delta_y = delta_h < 0 ? delta_h : 0;
                gg.drawOval(this.newObjectOrigin.x + delta_x, this.snapToGridVertically(this.newObjectOrigin.y + delta_y), Math.abs(delta_w), Math.abs(delta_h));
            } else if (this.newObjectType == 8) {
                if (!this.firstXORDraw) {
                    gg.drawRoundRect(this.newObjectOrigin.x + delta_x, this.snapToGridVertically(this.newObjectOrigin.y + delta_y), Math.abs(delta_w), Math.abs(delta_h), 20, 20);
                }
                delta_w = this.gridMultiple(evt.getX() - this.newObjectOrigin.x);
                delta_h = this.gridMultiple(evt.getY() - this.newObjectOrigin.y);
                delta_x = delta_w < 0 ? delta_w : 0;
                delta_y = delta_h < 0 ? delta_h : 0;
                gg.drawRoundRect(this.newObjectOrigin.x + delta_x, this.snapToGridVertically(this.newObjectOrigin.y + delta_y), Math.abs(delta_w), Math.abs(delta_h), 20, 20);
            } else {
                if (!this.firstXORDraw) {
                    gg.drawRect(this.newObjectOrigin.x + delta_x, this.snapToGridVertically(this.newObjectOrigin.y + delta_y), Math.abs(delta_w), Math.abs(delta_h));
                }
                delta_w = this.gridMultiple(evt.getX() - this.newObjectOrigin.x);
                delta_h = this.gridMultiple(evt.getY() - this.newObjectOrigin.y);
                delta_x = delta_w < 0 ? delta_w : 0;
                delta_y = delta_h < 0 ? delta_h : 0;
                gg.drawRect(this.newObjectOrigin.x + delta_x, this.snapToGridVertically(this.newObjectOrigin.y + delta_y), Math.abs(delta_w), Math.abs(delta_h));
            }
            this.firstXORDraw = false;
            gg.setPaintMode();
        } else if (this.selectedElements.size() > 0 && this.newObjectType == -1 && this.transformation_origin_end != null) {
            int new_transformation_origin_end_x = this.transformation_origin_end.x;
            int new_transformation_origin_end_y = this.transformation_origin_end.y;
            if (this.transformation_type >= 0 && this.trasforming) {
                int width_grow;
                int height_grow;
                int y_delta;
                int x_delta;
                Rectangle bounds;
                ReportElement re;
                Enumeration e;
                Graphics gg = this.getGraphics();
                gg.setXORMode(Color.WHITE);
                if (!this.firstXORDrawTransforming) {
                    new_transformation_origin_end_y = evt.getY();
                    new_transformation_origin_end_x = evt.getX();
                    e = this.getSelectedElements().elements();
                    while (e.hasMoreElements()) {
                        re = (ReportElement)e.nextElement();
                        bounds = new Rectangle(this.getZoomedDim(re.getPosition().x - 10) + 10, this.getZoomedDim(re.getPosition().y - 10) + 10, this.getZoomedDim(re.getWidth()), this.getZoomedDim(re.getHeight()));
                        if (this.transformation_type == TransformationType.TRANSFORMATION_MOVE) {
                            if (!this.resistenceExceeded) continue;
                            bounds.translate(this.transformation_origin_end.x - this.transformation_origin.x, this.transformation_origin_end.y - this.transformation_origin.y);
                            gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                            continue;
                        }
                        if (this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_SE || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_S || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_E) {
                            x_delta = this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_SE || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_E ? this.transformation_origin_end.x - this.transformation_origin.x : 0;
                            y_delta = this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_SE || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_S ? this.transformation_origin_end.y - this.transformation_origin.y : 0;
                            bounds.setSize(Math.max(0, bounds.width + x_delta), Math.max(0, bounds.height + y_delta));
                            gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                            continue;
                        }
                        if (this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_NW || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_N || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_W) {
                            x_delta = this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_NW || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_W ? this.transformation_origin_end.x - this.transformation_origin.x : 0;
                            y_delta = this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_NW || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_N ? this.transformation_origin_end.y - this.transformation_origin.y : 0;
                            height_grow = Math.min(y_delta, bounds.height);
                            width_grow = Math.min(x_delta, bounds.width);
                            bounds.translate(width_grow, height_grow);
                            bounds.setSize(bounds.width - width_grow, bounds.height - height_grow);
                            gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                            continue;
                        }
                        if (this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_NE) {
                            x_delta = Math.max(-bounds.width, this.transformation_origin_end.x - this.transformation_origin.x);
                            y_delta = Math.min(bounds.height, this.transformation_origin_end.y - this.transformation_origin.y);
                            bounds.y += y_delta;
                            bounds.height -= y_delta;
                            bounds.width += x_delta;
                            gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                            continue;
                        }
                        if (this.transformation_type != TransformationType.TRANSFORMATION_RESIZE_SW) continue;
                        x_delta = Math.min(bounds.width, this.transformation_origin_end.x - this.transformation_origin.x);
                        y_delta = Math.max(-bounds.height, this.transformation_origin_end.y - this.transformation_origin.y);
                        bounds.x += x_delta;
                        bounds.width -= x_delta;
                        bounds.height += y_delta;
                        gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                    }
                }
                this.transformation_origin_end.x = new_transformation_origin_end_x;
                this.transformation_origin_end.y = new_transformation_origin_end_y;
                e = this.getSelectedElements().elements();
                while (e.hasMoreElements()) {
                    re = (ReportElement)e.nextElement();
                    bounds = new Rectangle(this.getZoomedDim(re.getPosition().x - 10) + 10, this.getZoomedDim(re.getPosition().y - 10) + 10, this.getZoomedDim(re.getWidth()), this.getZoomedDim(re.getHeight()));
                    if (this.transformation_type == TransformationType.TRANSFORMATION_MOVE) {
                        if (Math.abs(this.transformation_origin_end.x - this.transformation_origin.x) > 5 || Math.abs(this.transformation_origin_end.y - this.transformation_origin.y) > 5) {
                            this.resistenceExceeded = true;
                        }
                        if (!this.resistenceExceeded) continue;
                        int pex = this.gridMultiple(this.transformation_origin_end.x - 10) + 10;
                        int pey = this.gridMultiple(this.transformation_origin_end.y - 10) + 10;
                        int pox = this.gridMultiple(this.transformation_origin.x - 10) + 10;
                        int poy = this.gridMultiple(this.transformation_origin.y - 10) + 10;
                        bounds.translate(this.transformation_origin_end.x - this.transformation_origin.x, this.transformation_origin_end.y - this.transformation_origin.y);
                        gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                        continue;
                    }
                    if (this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_SE || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_S || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_E) {
                        x_delta = this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_SE || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_E ? this.transformation_origin_end.x - this.transformation_origin.x : 0;
                        y_delta = this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_SE || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_S ? this.transformation_origin_end.y - this.transformation_origin.y : 0;
                        bounds.setSize(Math.max(0, bounds.width + x_delta), Math.max(0, bounds.height + y_delta));
                        gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                        continue;
                    }
                    if (this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_NW || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_N || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_W) {
                        x_delta = this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_NW || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_W ? this.transformation_origin_end.x - this.transformation_origin.x : 0;
                        y_delta = this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_NW || this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_N ? this.transformation_origin_end.y - this.transformation_origin.y : 0;
                        height_grow = Math.min(y_delta, bounds.height);
                        width_grow = Math.min(x_delta, bounds.width);
                        bounds.translate(width_grow, height_grow);
                        bounds.setSize(bounds.width - width_grow, bounds.height - height_grow);
                        gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                        continue;
                    }
                    if (this.transformation_type == TransformationType.TRANSFORMATION_RESIZE_NE) {
                        x_delta = Math.max(-bounds.width, this.transformation_origin_end.x - this.transformation_origin.x);
                        y_delta = Math.min(bounds.height, this.transformation_origin_end.y - this.transformation_origin.y);
                        bounds.y += y_delta;
                        bounds.height -= y_delta;
                        bounds.width += x_delta;
                        gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                        continue;
                    }
                    if (this.transformation_type != TransformationType.TRANSFORMATION_RESIZE_SW) continue;
                    x_delta = Math.min(bounds.width, this.transformation_origin_end.x - this.transformation_origin.x);
                    y_delta = Math.max(-bounds.height, this.transformation_origin_end.y - this.transformation_origin.y);
                    bounds.x += x_delta;
                    bounds.width -= x_delta;
                    bounds.height += y_delta;
                    gg.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
                }
                this.firstXORDrawTransforming = false;
                gg.setPaintMode();
            }
        }
        this.mouse.y = mouseY;
        this.mouse.x = mouseX;
    }

    private void formMousePressed(MouseEvent evt) {
        this.requestFocus();
        int mouseX = (int)evt.getPoint().getX();
        int mouseY = (int)evt.getPoint().getY();
        if (evt.getButton() == 1 && evt.getClickCount() < 2) {
            if (this.readyToDragCellVertically > 0) {
                Graphics gg = this.getGraphics();
                gg.setXORMode(Color.WHITE);
                gg.drawLine(0, mouseY, this.getWidth(), mouseY);
                gg.setPaintMode();
                this.mouse.y = mouseY;
                this.mouse.x = mouseX;
                this.cell_dragging = true;
                return;
            }
            if (this.readyToDragCellHorizontally > 0) {
                Graphics gg = this.getGraphics();
                gg.setXORMode(Color.WHITE);
                gg.drawLine(mouseX, 0, mouseX, this.getHeight());
                gg.setPaintMode();
                this.mouse.y = mouseY;
                this.mouse.x = mouseX;
                this.cell_dragging = true;
                return;
            }
            if (this.newObjectType != -1) {
                this.firstXORDraw = false;
                this.newObjectOrigin = new Point(evt.getX(), evt.getY());
                this.mouse.x = this.newObjectOrigin.x;
                this.mouse.y = this.newObjectOrigin.y;
                return;
            }
            if (this.selectedElements.size() > 0) {
                if ((evt.getModifiers() & 1) == 0 && this.transformation_type >= 0) {
                    this.trasforming = true;
                    this.firstXORDrawTransforming = true;
                    this.transformation_origin = new Point(evt.getX(), evt.getY());
                    this.transformation_undo_delta = new Point(0, 0);
                    this.transformation_origin_end = new Point(evt.getX(), evt.getY());
                    return;
                }
            }
            boolean foundElement = false;
            for (int i = this.getCrosstabElement().getElements().size() - 1; i >= 0; --i) {
                ReportElement re = (ReportElement)this.getCrosstabElement().getElements().elementAt(i);
                if (this.isDefaultCellMode() != (re.getCell().getType() == 2) || !re.intersects(new Point(this.getRealDim(evt.getX() - 10) + 10, this.getRealDim(evt.getY() - 10) + 10))) continue;
                foundElement = true;
                if (this.selectedElements.size() > 0 && re == (ReportElement)this.selectedElements.firstElement()) continue;
                if ((evt.getModifiers() & 1) != 0) {
                    if (this.getSelectedElements().contains(re)) {
                        this.getSelectedElements().remove(re);
                        this.repaint();
                    } else {
                        this.addSelectedElement(re);
                        this.repaint();
                    }
                } else {
                    this.setSelectedElement(re);
                }
                this.trasforming = true;
                this.firstXORDrawTransforming = true;
                this.transformation_origin = new Point(evt.getX(), evt.getY());
                this.transformation_origin_end = new Point(evt.getX(), evt.getY());
                this.transformation_type = TransformationType.TRANSFORMATION_MOVE;
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
            if (!foundElement) {
                if (this.getSelectedElements().size() > 0) {
                    if ((evt.getModifiers() & 1) == 0) {
                        this.setSelectedElement(null);
                    }
                }
                this.drag_selection_mode = true;
                this.first_draw_selection_rect = true;
                this.drag_selection_origin = new Point(evt.getX(), evt.getY());
                this.drag_selection_end = new Point(evt.getX(), evt.getY());
            }
        } else if (evt.getButton() == 3) {
            if (this.getSelectedElements().size() > 0) {
                this.jMenuItemCellProperties.setEnabled(false);
                this.selectedCell = this.getCellByPoint(new Point(this.getRealDim(evt.getX() - 10), this.getRealDim(evt.getY() - 10)));
                this.jMenuItemCellProperties.setEnabled(this.selectedCell != null);
                this.jMenuItemCopy.setEnabled(true);
                this.jMenuItemCut.setEnabled(true);
                this.jMenuItemDelete.setEnabled(true);
                this.jMenuItemCopyStyle.setEnabled(true);
                this.jMenuItemPasteStyle.setEnabled(this.getMainFrame().getStyleClipboard() != null);
                this.jMenuItemPaste.setEnabled(this.getMainFrame().getClipBoard().size() > 0);
                this.jCheckBoxMenuItemDefaultCellEdit.setSelected(this.isDefaultCellMode());
                this.jPopupMenuCrosstabReporteElement.show(this, evt.getX(), evt.getY());
            } else {
                this.jMenuItemCellProperties1.setEnabled(true);
                this.selectedCell = this.getCellByPoint(new Point(this.getRealDim(evt.getX() - 10), this.getRealDim(evt.getY() - 10)));
                this.jMenuItemCellProperties1.setEnabled(this.selectedCell != null);
                this.jMenuItemPaste1.setEnabled(this.getMainFrame().getClipBoard().size() > 0);
                this.jCheckBoxMenuItemDefaultCellEdit1.setSelected(this.isDefaultCellMode());
                this.jPopupMenuCrosstab.show(this, evt.getX(), evt.getY());
            }
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.getSelectedElements().size() > 0) {
            this.getParentReportFrame().openElementPropertiesDialog();
        }
    }

    private void formMouseMoved(MouseEvent evt) {
        double mouseX = evt.getPoint().getX();
        double mouseY = evt.getPoint().getY();
        this.readyToDragCellVertically = -1;
        this.readyToDragCellHorizontally = -1;
        try {
            if (this.newObjectType == -1) {
                if (this.getSelectedElements().size() == 0) {
                    int position;
                    int i;
                    for (i = 1; i < this.getRows().size(); ++i) {
                        position = (Integer)this.getRows().get(i);
                        if (!(mouseY > (double)((position = this.getZoomedDim(position) + 10) - 2)) || !(mouseY < (double)(position + 2))) continue;
                        this.readyToDragCellVertically = i;
                        this.setCursor(Cursor.getPredefinedCursor(9));
                        break;
                    }
                    for (i = 1; this.readyToDragCellVertically < 0 && i < this.getColumns().size(); ++i) {
                        position = (Integer)this.getColumns().get(i);
                        if (!(mouseX > (double)((position = this.getZoomedDim(position) + 10) - 2)) || !(mouseX < (double)(position + 2))) continue;
                        this.readyToDragCellHorizontally = i;
                        this.setCursor(Cursor.getPredefinedCursor(11));
                        break;
                    }
                    if (this.readyToDragCellVertically <= 0 && this.readyToDragCellHorizontally <= 0) {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (this.selectedElements.size() > 0 && this.newObjectType == -1) {
                    Enumeration e = this.selectedElements.elements();
                    boolean found = false;
                    boolean sizeall = false;
                    while (!found && e.hasMoreElements()) {
                        ReportElement selectedRe = (ReportElement)e.nextElement();
                        Rectangle grip = new Rectangle(this.getZoomedDim(selectedRe.position.x - 10) - 5 + 10, this.getZoomedDim(selectedRe.position.y - 10) - 5 + 10, this.getZoomedDim(selectedRe.width) + 10, this.getZoomedDim(selectedRe.height) + 10);
                        Rectangle cursor = new Rectangle(evt.getX(), evt.getY(), 1, 1);
                        if (!cursor.intersects(grip)) continue;
                        sizeall = true;
                        grip.width = 5;
                        grip.height = 5;
                        if (cursor.intersects(grip)) {
                            this.setCursor(Cursor.getPredefinedCursor(6));
                            found = true;
                            this.transformation_type = TransformationType.TRANSFORMATION_RESIZE_NW;
                        }
                        if (!found) {
                            grip.x = this.getZoomedDim(selectedRe.position.x - 10 + selectedRe.width) + 10;
                            grip.y = this.getZoomedDim(selectedRe.position.y - 10) + 10 - 5;
                            grip.width = 5;
                            grip.height = 5;
                            if (cursor.intersects(grip)) {
                                this.setCursor(Cursor.getPredefinedCursor(7));
                                found = true;
                                this.transformation_type = TransformationType.TRANSFORMATION_RESIZE_NE;
                            }
                        }
                        if (!found) {
                            grip.x = this.getZoomedDim(selectedRe.position.x - 10) + 10 - 5;
                            grip.y = this.getZoomedDim(selectedRe.position.y + selectedRe.height / 2 - 10) + 10 - 2;
                            grip.width = 5;
                            grip.height = 5;
                            if (cursor.intersects(grip)) {
                                this.setCursor(Cursor.getPredefinedCursor(10));
                                found = true;
                                this.transformation_type = TransformationType.TRANSFORMATION_RESIZE_W;
                            }
                        }
                        if (!found) {
                            grip.x = this.getZoomedDim(selectedRe.position.x - 10) + 10 - 5;
                            grip.y = this.getZoomedDim(selectedRe.position.y - 10 + selectedRe.height) + 10;
                            grip.width = 5;
                            grip.height = 5;
                            if (cursor.intersects(grip)) {
                                this.setCursor(Cursor.getPredefinedCursor(4));
                                found = true;
                                this.transformation_type = TransformationType.TRANSFORMATION_RESIZE_SW;
                            }
                        }
                        if (!found) {
                            grip.x = this.getZoomedDim(selectedRe.position.x + selectedRe.width / 2 - 10) + 10 - 2;
                            grip.y = this.getZoomedDim(selectedRe.position.y - 10) + 10 - 5;
                            grip.width = 5;
                            grip.height = 5;
                            if (cursor.intersects(grip)) {
                                this.setCursor(Cursor.getPredefinedCursor(8));
                                found = true;
                                this.transformation_type = TransformationType.TRANSFORMATION_RESIZE_N;
                            }
                        }
                        if (!found) {
                            grip.x = this.getZoomedDim(selectedRe.position.x + selectedRe.width / 2 - 10) + 10 - 2;
                            grip.y = this.getZoomedDim(selectedRe.position.y + selectedRe.height - 10) + 10;
                            grip.width = 5;
                            grip.height = 5;
                            if (cursor.intersects(grip)) {
                                this.setCursor(Cursor.getPredefinedCursor(9));
                                found = true;
                                this.transformation_type = TransformationType.TRANSFORMATION_RESIZE_S;
                            }
                        }
                        if (!found) {
                            grip.x = this.getZoomedDim(selectedRe.position.x + selectedRe.width - 10) + 10;
                            grip.y = this.getZoomedDim(selectedRe.position.y + selectedRe.height - 10) + 10;
                            grip.width = 5;
                            grip.height = 5;
                            if (cursor.intersects(grip)) {
                                this.setCursor(Cursor.getPredefinedCursor(5));
                                found = true;
                                this.transformation_type = TransformationType.TRANSFORMATION_RESIZE_SE;
                            }
                        }
                        if (!found) {
                            grip.x = this.getZoomedDim(selectedRe.position.x + selectedRe.width - 10) + 10;
                            grip.y = this.getZoomedDim(selectedRe.position.y + selectedRe.height / 2 - 10) + 10 - 2;
                            grip.width = 5;
                            grip.height = 5;
                            if (cursor.intersects(grip)) {
                                this.setCursor(Cursor.getPredefinedCursor(11));
                                found = true;
                                this.transformation_type = TransformationType.TRANSFORMATION_RESIZE_E;
                            }
                        }
                        if (found) continue;
                        this.setCursor(Cursor.getPredefinedCursor(13));
                        if (this.getMainFrame().isEMMActive()) {
                            this.transformation_type = TransformationType.TRANSFORMATION_NONE;
                            continue;
                        }
                        this.transformation_type = TransformationType.TRANSFORMATION_MOVE;
                        this.resistenceExceeded = false;
                    }
                    if (!sizeall) {
                        this.setCursor(Cursor.getDefaultCursor());
                        this.transformation_type = TransformationType.TRANSFORMATION_NONE;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List getColumns() {
        return this.columns;
    }

    public void setColumns(List columns) {
        this.columns = columns;
    }

    public List getRows() {
        return this.rows;
    }

    public void setRows(List rows) {
        this.rows = rows;
    }

    public void addNotDefinedCells() {
        int cellGridHeight;
        if (this.getCrosstabElement() == null) {
            return;
        }
        int cellGridWidth = this.getCrosstabElement().getColumnGroups().size();
        for (int y = cellGridHeight = this.getCrosstabElement().getRowGroups().size(); y >= 0; --y) {
            for (int x = cellGridWidth; x >= 0; --x) {
                int k;
                CrosstabCell cell;
                String totalRowGroupName = "";
                if (y < cellGridHeight) {
                    totalRowGroupName = ((CrosstabGroup)this.getCrosstabElement().getRowGroups().get(y)).getName();
                }
                String totalColumnGroupName = "";
                if (x < cellGridWidth) {
                    totalColumnGroupName = ((CrosstabGroup)this.getCrosstabElement().getColumnGroups().get(x)).getName();
                }
                if ((cell = this.findCell(totalRowGroupName, totalColumnGroupName)) != null) continue;
                int cellHeight = this.getRowHeight(totalRowGroupName);
                int cellWidth = this.getColumnWidth(totalColumnGroupName);
                CrosstabCell templateCell = null;
                for (k = x + 1; k < cellGridWidth; ++k) {
                    templateCell = this.findCell(totalRowGroupName, ((CrosstabGroup)this.getCrosstabElement().getColumnGroups().get(k)).getName());
                    if (templateCell == null) continue;
                    if (templateCell.getWidth() == cellWidth) break;
                    templateCell = null;
                }
                if (templateCell == null && (templateCell = this.findCell(totalRowGroupName, "")) != null && templateCell.getWidth() != cellWidth) {
                    templateCell = null;
                }
                if (templateCell == null) {
                    for (k = y + 1; k < cellGridHeight && (templateCell = this.findCell(((CrosstabGroup)this.getCrosstabElement().getRowGroups().get(k)).getName(), totalColumnGroupName)).getHeight() != cellHeight; ++k) {
                        templateCell = null;
                    }
                    if (templateCell == null && (templateCell = this.findCell("", totalColumnGroupName)) != null && templateCell.getHeight() != cellHeight) {
                        templateCell = null;
                    }
                }
                if (templateCell == null) {
                    cell = new CrosstabCell();
                    cell.setParent(this.getCrosstabElement());
                    cell.setWidth(cellWidth);
                    cell.setHeight(cellHeight);
                    cell.setColumnTotalGroup(totalColumnGroupName);
                    cell.setRowTotalGroup(totalRowGroupName);
                } else {
                    cell = templateCell.cloneMe();
                    cell.setColumnTotalGroup(totalColumnGroupName);
                    cell.setRowTotalGroup(totalRowGroupName);
                    cell.setParent(this.getCrosstabElement());
                    int currentElements = this.getCrosstabElement().getElements().size();
                    for (int i = 0; i < currentElements; ++i) {
                        ReportElement re = (ReportElement)this.getCrosstabElement().getElements().elementAt(i);
                        if (re.getCell() != templateCell) continue;
                        re = re.cloneMe();
                        cell.setColumnTotalGroup(totalColumnGroupName);
                        cell.setRowTotalGroup(totalRowGroupName);
                        re.setCell(cell);
                        this.getCrosstabElement().getElements().add(re);
                    }
                }
                this.getCrosstabElement().getCells().add(cell);
            }
        }
    }

    public Vector getSelectedElements() {
        return this.selectedElements;
    }

    public void setSelectedElements(Vector selectedElements) {
        this.selectedElements = selectedElements;
    }

    public CrosstabCell getCellByPoint(Point p) {
        for (int i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
            CrosstabCell cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
            if (!cell.getBounds().contains(p) || this.isDefaultCellMode() != (cell.getType() == 2)) continue;
            return cell;
        }
        return null;
    }

    public Vector getRowBands() {
        return this.rowBands;
    }

    public Vector getColumnBands() {
        return this.columnBands;
    }

    public void validateSelection() {
        for (int i = 0; i < this.getSelectedElements().size(); ++i) {
            ReportElement re = (ReportElement)this.getSelectedElements().elementAt(i);
            if (this.getCrosstabElement().getElements().contains(re)) continue;
            this.getSelectedElements().remove(re);
            --i;
        }
    }

    public MainFrame getMainFrame() {
        return MainFrame.getMainInstance();
    }

    public void setSelectedElement(ReportElement e) {
        this.setSelectedElement(e, true);
    }

    public void setSelectedElement(ReportElement el, boolean fireEvent) {
        this.getSelectedElements().removeAllElements();
        if (el != null && this.isDefaultCellMode() == (el.getCell().getType() == 2)) {
            this.selectedElements.addElement(el);
            this.getMainFrame().setCutCopyEnabled(true);
        } else {
            this.getMainFrame().setCutCopyEnabled(false);
        }
        this.repaint();
        if (fireEvent) {
            this.fireSelectionChangedEvent();
        }
    }

    public void addSelectedElement(ReportElement el) {
        this.addSelectedElement(el, true);
    }

    public void addSelectedElement(ReportElement el, boolean fireEvent) {
        if (this.selectedElements.contains(el)) {
            return;
        }
        if (this.isDefaultCellMode() != (el.getCell().getType() == 2)) {
            return;
        }
        Rectangle rect = new Rectangle(el.position.x - 5, el.position.y - 5, el.width + 10, el.height + 10);
        this.selectedElements.addElement(el);
        this.repaint();
        if (fireEvent) {
            this.fireSelectionChangedEvent();
        }
        this.getMainFrame().setCutCopyEnabled(true);
    }

    public int gridMultiple(int zoomedDim) {
        return zoomedDim;
    }

    public int magnetEffect(List spots, int position) {
        for (int i = 0; i < spots.size(); ++i) {
            int spotPoint = (Integer)spots.get(i);
            if (position <= (spotPoint = this.getZoomedDim(spotPoint) + 10) - 5 || position >= spotPoint + 5) continue;
            return spotPoint;
        }
        return position;
    }

    public int getNewObjectType() {
        return this.newObjectType;
    }

    public void setNewObjectType(int newObjectType) {
        if (this.newObjectType == newObjectType) {
            return;
        }
        if (newObjectType == -1) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }
        this.newObjectType = newObjectType;
    }

    public Point straighten(int delta_w, int delta_h) {
        double clipAngle = 15.0;
        double R = Math.sqrt(delta_w * delta_w + delta_h * delta_h);
        double cos = (double)delta_w / R;
        double angle = 180.0 * Math.acos(cos) / Math.PI;
        int repeat2 = (int)Math.floor((angle + 0.5 * clipAngle) / clipAngle);
        double newAngle = (double)repeat2 * clipAngle;
        delta_h = (int)(Math.abs(R * Math.sin(newAngle / 180.0 * Math.PI)) * (double)delta_h / (double)Math.abs(delta_h));
        delta_w = (int)(Math.abs(R * Math.cos(newAngle / 180.0 * Math.PI)) * (double)delta_w / (double)Math.abs(delta_w));
        return new Point(delta_w, delta_h);
    }

    public int snapToGridVertically(int p) {
        return p;
    }

    public void deleteSelectedElements() {
        Enumeration e = this.selectedElements.elements();
        DeleteElementsOperation undoOp = new DeleteElementsOperation(this.getParentReportFrame(), this.getCrosstabElement());
        Vector<ReportElement> deletedElements = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            ReportElement re = (ReportElement)e.nextElement();
            if (!this.getCrosstabElement().getElements().contains(re)) continue;
            undoOp.addElement(re, this.getCrosstabElement().getElements().indexOf(re));
            this.getCrosstabElement().getElements().remove(re);
            deletedElements.add(re);
            if (!(re instanceof FrameReportElement)) continue;
            this.removeSubElements(re, undoOp, deletedElements);
        }
        this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), deletedElements, 1));
        this.setSelectedElement(null);
        this.getParentReportFrame().addUndoOperation(undoOp);
        this.repaint();
    }

    protected void removeSubElements(ReportElement parentElement, DeleteElementsOperation undoOp, Vector deletedElements) {
        for (int i = 0; i < this.getCrosstabElement().getElements().size(); ++i) {
            ReportElement re = (ReportElement)this.getCrosstabElement().getElements().elementAt(i);
            if (re.getParentElement() != parentElement) continue;
            undoOp.addElement(re, this.getCrosstabElement().getElements().indexOf(re));
            this.getCrosstabElement().getElements().remove(re);
            --i;
            deletedElements.add(re);
            if (!(re instanceof FrameReportElement)) continue;
            this.removeSubElements(re, undoOp, deletedElements);
        }
    }

    public void fireSelectionChangedEvent() {
        ReportElementsSelectionEvent rece = new ReportElementsSelectionEvent(this.getParentReportFrame(), this.getCrosstabElement(), this.getSelectedElements());
        this.getParentReportFrame().fireReportListenerReportElementsSelectionChanged(rece);
        this.getMainFrame().getElementPropertiesDialog().updateSelection();
    }

    public void copyStyle() {
        if (this.getSelectedElements().size() == 0) {
            return;
        }
        this.getMainFrame().setStyleClipbardContent(((ReportElement)this.getSelectedElements().elementAt(0)).cloneMe());
    }

    public void pasteStyle() {
        if (this.getSelectedElements().size() == 0) {
            return;
        }
        if (this.getMainFrame().getStyleClipboard() == null) {
            return;
        }
        ReportElement templateElement = this.getMainFrame().getStyleClipboard();
        PasteStyleOperation undoOp = new PasteStyleOperation(this.getParentReportFrame(), this.getCrosstabElement());
        Enumeration elements = this.getSelectedElements().elements();
        while (elements.hasMoreElements()) {
            ReportElement re = (ReportElement)elements.nextElement();
            undoOp.addElement(re, re.cloneMe(), templateElement);
            this.getParentReportFrame();
            JReportFrame.applyStyle(re, templateElement);
        }
        this.getParentReportFrame().addUndoOperation(undoOp);
        this.getParentReportFrame().fireReportListenerReportElementsSelectionChanged(new ReportElementsSelectionEvent(this.getParentReportFrame(), this.getCrosstabElement(), this.getSelectedElements()));
        this.repaint();
    }

    public void transformStaticInTextFields() {
        String keyStaticText = new StaticTextReportElement(0, 0, 0, 0).getKey();
        String keyTextField = new TextFieldReportElement(0, 0, 0, 0).getKey();
        Enumeration e = this.selectedElements.elements();
        ReplacedElementsOperation undoOp = new ReplacedElementsOperation(this.getParentReportFrame(), this.getCrosstabElement());
        while (e.hasMoreElements()) {
            ReportElement re = (ReportElement)e.nextElement();
            if (!(re instanceof StaticTextReportElement)) continue;
            TextFieldReportElement tfre = new TextFieldReportElement(re.getPosition().x, re.getPosition().y, re.width, re.height);
            tfre.setRelativePosition(new Point(re.getRelativePosition().x, re.getRelativePosition().y));
            tfre.copyBaseReportElement(tfre, re);
            tfre.setBold(((TextReportElement)re).isBold());
            tfre.setUnderline(((TextReportElement)re).isUnderline());
            tfre.setStrikeTrought(((TextReportElement)re).isStrikeTrought());
            tfre.setItalic(((TextReportElement)re).isItalic());
            tfre.setLineSpacing(((TextReportElement)re).getLineSpacing());
            tfre.setPDFFontName(((TextReportElement)re).getPDFFontName());
            tfre.setPdfEncoding(((TextReportElement)re).getPdfEncoding());
            tfre.setReportFont(((TextReportElement)re).getReportFont());
            tfre.setRotate(((TextReportElement)re).getRotate());
            tfre.setTTFFont(((TextReportElement)re).getTTFFont());
            tfre.setVerticalAlign(((TextReportElement)re).getVerticalAlign());
            tfre.setFont(((TextReportElement)re).getFont());
            tfre.setFontName(((TextReportElement)re).getFontName());
            tfre.setFontSize(((TextReportElement)re).getFontSize());
            tfre.setClassExpression("java.lang.String");
            if (re.getKey().indexOf(keyStaticText + "-") == 0) {
                tfre.setKey(this.getParentReportFrame().getNextElementKey(keyTextField));
            }
            String te = ((TextReportElement)re).getText();
            String result = JOptionPane.showInputDialog(this, I18n.getString("messages.enterNewValue", "Please enter a new Value"), "\"" + te + "\"");
            if (result == null || result.equals("")) continue;
            tfre.setText(result);
            int index = this.getCrosstabElement().getElements().indexOf(re);
            this.getCrosstabElement().getElements().remove(re);
            this.getCrosstabElement().getElements().add(index, tfre);
            int index2 = this.getSelectedElements().indexOf(re);
            this.getSelectedElements().remove(re);
            this.getSelectedElements().add(index2, tfre);
            undoOp.addElement(re, tfre);
            this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), re, 1));
            this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), tfre, 2));
        }
        this.getParentReportFrame().addUndoOperation(undoOp);
        this.getParentReportFrame().fireReportListenerReportElementsSelectionChanged(new ReportElementsSelectionEvent(this.getParentReportFrame(), this.getCrosstabElement(), this.getSelectedElements()));
        this.repaint();
    }

    public void bringToFront() {
        Enumeration e = this.getSelectedElements().elements();
        ChangeEmentsOrderOperation undoOp = new ChangeEmentsOrderOperation(this.getParentReportFrame(), this.getCrosstabElement());
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            int oldPosition = this.getCrosstabElement().getElements().indexOf(element);
            this.getCrosstabElement().getElements().remove(element);
            this.getCrosstabElement().getElements().addElement(element);
            int newPosition = this.getCrosstabElement().getElements().indexOf(element);
            undoOp.addElement(element, oldPosition, newPosition);
        }
        if (undoOp.getElements().size() > 0) {
            this.getParentReportFrame().addUndoOperation(undoOp);
        }
        this.repaint();
    }

    public void sendToBack() {
        Enumeration e = this.getSelectedElements().elements();
        ChangeEmentsOrderOperation undoOp = new ChangeEmentsOrderOperation(this.getParentReportFrame(), this.getCrosstabElement());
        while (e.hasMoreElements()) {
            ReportElement element = (ReportElement)e.nextElement();
            int oldPosition = this.getCrosstabElement().getElements().indexOf(element);
            this.getCrosstabElement().getElements().remove(element);
            if (element.getParentElement() != null) {
                this.getCrosstabElement().getElements().insertElementAt(element, this.getCrosstabElement().getElements().indexOf(element.getParentElement()) + 1);
            } else {
                this.getCrosstabElement().getElements().insertElementAt(element, 0);
            }
            int newPosition = 0;
            undoOp.addElement(element, oldPosition, newPosition);
        }
        if (undoOp.getElements().size() > 0) {
            this.getParentReportFrame().addUndoOperation(undoOp);
        }
        this.repaint();
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            DropTargetContext context = dtde.getDropTargetContext();
            Transferable tr = dtde.getTransferable();
            DataFlavor[] df = tr.getTransferDataFlavors();
            if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.crosstab.Measure")) {
                DataFlavor myFlavor = new DataFlavor(Measure.class, Measure.class.getName());
                Measure field = (Measure)tr.getTransferData(myFlavor);
                this.dropNewTextField(dtde.getLocation(), "$V{" + field.getName() + "}", field.getClassType(), "Now");
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.crosstab.CrosstabRowGroup")) {
                DataFlavor myFlavor = new DataFlavor(CrosstabRowGroup.class, CrosstabRowGroup.class.getName());
                CrosstabGroup field = (CrosstabGroup)tr.getTransferData(myFlavor);
                this.dropNewTextField(dtde.getLocation(), "$V{" + field.getName() + "}", field.getBucketExpressionClass(), "Now");
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.crosstab.CrosstabColumnGroup")) {
                DataFlavor myFlavor = new DataFlavor(CrosstabColumnGroup.class, CrosstabColumnGroup.class.getName());
                CrosstabGroup field = (CrosstabGroup)tr.getTransferData(myFlavor);
                this.dropNewTextField(dtde.getLocation(), "$V{" + field.getName() + "}", field.getBucketExpressionClass(), "Now");
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.crosstab.GroupTotal")) {
                DataFlavor myFlavor = new DataFlavor(GroupTotal.class, GroupTotal.class.getName());
                GroupTotal field = (GroupTotal)tr.getTransferData(myFlavor);
                this.dropNewTextField(dtde.getLocation(), "$V{" + field.getVarName() + "}", field.getClassType(), "Now");
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.crosstab.CrosstabParameter")) {
                DataFlavor myFlavor = new DataFlavor(CrosstabParameter.class, CrosstabParameter.class.getName());
                CrosstabParameter field = (CrosstabParameter)tr.getTransferData(myFlavor);
                this.dropNewTextField(dtde.getLocation(), "$P{" + field.getName() + "}", field.getClassType(), "Now");
            } else if (df[0].getHumanPresentableName().equals("it.businesslogic.ireport.Style")) {
                DataFlavor myFlavor = new DataFlavor(Style.class, JRParameter.class.getName());
                Style var = (Style)tr.getTransferData(myFlavor);
                ReportElement re = this.getElementAt(dtde.getLocation());
                if (re != null) {
                    if (!this.getParentReportFrame().getReport().getStyles().contains(var)) {
                        boolean found = false;
                        for (int i = 0; i < this.getParentReportFrame().getReport().getStyles().size(); ++i) {
                            Style s = (Style)this.getParentReportFrame().getReport().getStyles().elementAt(i);
                            if (s.getName() == null || !s.getName().equals(var.getName())) continue;
                            var = s;
                            found = true;
                            break;
                        }
                        if (!found) {
                            var = new Style(var);
                            this.getParentReportFrame().getReport().addStyle(var);
                        }
                    }
                    re.setStyle(var);
                    this.getParentReportFrame().fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.getParentReportFrame(), this.getCrosstabElement(), re, 3));
                    this.repaint();
                }
            } else {
                Class<?> c = Class.forName(df[0].getHumanPresentableName());
                if (AbstractLibraryObject.class.isAssignableFrom(c)) {
                    DataFlavor myFlavor = new DataFlavor(c, df[0].getHumanPresentableName());
                    Object obj = tr.getTransferData(myFlavor);
                    ((AbstractLibraryObject)obj).drop(dtde);
                }
            }
            context.dropComplete(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public TextFieldReportElement dropNewTextField(Point newObjectOrigin, String textfieldExpression, String classExpression, String time) {
        TextFieldReportElement re = null;
        CrosstabCell cell = this.getCellByPoint(new Point(this.getRealDim(newObjectOrigin.x - 10), this.getRealDim(newObjectOrigin.y - 10)));
        if (cell == null) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.dropObjectInsideTheCell", "Please drop the object inside a cell."), "", 2);
            return null;
        }
        int originX = cell.getLeft() + 10;
        int originY = cell.getTop() + 10;
        int width = cell.getWidth();
        int height = cell.getHeight();
        re = new TextFieldReportElement(originX, originY, width, height);
        re.setRelativePosition(new Point(0, 0));
        re.setCell(cell);
        re.setText(textfieldExpression);
        re.setMatchingClassExpression(classExpression, true);
        re.setEvaluationTime(time);
        this.getCrosstabElement().getElements().addElement(re);
        this.getParentReportFrame().addUndoOperation(new InsertElementOperation(this.getParentReportFrame(), this.getCrosstabElement(), re));
        this.setSelectedElement(re);
        this.repaint();
        return re;
    }

    public boolean isDefaultCellMode() {
        return this.defaultCellMode;
    }

    public void setDefaultCellMode(boolean defaultCellMode) {
        this.defaultCellMode = defaultCellMode;
        if (defaultCellMode) {
            CrosstabCell noDataCell = this.getWhenNoDataCell();
            noDataCell.setPaintSelection(false);
            CellAnimationEffect ae = new CellAnimationEffect();
            ae.setNoDataCell(noDataCell);
            ae.setEditor(this);
            SwingUtilities.invokeLater(ae);
        }
        if (this.getSelectedElements().size() > 0) {
            this.setSelectedElement(null);
        } else {
            this.invalidate();
            this.repaint();
        }
    }

    public CrosstabCell getWhenNoDataCell() {
        for (int i = 0; i < this.getCrosstabElement().getCells().size(); ++i) {
            CrosstabCell cell = (CrosstabCell)this.getCrosstabElement().getCells().elementAt(i);
            if (cell.getType() != 2) continue;
            return cell;
        }
        return null;
    }

    public List getOpenedNodesDocumentStructure() {
        return this.openedNodesDocumentStructure;
    }

    public void setOpenedNodesDocumentStructure(List openedNodesDocumentStructure) {
        this.openedNodesDocumentStructure = openedNodesDocumentStructure;
    }

    private void addFormatItemsToMenu(JComponent m) {
        this.jMenuItemFillCell = new JMenuItem();
        this.jMenuItemFillCell.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_maximise.png")));
        this.jMenuItemFillCell.setText(I18n.getString("fillCell", "Fill the cell"));
        this.jMenuItemFillCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatCommand.getCommand(41).execute();
            }
        });
        m.add(this.jMenuItemFillCell);
        this.jMenuItemFillCellH = new JMenuItem();
        this.jMenuItemFillCellH.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_hmaximise.png")));
        this.jMenuItemFillCellH.setText(I18n.getString("fillCellHorizontally", "Fill the cell (horizontally)"));
        this.jMenuItemFillCellH.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatCommand.getCommand(42).execute();
            }
        });
        m.add(this.jMenuItemFillCellH);
        this.jMenuItemFillCellV = new JMenuItem();
        this.jMenuItemFillCellV.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vmaximise.png")));
        this.jMenuItemFillCellV.setText(I18n.getString("fillCellVertically", "Fill the cell (vertically)"));
        this.jMenuItemFillCellV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FormatCommand.getCommand(43).execute();
            }
        });
        m.add(this.jMenuItemFillCellV);
        this.jMenuAlign = new JMenu();
        this.jMenuAlign.setText(I18n.getString("align", "Align..."));
        this.jMenuItemAlignLeft = new JMenuItem();
        this.jMenuItemAlignLeft.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_left.png")));
        this.jMenuItemAlignLeft.setText(I18n.getString("alignLeft", "Align left"));
        this.jMenuItemAlignLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemAlignLeftActionPerformed(evt);
            }
        });
        this.jMenuAlign.add(this.jMenuItemAlignLeft);
        this.jMenuItemAlignRight = new JMenuItem();
        this.jMenuItemAlignRight.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_right.png")));
        this.jMenuItemAlignRight.setText(I18n.getString("alignRight", "Align right"));
        this.jMenuItemAlignRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemAlignRightActionPerformed(evt);
            }
        });
        this.jMenuAlign.add(this.jMenuItemAlignRight);
        this.jMenuItemAlignTop = new JMenuItem();
        this.jMenuItemAlignTop.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_top.png")));
        this.jMenuItemAlignTop.setText(I18n.getString("alignTop", "Align top"));
        this.jMenuItemAlignTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemAlignTopActionPerformed(evt);
            }
        });
        this.jMenuAlign.add(this.jMenuItemAlignTop);
        this.jMenuItemAlignBottom = new JMenuItem();
        this.jMenuItemAlignBottom.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_bottom.png")));
        this.jMenuItemAlignBottom.setText(I18n.getString("alignBottom", "Align bottom"));
        this.jMenuItemAlignBottom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemAlignBottomActionPerformed(evt);
            }
        });
        this.jMenuAlign.add(this.jMenuItemAlignBottom);
        this.jSeparator19 = new JSeparator();
        this.jMenuAlign.add(this.jSeparator19);
        this.jMenuItemAlignVerticalAxis = new JMenuItem();
        this.jMenuItemAlignVerticalAxis.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_center_axis.png")));
        this.jMenuItemAlignVerticalAxis.setText(I18n.getString("alignVerticalAxis", "Align vertical axis"));
        this.jMenuItemAlignVerticalAxis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemAlignVerticalAxisActionPerformed(evt);
            }
        });
        this.jMenuAlign.add(this.jMenuItemAlignVerticalAxis);
        this.jMenuItemAlignHorizontalAxis = new JMenuItem();
        this.jMenuItemAlignHorizontalAxis.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vcenter_axis.png")));
        this.jMenuItemAlignHorizontalAxis.setText(I18n.getString("alignHorizontalAxis", "Align horizontal axis"));
        this.jMenuItemAlignHorizontalAxis.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemAlignHorizontalAxisActionPerformed(evt);
            }
        });
        this.jMenuAlign.add(this.jMenuItemAlignHorizontalAxis);
        m.add(this.jMenuAlign);
        this.jMenuSize = new JMenu();
        this.jMenuSize.setText(I18n.getString("size", "Size..."));
        this.jMenuItemSameWidth = new JMenuItem();
        this.jMenuItemSameWidth.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize.png")));
        this.jMenuItemSameWidth.setText(I18n.getString("sameWidth", "Same width"));
        this.jMenuItemSameWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemSameWidthActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSameWidth);
        this.jMenuItemSameWidthMax = new JMenuItem();
        this.jMenuItemSameWidthMax.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_plus.png")));
        this.jMenuItemSameWidthMax.setText(I18n.getString("sameWidthMax", "Same width (max)"));
        this.jMenuItemSameWidthMax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemSameWidthMaxActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSameWidthMax);
        this.jMenuItemSameWidthMin = new JMenuItem();
        this.jMenuItemSameWidthMin.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_min.png")));
        this.jMenuItemSameWidthMin.setText(I18n.getString("sameWidthMin", "Same width (min)"));
        this.jMenuItemSameWidthMin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemSameWidthMinActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSameWidthMin);
        this.jSeparator17 = new JSeparator();
        this.jMenuSize.add(this.jSeparator17);
        this.jMenuItemSameHeight = new JMenuItem();
        this.jMenuItemSameHeight.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize.png")));
        this.jMenuItemSameHeight.setText(I18n.getString("sameHeight", "Same height"));
        this.jMenuItemSameHeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemSameHeightActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSameHeight);
        this.jMenuItemSameHeightMin = new JMenuItem();
        this.jMenuItemSameHeightMin.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_min.png")));
        this.jMenuItemSameHeightMin.setText(I18n.getString("sameHeightMin", "Same height (min)"));
        this.jMenuItemSameHeightMin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemSameHeightMinActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSameHeightMin);
        this.jMenuItemSameHeightMax = new JMenuItem();
        this.jMenuItemSameHeightMax.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_plus.png")));
        this.jMenuItemSameHeightMax.setText(I18n.getString("sameHeightMax", "Same height (max)"));
        this.jMenuItemSameHeightMax.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemSameHeightMaxActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSameHeightMax);
        this.jSeparator18 = new JSeparator();
        this.jMenuSize.add(this.jSeparator18);
        this.jMenuItemSameSize = new JMenuItem();
        this.jMenuItemSameSize.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_size.png")));
        this.jMenuItemSameSize.setText(I18n.getString("sameSize", "Same size"));
        this.jMenuItemSameSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemSameSizeActionPerformed(evt);
            }
        });
        this.jMenuSize.add(this.jMenuItemSameSize);
        m.add(this.jMenuSize);
        this.jMenuPosition = new JMenu();
        this.jMenuPosition.setText(I18n.getString("position", "Position..."));
        this.jMenuItemCenterH = new JMenuItem();
        this.jMenuItemCenterH.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_hcenter.png")));
        this.jMenuItemCenterH.setText(I18n.getString("centerHorizontallyCellBased", "Center horizontally (cell based)"));
        this.jMenuItemCenterH.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemCenterHActionPerformed(evt);
            }
        });
        this.jMenuPosition.add(this.jMenuItemCenterH);
        this.jMenuItemCenterV = new JMenuItem();
        this.jMenuItemCenterV.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vcenter.png")));
        this.jMenuItemCenterV.setText(I18n.getString("centerVerticallyCellBased", "Center vertically (cell based)"));
        this.jMenuItemCenterV.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemCenterVActionPerformed(evt);
            }
        });
        this.jMenuPosition.add(this.jMenuItemCenterV);
        this.jMenuItemCenterInCell = new JMenuItem();
        this.jMenuItemCenterInCell.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_ccenter.png")));
        this.jMenuItemCenterInCell.setText(I18n.getString("centerInCell", "Center in cell"));
        this.jMenuItemCenterInCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemCenterInBandActionPerformed(evt);
            }
        });
        this.jMenuPosition.add(this.jMenuItemCenterInCell);
        this.jMenuItemJoinLeft = new JMenuItem();
        this.jMenuItemJoinLeft.setText(I18n.getString("joinSidesLeft", "Join sides left"));
        this.jMenuItemJoinLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemJoinLeftActionPerformed(evt);
            }
        });
        this.jMenuPosition.add(this.jMenuItemJoinLeft);
        this.jMenuItemJoinRight = new JMenuItem();
        this.jMenuItemJoinRight.setText(I18n.getString("joinSidesRight", "Join sides right"));
        this.jMenuItemJoinRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemJoinRightActionPerformed(evt);
            }
        });
        this.jMenuPosition.add(this.jMenuItemJoinRight);
        m.add(this.jMenuPosition);
        this.jSeparator5 = new JSeparator();
        m.add(this.jSeparator5);
        this.jMenuHSpacing = new JMenu();
        this.jMenuHSpacing.setText(I18n.getString("horizontalSpacing", "Horizontal spacing..."));
        this.jMenuItemHSMakeEqual = new JMenuItem();
        this.jMenuItemHSMakeEqual.setText(I18n.getString("makeEqual", "Make equal"));
        this.jMenuItemHSMakeEqual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemHSMakeEqualActionPerformed(evt);
            }
        });
        this.jMenuHSpacing.add(this.jMenuItemHSMakeEqual);
        this.jMenuItemHSIncrease = new JMenuItem();
        this.jMenuItemHSIncrease.setText(I18n.getString("increase", "Increase"));
        this.jMenuItemHSIncrease.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemHSIncreaseActionPerformed(evt);
            }
        });
        this.jMenuHSpacing.add(this.jMenuItemHSIncrease);
        this.jMenuItemHSDecrease = new JMenuItem();
        this.jMenuItemHSDecrease.setText(I18n.getString("decrease", "Decrease"));
        this.jMenuItemHSDecrease.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemHSDecreaseActionPerformed(evt);
            }
        });
        this.jMenuHSpacing.add(this.jMenuItemHSDecrease);
        this.jMenuItemHSRemove = new JMenuItem();
        this.jMenuItemHSRemove.setText(I18n.getString("remove", "Remove"));
        this.jMenuItemHSRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemHSRemoveActionPerformed(evt);
            }
        });
        this.jMenuHSpacing.add(this.jMenuItemHSRemove);
        m.add(this.jMenuHSpacing);
        this.jMenuVSpacing = new JMenu();
        this.jMenuVSpacing.setText(I18n.getString("verticalSpacing", "Vertical spacing"));
        this.jMenuItemVSMakeEqual = new JMenuItem();
        this.jMenuItemVSMakeEqual.setText(I18n.getString("makeEqual", "Make equal"));
        this.jMenuItemVSMakeEqual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemVSMakeEqualActionPerformed(evt);
            }
        });
        this.jMenuVSpacing.add(this.jMenuItemVSMakeEqual);
        this.jMenuItemVSIncrease = new JMenuItem();
        this.jMenuItemVSIncrease.setText(I18n.getString("increase", "Increase"));
        this.jMenuItemVSIncrease.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemVSIncreaseActionPerformed(evt);
            }
        });
        this.jMenuVSpacing.add(this.jMenuItemVSIncrease);
        this.jMenuItemVSDecrease = new JMenuItem();
        this.jMenuItemVSDecrease.setText(I18n.getString("decrease", "Decrease"));
        this.jMenuItemVSDecrease.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemVSDecreaseActionPerformed(evt);
            }
        });
        this.jMenuVSpacing.add(this.jMenuItemVSDecrease);
        this.jMenuItemVSRemove = new JMenuItem();
        this.jMenuItemVSRemove.setText(I18n.getString("remove", "Remove"));
        this.jMenuItemVSRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemVSRemoveActionPerformed(evt);
            }
        });
        this.jMenuVSpacing.add(this.jMenuItemVSRemove);
        m.add(this.jMenuVSpacing);
        this.jSeparator8 = new JSeparator();
        m.add(this.jSeparator8);
        this.jMenuItemBringToFront = new JMenuItem();
        this.jMenuItemBringToFront.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/sendtofront.png")));
        this.jMenuItemBringToFront.setText(I18n.getString("bringToFront", "Bring to front"));
        this.jMenuItemBringToFront.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemBringToFrontActionPerformed(evt);
            }
        });
        m.add(this.jMenuItemBringToFront);
        this.jMenuItemSendToBack = new JMenuItem();
        this.jMenuItemSendToBack.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/menu/sendtoback.png")));
        this.jMenuItemSendToBack.setText(I18n.getString("sendToBack", "Send to back"));
        this.jMenuItemSendToBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CrosstabEditorPanel.this.getMainFrame().jMenuItemSendToBackActionPerformed(evt);
            }
        });
        m.add(this.jMenuItemSendToBack);
    }

    public JReportFrame getParentReportFrame() {
        if (this.parentReportFrame == null) {
            this.parentReportFrame = this.getMainFrame().getActiveReportFrame();
        }
        return this.parentReportFrame;
    }

    public void setParentReportFrame(JReportFrame parentReportFrame) {
        this.parentReportFrame = parentReportFrame;
    }

    public ReportElement getElementAt(Point location) {
        Point p = new Point(this.getRealDim((int)location.getX() - 10) + 10, this.getRealDim((int)location.getY() - 10) + 10);
        for (int i = this.getCrosstabElement().getElements().size() - 1; i >= 0; --i) {
            ReportElement re = (ReportElement)this.getCrosstabElement().getElements().elementAt(i);
            if (this.isDefaultCellMode() != (re.getCell().getType() == 2) || !re.intersects(p)) continue;
            return re;
        }
        return null;
    }

    public void applyI18n() {
        this.jCheckBoxMenuItemDefaultCellEdit.setText(I18n.getString("crosstabEditorPanel.checkBoxMenuItemDefaultCellEdit", "Edit When-No-Data default cell"));
        this.jCheckBoxMenuItemDefaultCellEdit1.setText(I18n.getString("crosstabEditorPanel.checkBoxMenuItemDefaultCellEdit1", "Edit When-No-Data default cell"));
        this.jMenuItemCellProperties.setText(I18n.getString("crosstabEditorPanel.menuItemCellProperties", "Cell properties"));
        this.jMenuItemCellProperties1.setText(I18n.getString("crosstabEditorPanel.menuItemCellProperties1", "Cell properties"));
        this.jMenuItemCopy.setText(I18n.getString("crosstabEditorPanel.menuItemCopy", "Copy"));
        this.jMenuItemCrosstabProperties.setText(I18n.getString("crosstabEditorPanel.menuItemCrosstabProperties", "Crosstab properties"));
        this.jMenuItemCrosstabProperties1.setText(I18n.getString("crosstabEditorPanel.menuItemCrosstabProperties1", "Crosstab properties"));
        this.jMenuItemCut.setText(I18n.getString("crosstabEditorPanel.menuItemCut", "Cut"));
        this.jMenuItemDelete.setText(I18n.getString("crosstabEditorPanel.menuItemDelete", "Delete"));
        this.jMenuItemPaste.setText(I18n.getString("crosstabEditorPanel.menuItemPaste", "Paste"));
        this.jMenuItemPaste1.setText(I18n.getString("crosstabEditorPanel.menuItemPaste1", "Paste"));
        this.jMenuItemPattern.setText(I18n.getString("crosstabEditorPanel.menuItemPattern", "Field pattern"));
    }
}

