/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;

public class CellPropertiesDialog
extends JDialog
implements LanguageChangedListener {
    private JComboBox cbFormats;
    private JTextField foreColor;
    private JTextField backColor;
    private JTextField solveOrder;
    private JLabel lblSolve = new JLabel(I18n.getString("label.solveOrder"));
    private JLabel lblBack = new JLabel(I18n.getString("label.backColor"));
    private JLabel lblFore = new JLabel(I18n.getString("label.foreColor"));
    private JLabel lblFormat = new JLabel(I18n.getString("label.formatString"));
    private JButton jb;

    public CellPropertiesDialog(JDialog owner) {
        super((Frame)null, I18n.getString("frame.cellProperties"), true);
        JPanel jp = new JPanel(new GridLayout(4, 2));
        jp.add(this.lblSolve);
        this.solveOrder = new JTextField();
        jp.add(this.solveOrder);
        jp.add(this.lblBack);
        this.backColor = new JTextField();
        jp.add(this.backColor);
        jp.add(this.lblFore);
        this.foreColor = new JTextField();
        jp.add(this.foreColor);
        String[] formats = new String[]{"", "#,#", "#,#.00", "#,#.00", "Standard", "Currency", "Short Date", "Short Time", "Percent"};
        this.cbFormats = new JComboBox<String>(formats);
        this.cbFormats.setMaximumSize(this.cbFormats.getPreferredSize());
        this.cbFormats.setEditable(true);
        this.cbFormats.setRequestFocusEnabled(false);
        this.cbFormats.setBackground(Color.white);
        jp.add(this.lblFormat);
        jp.add(this.cbFormats);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jp, "Center");
        this.jb = new JButton(I18n.getString("btn.ok"));
        this.jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellPropertiesDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.jb, "South");
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(sd.width / 2 - 125, sd.height / 2 - 60);
        this.setResizable(false);
        this.setSize(350, 160);
        this.setVisible(true);
    }

    public String getFormat() {
        StringBuffer format = new StringBuffer("");
        if (!this.solveOrder.getText().trim().equals("")) {
            format.append("SOLVE_ORDER='" + this.solveOrder.getText().trim() + "'");
        }
        if (!this.backColor.getText().trim().equals("")) {
            if (format.length() > 0) {
                format.append(", ");
            }
            format.append("BACK_COLOR='" + this.backColor.getText().trim() + "'");
        }
        if (!this.foreColor.getText().trim().equals("")) {
            if (format.length() > 0) {
                format.append(", ");
            }
            format.append("FORE_COLOR='" + this.foreColor.getText().trim() + "'");
        }
        if (!this.cbFormats.getSelectedItem().toString().trim().equals("")) {
            if (format.length() > 0) {
                format.append(", ");
            }
            format.append("FORMAT_STRING='" + this.cbFormats.getSelectedItem() + "'");
        }
        return format.toString();
    }

    public static void main(String[] args) {
        CellPropertiesDialog testDialog = new CellPropertiesDialog(null);
        System.out.println(testDialog.getFormat());
        testDialog.dispose();
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.lblSolve.setText(I18n.getString("label.solveOrder"));
        this.lblBack.setText(I18n.getString("label.backColor"));
        this.lblFore.setText(I18n.getString("label.foreColor"));
        this.lblFormat = new JLabel(I18n.getString("label.formatString"));
        this.jb.setText(I18n.getString("btn.ok"));
    }
}

