/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import rex.bidirectional.AxisEmpty;
import rex.graphics.TreeElement;
import rex.graphics.dimensiontree.DimensionTree;
import rex.graphics.dimensiontree.DimensionTreeModel;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderTree;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTAxisNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgEnumNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgSetNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgStringNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTFunctionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNode;
import rex.metadata.Query;
import rex.metadata.resultelements.Member;

public class OrderFunction {
    private JTree bTree;
    private DefaultTreeModel builderTreeModel;
    private DefaultMutableTreeNode builderRoot;
    private JTree dimTree;
    private DimensionTreeModel dimensionTreeModel;
    private DimensionTree dimensionTree;
    private MdxBuilderTree builderTree;
    private Query query;
    private MBTNode[] children;
    private DefaultMutableTreeNode withTreeNode;
    private DefaultMutableTreeNode colTreeNode;
    private DefaultMutableTreeNode rowTreeNode;
    private DefaultMutableTreeNode pageTreeNode;
    private DefaultMutableTreeNode whereTreeNode;
    private String[] columnsOnSelect;
    private String[] rowsOnSelect;
    private String[] measuresOnSelect;
    private String[] columns;
    private String[] rows;
    private String[] slicer;
    private String memberToSort;
    private String sortType;
    private MBTArgSetNode setNode;
    private MBTArgStringNode sortNode;
    private MBTArgEnumNode sortTypeNode;

    public OrderFunction(DimensionTree dimensionTree, MdxBuilderTree builderTree, Query query) {
        this.dimensionTree = dimensionTree;
        this.builderTree = builderTree;
        this.query = query;
        String mdx = "";
        this.bTree = this.builderTree.getTree();
        this.builderTreeModel = (DefaultTreeModel)this.bTree.getModel();
        this.builderRoot = (DefaultMutableTreeNode)this.builderTreeModel.getRoot();
        this.bTree.repaint();
        this.children = ((MBTNode)this.builderRoot.getUserObject()).getMdxBuilderTreeNodes();
        this.withTreeNode = (DefaultMutableTreeNode)this.builderRoot.getChildAt(0);
        this.colTreeNode = (DefaultMutableTreeNode)this.builderRoot.getChildAt(1);
        this.rowTreeNode = (DefaultMutableTreeNode)this.builderRoot.getChildAt(2);
        this.pageTreeNode = (DefaultMutableTreeNode)this.builderRoot.getChildAt(3);
        this.whereTreeNode = (DefaultMutableTreeNode)this.builderRoot.getChildAt(5);
        this.dimTree = this.dimensionTree.getTree();
        this.dimensionTreeModel = (DimensionTreeModel)this.dimTree.getModel();
    }

    public void removeNode() {
        for (int i = 0; i < this.builderRoot.getChildCount(); ++i) {
            ((DefaultMBTNode)((DefaultMutableTreeNode)this.builderRoot.getChildAt(i)).getUserObject()).removeAllChildrenFromTheTree((DefaultMutableTreeNode)this.builderRoot.getChildAt(i), (DefaultTreeModel)this.bTree.getModel());
            ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(this.builderRoot.getChildAt(i));
        }
    }

    public String[] getColumnsMember() {
        return this.columnsOnSelect;
    }

    public void setColumnsMember(String[] columnsOnSelect) {
        this.columnsOnSelect = columnsOnSelect;
    }

    public String[] getColumnsMemberWOM() {
        return this.columns;
    }

    public void setColumnsMemberWOM(String[] columns) {
        this.columns = columns;
    }

    public String[] getRowsMember() {
        return this.rowsOnSelect;
    }

    public void setRowsMember(String[] rowsOnSelect) {
        this.rowsOnSelect = rowsOnSelect;
    }

    public String[] getRowsMemberWOM() {
        return this.rows;
    }

    public void setRowsMemberWOM(String[] rows) {
        this.rows = rows;
    }

    public String[] getMeasures() {
        return this.measuresOnSelect;
    }

    public void setMeasures(String[] measuresOnSelect) {
        this.measuresOnSelect = measuresOnSelect;
    }

    public void setSlicer(String[] slicer) {
        this.slicer = slicer;
    }

    public String getMemberToSort() {
        if (this.memberToSort == null) {
            return null;
        }
        return this.memberToSort;
    }

    public void setMemberToSort(Member memberToSort) {
        this.memberToSort = memberToSort.getUniqueName();
    }

    public String getSortType() {
        if (this.sortType == null) {
            return null;
        }
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public void addChildrenLevel(LinkedList queryLevels) {
        Iterator it = queryLevels.iterator();
        while (it.hasNext()) {
            TreeElement obj = this.dimensionTreeModel.getTreeElement((String)it.next());
            this.dimensionTreeModel.addChildrenOneLevel(obj);
        }
    }

    private Object getDimensionTreeElement(String uniqueName) {
        DimensionTreeElement obj = this.dimensionTreeModel.getDimensionTreeElement(uniqueName.trim());
        if (obj == null) {
            JOptionPane.showMessageDialog(null, uniqueName + " not found in Dimension Tree");
            return null;
        }
        return obj;
    }

    private void generateSlicerNodefromResult() {
        if (this.slicer != null && this.slicer.length > 0) {
            for (int count = 0; count < this.slicer.length; ++count) {
                this.children[5].handleDrop(this.getDimensionTreeElement(this.slicer[count]), this.whereTreeNode, this.builderTreeModel);
                ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(this.whereTreeNode);
                this.bTree.expandPath(new TreePath(this.whereTreeNode.getPath()));
                this.bTree.repaint();
            }
        }
    }

    public void setAxisEmpty(AxisEmpty axisEmpty) {
        ((DefaultMBTAxisNode)((MBTNode)this.colTreeNode.getUserObject())).setNonEmpty(axisEmpty.isColumnEmpty());
        ((DefaultMBTAxisNode)((MBTNode)this.rowTreeNode.getUserObject())).setNonEmpty(axisEmpty.isRowEmpty());
    }

    private void generateColumnsNodefromResultWOM() {
        for (int count = 0; count < this.columns.length; ++count) {
            this.children[1].handleDrop(this.getDimensionTreeElement(this.columns[count]), this.colTreeNode, this.builderTreeModel);
            ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(this.colTreeNode);
            this.bTree.expandPath(new TreePath(this.colTreeNode.getPath()));
            this.bTree.repaint();
        }
    }

    private void generateRowsNodefromResultWOM() {
        for (int count = 0; count < this.rows.length; ++count) {
            this.children[2].handleDrop(this.dimensionTreeModel.getDimensionTreeElement(this.rows[count]), this.rowTreeNode, this.builderTreeModel);
            ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(this.rowTreeNode);
            this.bTree.expandPath(new TreePath(this.rowTreeNode.getPath()));
            this.bTree.repaint();
        }
    }

    private void generateMeasuresNodefromResult(MBTNode node, DefaultMutableTreeNode tNode) {
        for (int count = 0; count < this.measuresOnSelect.length; ++count) {
            node.handleDrop(this.dimensionTreeModel.getDimensionTreeElement(this.measuresOnSelect[count]), tNode, this.builderTreeModel);
            ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(tNode);
            this.bTree.expandPath(new TreePath(tNode.getPath()));
            this.bTree.repaint();
        }
    }

    private void generateColumnsNodefromResult() {
        this.generateColumnsNodefromResultWOM();
        this.generateMeasuresNodefromResult(this.children[1], this.colTreeNode);
    }

    private void generateRowsNodefromResult() {
        this.generateRowsNodefromResultWOM();
        this.generateMeasuresNodefromResult(this.children[2], this.rowTreeNode);
    }

    public void generateOrderCombination1() {
        this.generateColumnsNodefromResultWOM();
        this.getOrder(this.rowTreeNode, this.rows, this.memberToSort, this.sortType);
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination2() {
        this.generateColumnsNodefromResult();
        this.getOrder(this.rowTreeNode, this.rows, this.memberToSort, this.sortType);
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination3() {
        this.generateMeasuresNodefromResult(this.children[1], this.colTreeNode);
        this.getOrder(this.rowTreeNode, this.rows, this.memberToSort, this.sortType);
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination4() {
        this.generateColumnsNodefromResultWOM();
        this.getOrder(this.rowTreeNode, this.rows, this.measuresOnSelect, this.memberToSort, this.sortType);
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination5() {
        this.generateColumnsNodefromResultWOM();
        this.getOrder(this.rowTreeNode, this.measuresOnSelect, this.memberToSort, this.sortType);
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination6() {
        this.getOrder(this.colTreeNode, this.columns, this.memberToSort, this.sortType);
        this.generateRowsNodefromResultWOM();
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination7() {
        this.getOrder(this.colTreeNode, this.columns, this.measuresOnSelect, this.memberToSort, this.sortType);
        this.generateRowsNodefromResultWOM();
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination8() {
        this.getOrder(this.colTreeNode, this.measuresOnSelect, this.memberToSort, this.sortType);
        this.generateRowsNodefromResultWOM();
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination9() {
        this.getOrder(this.colTreeNode, this.columns, this.memberToSort, this.sortType);
        this.generateRowsNodefromResult();
        this.generateSlicerNodefromResult();
    }

    public void generateOrderCombination10() {
        this.getOrder(this.colTreeNode, this.columns, this.memberToSort, this.sortType);
        this.generateMeasuresNodefromResult(this.children[2], this.rowTreeNode);
        this.generateSlicerNodefromResult();
    }

    private void getOrder(DefaultMutableTreeNode tNode, String[] set, String memberToSort, String sortType) {
        MBTFunctionNode func = new MBTFunctionNode("Order", "Arranges members of a set, optionally preserving or breaking the hierarchy.", "Order(\u00abSet\u00bb, {\u00abString Expression\u00bb | \u00abNumeric Expression\u00bb} [, ASC | DESC | BASC | BDESC])", null);
        DefaultMutableTreeNode funcNode = new DefaultMutableTreeNode(func);
        ((MBTNode)tNode.getUserObject()).addChild(func);
        this.builderTreeModel.insertNodeInto(funcNode, tNode, tNode.getChildCount());
        this.setNode = new MBTArgSetNode("\u00abSet1\u00bb");
        this.sortNode = new MBTArgStringNode("\u00abString Expression\u00bb | \u00abNumeric Expression\u00bb");
        this.sortTypeNode = new MBTArgEnumNode(false, "ASC | DESC | BASC | BDESC", new String[]{"ASC", "DESC", "BASC", "BDESC"}, false, false);
        DefaultMutableTreeNode setTreeNode = new DefaultMutableTreeNode(this.setNode);
        DefaultMutableTreeNode sortTreeNode = new DefaultMutableTreeNode(this.sortNode);
        DefaultMutableTreeNode sortTypeTreeNode = new DefaultMutableTreeNode(this.sortTypeNode);
        func.addChild(this.setNode);
        this.builderTreeModel.insertNodeInto(setTreeNode, funcNode, funcNode.getChildCount());
        func.addChild(this.sortNode);
        this.builderTreeModel.insertNodeInto(sortTreeNode, funcNode, funcNode.getChildCount());
        func.addChild(this.sortTypeNode);
        this.builderTreeModel.insertNodeInto(sortTypeTreeNode, funcNode, funcNode.getChildCount());
        for (int count = 0; count < set.length; ++count) {
            this.setNode.handleDrop(this.dimensionTreeModel.getDimensionTreeElement(set[count]), setTreeNode, this.builderTreeModel);
            ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(setTreeNode);
            this.bTree.expandPath(new TreePath(setTreeNode.getPath()));
            this.bTree.repaint();
        }
        this.sortNode.handleDrop(this.dimensionTreeModel.getDimensionTreeElement(memberToSort), funcNode, this.builderTreeModel);
        this.sortTypeNode.setArgName(sortType);
        ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(funcNode);
        this.bTree.expandPath(new TreePath(funcNode.getPath()));
        this.bTree.repaint();
    }

    private void getOrder(DefaultMutableTreeNode tNode, String[] set, String[] measureSet, String memberToSort, String sortType) {
        int count;
        MBTFunctionNode func = new MBTFunctionNode("Order", "Arranges members of a set, optionally preserving or breaking the hierarchy.", "Order(\u00abSet\u00bb, {\u00abString Expression\u00bb | \u00abNumeric Expression\u00bb} [, ASC | DESC | BASC | BDESC])", null);
        DefaultMutableTreeNode funcNode = new DefaultMutableTreeNode(func);
        ((MBTNode)tNode.getUserObject()).addChild(func);
        this.builderTreeModel.insertNodeInto(funcNode, tNode, tNode.getChildCount());
        this.setNode = new MBTArgSetNode("\u00abSet1\u00bb");
        this.sortNode = new MBTArgStringNode("\u00abString Expression\u00bb | \u00abNumeric Expression\u00bb");
        this.sortTypeNode = new MBTArgEnumNode(false, "ASC | DESC | BASC | BDESC", new String[]{"ASC", "DESC", "BASC", "BDESC"}, false, true);
        DefaultMutableTreeNode setTreeNode = new DefaultMutableTreeNode(this.setNode);
        DefaultMutableTreeNode sortTreeNode = new DefaultMutableTreeNode(this.sortNode);
        DefaultMutableTreeNode sortTypeTreeNode = new DefaultMutableTreeNode(this.sortTypeNode);
        func.addChild(this.setNode);
        this.builderTreeModel.insertNodeInto(setTreeNode, funcNode, funcNode.getChildCount());
        func.addChild(this.sortNode);
        this.builderTreeModel.insertNodeInto(sortTreeNode, funcNode, funcNode.getChildCount());
        func.addChild(this.sortTypeNode);
        this.builderTreeModel.insertNodeInto(sortTypeTreeNode, funcNode, funcNode.getChildCount());
        for (count = 0; count < set.length; ++count) {
            this.setNode.handleDrop(this.dimensionTreeModel.getDimensionTreeElement(set[count]), setTreeNode, this.builderTreeModel);
            ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(setTreeNode);
            this.bTree.expandPath(new TreePath(setTreeNode.getPath()));
            this.bTree.repaint();
        }
        for (count = 0; count < measureSet.length; ++count) {
            this.setNode.handleDrop(this.dimensionTreeModel.getDimensionTreeElement(measureSet[count]), setTreeNode, this.builderTreeModel);
            ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(setTreeNode);
            this.bTree.expandPath(new TreePath(setTreeNode.getPath()));
            this.bTree.repaint();
        }
        this.sortNode.handleDrop(this.dimensionTreeModel.getDimensionTreeElement(memberToSort), funcNode, this.builderTreeModel);
        this.sortTypeNode.setArgName(sortType);
        ((DefaultTreeModel)this.bTree.getModel()).nodeChanged(funcNode);
        this.bTree.expandPath(new TreePath(funcNode.getPath()));
        this.bTree.repaint();
    }
}

