/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.locale;

import com.jaspersoft.babylon.JasperBabylonClient;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.plugin.locale.JasperBabylonRunnerListener;
import java.util.List;
import java.util.Properties;

public class JasperBabylonRunner
implements Runnable {
    public static String IREPORT_APP_ID = "1";
    private JasperBabylonRunnerListener runnerListener;
    private int operation = 0;
    private JasperBabylonClient jbc = new JasperBabylonClient();
    public static final int OP_LIST_LOCALES = 1;
    public static final int OP_GET_LOCALE = 2;
    public static final int OP_PUT_LOCALE = 3;
    private String localeId = null;
    private Properties props = null;

    public void listLocales() {
        this.operation = 1;
        this.jbc.setAppId(IREPORT_APP_ID);
        this.jbc.setJasperBabylonUrl(MainFrame.getMainInstance().getProperties().getProperty("jasperBabylonURL", "http://www.jasperforge.org/jasperbabylon"));
        Thread t = new Thread(this);
        t.start();
    }

    public void getLocale(String localeId) {
        this.operation = 2;
        this.jbc.setAppId(IREPORT_APP_ID);
        this.jbc.setJasperBabylonUrl(MainFrame.getMainInstance().getProperties().getProperty("jasperBabylonURL", "http://www.jasperforge.org/jasperbabylon"));
        this.localeId = localeId;
        Thread t = new Thread(this);
        t.start();
    }

    public void putLocale(String localeId, Properties props) {
        this.operation = 3;
        this.jbc.setAppId(IREPORT_APP_ID);
        this.jbc.setJasperBabylonUrl(MainFrame.getMainInstance().getProperties().getProperty("jasperBabylonURL", "http://www.jasperforge.org/jasperbabylon"));
        this.jbc.setUsername(MainFrame.getMainInstance().getProperties().getProperty("jasperBabylonUsername"));
        this.jbc.setPassword(MainFrame.getMainInstance().getProperties().getProperty("jasperBabylonPassword"));
        this.props = props;
        this.localeId = localeId;
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        try {
            switch (this.operation) {
                case 1: {
                    List list = this.jbc.listLocales();
                    this.getRunnerListener().listLocalesComplete(list);
                    break;
                }
                case 2: {
                    Properties p = this.jbc.getLocale(this.localeId);
                    this.getRunnerListener().getLocaleComplete(p);
                    break;
                }
                case 3: {
                    String s = this.jbc.putLocale(this.localeId, this.props);
                    this.getRunnerListener().putLocaleComplete(s);
                }
            }
        }
        catch (Exception ex) {
            this.getRunnerListener().operationError(this.operation, ex.getMessage());
        }
    }

    public JasperBabylonRunnerListener getRunnerListener() {
        return this.runnerListener;
    }

    public void setRunnerListener(JasperBabylonRunnerListener runnerListener) {
        this.runnerListener = runnerListener;
    }
}

