/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.chart.Dataset;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.crosstab.CrosstabRowGroup;
import it.businesslogic.ireport.crosstab.Measure;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedEvent;
import it.businesslogic.ireport.gui.event.CrosstabLayoutChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class CrosstabReportElement
extends ReportElement {
    private Report report = null;
    private boolean repeatColumnHeaders = true;
    private boolean repeatRowHeaders = true;
    private int columnBreakOffset = 10;
    private Vector crosstabParameters = null;
    private String parametersMapExpression = "";
    private String runDirection = "LTR";
    private boolean useDataset = false;
    private Dataset dataset = null;
    private boolean preSorted = false;
    private Vector measures = null;
    private Vector rowGroups = new Vector();
    private Vector columnGroups = new Vector();
    private Vector elements = new Vector();
    private Vector cells = new Vector();
    public static Image img = null;
    private EventListenerList listenerList = null;

    public String getRunDirection() {
        return this.runDirection;
    }

    public void setRunDirection(String runDirection) {
        this.runDirection = runDirection;
    }

    public CrosstabReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setKey("crosstab");
        this.dataset = new Dataset();
        this.crosstabParameters = new Vector();
        this.measures = new Vector();
        if (img == null) {
            img = Misc.loadBufferedImageFromResources(new Panel(), "it/businesslogic/ireport/icons/crosstabTool1.png");
        }
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        this.zoom_factor = zoom_factor;
        Color ccc = new Color(204, 204, 204, 150);
        g.setColor(ccc);
        Paint paint = g.getPaint();
        g.setPaint(new GradientPaint(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - (y_shift_origin -= 10), ccc, this.getZoomedDim(this.position.x) - (x_shift_origin -= 10) + this.getZoomedDim(this.width), this.getZoomedDim(this.position.x) - x_shift_origin + this.getZoomedDim(this.height), ccc.brighter()));
        g.fillRect(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        g.setPaint(paint);
        this.position.x += 10;
        this.position.y += 10;
        this.drawGraphicsElement(g, zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
    }

    public void drawGraphicsElement(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.drawGraphicsElement(g, "Thin", zoom_factor, x_shift_origin, y_shift_origin);
        boolean correction = false;
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        if (img != null) {
            int imageWidth = img.getWidth(null);
            int imageHeight = img.getHeight(null);
            if (imageWidth < this.width && imageHeight < this.height) {
                Rectangle destination = new Rectangle(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(imageWidth), this.getZoomedDim(imageHeight - 1));
                Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                int elem_height = this.getZoomedDim(this.height);
                elem_height -= this.getZoomedDim(imageHeight);
                int elem_width = this.getZoomedDim(this.width);
                elem_width -= this.getZoomedDim(imageWidth);
                g.drawImage(img, destination.x + 1, destination.y + 1, destination.x + destination.width + 1, destination.y + destination.height + 1, source.x, source.y, source.width, source.height, null, null);
            } else if (this.width > 0 && this.height > 0) {
                if ((double)imageWidth / (double)this.width > (double)imageHeight / (double)this.height) {
                    Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                    Rectangle destination = new Rectangle(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width), this.getZoomedDim(Math.min(imageHeight * this.width / imageWidth, this.height - 1)));
                    int elem_height = this.getZoomedDim(this.height);
                    elem_height -= this.getZoomedDim(Math.min(imageHeight * this.width / imageWidth, this.height));
                    g.drawImage(img, destination.x + 1, destination.y + 1, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, null);
                } else {
                    Rectangle source = new Rectangle(0, 0, imageWidth, imageHeight);
                    Rectangle destination = new Rectangle(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(Math.min(imageWidth * this.height / imageHeight, this.width)), this.getZoomedDim(this.height - 1));
                    int elem_width = this.getZoomedDim(this.width);
                    elem_width -= this.getZoomedDim(Math.min(imageWidth * this.height / imageHeight, this.width));
                    g.drawImage(img, destination.x + 1, destination.y + 1, destination.x + destination.width, destination.y + destination.height, source.x, source.y, source.width, source.height, null, null);
                }
            }
        }
        this.position.x += 10;
        this.position.y += 10;
    }

    public ReportElement cloneMe() {
        CrosstabReportElement newReportElement = new CrosstabReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (!(destination instanceof CrosstabReportElement) || source instanceof CrosstabReportElement) {
            // empty if block
        }
    }

    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public void setRepeatColumnHeaders(boolean repeatColumnHeaders) {
        if (this.repeatColumnHeaders == repeatColumnHeaders) {
            return;
        }
        this.columnBreakOffset = this.columnBreakOffset;
        this.notifyChange();
    }

    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public Vector getCrosstabParameters() {
        return this.crosstabParameters;
    }

    public String getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void setParametersMapExpression(String parametersMapExpression) {
        if (this.parametersMapExpression == null ? parametersMapExpression == null : this.parametersMapExpression.equals(parametersMapExpression)) {
            return;
        }
        this.parametersMapExpression = parametersMapExpression;
        this.notifyChange();
    }

    public void setColumnBreakOffset(int columnBreakOffset) {
        if (this.columnBreakOffset == columnBreakOffset) {
            return;
        }
        this.columnBreakOffset = columnBreakOffset;
        this.notifyChange();
    }

    public void setRepeatRowHeaders(boolean repeatRowHeaders) {
        if (this.repeatRowHeaders == repeatRowHeaders) {
            return;
        }
        this.repeatRowHeaders = repeatRowHeaders;
        this.notifyChange();
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        if (this.dataset == dataset) {
            return;
        }
        this.dataset = dataset;
        this.notifyChange();
    }

    public boolean isUseDataset() {
        return this.useDataset;
    }

    public void setUseDataset(boolean useDataset) {
        if (this.useDataset == useDataset) {
            return;
        }
        this.useDataset = useDataset;
        this.notifyChange();
    }

    public boolean isPreSorted() {
        return this.preSorted;
    }

    public void setPreSorted(boolean preSorted) {
        if (this.preSorted == preSorted) {
            return;
        }
        this.preSorted = preSorted;
        this.notifyChange();
    }

    public Vector getMeasures() {
        return this.measures;
    }

    public void setMeasures(Vector measures) {
        this.measures = measures;
    }

    public Vector getRowGroups() {
        return this.rowGroups;
    }

    public void setRowGroups(Vector rowGroups) {
        this.rowGroups = rowGroups;
    }

    public Vector getColumnGroups() {
        return this.columnGroups;
    }

    public void setColumnGroups(Vector columnGroups) {
        this.columnGroups = columnGroups;
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public Vector getCells() {
        return this.cells;
    }

    public void setCells(Vector cells) {
        this.cells = cells;
    }

    public synchronized void addCrosstabLayoutChangedListener(CrosstabLayoutChangedListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(CrosstabLayoutChangedListener.class, listener);
    }

    public synchronized void removeCrosstabLayoutChangedListener(CrosstabLayoutChangedListener listener) {
        this.listenerList.remove(CrosstabLayoutChangedListener.class, listener);
    }

    public void fireCrosstabLayoutChangedListenerCrosstabLayoutChanged(CrosstabLayoutChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$it$businesslogic$ireport$gui$event$CrosstabLayoutChangedListener == null ? CrosstabReportElement.class$("it.businesslogic.ireport.gui.event.CrosstabLayoutChangedListener") : class$it$businesslogic$ireport$gui$event$CrosstabLayoutChangedListener)) continue;
            ((CrosstabLayoutChangedListener)listeners[i + 1]).crosstabLayoutChanged(event);
        }
    }

    public void fireCrosstabMeasureChangedListenerCrosstabLayoutChanged(CrosstabLayoutChangedEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$it$businesslogic$ireport$gui$event$CrosstabLayoutChangedListener == null ? CrosstabReportElement.class$("it.businesslogic.ireport.gui.event.CrosstabLayoutChangedListener") : class$it$businesslogic$ireport$gui$event$CrosstabLayoutChangedListener)) continue;
            ((CrosstabLayoutChangedListener)listeners[i + 1]).crosstabMeasureChanged(event);
        }
    }

    public void addGroup(CrosstabRowGroup group) {
        CrosstabCell headerCell = new CrosstabCell();
        headerCell.setName(group.getName() + " header");
        headerCell.setType(1);
        headerCell.setWidth(group.getWidth());
        group.setHeaderCell(headerCell);
        CrosstabCell totalHeaderCell = new CrosstabCell();
        totalHeaderCell.setName(group.getName() + " total header");
        totalHeaderCell.setType(1);
        totalHeaderCell.setWidth(group.getWidth());
        if (group.getTotalPosition().equals("None")) {
            totalHeaderCell.setHeight(0);
        } else {
            totalHeaderCell.setHeight(30);
        }
        group.setTotalCell(totalHeaderCell);
        this.getCells().add(group.getHeaderCell());
        this.getCells().add(group.getTotalCell());
        CrosstabCell cell = new CrosstabCell();
        cell.setType(0);
        cell.setParent(this);
        cell.setName(null);
        cell.setRowTotalGroup(group.getName());
        if (group.getTotalPosition().equals("None")) {
            cell.setHeight(0);
        } else {
            cell.setHeight(30);
        }
        this.getCells().add(cell);
        this.getRowGroups().add(group);
        this.fireCrosstabLayoutChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this));
        this.notifyChange();
    }

    public void addGroup(CrosstabColumnGroup group) {
        CrosstabCell headerCell = new CrosstabCell();
        headerCell.setName(group.getName() + " header");
        headerCell.setType(1);
        headerCell.setParent(this);
        headerCell.setHeight(group.getHeight());
        group.setHeaderCell(headerCell);
        CrosstabCell totalHeaderCell = new CrosstabCell();
        totalHeaderCell.setName(group.getName() + " total header");
        totalHeaderCell.setType(1);
        totalHeaderCell.setParent(this);
        totalHeaderCell.setHeight(group.getHeight());
        if (group.getTotalPosition().equals("None")) {
            totalHeaderCell.setWidth(0);
        } else {
            totalHeaderCell.setWidth(30);
        }
        group.setTotalCell(totalHeaderCell);
        this.getCells().add(group.getHeaderCell());
        this.getCells().add(group.getTotalCell());
        CrosstabCell cell = new CrosstabCell();
        cell.setType(0);
        cell.setParent(this);
        cell.setColumnTotalGroup(group.getName());
        if (group.getTotalPosition().equals("None")) {
            cell.setWidth(0);
        } else {
            cell.setWidth(30);
        }
        this.getCells().add(cell);
        this.getColumnGroups().add(group);
        this.fireCrosstabLayoutChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this));
        this.notifyChange();
    }

    public void removeGroups(Collection groups) {
        Iterator i_groups = groups.iterator();
        while (i_groups.hasNext()) {
            CrosstabGroup group = (CrosstabGroup)i_groups.next();
            this.removeCell(group.getHeaderCell());
            this.removeCell(group.getTotalCell());
            for (int i = 0; i < this.getCells().size(); ++i) {
                CrosstabCell cell = (CrosstabCell)this.getCells().elementAt(i);
                if (!cell.getColumnTotalGroup().equals(group.getName()) && !cell.getRowTotalGroup().equals(group.getName())) continue;
                i -= this.removeCell(cell) ? 1 : 0;
            }
            if (group instanceof CrosstabRowGroup) {
                this.getRowGroups().remove(group);
            }
            if (!(group instanceof CrosstabColumnGroup)) continue;
            this.getColumnGroups().remove(group);
        }
        this.fireCrosstabLayoutChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this));
        this.notifyChange();
    }

    public void removeGroup(CrosstabGroup group) {
        if (group == null) {
            return;
        }
        ArrayList<CrosstabGroup> v = new ArrayList<CrosstabGroup>();
        v.add(group);
        this.removeGroups(v);
        this.notifyChange();
    }

    public void addMeasure(Measure measure) {
        this.getMeasures().addElement(measure);
        this.fireCrosstabMeasureChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this));
        this.notifyChange();
    }

    public void measureModified(Measure measure) {
        this.fireCrosstabMeasureChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this));
        this.notifyChange();
    }

    public void removeMeasure(Measure measure) {
        this.getMeasures().removeElement(measure);
        this.fireCrosstabMeasureChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this));
        this.notifyChange();
    }

    public void modifyGroup(String oldGroupName, CrosstabRowGroup group) {
        group.getHeaderCell().setWidth(group.getWidth());
        group.getTotalCell().setWidth(group.getWidth());
        if (!group.isHasHeader()) {
            for (int i = 0; i < this.getElements().size(); ++i) {
                ReportElement re = (ReportElement)this.getElements().elementAt(i);
                if (re.getCell() == group.getHeaderCell()) {
                    i -= this.getElements().remove(re) ? 1 : 0;
                }
                group.getHeaderCell().setBox(new Box());
                group.getHeaderCell().setBackcolor(null);
            }
        }
        if (!group.isHasTotal()) {
            group.getTotalCell().setHeight(0);
        } else if (group.getTotalCell().getHeight() == 0) {
            group.getTotalCell().setHeight(30);
        }
        Iterator i = this.getCells().iterator();
        while (i.hasNext()) {
            CrosstabCell cell = (CrosstabCell)i.next();
            if (!cell.getRowTotalGroup().equals(oldGroupName)) continue;
            cell.setRowTotalGroup(group.getName());
            if (!group.isHasTotal()) {
                cell.setHeight(0);
                for (int t = 0; t < this.getElements().size(); ++t) {
                    ReportElement re = (ReportElement)this.getElements().elementAt(t);
                    if (re.getCell() != cell) continue;
                    t -= this.getElements().remove(re) ? 1 : 0;
                }
                continue;
            }
            if (cell.getHeight() != 0) continue;
            cell.setHeight(30);
        }
        this.fireCrosstabLayoutChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this));
        this.notifyChange();
    }

    public void modifyGroup(String oldGroupName, CrosstabColumnGroup group) {
        group.getHeaderCell().setHeight(group.getHeight());
        group.getTotalCell().setHeight(group.getHeight());
        if (!group.isHasHeader()) {
            for (int i = 0; i < this.getElements().size(); ++i) {
                ReportElement re = (ReportElement)this.getElements().elementAt(i);
                if (re.getCell() == group.getHeaderCell()) {
                    i -= this.getElements().remove(re) ? 1 : 0;
                }
                group.getHeaderCell().setBox(new Box());
                group.getHeaderCell().setBackcolor(null);
            }
        }
        if (!group.isHasTotal()) {
            group.getTotalCell().setWidth(0);
        } else if (group.getTotalCell().getWidth() == 0) {
            group.getTotalCell().setWidth(30);
        }
        Iterator i = this.getCells().iterator();
        while (i.hasNext()) {
            CrosstabCell cell = (CrosstabCell)i.next();
            if (!cell.getColumnTotalGroup().equals(oldGroupName)) continue;
            cell.setColumnTotalGroup(group.getName());
            if (!group.isHasTotal()) {
                cell.setWidth(0);
                for (int t = 0; t < this.getElements().size(); ++t) {
                    ReportElement re = (ReportElement)this.getElements().elementAt(t);
                    if (re.getCell() != cell) continue;
                    t -= this.getElements().remove(re) ? 1 : 0;
                }
                continue;
            }
            if (cell.getWidth() != 0) continue;
            cell.setWidth(30);
        }
        this.fireCrosstabLayoutChangedListenerCrosstabLayoutChanged(new CrosstabLayoutChangedEvent(this, this));
        this.notifyChange();
    }

    private boolean removeCell(CrosstabCell cell) {
        for (int i = 0; i < this.getElements().size(); ++i) {
            ReportElement re = (ReportElement)this.getElements().elementAt(i);
            if (re.getCell() != cell) continue;
            i -= this.getElements().remove(re) ? 1 : 0;
        }
        this.notifyChange();
        return this.getCells().remove(cell);
    }

    public Point trasform(Point delta, int type) {
        Point point = super.trasform(delta, type);
        try {
            if (MainFrame.getMainInstance().getActiveReportFrame() != null) {
                MainFrame.getMainInstance().getActiveReportFrame().getCrosstabEditor(this).getPanelEditor().updateGrid();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return point;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public void notifyChange() {
        if (this.getReport() != null) {
            this.getReport().incrementReportChanges();
        }
    }
}

