/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Collections;
import java.util.List;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberSource;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;

abstract class ArrayMemberSource
implements MemberSource {
    protected final RolapHierarchy hierarchy;
    protected final RolapMember[] members;

    ArrayMemberSource(RolapHierarchy hierarchy, RolapMember[] members) {
        this.hierarchy = hierarchy;
        this.members = members;
    }

    public RolapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public boolean setCache(MemberCache cache) {
        return false;
    }

    public RolapMember[] getMembers() {
        return this.members;
    }

    public int getMemberCount() {
        return this.members.length;
    }

    public List getRootMembers() {
        return Collections.EMPTY_LIST;
    }

    public void getMemberChildren(RolapMember parentMember, List children) {
    }

    public void getMemberChildren(List parentMembers, List children) {
    }

    public RolapMember lookupMember(String[] uniqueNameParts, boolean failIfNotFound) {
        String uniqueName = Util.implode(uniqueNameParts);
        for (int i = 0; i < this.members.length; ++i) {
            RolapMember member = this.members[i];
            if (!member.getUniqueName().equals(uniqueName)) continue;
            return member;
        }
        if (failIfNotFound) {
            throw MondrianResource.instance().MdxCantFindMember.ex(uniqueName);
        }
        return null;
    }
}

