/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;

public class JRReportCompileData
implements Serializable {
    private static final long serialVersionUID = 10200L;
    private Serializable mainDatasetCompileData;
    private Map datasetCompileData = new HashMap();
    private Map crosstabCompileData = new HashMap();

    public void setMainDatasetCompileData(Serializable compileData) {
        this.mainDatasetCompileData = compileData;
    }

    public void setDatasetCompileData(JRDataset dataset, Serializable compileData) {
        if (dataset.isMainDataset()) {
            this.setMainDatasetCompileData(compileData);
        } else {
            this.datasetCompileData.put(dataset.getName(), compileData);
        }
    }

    public void setCrosstabCompileData(int crosstabId, Serializable compileData) {
        this.crosstabCompileData.put(new Integer(crosstabId), compileData);
    }

    public Serializable getMainDatasetCompileData() {
        return this.mainDatasetCompileData;
    }

    public Serializable getDatasetCompileData(JRDataset dataset) throws JRException {
        Serializable compileData;
        if (dataset.isMainDataset()) {
            compileData = this.getMainDatasetCompileData();
        } else {
            compileData = (Serializable)this.datasetCompileData.get(dataset.getName());
            if (compileData == null) {
                throw new JRException("Compile data for dataset " + dataset.getName() + " not found in the report.");
            }
        }
        return compileData;
    }

    public Serializable getCrosstabCompileData(JRCrosstab crosstab) throws JRException {
        Serializable compileData = (Serializable)this.crosstabCompileData.get(new Integer(crosstab.getId()));
        if (compileData == null) {
            throw new JRException("Compile data for crosstab not found in the report.");
        }
        return compileData;
    }
}

