/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.hsqldb.Database;
import org.hsqldb.HsqlProperties;
import org.hsqldb.ServerConnection;
import org.hsqldb.Trace;
import org.hsqldb.jdbcSystem;

public class Server {
    static final int CONNECTION_CLOSED = 0;
    Vector serverConnList = new Vector(16);
    Database mDatabase;
    HsqlProperties serverProperties;
    protected ServerSocket socket;
    protected Thread thread;
    protected boolean traceMessages;
    private boolean restartOnShutdown;
    private boolean noSystemExit;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0 && (object = stringArray[0]) != null && ((String)object).startsWith("-?")) {
            Server.printHelp();
            return;
        }
        object = HsqlProperties.argArrayToProps(stringArray, "server");
        Server server = new Server();
        server.setProperties((HsqlProperties)object);
        server.run();
    }

    void setProperties(HsqlProperties hsqlProperties) {
        this.serverProperties = new HsqlProperties("server");
        try {
            this.serverProperties.load();
        }
        catch (Exception exception) {
            Trace.printSystemOut("server.properties not found, using command line or default properties");
        }
        this.serverProperties.addProperties(hsqlProperties);
        this.serverProperties.setPropertyIfNotExists("server.database", "test");
        this.serverProperties.setPropertyIfNotExists("server.port", String.valueOf(9001));
        if (this.serverProperties.isPropertyTrue("server.trace")) {
            jdbcSystem.setLogToSystem(true);
        }
        this.traceMessages = !this.serverProperties.isPropertyTrue("server.silent", true);
        this.noSystemExit = this.serverProperties.isPropertyTrue("server.no_system_exit");
        this.restartOnShutdown = this.serverProperties.isPropertyTrue("server.restart_on_shutdown");
    }

    void openDB() throws SQLException {
        String string = this.serverProperties.getProperty("server.database");
        this.mDatabase = new Database(string);
    }

    private void run() {
        Object object;
        try {
            int n = this.serverProperties.getIntegerProperty("server.port", 9001);
            object = this.serverProperties.getProperty("server.database");
            Trace.printSystemOut("Opening database: " + (String)object);
            this.printTraceMessages();
            this.openDB();
            this.socket = new ServerSocket(n);
            Trace.printSystemOut(new Date(System.currentTimeMillis()) + " Listening for connections ...");
        }
        catch (Exception exception) {
            this.traceError("Server.run/init: " + exception);
            exception.printStackTrace();
            return;
        }
        try {
            while (true) {
                Socket socket = this.socket.accept();
                object = new ServerConnection(socket, this);
                this.thread = new Thread((Runnable)object);
                this.thread.start();
            }
        }
        catch (IOException iOException) {
            if (this.mDatabase != null) {
                this.traceError("Server.run/loop: " + iOException.getMessage());
                iOException.printStackTrace();
            } else {
                this.trace("");
            }
            return;
        }
    }

    static void printHelp() {
        Trace.printSystemOut("Usage: java Server [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display JDBC trace messages\n    -no_system_exit <true/false>  do not issue System.exit()\nThe command line arguments override the values in the server.properties file.");
    }

    void printTraceMessages() {
        this.trace("server.port    =" + this.serverProperties.getProperty("server.port"));
        this.trace("server.database=" + this.serverProperties.getProperty("server.database"));
        this.trace("server.silent  =" + this.serverProperties.getProperty("server.silent"));
        Trace.printSystemOut("HSQLDB server 1.7.1 is running");
        Trace.printSystemOut("Use SHUTDOWN to close normally. Use [Ctrl]+[C] to abort abruptly");
    }

    void trace(String string) {
        if (this.traceMessages) {
            Trace.printSystemOut(string);
        }
    }

    void traceError(String string) {
        Trace.printSystemOut(string);
    }

    void closeAllServerConnections() {
        int n = this.serverConnList.size() - 1;
        while (n >= 0) {
            ServerConnection serverConnection = (ServerConnection)this.serverConnList.elementAt(n);
            serverConnection.close();
            --n;
        }
        this.serverConnList.removeAllElements();
    }

    void notify(int n) {
        if (this.mDatabase == null) {
            return;
        }
        if (!this.mDatabase.isShutdown()) {
            return;
        }
        this.mDatabase = null;
        this.closeAllServerConnections();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            this.traceError("Exception when closing the main socket");
        }
        this.serverProperties = null;
        this.socket = null;
        this.thread = null;
        if (!this.noSystemExit) {
            Trace.printSystemOut(new Date(System.currentTimeMillis()) + " SHUTDOWN : System.exit() is called next");
            System.exit(0);
        }
        Trace.printSystemOut(new Date(System.currentTimeMillis()) + " SHUTDOWN : System.exit() was not called");
    }
}

