/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.DeprecationException;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyResourceLoader;
import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyClassLoader
extends URLClassLoader {
    protected Map classCache = new HashMap();
    protected Map sourceCache = new HashMap();
    private CompilerConfiguration config;
    private Boolean recompile = null;
    private static int scriptNameCounter = 1000000;
    private GroovyResourceLoader resourceLoader = new GroovyResourceLoader(){

        public URL loadGroovySource(final String filename) throws MalformedURLException {
            URL file = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return GroovyClassLoader.this.getSourceFile(filename);
                }
            });
            return file;
        }
    };

    public GroovyClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GroovyClassLoader(ClassLoader loader) {
        this(loader, null);
    }

    public GroovyClassLoader(GroovyClassLoader parent) {
        this(parent, parent.config, false);
    }

    public GroovyClassLoader(ClassLoader parent, CompilerConfiguration config, boolean useConfigurationClasspath) {
        super(new URL[0], parent);
        if (config == null) {
            config = CompilerConfiguration.DEFAULT;
        }
        this.config = config;
        if (useConfigurationClasspath) {
            Iterator it = config.getClasspath().iterator();
            while (it.hasNext()) {
                String path = (String)it.next();
                this.addClasspath(path);
            }
        }
    }

    public GroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        this(loader, config, true);
    }

    public void setResourceLoader(GroovyResourceLoader resourceLoader) {
        if (resourceLoader == null) {
            throw new IllegalArgumentException("Resource loader must not be null!");
        }
        this.resourceLoader = resourceLoader;
    }

    public GroovyResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public Class defineClass(ClassNode classNode, String file) {
        throw new DeprecationException("the method GroovyClassLoader#defineClass(ClassNode, String) is no longer used and removed");
    }

    public Class defineClass(ClassNode classNode, String file, String newCodeBase) {
        CodeSource codeSource = null;
        try {
            codeSource = new CodeSource(new URL("file", "", newCodeBase), (Certificate[])null);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        CompilationUnit unit = this.createCompilationUnit(this.config, codeSource);
        ClassCollector collector = this.createCollector(unit, classNode.getModule().getContext());
        try {
            unit.addClassNode(classNode);
            unit.setClassgenCallback(collector);
            unit.compile(7);
            return collector.generatedClass;
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public Class parseClass(File file) throws CompilationFailedException, IOException {
        return this.parseClass(new GroovyCodeSource(file));
    }

    public Class parseClass(String text, String fileName) throws CompilationFailedException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), fileName);
    }

    public Class parseClass(String text) throws CompilationFailedException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(InputStream in) throws CompilationFailedException {
        return this.parseClass(in, this.generateScriptName());
    }

    public synchronized String generateScriptName() {
        return "script" + ++scriptNameCounter + ".groovy";
    }

    public Class parseClass(final InputStream in, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/script");
            }
        });
        return this.parseClass(gcs);
    }

    public Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException {
        return this.parseClass(codeSource, codeSource.isCachable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class parseClass(GroovyCodeSource codeSource, boolean shouldCacheSource) throws CompilationFailedException {
        Map map = this.classCache;
        synchronized (map) {
            Class answer = (Class)this.sourceCache.get(codeSource.getName());
            if (answer != null) {
                return answer;
            }
            try {
                CompilationUnit unit = this.createCompilationUnit(this.config, codeSource.getCodeSource());
                SourceUnit su = null;
                su = codeSource.getFile() == null ? unit.addSource(codeSource.getName(), codeSource.getInputStream()) : unit.addSource(codeSource.getFile());
                ClassCollector collector = this.createCollector(unit, su);
                unit.setClassgenCallback(collector);
                int goalPhase = 7;
                if (this.config != null && this.config.getTargetDirectory() != null) {
                    goalPhase = 8;
                }
                unit.compile(goalPhase);
                answer = collector.generatedClass;
                Iterator iter = collector.getLoadedClasses().iterator();
                while (iter.hasNext()) {
                    Class clazz = (Class)iter.next();
                    this.setClassCacheEntry(clazz);
                }
                if (shouldCacheSource) {
                    this.sourceCache.put(codeSource.getName(), answer);
                }
            }
            finally {
                try {
                    InputStream is = codeSource.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    throw new GroovyRuntimeException("unable to close stream", e);
                }
            }
            return answer;
        }
    }

    protected String[] getClassPath() {
        URL[] urls = this.getURLs();
        String[] ret = new String[urls.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = urls[i].getFile();
        }
        return ret;
    }

    protected void expandClassPath(List pathList, String base, String classpath, boolean isManifestClasspath) {
        throw new DeprecationException("the method groovy.lang.GroovyClassLoader#expandClassPath(List,String,String,boolean) is no longer used internally and removed");
    }

    protected Class defineClass(String name, byte[] bytecode, ProtectionDomain domain) {
        throw new DeprecationException("the method groovy.lang.GroovyClassLoader#defineClass(String,byte[],ProtectionDomain) is no longer used internally and removed");
    }

    protected CompilationUnit createCompilationUnit(CompilerConfiguration config, CodeSource source) {
        return new CompilationUnit(config, source, this);
    }

    protected ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
        InnerLoader loader = (InnerLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new InnerLoader(GroovyClassLoader.this);
            }
        });
        return new ClassCollector(loader, unit, su);
    }

    public Class defineClass(String name, byte[] b) {
        return super.defineClass(name, b, 0, b.length);
    }

    public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript) throws ClassNotFoundException, CompilationFailedException {
        return this.loadClass(name, lookupScriptFiles, preferClassOverScript, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getClassCacheEntry(String name) {
        if (name == null) {
            return null;
        }
        Map map = this.classCache;
        synchronized (map) {
            Class cls = (Class)this.classCache.get(name);
            return cls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClassCacheEntry(Class cls) {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.put(cls.getName(), cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeClassCacheEntry(String name) {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.remove(name);
        }
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    protected boolean isRecompilable(Class cls) {
        if (cls == null) {
            return true;
        }
        if (this.recompile == null && !this.config.getRecompileGroovySource()) {
            return false;
        }
        if (this.recompile != null && !this.recompile.booleanValue()) {
            return false;
        }
        if (!GroovyObject.class.isAssignableFrom(cls)) {
            return false;
        }
        long timestamp = this.getTimeStamp(cls);
        return timestamp != Long.MAX_VALUE;
    }

    public void setShouldRecompile(Boolean mode) {
        this.recompile = mode;
    }

    public Boolean isShouldRecompile() {
        return this.recompile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript, boolean resolve) throws ClassNotFoundException, CompilationFailedException {
        String className;
        int i;
        Class cls = this.getClassCacheEntry(name);
        boolean recompile = this.isRecompilable(cls);
        if (!recompile) {
            return cls;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (i = (className = name.replace('/', '.')).lastIndexOf(46)) != -1) {
            sm.checkPackageAccess(className.substring(0, i));
        }
        ClassNotFoundException last = null;
        try {
            Class<?> parentClassLoaderClass = super.loadClass(name, resolve);
            if (cls != parentClassLoaderClass) {
                return parentClassLoaderClass;
            }
        }
        catch (ClassNotFoundException cnfe) {
            last = cnfe;
        }
        catch (NoClassDefFoundError ncdfe) {
            if (ncdfe.getMessage().indexOf("wrong name") <= 0) {
                throw ncdfe;
            }
            last = new ClassNotFoundException(name);
        }
        if (cls != null && (preferClassOverScript |= !recompile)) {
            return cls;
        }
        if (lookupScriptFiles) {
            Map map = this.classCache;
            synchronized (map) {
                try {
                    if (this.getClassCacheEntry(name) != cls) {
                        Class clazz = this.getClassCacheEntry(name);
                        return clazz;
                    }
                    URL source = this.resourceLoader.loadGroovySource(name);
                    cls = this.recompile(source, name, cls);
                }
                catch (IOException ioe) {
                    last = new ClassNotFoundException("IOException while openening groovy source: " + name, ioe);
                }
                finally {
                    if (cls == null) {
                        this.removeClassCacheEntry(name);
                    } else {
                        this.setClassCacheEntry(cls);
                    }
                }
            }
        }
        if (cls != null) {
            return cls;
        }
        if (last == null) {
            throw new AssertionError(true);
        }
        throw last;
    }

    protected Class recompile(URL source, String className, Class oldClass) throws CompilationFailedException, IOException {
        if (source != null && (oldClass != null && this.isSourceNewer(source, oldClass) || oldClass == null)) {
            this.sourceCache.remove(className);
            return this.parseClass(source.openStream(), className);
        }
        return oldClass;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, true, false, resolve);
    }

    protected long getTimeStamp(Class cls) {
        Long o;
        try {
            Field field = cls.getField("__timeStamp");
            o = (Long)field.get(null);
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
        return o;
    }

    private URL getSourceFile(String name) {
        String filename = name.replace('.', '/') + this.config.getDefaultScriptExtension();
        URL ret = this.getResource(filename);
        if (ret != null && ret.getProtocol().equals("file")) {
            File file;
            File path;
            String fileWithoutPackage = filename;
            if (fileWithoutPackage.indexOf(47) != -1) {
                int index = fileWithoutPackage.lastIndexOf(47);
                fileWithoutPackage = fileWithoutPackage.substring(index + 1);
            }
            if ((path = new File(ret.getFile()).getParentFile()).exists() && path.isDirectory() && (file = new File(path, fileWithoutPackage)).exists()) {
                File parent = file.getParentFile();
                String[] files = parent.list();
                for (int j = 0; j < files.length; ++j) {
                    if (!files[j].equals(fileWithoutPackage)) continue;
                    return ret;
                }
            }
            return null;
        }
        return ret;
    }

    protected boolean isSourceNewer(URL source, Class cls) throws IOException {
        long lastMod;
        if (source.getProtocol().equals("file")) {
            String path = source.getPath().replace('/', File.separatorChar).replace('|', ':');
            File file = new File(path);
            lastMod = file.lastModified();
        } else {
            lastMod = source.openConnection().getLastModified();
        }
        long classTime = this.getTimeStamp(cls);
        return classTime + (long)this.config.getMinimumRecompilationInterval() < lastMod;
    }

    public void addClasspath(final String path) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    File f = new File(path);
                    URL newURL = f.toURI().toURL();
                    URL[] urls = GroovyClassLoader.this.getURLs();
                    for (int i = 0; i < urls.length; ++i) {
                        if (!urls[i].equals(newURL)) continue;
                        return null;
                    }
                    GroovyClassLoader.this.addURL(newURL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getLoadedClasses() {
        Map map = this.classCache;
        synchronized (map) {
            return this.classCache.values().toArray(new Class[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map map = this.classCache;
        synchronized (map) {
            this.classCache.clear();
        }
    }

    public static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        private Class generatedClass;
        private GroovyClassLoader cl;
        private SourceUnit su;
        private CompilationUnit unit;
        private Collection loadedClasses = null;

        protected ClassCollector(InnerLoader cl, CompilationUnit unit, SourceUnit su) {
            this.cl = cl;
            this.unit = unit;
            this.loadedClasses = new ArrayList();
            this.su = su;
        }

        protected GroovyClassLoader getDefiningClassLoader() {
            return this.cl;
        }

        protected Class createClass(byte[] code, ClassNode classNode) {
            GroovyClassLoader cl = this.getDefiningClassLoader();
            Class theClass = cl.defineClass(classNode.getName(), code, 0, code.length, this.unit.getAST().getCodeSource());
            cl.resolveClass(theClass);
            this.loadedClasses.add(theClass);
            if (this.generatedClass == null) {
                ModuleNode mn = classNode.getModule();
                SourceUnit msu = null;
                if (mn != null) {
                    msu = mn.getContext();
                }
                ClassNode main = null;
                if (mn != null) {
                    main = (ClassNode)mn.getClasses().get(0);
                }
                if (msu == this.su && main == classNode) {
                    this.generatedClass = theClass;
                }
            }
            return theClass;
        }

        protected Class onClassNode(ClassWriter classWriter, ClassNode classNode) {
            byte[] code = classWriter.toByteArray();
            return this.createClass(code, classNode);
        }

        public void call(ClassVisitor classWriter, ClassNode classNode) {
            this.onClassNode((ClassWriter)classWriter, classNode);
        }

        public Collection getLoadedClasses() {
            return this.loadedClasses;
        }
    }

    public static class InnerLoader
    extends GroovyClassLoader {
        private GroovyClassLoader delegate;

        public InnerLoader(GroovyClassLoader delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public void addClasspath(String path) {
            this.delegate.addClasspath(path);
        }

        public void clearCache() {
            this.delegate.clearCache();
        }

        public URL findResource(String name) {
            return this.delegate.findResource(name);
        }

        public Enumeration findResources(String name) throws IOException {
            return this.delegate.findResources(name);
        }

        public Class[] getLoadedClasses() {
            return this.delegate.getLoadedClasses();
        }

        public URL getResource(String name) {
            return this.delegate.getResource(name);
        }

        public InputStream getResourceAsStream(String name) {
            return this.delegate.getResourceAsStream(name);
        }

        public GroovyResourceLoader getResourceLoader() {
            return this.delegate.getResourceLoader();
        }

        public URL[] getURLs() {
            return this.delegate.getURLs();
        }

        public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript, boolean resolve) throws ClassNotFoundException, CompilationFailedException {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            return this.delegate.loadClass(name, lookupScriptFiles, preferClassOverScript, resolve);
        }

        public Class parseClass(GroovyCodeSource codeSource, boolean shouldCache) throws CompilationFailedException {
            return this.delegate.parseClass(codeSource, shouldCache);
        }

        public void setResourceLoader(GroovyResourceLoader resourceLoader) {
            this.delegate.setResourceLoader(resourceLoader);
        }

        public void addURL(URL url) {
            this.delegate.addURL(url);
        }
    }
}

