/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRClonePool;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import org.apache.commons.collections.ReferenceMap;

public class JRFillCellContents
extends JRFillElementContainer
implements JRCellContents,
JRCloneable {
    private final Map transformedContentsCache;
    private final Map boxContentsCache;
    private final JRClonePool clonePool;
    private JRFillCellContents original;
    private final JRCellContents parentCell;
    private JRBox box;
    private int height;
    private int width;
    private int x;
    private int y;
    private int verticalSpan;
    private byte verticalPositionType = 1;
    private Map templateFrames;
    private final JRStyle initStyle;

    public JRFillCellContents(JRBaseFiller filler, JRCellContents cell, JRFillObjectFactory factory) {
        super(filler, cell, factory);
        this.parentCell = cell;
        this.box = cell.getBox();
        this.width = cell.getWidth();
        this.height = cell.getHeight();
        this.initStyle = factory.getStyle(this.parentCell.getStyle());
        this.initElements();
        this.initConditionalStyles();
        this.initTemplatesMap();
        this.transformedContentsCache = new ReferenceMap();
        this.boxContentsCache = new HashMap();
        this.clonePool = new JRClonePool(this, true, true);
    }

    private void initTemplatesMap() {
        this.templateFrames = new HashMap();
    }

    protected JRFillCellContents(JRFillCellContents cellContents, JRFillCloneFactory factory) {
        super(cellContents, factory);
        this.parentCell = cellContents.parentCell;
        this.box = cellContents.box;
        this.width = cellContents.width;
        this.height = cellContents.height;
        this.initStyle = cellContents.initStyle;
        this.initElements();
        this.initConditionalStyles();
        this.templateFrames = cellContents.templateFrames;
        this.transformedContentsCache = new ReferenceMap();
        this.boxContentsCache = new HashMap();
        this.clonePool = new JRClonePool(this, true, true);
        this.verticalPositionType = cellContents.verticalPositionType;
    }

    public Color getBackcolor() {
        return this.parentCell.getBackcolor();
    }

    public JRBox getBox() {
        return this.box;
    }

    protected void setBox(JRBox box) {
        this.box = box;
        this.initTemplatesMap();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public JRFillCellContents getBoxContents(boolean left, boolean right, boolean top) {
        boolean copyTop;
        if (this.box == null) {
            return this;
        }
        boolean copyLeft = left && this.box.getLeftBorder() == 0 && this.box.getRightBorder() != 0;
        boolean copyRight = right && this.box.getRightBorder() == 0 && this.box.getLeftBorder() != 0;
        boolean bl = copyTop = top && this.box.getTopBorder() == 0 && this.box.getBottomBorder() != 0;
        if (!(copyLeft || copyRight || copyTop)) {
            return this;
        }
        BoxContents key = new BoxContents(copyLeft, copyRight, copyTop);
        JRFillCellContents boxContents = (JRFillCellContents)this.boxContentsCache.get(key);
        if (boxContents == null) {
            boxContents = (JRFillCellContents)this.createClone();
            JRBaseBox newBox = new JRBaseBox(this.box);
            if (copyLeft) {
                newBox.setLeftBorder(this.box.getRightBorder());
                newBox.setLeftBorderColor(this.box.getRightBorderColor());
            }
            if (copyRight) {
                newBox.setRightBorder(this.box.getLeftBorder());
                newBox.setRightBorderColor(this.box.getLeftBorderColor());
            }
            if (copyTop) {
                newBox.setTopBorder(this.box.getBottomBorder());
                newBox.setTopBorderColor(this.box.getBottomBorderColor());
            }
            boxContents.setBox(newBox);
            this.boxContentsCache.put(key, boxContents);
        }
        return boxContents;
    }

    public JRFillCellContents getTransformedContents(int newWidth, int newHeight, byte xPosition, byte yPosition) throws JRException {
        if (this.getHeight() == newHeight && this.getWidth() == newWidth) {
            return this;
        }
        if (newHeight < this.getHeight() || newWidth < this.getWidth()) {
            throw new JRException("Cannot shrink cell contents.");
        }
        StretchedContents key = new StretchedContents(newWidth, newHeight, xPosition, yPosition);
        JRFillCellContents transformedCell = (JRFillCellContents)this.transformedContentsCache.get(key);
        if (transformedCell == null) {
            transformedCell = (JRFillCellContents)this.createClone();
            transformedCell.transform(newWidth, newHeight, xPosition, yPosition);
            transformedCell.setElementsBandBottomY();
            this.transformedContentsCache.put(key, transformedCell);
        }
        return transformedCell;
    }

    private void transform(int newWidth, int newHeight, byte xPosition, byte yPosition) {
        this.transformElements(newWidth, newHeight, xPosition, yPosition);
        this.width = newWidth;
        this.height = newHeight;
    }

    private void transformElements(int newWidth, int newHeight, byte xPosition, byte yPosition) {
        if (!(this.height != newHeight && yPosition != 1 || this.width != newWidth && xPosition != 1)) {
            return;
        }
        double scaleX = -1.0;
        int offsetX = 0;
        switch (xPosition) {
            case 2: {
                offsetX = (newWidth - this.width) / 2;
                break;
            }
            case 3: {
                offsetX = newWidth - this.width;
                break;
            }
            case 4: {
                scaleX = (double)newWidth / (double)this.width;
            }
        }
        double scaleY = -1.0;
        int offsetY = 0;
        switch (yPosition) {
            case 2: {
                offsetY = (newHeight - this.height) / 2;
                break;
            }
            case 3: {
                offsetY = newHeight - this.height;
                break;
            }
            case 4: {
                scaleY = (double)newHeight / (double)this.height;
            }
        }
        JRFillCellContents.transformElements(this.getElements(), scaleX, offsetX, scaleY, offsetY);
    }

    private static void transformElements(JRElement[] elements, double scaleX, int offsetX, double scaleY, int offsetY) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                JRFillElement element = (JRFillElement)elements[i];
                if (scaleX != -1.0) {
                    element.setX((int)((double)element.getX() * scaleX));
                    element.setWidth((int)((double)element.getWidth() * scaleX));
                }
                if (offsetX != 0) {
                    element.setX(element.getX() + offsetX);
                }
                if (scaleY != -1.0) {
                    element.setY((int)((double)element.getY() * scaleY));
                    element.setHeight((int)((double)element.getHeight() * scaleY));
                }
                if (offsetY != 0) {
                    element.setY(element.getY() + offsetY);
                }
                if (!(element instanceof JRFrame)) continue;
                JRElement[] frameElements = ((JRFrame)((Object)element)).getElements();
                JRFillCellContents.transformElements(frameElements, scaleX, offsetX, scaleY, offsetY);
            }
        }
    }

    protected void prepare(int availableStretchHeight) throws JRException {
        this.initFill();
        this.resetElements();
        this.prepareElements(availableStretchHeight, true);
    }

    protected JRPrintFrame fill() throws JRException {
        this.stretchElements();
        this.moveBandBottomElements();
        this.removeBlankElements();
        JRTemplatePrintFrame printCell = new JRTemplatePrintFrame(this.getTemplateFrame());
        printCell.setX(this.x);
        printCell.setY(this.y);
        printCell.setWidth(this.width);
        this.fillElements(printCell);
        this.verticallyPositionElements(printCell);
        printCell.setHeight(this.getPrintHeight());
        return printCell;
    }

    private JRTemplateFrame getTemplateFrame() {
        JRStyle style = this.getStyle();
        JRTemplateFrame template = (JRTemplateFrame)this.templateFrames.get(style);
        if (template == null) {
            template = new JRTemplateFrame(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.templateFrames.put(style, template);
        }
        return template;
    }

    protected void verticallyPositionElements(JRTemplatePrintFrame printCell) {
        int positionOffset;
        switch (this.verticalPositionType) {
            case 2: {
                positionOffset = (this.getStretchHeight() - this.getContainerHeight()) / 2;
                break;
            }
            case 3: {
                positionOffset = this.getStretchHeight() - this.getContainerHeight();
                break;
            }
            default: {
                positionOffset = 0;
            }
        }
        if (positionOffset != 0) {
            JRPrintElement element;
            List printElements = printCell.getElements();
            int positionY = this.getStretchHeight() - positionOffset;
            boolean outside = false;
            Iterator it = printElements.iterator();
            while (!outside && it.hasNext()) {
                element = (JRPrintElement)it.next();
                outside = element.getY() > positionY;
            }
            if (!outside) {
                it = printElements.iterator();
                while (it.hasNext()) {
                    element = (JRPrintElement)it.next();
                    element.setY(element.getY() + positionOffset);
                }
            }
        }
    }

    protected int getPrintHeight() {
        return this.getStretchHeight() + this.getTopPadding() + this.getBottomPadding();
    }

    protected void stretchTo(int stretchHeight) {
        this.setStretchHeight(stretchHeight - this.getTopPadding() - this.getBottomPadding());
    }

    protected int getContainerHeight() {
        return this.getHeight() - this.getTopPadding() - this.getBottomPadding();
    }

    protected int getTopPadding() {
        return this.box == null ? 0 : this.box.getTopPadding();
    }

    protected int getBottomPadding() {
        return this.box == null ? 0 : this.box.getBottomPadding();
    }

    public JRCloneable createClone() {
        JRFillCloneFactory factory = new JRFillCloneFactory();
        return this.createClone(factory);
    }

    public JRCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillCellContents(this, factory);
    }

    public JRFillCellContents getWorkingClone() {
        JRFillCellContents clone = (JRFillCellContents)this.clonePool.getClone();
        clone.original = this;
        return clone;
    }

    public void releaseWorkingClone() {
        this.original.clonePool.releaseClone(this);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getVerticalSpan() {
        return this.verticalSpan;
    }

    public void setVerticalSpan(int span) {
        this.verticalSpan = span;
    }

    public void setVerticalPositionType(byte positionType) {
        this.verticalPositionType = positionType;
    }

    protected void evaluate(byte evaluation) throws JRException {
        super.evaluate(evaluation);
        this.evaluateConditionalStyles(evaluation);
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.parentCell.getDefaultStyleProvider();
    }

    public JRStyle getStyle() {
        JRStyle crtStyle = this.initStyle;
        boolean isUsingDefaultStyle = false;
        if (crtStyle == null) {
            crtStyle = this.filler.getDefaultStyle();
            isUsingDefaultStyle = true;
        }
        JRStyle evalStyle = this.getEvaluatedConditionalStyle(crtStyle);
        if (isUsingDefaultStyle && evalStyle == crtStyle) {
            evalStyle = null;
        }
        return evalStyle;
    }

    protected void initConditionalStyles() {
        super.initConditionalStyles();
        this.collectConditionalStyle(this.initStyle);
    }

    public Byte getMode() {
        return this.parentCell.getMode();
    }

    protected static class StretchedContents {
        final int newHeight;
        final int newWidth;
        final int hashCode;
        final byte xPosition;
        final byte yPosition;

        StretchedContents(int newWidth, int newHeight, byte xPosition, byte yPosition) {
            this.newHeight = newHeight;
            this.newWidth = newWidth;
            this.xPosition = xPosition;
            this.yPosition = yPosition;
            int hash = newHeight;
            hash = 31 * hash + newWidth;
            hash = 31 * hash + xPosition;
            this.hashCode = hash = 31 * hash + yPosition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            StretchedContents s = (StretchedContents)o;
            return s.newHeight == this.newHeight && s.newWidth == this.newWidth && s.xPosition == this.xPosition && s.yPosition == this.yPosition;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class BoxContents {
        final boolean left;
        final boolean right;
        final boolean top;
        final int hashCode;

        public BoxContents(boolean left, boolean right, boolean top) {
            this.left = left;
            this.right = right;
            this.top = top;
            int hash = left ? 1231 : 1237;
            hash = 31 * hash + (right ? 1231 : 1237);
            this.hashCode = hash = 31 * hash + (top ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            BoxContents b = (BoxContents)obj;
            return b.left == this.left && b.right == this.right && b.top == this.top;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

