/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.base.JRBaseDataRange;
import net.sf.jasperreports.charts.base.JRBaseValueDisplay;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

public class JRBaseMeterPlot
extends JRBaseChartPlot
implements JRMeterPlot {
    private static final long serialVersionUID = 10200L;
    protected JRDataRange dataRange = null;
    protected JRValueDisplay valueDisplay = null;
    protected byte shape = (byte)2;
    protected List intervals = new ArrayList();
    protected int meterAngle = 180;
    protected String units = null;
    protected double tickInterval = 10.0;
    protected Color meterBackgroundColor = null;
    protected Color needleColor = null;
    protected Color tickColor = null;

    public JRBaseMeterPlot(JRChartPlot meterPlot, JRChart chart) {
        super(meterPlot, chart);
    }

    public JRBaseMeterPlot(JRMeterPlot meterPlot, JRBaseObjectFactory factory) {
        super((JRChartPlot)meterPlot, factory);
        this.dataRange = new JRBaseDataRange(meterPlot.getDataRange(), factory);
        this.valueDisplay = new JRBaseValueDisplay(meterPlot.getValueDisplay(), factory);
        this.shape = meterPlot.getShape();
        List origIntervals = meterPlot.getIntervals();
        this.intervals.clear();
        if (origIntervals != null) {
            Iterator iter = origIntervals.iterator();
            while (iter.hasNext()) {
                JRMeterInterval interval = (JRMeterInterval)iter.next();
                this.intervals.add(new JRMeterInterval(interval, factory));
            }
        }
        this.meterAngle = meterPlot.getMeterAngle();
        this.units = meterPlot.getUnits();
        this.tickInterval = meterPlot.getTickInterval();
        this.meterBackgroundColor = meterPlot.getMeterBackgroundColor();
        this.needleColor = meterPlot.getNeedleColor();
        this.tickColor = meterPlot.getTickColor();
    }

    public JRDataRange getDataRange() {
        return this.dataRange;
    }

    public JRValueDisplay getValueDisplay() {
        return this.valueDisplay;
    }

    public byte getShape() {
        return this.shape;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public int getMeterAngle() {
        return this.meterAngle;
    }

    public String getUnits() {
        return this.units;
    }

    public double getTickInterval() {
        return this.tickInterval;
    }

    public Color getMeterBackgroundColor() {
        return this.meterBackgroundColor;
    }

    public Color getNeedleColor() {
        return this.needleColor;
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }
}

