/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.Batcher;
import org.hibernate.util.JDBCExceptionReporter;

public class ConnectionManager
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$jdbc$ConnectionManager == null ? (class$org$hibernate$jdbc$ConnectionManager = ConnectionManager.class$("org.hibernate.jdbc.ConnectionManager")) : class$org$hibernate$jdbc$ConnectionManager));
    private transient SessionFactoryImplementor factory;
    private final Callback callback;
    private final ConnectionReleaseMode releaseMode;
    private transient Connection connection;
    private final boolean wasConnectionSupplied;
    private transient boolean shouldObtainConnection;
    private transient Batcher batcher;
    static /* synthetic */ Class class$org$hibernate$jdbc$ConnectionManager;

    public ConnectionManager(SessionFactoryImplementor factory, Callback callback, ConnectionReleaseMode releaseMode, Connection connection) {
        this.factory = factory;
        this.callback = callback;
        this.batcher = factory.getSettings().getBatcherFactory().createBatcher(this);
        this.releaseMode = releaseMode;
        this.connection = connection;
        this.wasConnectionSupplied = connection != null;
        this.shouldObtainConnection = !this.wasConnectionSupplied;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public Batcher getBatcher() {
        return this.batcher;
    }

    public Connection getConnection() throws HibernateException {
        if (this.connection == null) {
            if (this.shouldObtainConnection) {
                this.openConnection();
            } else {
                throw new HibernateException("Not able to obtain connection");
            }
        }
        return this.connection;
    }

    public boolean isAutoCommit() throws SQLException {
        return this.connection == null || this.connection.getAutoCommit();
    }

    public boolean isLogicallyConnected() {
        return this.connection != null || this.shouldObtainConnection;
    }

    public boolean isPhysicallyConnected() {
        return this.connection != null;
    }

    public void afterStatement() {
        if (this.releaseMode == ConnectionReleaseMode.AFTER_STATEMENT) {
            if (this.batcher.hasOpenResources()) {
                log.info((Object)"Skipping aggresive-release due to open resources on batcher");
            } else {
                this.aggressiveRelease();
            }
        }
    }

    public void afterTransaction() {
        if (this.releaseMode == ConnectionReleaseMode.AFTER_TRANSACTION) {
            this.aggressiveRelease();
        }
    }

    public Connection close() {
        if (this.connection == null) {
            this.shouldObtainConnection = false;
            return null;
        }
        return this.cleanup();
    }

    public Connection manualDisconnect() {
        return this.cleanup();
    }

    public void manualReconnect() {
        if (this.isLogicallyConnected()) {
            throw new HibernateException("Already connected");
        }
        this.shouldObtainConnection = true;
    }

    public void manualReconnect(Connection suppliedConnection) {
        if (this.isLogicallyConnected()) {
            throw new HibernateException("Already connected");
        }
        this.connection = suppliedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection cleanup() throws HibernateException {
        try {
            if (this.shouldObtainConnection) {
                this.shouldObtainConnection = false;
                Connection connection = null;
                return connection;
            }
            if (this.connection == null) {
                throw new HibernateException("Already disconnected");
            }
            this.batcher.closeStatements();
            Connection c = null;
            if (!this.wasConnectionSupplied) {
                this.closeConnection();
            } else {
                c = this.connection;
            }
            this.connection = null;
            Connection connection = c;
            return connection;
        }
        finally {
            this.callback.connectionCleanedUp();
        }
    }

    private void aggressiveRelease() {
        if (!this.wasConnectionSupplied) {
            log.debug((Object)"aggressively releasing JDBC connection");
            if (this.connection != null) {
                this.closeConnection();
            }
            this.shouldObtainConnection = true;
        }
    }

    private void openConnection() throws HibernateException {
        log.debug((Object)"opening JDBC connection");
        try {
            this.connection = this.factory.getConnectionProvider().getConnection();
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "Cannot open connection");
        }
        this.shouldObtainConnection = false;
        this.callback.connectionOpened();
    }

    private void closeConnection() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing JDBC connection [" + this.batcher.openResourceStatsAsString() + "]"));
        }
        try {
            if (!this.connection.isClosed()) {
                JDBCExceptionReporter.logAndClearWarnings(this.connection);
            }
            this.factory.getConnectionProvider().closeConnection(this.connection);
            this.connection = null;
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sqle, "Cannot close connection");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isPhysicallyConnected()) {
            throw new IllegalStateException("Cannot serialize a ConnectionManager while connected");
        }
        oos.writeObject(this.factory);
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.factory = (SessionFactoryImplementor)ois.readObject();
        ois.defaultReadObject();
        this.batcher = this.factory.getSettings().getBatcherFactory().createBatcher(this);
    }

    protected void finalize() throws Throwable {
        log.debug((Object)"running Session.finalize()");
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                log.warn((Object)"finalizing with closed connection");
            } else {
                log.warn((Object)"unclosed connection, forgot to call close() on your session?");
                if (!this.wasConnectionSupplied) {
                    this.connection.close();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Callback {
        public void connectionOpened();

        public void connectionCleanedUp();
    }
}

