/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.AbstractMaskPerform;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;

public class MaskImport
extends AbstractMaskPerform {
    private AbstractChoice iChoice;

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.iChoice.getComponentCount(); ++i) {
            this.iChoice.getComponent(i).setEnabled(b);
        }
    }

    void setType(short type, String tname, String fname) {
        if (this.iChoice != null) {
            this.remove(this.iChoice);
        }
        this.progress.setValue(0);
        this.progress.setMaximum(0);
        if (type == 1) {
            if (!fname.endsWith(".txt")) {
                fname = fname + ".txt";
            }
            this.iChoice = new TxtChoice();
            this.setComponentCenter(this.iChoice);
        }
        this.lblFile.setText("file: " + fname);
    }

    void init(ContentView view) {
        super.init(view);
        this.progress.setValue(0);
        this.progress.setMaximum(this.iChoice.open());
    }

    void next() {
        String line = this.iChoice.nextln();
        Object[] rowdata = new Object[this.view.getColumnCount()];
        this.iChoice.flush(line, rowdata);
        this.view.addRow(rowdata, true);
        this.progress.setValue(this.progress.getValue() + line.length() + 1);
    }

    boolean finished() {
        if (this.progress.getValue() == this.progress.getMaximum()) {
            this.iChoice.close();
            this.view.onTableChanged(true);
            this.view.getControl().doRefreshStatus();
            this.btnStop.setEnabled(false);
            this.lblMsg.setText("ready!");
            return true;
        }
        return false;
    }

    private class TxtChoice
    extends AbstractChoice {
        JCheckBox cbxHeader;
        JCheckBox cbxNull;
        JCheckBox cbxTrim;
        JRadioButton rbTab;
        JRadioButton rbOther;
        JTextField txtDelimiter;

        TxtChoice() {
            super("options");
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            this.cbxHeader = new JCheckBox("with header");
            gbl.setConstraints(this.cbxHeader, gbc);
            this.add(this.cbxHeader);
            this.cbxNull = new JCheckBox("null if blanks");
            gbl.setConstraints(this.cbxNull, gbc);
            this.add(this.cbxNull);
            this.cbxTrim = new JCheckBox("trim value");
            gbl.setConstraints(this.cbxTrim, gbc);
            this.add(this.cbxTrim);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 3, 0, 0);
            gbc.weighty = 1.0;
            JLabel lbl = new JLabel("delimiter:");
            gbl.setConstraints(lbl, gbc);
            this.add(lbl);
            this.rbTab = new JRadioButton("tab", true);
            gbl.setConstraints(this.rbTab, gbc);
            this.add(this.rbTab);
            this.rbOther = new JRadioButton("other");
            gbl.setConstraints(this.rbOther, gbc);
            this.add(this.rbOther);
            gbc.anchor = 17;
            this.txtDelimiter = new JTextField(";", 5);
            this.txtDelimiter.setEditable(false);
            this.txtDelimiter.setEnabled(false);
            gbl.setConstraints(this.txtDelimiter, gbc);
            this.add(this.txtDelimiter);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbTab);
            bg.add(this.rbOther);
            this.rbTab.addItemListener(new ItemListener(this){
                private final /* synthetic */ TxtChoice this$1;
                {
                    this.this$1 = this$1;
                }

                public void itemStateChanged(ItemEvent e) {
                    this.this$1.txtDelimiter.setEditable(!this.this$1.rbTab.isSelected());
                    this.this$1.txtDelimiter.setEnabled(!this.this$1.rbTab.isSelected());
                }
            });
        }

        private String getDelimiter() {
            if (this.rbTab.isSelected()) {
                return "\t";
            }
            return this.txtDelimiter.getText();
        }

        int open() {
            int bytes = super.open();
            if (this.cbxHeader.isSelected()) {
                String line = this.nextln();
                bytes -= line.length() + 1;
            }
            return bytes;
        }

        void flush(String line, Object[] rowdata) {
            String value;
            Vector<String> vRow = new Vector<String>();
            int bix = 0;
            int eix = 0;
            while ((eix = line.indexOf(this.getDelimiter(), bix)) != -1) {
                value = line.substring(bix, eix);
                bix = eix + this.getDelimiter().length();
                if (this.cbxNull.isSelected() && value.trim().length() == 0) {
                    value = null;
                }
                if (this.cbxTrim.isSelected() && value != null) {
                    value = value.trim();
                }
                vRow.addElement(value);
            }
            if (bix < line.length() - 1) {
                value = line.substring(bix);
                if (this.cbxNull.isSelected() && value.trim().length() == 0) {
                    value = null;
                }
                if (this.cbxTrim.isSelected() && value != null) {
                    value = value.trim();
                }
                vRow.addElement(value);
            }
            vRow.toArray(rowdata);
        }
    }

    private abstract class AbstractChoice
    extends JPanel {
        private FileInputStream stream;

        AbstractChoice(String title) {
            this.setBorder(new TitledBorder(title));
        }

        int open() {
            try {
                this.stream = new FileInputStream(MaskImport.this.lblFile.getText().substring(6));
                return this.stream.available();
            }
            catch (FileNotFoundException e) {
                Application.println(e, true);
            }
            catch (IOException e) {
                Application.println(e, true);
            }
            return 0;
        }

        void close() {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                Application.println(e, true);
            }
        }

        abstract void flush(String var1, Object[] var2);

        String nextln() {
            try {
                int nChar;
                String line = new String("");
                while ((nChar = this.stream.read()) != -1 && (char)nChar != '\n') {
                    line = line + (char)nChar;
                }
                return line;
            }
            catch (IOException e) {
                Application.println(e, true);
                return null;
            }
        }
    }
}

