/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.TitledPanelUI;

public abstract class BasicTitledPanelUI
extends TitledPanelUI {
    private static final Logger LOG = Logger.getLogger(BasicTitledPanelUI.class.getName());
    private JLabel caption;
    private JXPanel topPanel;
    private PropertyChangeListener titleChangeListener;
    protected JXTitledPanel titledPanel;
    private JComponent left;
    private JComponent right;

    public void installUI(JComponent c) {
        assert (c instanceof JXTitledPanel);
        this.titledPanel = (JXTitledPanel)c;
        this.installProperty(this.titledPanel, "titlePainter", (Painter)UIManager.get("JXTitledPanel.title.painter"));
        this.installProperty(this.titledPanel, "titleForeground", UIManager.getColor("JXTitledPanel.title.foreground"));
        this.installProperty(this.titledPanel, "titleFont", UIManager.getFont("JXTitledPanel.title.font"));
        this.caption = this.createAndConfigureCaption(this.titledPanel);
        this.topPanel = this.createAndConfigureTopPanel(this.titledPanel);
        this.fillTopPanel();
        this.titledPanel.setLayout(new BorderLayout());
        this.titledPanel.add((Component)this.topPanel, "North");
        this.titledPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.titledPanel.setOpaque(false);
        this.installListeners();
    }

    private void fillTopPanel() {
        this.topPanel.add((Component)this.caption, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(4, 12, 4, 12), 0, 0));
        if (this.titledPanel.getClientProperty("JXTitledPanel.rightDecoration") instanceof JComponent) {
            this.setRightDecoration((JComponent)this.titledPanel.getClientProperty("JXTitledPanel.rightDecoration"));
        }
        if (this.titledPanel.getClientProperty("JXTitledPanel.leftDecoration") instanceof JComponent) {
            this.setLeftDecoration((JComponent)this.titledPanel.getClientProperty("JXTitledPanel.leftDecoration"));
        }
    }

    private JXPanel createAndConfigureTopPanel(JXTitledPanel titledPanel) {
        JXPanel topPanel = new JXPanel();
        topPanel.setBackgroundPainter(titledPanel.getTitlePainter());
        topPanel.setBorder(BorderFactory.createEmptyBorder());
        topPanel.setLayout(new GridBagLayout());
        return topPanel;
    }

    private JLabel createAndConfigureCaption(JXTitledPanel titledPanel) {
        JLabel caption = new JLabel(titledPanel.getTitle());
        caption.setFont(titledPanel.getTitleFont());
        caption.setForeground(titledPanel.getTitleForeground());
        return caption;
    }

    public void uninstallUI(JComponent c) {
        assert (c instanceof JXTitledPanel);
        this.uninstallListeners(this.titledPanel);
        this.topPanel.removeAll();
        this.titledPanel.remove(this.topPanel);
        this.titledPanel.putClientProperty("JXTitledPanel.leftDecoration", this.left);
        this.titledPanel.putClientProperty("JXTitledPanel.rightDecoration", this.right);
        this.caption = null;
        this.topPanel = null;
        this.titledPanel = null;
        this.left = null;
        this.right = null;
    }

    protected void installListeners() {
        this.titleChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("title")) {
                    BasicTitledPanelUI.this.caption.setText((String)evt.getNewValue());
                } else if (evt.getPropertyName().equals("titleForeground")) {
                    BasicTitledPanelUI.this.caption.setForeground((Color)evt.getNewValue());
                } else if (evt.getPropertyName().equals("titleFont")) {
                    BasicTitledPanelUI.this.caption.setFont((Font)evt.getNewValue());
                } else if ("titlePainter".equals(evt.getPropertyName())) {
                    BasicTitledPanelUI.this.topPanel.setBackgroundPainter(BasicTitledPanelUI.this.titledPanel.getTitlePainter());
                    BasicTitledPanelUI.this.topPanel.repaint();
                }
            }
        };
        this.titledPanel.addPropertyChangeListener(this.titleChangeListener);
    }

    protected void uninstallListeners(JXTitledPanel panel) {
        this.titledPanel.removePropertyChangeListener(this.titleChangeListener);
    }

    protected void installProperty(JComponent c, String propName, Object value) {
        try {
            BeanInfo bi = Introspector.getBeanInfo(c.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                Method m;
                Object oldVal;
                if (!pd.getName().equals(propName) || (oldVal = (m = pd.getReadMethod()).invoke((Object)c, new Object[0])) != null && !(oldVal instanceof UIResource)) continue;
                m = pd.getWriteMethod();
                m.invoke((Object)c, value);
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Failed to install property " + propName, e);
        }
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    public void setRightDecoration(JComponent decoration) {
        if (this.right != null) {
            this.topPanel.remove(this.right);
        }
        this.right = decoration;
        if (this.right != null) {
            this.topPanel.add((Component)decoration, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
    }

    public JComponent getRightDecoration() {
        return this.right;
    }

    public void setLeftDecoration(JComponent decoration) {
        if (this.left != null) {
            this.topPanel.remove(this.left);
        }
        this.left = decoration;
        if (this.left != null) {
            this.topPanel.add((Component)this.left, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
    }

    public JComponent getLeftDecoration() {
        return this.left;
    }

    public Container getTitleBar() {
        return this.topPanel;
    }
}

