/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.locale;

import it.businesslogic.ireport.plugin.locale.JasperBabylonRunner;
import it.businesslogic.ireport.plugin.locale.JasperBabylonRunnerListener;
import it.businesslogic.ireport.util.LocaleAdapter;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QueryLocalesDialog
extends JDialog
implements JasperBabylonRunnerListener {
    private int dialogResult = 2;
    private Properties localeProperties = null;
    private String locale_code = null;
    private JButton jButton2;
    private JButton jButtonImport;
    private JLabel jLabelJasperBabylon;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public QueryLocalesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                QueryLocalesDialog.this.jButton2ActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.jButtonImport.setEnabled(false);
        this.jList1.setModel(new DefaultListModel());
        this.getRootPane().setDefaultButton(this.jButton2);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void initComponents() {
        this.jLabelJasperBabylon = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonImport = new JButton();
        this.jButton2 = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                QueryLocalesDialog.this.formWindowOpened(evt);
            }
        });
        this.jLabelJasperBabylon.setText("Available locales:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabelJasperBabylon, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 200));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                QueryLocalesDialog.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 4));
        this.jSeparator1.setPreferredSize(new Dimension(0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonImport.setText("Import");
        this.jButtonImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryLocalesDialog.this.jButtonImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButtonImport, gridBagConstraints);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                QueryLocalesDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 4, 10);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0 && this.jList1.getSelectedValue() instanceof LocaleAdapter) {
            this.jButtonImport.setEnabled(true);
        } else {
            this.jButtonImport.setEnabled(false);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void formWindowOpened(WindowEvent evt) {
        JasperBabylonRunner jbr = new JasperBabylonRunner();
        jbr.setRunnerListener(this);
        ((DefaultListModel)this.jList1.getModel()).clear();
        ((DefaultListModel)this.jList1.getModel()).addElement("Reading locales...");
        this.jList1.updateUI();
        jbr.listLocales();
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        JasperBabylonRunner jbr = new JasperBabylonRunner();
        jbr.setRunnerListener(this);
        LocaleAdapter la = (LocaleAdapter)this.jList1.getSelectedValue();
        String code = la.getLocale().getLanguage();
        if (la.getLocale().getCountry().length() > 0) {
            code = code + "_" + la.getLocale().getCountry();
        }
        if (la.getLocale().getVariant().length() > 0) {
            code = code + "_" + la.getLocale().getVariant();
        }
        this.setLocale_code(code);
        jbr.getLocale(code);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jButtonImport.setEnabled(false);
    }

    public void applyI18n() {
    }

    public void listLocalesComplete(List list) {
        ((DefaultListModel)this.jList1.getModel()).clear();
        Object[] ar = list.toArray();
        Arrays.sort(ar);
        for (int i = 0; i < ar.length; ++i) {
            String code = "" + ar[i];
            Locale loc = Misc.getLocaleFromString(code);
            LocaleAdapter la = new LocaleAdapter(loc);
            ((DefaultListModel)this.jList1.getModel()).addElement(la);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    QueryLocalesDialog.this.jList1.updateUI();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getLocaleComplete(Properties props) {
        this.setLocaleProperties(props);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    QueryLocalesDialog.this.setCursor(Cursor.getDefaultCursor());
                    QueryLocalesDialog.this.setDialogResult(0);
                    QueryLocalesDialog.this.setVisible(false);
                    QueryLocalesDialog.this.dispose();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void putLocaleComplete(String returnMessage) {
    }

    public void operationError(int operation, String message) {
        if (operation == 2) {
            try {
                final String msg = message;
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        QueryLocalesDialog.this.setCursor(Cursor.getDefaultCursor());
                        QueryLocalesDialog.this.jList1ValueChanged(null);
                        JOptionPane.showMessageDialog(QueryLocalesDialog.this, msg);
                    }
                });
            }
            catch (Exception ex) {}
        } else {
            ((DefaultListModel)this.jList1.getModel()).clear();
            ((DefaultListModel)this.jList1.getModel()).addElement(message);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        QueryLocalesDialog.this.jList1.updateUI();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Properties getLocaleProperties() {
        return this.localeProperties;
    }

    public void setLocaleProperties(Properties localeProperties) {
        this.localeProperties = localeProperties;
    }

    public String getLocale_code() {
        return this.locale_code;
    }

    public void setLocale_code(String locale_code) {
        this.locale_code = locale_code;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

