/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.logpane;

import it.businesslogic.ireport.compiler.ErrorLocator;
import it.businesslogic.ireport.compiler.xml.SourceLocation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.logpane.ProblemIconTableCellRenderer;
import it.businesslogic.ireport.gui.logpane.ProblemItem;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class ProblemsPanel
extends JPanel
implements ReportFrameActivatedListener {
    private ErrorLocator errorLocator = null;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public ProblemsPanel() {
        this.initComponents();
        this.errorLocator = new ErrorLocator();
        this.jTable1.getColumnModel().getColumn(0).setMinWidth(20);
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(20);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.jTable1.getColumnModel().getColumn(0).setCellRenderer(new ProblemIconTableCellRenderer());
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.jTable1.getColumnModel().getColumn(3).setPreferredWidth(550);
        MainFrame.getMainInstance().addReportFrameActivatedListener(this);
        this.setName(I18n.getFormattedString("problems", "Problems ({0,number})", new Object[]{new Integer(0)}));
        I18n.addOnLanguageChangedListener(new LanguageChangedListener(){

            public void languageChanged(LanguageChangedEvent evt) {
                ProblemsPanel.this.applyI18n();
            }
        });
    }

    public void updateProblemsList() {
        JReportFrame rf = MainFrame.getMainInstance().getActiveReportFrame();
        if (rf != null) {
            this.setProblems(rf.getReportProblems());
        } else {
            DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
            dtm.setRowCount(0);
        }
        this.updateUI();
    }

    public void setProblems(List problems) {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        dtm.setRowCount(0);
        for (int i = 0; i < problems.size(); ++i) {
            ProblemItem pi = (ProblemItem)problems.get(i);
            this.addProblem(pi);
        }
        this.updateName();
    }

    public void addProblem(ProblemItem pi) {
        String pWhere = pi.getWhere();
        String location = "";
        if (pi.getProblemReference() != null && pi.getProblemReference() instanceof SourceLocation) {
            SourceLocation sl = (SourceLocation)pi.getProblemReference();
            location = I18n.getFormattedString("LineColumn", "Line {0,number,integer}, Column {1,number,integer}", new Object[]{new Integer(sl.getLineNumber()), new Integer(sl.getColumnNumber())});
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        dtm.addRow(new Object[]{pi, pi.getDescription(), location, pWhere});
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Description", "Location", "Element"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ProblemsPanel.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = ProblemsPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = ProblemsPanel.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = ProblemsPanel.class$("java.lang.Object")) : class$java$lang$Object};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ProblemsPanel.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        System.out.flush();
        if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt) && this.jTable1.getSelectedRow() >= 0) {
            ProblemItem pi = (ProblemItem)this.jTable1.getValueAt(this.jTable1.getSelectedRow(), 0);
            this.errorLocator.parseError(pi.getWhere(), pi.getDescription());
        }
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        if (evt.getReportFrame() != null) {
            this.setProblems(evt.getReportFrame().getReportProblems());
        } else {
            DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
            dtm.setRowCount(0);
        }
        this.errorLocator.setJReportFrame(evt.getReportFrame());
    }

    public void updateName() {
        this.setName(I18n.getFormattedString("problems", "Problems ({0,number})", new Object[]{new Integer(this.jTable1.getRowCount())}));
        if (this.getParent() != null && this.getParent() instanceof JTabbedPane) {
            JTabbedPane tp = (JTabbedPane)this.getParent();
            try {
                if (this.jTable1.getRowCount() > 0) {
                    tp.setIconAt(1, ProblemIconTableCellRenderer.errorIcon);
                    tp.setTitleAt(1, "<html><font color=\"red\">" + this.getName());
                } else {
                    tp.setIconAt(1, null);
                    tp.setTitleAt(1, this.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void applyI18n() {
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("problemsPanel.table.description", "Description"));
        this.jTable1.getColumnModel().getColumn(2).setHeaderValue(I18n.getString("problemsPanel.table.location", "JRXML location"));
        this.jTable1.getColumnModel().getColumn(3).setHeaderValue(I18n.getString("problemsPanel.table.object", "Object"));
    }
}

