/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.beanutils.PropertyUtils;

public class JRExtendedBeanDataSource
implements JRDataSource {
    private Object[] beans = null;
    private int index = -1;

    public JRExtendedBeanDataSource(Vector beans) {
        this.beans = beans.toArray();
    }

    public JRExtendedBeanDataSource(Object[] beans) {
        this.beans = beans;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String path = jRField.getDescription();
        Object val = this.getPathValue(this.beans[this.index], path);
        if (val == null) {
            return null;
        }
        if (val.getClass().isAssignableFrom(jRField.getValueClass())) {
            return val;
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index < this.beans.length;
    }

    private Object getPathValue(Object bean, String path) {
        System.out.println("Looking for " + path + " in " + bean);
        if (path == null || bean == null || path.trim().length() == 0) {
            return bean;
        }
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (path.trim().length() == 0) {
            return bean;
        }
        path = path.trim();
        String attr_name = JRExtendedBeanDataSource.getNextNodeName(path);
        Class clazz = null;
        try {
            clazz = PropertyUtils.getPropertyType((Object)bean, (String)attr_name);
        }
        catch (Exception ex) {
            return null;
        }
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            try {
                return new JRExtendedBeanDataSource((Object[])PropertyUtils.getProperty((Object)bean, (String)attr_name));
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (path.equals(attr_name)) {
            try {
                return PropertyUtils.getProperty((Object)bean, (String)attr_name);
            }
            catch (Exception ex) {
                return null;
            }
        }
        Object child_bean = null;
        try {
            child_bean = PropertyUtils.getProperty((Object)bean, (String)attr_name);
        }
        catch (Exception ex) {
            return null;
        }
        path = path.substring(attr_name.length());
        return this.getPathValue(child_bean, path);
    }

    private static String getNextNodeName(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        String childToTake = path;
        if (path.indexOf(".") >= 0) {
            childToTake = path.substring(0, path.indexOf("."));
        }
        return childToTake;
    }
}

