/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.gui.JRCustomDataSourceConnectionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.sql.Connection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;

public class JRCustomDataSourceConnection
extends IReportConnection {
    private String name;
    private String factoryClass;
    private String methodToCall;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FactoryClass", Misc.nvl(this.getFactoryClass(), ""));
        map.put("MethodToCall", Misc.nvl(this.getMethodToCall(), ""));
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setFactoryClass((String)map.get("FactoryClass"));
        this.setMethodToCall((String)map.get("MethodToCall"));
    }

    public String getMethodToCall() {
        return this.methodToCall;
    }

    public void setMethodToCall(String methodToCall) {
        this.methodToCall = methodToCall;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public JRDataSource getJRDataSource() {
        try {
            Object obj = Class.forName(this.factoryClass).newInstance();
            return (JRDataSource)obj.getClass().getMethod(this.methodToCall, new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Exception ex) {
            return super.getJRDataSource();
        }
    }

    public String getDescription() {
        return I18n.getString("connectionType.customDataSource", "Custom JRDataSource");
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JRCustomDataSourceConnectionEditor();
    }

    public void test() throws Exception {
        try {
            Object obj = Class.forName(this.getFactoryClass(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
            obj.getClass().getMethod(this.getMethodToCall(), new Class[0]).invoke(obj, new Object[0]);
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.connection.noClassDefFoundError", "{0}\nNoClassDefFoundError!!\nCheck your classpath!\n{1}", new Object[]{"", "" + ex.getMessage()}), I18n.getString("message.title.exception", "Exception"), 0);
            throw new Exception();
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.connection.classNotFoundError", "{0}\nClassNotFoundError!\nMsg: {1}\nPossible not found class: {2}\nCheck your classpath!", new Object[]{"", "" + ex.getMessage(), "" + this.getFactoryClass()}), I18n.getString("message.title.exception", "Exception"), 0);
            throw new Exception();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getFormattedString("messages.connection.generalError2", "{0}\nGeneral problem:\n {1}", new Object[]{"", "" + ex.getMessage()}), I18n.getString("message.title.exception", "Exception"), 0);
            return;
        }
        JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.connectionDialog.connectionTestSuccessful", "Connection test successful!"), "", 1);
    }
}

