/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;

public class JRCustomConnection
extends IReportConnection {
    public static final String CLASSNAME_PROPERTY = "iReportConnectionClassName";
    public static final String PROPERTY_PREFIX = "prop_";
    private HashMap innerConnectionProperties = new HashMap();
    private IReportConnection innerConnection = null;
    private String iReportConnectionClassName = null;

    public Connection getConnection() {
        if (this.getInnerConnection() == null) {
            return super.getConnection();
        }
        return this.getInnerConnection().getConnection();
    }

    public boolean isJDBCConnection() {
        if (this.getInnerConnection() == null) {
            return super.isJDBCConnection();
        }
        return this.getInnerConnection().isJDBCConnection();
    }

    public HashMap getProperties() {
        HashMap map = new HashMap();
        HashMap map2 = this.getInnerConnectionProperties();
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            map.put(PROPERTY_PREFIX + key, map2.get(key));
        }
        if (this.getIReportConnectionClassName() != null) {
            map.put(CLASSNAME_PROPERTY, this.getIReportConnectionClassName());
        }
        return map;
    }

    public void loadProperties(HashMap map) {
        HashMap map2 = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = "" + iterator.next();
            Object value = map.get(key);
            if (key.startsWith(PROPERTY_PREFIX)) {
                map2.put(key.substring(PROPERTY_PREFIX.length()), value);
                continue;
            }
            if (!key.equals(CLASSNAME_PROPERTY)) continue;
            this.setIReportConnectionClassName("" + map.get(CLASSNAME_PROPERTY));
        }
        this.setInnerConnectionProperties(map2);
        this.setInnerConnection(null);
    }

    public JRDataSource getJRDataSource() {
        if (this.getInnerConnection() == null) {
            return super.getJRDataSource();
        }
        return this.getInnerConnection().getJRDataSource();
    }

    public Map getSpecialParameters(Map map) throws JRException {
        if (this.getInnerConnection() == null) {
            return super.getSpecialParameters(map);
        }
        return this.getInnerConnection().getSpecialParameters(map);
    }

    public Map disposeSpecialParameters(Map map) {
        if (this.getInnerConnection() == null) {
            return super.disposeSpecialParameters(map);
        }
        return this.getInnerConnection().disposeSpecialParameters(map);
    }

    public boolean isJRDataSource() {
        if (this.getInnerConnection() == null) {
            return super.isJRDataSource();
        }
        return this.getInnerConnection().isJRDataSource();
    }

    public String getIReportConnectionClassName() {
        return this.iReportConnectionClassName;
    }

    public void setIReportConnectionClassName(String iReportConnectionClassName) {
        this.iReportConnectionClassName = iReportConnectionClassName;
    }

    public IReportConnection getInnerConnection() {
        if (this.innerConnection == null) {
            try {
                this.innerConnection = (IReportConnection)Class.forName(this.getIReportConnectionClassName(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
                this.innerConnection.loadProperties(this.getInnerConnectionProperties());
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return this.innerConnection;
    }

    public void setInnerConnection(IReportConnection innerConnection) {
        this.innerConnection = innerConnection;
    }

    public HashMap getInnerConnectionProperties() {
        return this.innerConnectionProperties;
    }

    public void setInnerConnectionProperties(HashMap innerConnectionProperties) {
        this.innerConnectionProperties = innerConnectionProperties;
    }

    public void test() throws Exception {
        IReportConnection testConnection = (IReportConnection)Class.forName(this.getIReportConnectionClassName(), true, MainFrame.getMainInstance().getReportClassLoader()).newInstance();
        if (testConnection != null) {
            testConnection.loadProperties(this.getInnerConnectionProperties());
            testConnection.test();
        }
    }

    public String getDescription() {
        return I18n.getString("connectionType.customIReportConnection", "Custom iReport connection");
    }
}

