/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis.zip;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.oasis.zip.OasisZipEntry;

public class ByteArrayOasisZipEntry
implements OasisZipEntry {
    private String name = null;
    private ByteArrayOutputStream baos = null;

    public ByteArrayOasisZipEntry(String name) {
        this(name, null);
    }

    public ByteArrayOasisZipEntry(String name, byte[] bytes) {
        this.name = name;
        if (bytes == null) {
            this.baos = new ByteArrayOutputStream();
        } else {
            this.baos = new ByteArrayOutputStream(bytes.length);
            try {
                this.baos.write(bytes);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Writer getWriter() throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)this.baos, "UTF-8"));
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.baos.toByteArray());
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.baos.toByteArray()), "UTF-8"));
    }
}

