/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseReport;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignVariable;

public class JasperDesign
extends JRBaseReport {
    private static final long serialVersionUID = 10200L;
    private Map fontsMap = new HashMap();
    private List fontsList = new ArrayList();
    private Map stylesMap = new HashMap();
    private List stylesList = new ArrayList();
    private JRDesignDataset mainDesignDataset;
    private Map datasetMap = new HashMap();
    private List datasetList = new ArrayList();
    private transient List crosstabs;

    public JasperDesign() {
        this.setMainDataset(new JRDesignDataset(true));
    }

    public void setName(String name) {
        this.name = name;
        this.mainDesignDataset.setName(name);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public void setPrintOrder(byte printOrder) {
        this.printOrder = printOrder;
    }

    public void setPageWidth(int pageWidth) {
        this.pageWidth = pageWidth;
    }

    public void setPageHeight(int pageHeight) {
        this.pageHeight = pageHeight;
    }

    public void setOrientation(byte orientation) {
        this.orientation = orientation;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public void setColumnSpacing(int columnSpacing) {
        this.columnSpacing = columnSpacing;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setBackground(JRBand background) {
        this.background = background;
    }

    public void setTitle(JRBand title) {
        this.title = title;
    }

    public void setTitleNewPage(boolean isTitleNewPage) {
        this.isTitleNewPage = isTitleNewPage;
    }

    public void setSummary(JRBand summary) {
        this.summary = summary;
    }

    public void setSummaryNewPage(boolean isSummaryNewPage) {
        this.isSummaryNewPage = isSummaryNewPage;
    }

    public void setFloatColumnFooter(boolean isFloatColumnFooter) {
        this.isFloatColumnFooter = isFloatColumnFooter;
    }

    public void setPageHeader(JRBand pageHeader) {
        this.pageHeader = pageHeader;
    }

    public void setPageFooter(JRBand pageFooter) {
        this.pageFooter = pageFooter;
    }

    public void setLastPageFooter(JRBand lastPageFooter) {
        this.lastPageFooter = lastPageFooter;
    }

    public void setColumnHeader(JRBand columnHeader) {
        this.columnHeader = columnHeader;
    }

    public void setColumnFooter(JRBand columnFooter) {
        this.columnFooter = columnFooter;
    }

    public void setDetail(JRBand detail) {
        this.detail = detail;
    }

    public void setScriptletClass(String scriptletClass) {
        this.mainDesignDataset.setScriptletClass(scriptletClass);
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        this.formatFactoryClass = formatFactoryClass;
    }

    public void setResourceBundle(String resourceBundle) {
        this.mainDesignDataset.setResourceBundle(resourceBundle);
    }

    public void addImport(String value) {
        if (this.importsSet == null) {
            this.importsSet = new HashSet();
        }
        this.importsSet.add(value);
    }

    public void removeImport(String value) {
        if (this.importsSet != null) {
            this.importsSet.remove(value);
        }
    }

    public void setDefaultFont(JRReportFont font) {
        this.defaultFont = font;
    }

    public JRReportFont[] getFonts() {
        JRReportFont[] fontsArray = new JRReportFont[this.fontsList.size()];
        this.fontsList.toArray(fontsArray);
        return fontsArray;
    }

    public List getFontsList() {
        return this.fontsList;
    }

    public Map getFontsMap() {
        return this.fontsMap;
    }

    public void addFont(JRReportFont reportFont) throws JRException {
        if (this.fontsMap.containsKey(reportFont.getName())) {
            throw new JRException("Duplicate declaration of report font : " + reportFont.getName());
        }
        this.fontsList.add(reportFont);
        this.fontsMap.put(reportFont.getName(), reportFont);
        if (reportFont.isDefault()) {
            this.setDefaultFont(reportFont);
        }
    }

    public JRReportFont removeFont(String propName) {
        return this.removeFont((JRReportFont)this.fontsMap.get(propName));
    }

    public JRReportFont removeFont(JRReportFont reportFont) {
        if (reportFont != null) {
            if (reportFont.isDefault()) {
                this.setDefaultFont(null);
            }
            this.fontsList.remove(reportFont);
            this.fontsMap.remove(reportFont.getName());
        }
        return reportFont;
    }

    public void setDefaultStyle(JRStyle style) {
        this.defaultStyle = style;
    }

    public JRStyle[] getStyles() {
        JRStyle[] stylesArray = new JRStyle[this.stylesList.size()];
        this.stylesList.toArray(stylesArray);
        return stylesArray;
    }

    public List getStylesList() {
        return this.stylesList;
    }

    public Map getStylesMap() {
        return this.stylesMap;
    }

    public void addStyle(JRStyle style) throws JRException {
        if (this.stylesMap.containsKey(style.getName())) {
            throw new JRException("Duplicate declaration of report style : " + style.getName());
        }
        this.stylesList.add(style);
        this.stylesMap.put(style.getName(), style);
        if (style.isDefault()) {
            this.setDefaultStyle(style);
        }
    }

    public JRStyle removeStyle(String styleName) {
        return this.removeStyle((JRStyle)this.stylesMap.get(styleName));
    }

    public JRStyle removeStyle(JRStyle style) {
        if (style != null) {
            if (style.isDefault()) {
                this.setDefaultStyle(null);
            }
            this.stylesList.remove(style);
            this.stylesMap.remove(style.getName());
        }
        return style;
    }

    public List getParametersList() {
        return this.mainDesignDataset.getParametersList();
    }

    public Map getParametersMap() {
        return this.mainDesignDataset.getParametersMap();
    }

    public void addParameter(JRParameter parameter) throws JRException {
        this.mainDesignDataset.addParameter(parameter);
    }

    public JRParameter removeParameter(String parameterName) {
        return this.mainDesignDataset.removeParameter(parameterName);
    }

    public JRParameter removeParameter(JRParameter parameter) {
        return this.mainDesignDataset.removeParameter(parameter);
    }

    public void setQuery(JRDesignQuery query) {
        this.mainDesignDataset.setQuery(query);
    }

    public List getFieldsList() {
        return this.mainDesignDataset.getFieldsList();
    }

    public Map getFieldsMap() {
        return this.mainDesignDataset.getFieldsMap();
    }

    public void addField(JRField field) throws JRException {
        this.mainDesignDataset.addField(field);
    }

    public JRField removeField(String fieldName) {
        return this.mainDesignDataset.removeField(fieldName);
    }

    public JRField removeField(JRField field) {
        return this.mainDesignDataset.removeField(field);
    }

    public List getSortFieldsList() {
        return this.mainDesignDataset.getSortFieldsList();
    }

    public void addSortField(JRSortField sortField) throws JRException {
        this.mainDesignDataset.addSortField(sortField);
    }

    public JRSortField removeSortField(String fieldName) {
        return this.mainDesignDataset.removeSortField(fieldName);
    }

    public JRSortField removeSortField(JRSortField sortField) {
        return this.mainDesignDataset.removeSortField(sortField);
    }

    public List getVariablesList() {
        return this.mainDesignDataset.getVariablesList();
    }

    public Map getVariablesMap() {
        return this.mainDesignDataset.getVariablesMap();
    }

    public void addVariable(JRDesignVariable variable) throws JRException {
        this.mainDesignDataset.addVariable(variable);
    }

    public JRVariable removeVariable(String variableName) {
        return this.mainDesignDataset.removeVariable(variableName);
    }

    public JRVariable removeVariable(JRVariable variable) {
        return this.mainDesignDataset.removeVariable(variable);
    }

    public List getGroupsList() {
        return this.mainDesignDataset.getGroupsList();
    }

    public Map getGroupsMap() {
        return this.mainDesignDataset.getGroupsMap();
    }

    public void addGroup(JRDesignGroup group) throws JRException {
        this.mainDesignDataset.addGroup(group);
    }

    public JRGroup removeGroup(String groupName) {
        return this.mainDesignDataset.removeGroup(groupName);
    }

    public JRGroup removeGroup(JRGroup group) {
        return this.mainDesignDataset.removeGroup(group);
    }

    public Collection getExpressions() {
        return JRExpressionCollector.collectExpressions(this);
    }

    public JRDataset[] getDatasets() {
        JRDataset[] datasetArray = new JRDataset[this.datasetList.size()];
        this.datasetList.toArray(datasetArray);
        return datasetArray;
    }

    public List getDatasetsList() {
        return this.datasetList;
    }

    public Map getDatasetMap() {
        return this.datasetMap;
    }

    public void addDataset(JRDesignDataset dataset) throws JRException {
        if (this.datasetMap.containsKey(dataset.getName())) {
            throw new JRException("Duplicate declaration of dataset : " + dataset.getName());
        }
        this.datasetList.add(dataset);
        this.datasetMap.put(dataset.getName(), dataset);
    }

    public JRDataset removeDataset(String datasetName) {
        return this.removeDataset((JRDataset)this.datasetMap.get(datasetName));
    }

    public JRDataset removeDataset(JRDataset dataset) {
        if (dataset != null) {
            this.datasetList.remove(dataset);
            this.datasetMap.remove(dataset.getName());
        }
        return dataset;
    }

    public JRDesignDataset getMainDesignDataset() {
        return this.mainDesignDataset;
    }

    public void setMainDataset(JRDesignDataset dataset) {
        this.mainDesignDataset = dataset;
        this.mainDataset = this.mainDesignDataset;
        this.mainDesignDataset.setName(this.getName());
    }

    public void preprocess() {
        this.collectCrosstabs();
        Iterator it = this.crosstabs.iterator();
        while (it.hasNext()) {
            JRDesignCrosstab crosstab = (JRDesignCrosstab)it.next();
            crosstab.preprocess();
        }
    }

    protected List getCrosstabs() {
        if (this.crosstabs == null) {
            this.collectCrosstabs();
        }
        return this.crosstabs;
    }

    protected List collectCrosstabs() {
        this.crosstabs = new ArrayList();
        this.collectCrosstabs(this.background);
        this.collectCrosstabs(this.title);
        this.collectCrosstabs(this.pageHeader);
        this.collectCrosstabs(this.columnHeader);
        this.collectCrosstabs(this.detail);
        this.collectCrosstabs(this.columnFooter);
        this.collectCrosstabs(this.pageFooter);
        this.collectCrosstabs(this.lastPageFooter);
        this.collectCrosstabs(this.summary);
        JRGroup[] groups = this.getGroups();
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                this.collectCrosstabs(groups[i].getGroupHeader());
                this.collectCrosstabs(groups[i].getGroupFooter());
            }
        }
        return this.crosstabs;
    }

    protected void collectCrosstabs(JRBand band) {
        if (band != null) {
            this.collectCrosstabs(band.getElements());
        }
    }

    protected void collectCrosstabs(JRElement[] elements) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                JRElement element = elements[i];
                if (element instanceof JRCrosstab) {
                    this.crosstabs.add(element);
                    continue;
                }
                if (!(element instanceof JRFrame)) continue;
                JRFrame frame = (JRFrame)element;
                this.collectCrosstabs(frame.getElements());
            }
        }
    }

    public void setIgnorePagination(boolean ignorePagination) {
        this.ignorePagination = ignorePagination;
    }

    public JRExpression getFilterExpression() {
        return this.mainDesignDataset.getFilterExpression();
    }

    public void setFilterExpression(JRExpression expression) {
        this.mainDesignDataset.setFilterExpression(expression);
    }
}

