/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyComboBoxButton;
import de.muntjak.tinylookandfeel.TinyComboBoxEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxIcon;

public class TinyComboBoxUI
extends BasicComboBoxUI {
    protected boolean isDisplaySizeDirty = true;
    protected Dimension cachedDisplaySize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent c) {
        return new TinyComboBoxUI();
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected ComboBoxEditor createEditor() {
        return new TinyComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new MetalComboPopup(this.comboBox);
    }

    protected JButton createArrowButton() {
        TinyComboBoxButton button = new TinyComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.putClientProperty("isComboBoxButton", Boolean.TRUE);
        return button;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new TinyPropertyChangeListener();
    }

    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    protected LayoutManager createLayoutManager() {
        return new TinyComboBoxLayoutManager();
    }

    protected Rectangle rectangleForCurrentValue2() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = Theme.comboButtonWidth[Theme.derivedStyle[Theme.style]];
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void configureEditor() {
        super.configureEditor();
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            this.isDisplaySizeDirty = true;
            return new Dimension(this.cachedMinimumSize);
        }
        Insets insets = Theme.comboInsets[Theme.style];
        Dimension size = this.getDisplaySize();
        size.width += Theme.comboButtonWidth[Theme.derivedStyle[Theme.style]];
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    protected Dimension getDisplaySize() {
        Object prototypeValue;
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension result = new Dimension();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        if ((prototypeValue = this.comboBox.getPrototypeDisplayValue()) != null) {
            result = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, prototypeValue, -1, false, false));
        } else {
            ComboBoxModel<Object> model = this.comboBox.getModel();
            int modelSize = model.getSize();
            if (modelSize > 0) {
                int i = 0;
                while (i < modelSize) {
                    Dimension d = this.getSizeForComponent(renderer.getListCellRendererComponent(this.listBox, model.getElementAt(i), -1, false, false));
                    result.width = Math.max(result.width, d.width);
                    result.height = Math.max(result.height, d.height);
                    ++i;
                }
            } else {
                result = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    result.width = 100;
                }
            }
        }
        if (this.comboBox.isEditable()) {
            Dimension d = this.editor.getPreferredSize();
            result.width = Math.max(result.width, d.width);
            result.height = Math.max(result.height, d.height);
        }
        this.cachedDisplaySize.setSize(result.width, result.height);
        this.isDisplaySizeDirty = false;
        return result;
    }

    private Dimension getSizeForComponent(Component comp) {
        this.currentValuePane.add(comp);
        comp.setFont(this.comboBox.getFont());
        Dimension d = comp.getPreferredSize();
        this.currentValuePane.remove(comp);
        return d;
    }

    public class TinyPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public TinyPropertyChangeListener() {
            super(TinyComboBoxUI.this);
        }

        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName.equals("editable")) {
                TinyComboBoxButton button = (TinyComboBoxButton)TinyComboBoxUI.this.arrowButton;
                button.setIconOnly(TinyComboBoxUI.this.comboBox.isEditable());
                TinyComboBoxUI.this.isMinimumSizeDirty = true;
                TinyComboBoxUI.this.isDisplaySizeDirty = true;
                TinyComboBoxUI.this.comboBox.revalidate();
            } else if (propertyName.equals("background")) {
                Color color = (Color)e.getNewValue();
                TinyComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName.equals("foreground")) {
                Color color = (Color)e.getNewValue();
                TinyComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }

    public class TinyComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            JComboBox cfr_ignored_0 = (JComboBox)parent;
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            JComboBox cfr_ignored_0 = (JComboBox)parent;
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            if (TinyComboBoxUI.this.comboBox.isEditable()) {
                if (TinyComboBoxUI.this.arrowButton != null) {
                    TinyComboBoxUI.this.arrowButton.setBounds(width - Theme.comboButtonWidth[Theme.derivedStyle[Theme.style]], 0, Theme.comboButtonWidth[Theme.derivedStyle[Theme.style]], height);
                }
                if (TinyComboBoxUI.this.editor != null) {
                    Rectangle cvb = TinyComboBoxUI.this.rectangleForCurrentValue2();
                    TinyComboBoxUI.this.editor.setBounds(cvb);
                }
            } else {
                TinyComboBoxUI.this.arrowButton.setBounds(0, 0, width, height);
            }
        }
    }

    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox cBox) {
            super(cBox);
        }

        public void delegateFocus(MouseEvent e) {
            super.delegateFocus(e);
        }
    }
}

