/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment.ctrl.CommandEditor;
import nickyb.sqleonardo.environment.ctrl.editor.DialogCommand;
import nickyb.sqleonardo.environment.mdi.ClientQueryBuilder;
import nickyb.sqleonardo.environment.mdi.MDIActions;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.environment.mdi._ConnectionListener;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.SQLParser;

public class ClientCommandEditor
extends MDIClient
implements _ConnectionListener {
    public static final String DEFAULT_TITLE = "command editor";
    private CommandEditor control = new CommandEditor();
    private JMenuItem[] m_actions;
    private Toolbar toolbar;
    private JComboBox cbx;

    public ClientCommandEditor() {
        super(DEFAULT_TITLE);
        this.setComponentCenter(this.control);
        this.control.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.createToolbar();
        this.initMenuActions();
        Application.window.addListener(this);
    }

    private void createToolbar() {
        this.cbx = new JComboBox<Object>(ConnectionAssistant.getHandlers().toArray());
        this.toolbar = new Toolbar(0);
        this.toolbar.add(new ActionOpen());
        this.toolbar.add(new ActionSave());
        this.toolbar.addSeparator();
        this.toolbar.add(this.control.getActionMap().get("start-task"));
        this.toolbar.add(this.control.getActionMap().get("stop-task"));
        this.toolbar.addSeparator();
        this.toolbar.add(new JLabel("use connection: "));
        this.toolbar.add(this.cbx);
        this.setComponentEast(this.toolbar);
    }

    private void initMenuActions() {
        this.m_actions = new JMenuItem[]{new JMenuItem(new ActionCommand()), null, new JMenuItem(new ActionClearInput()), new JMenuItem(new ActionClearOutput()), null, new JMenuItem(new ActionReverseSyntax())};
    }

    public final CommandEditor getControl() {
        return this.control;
    }

    public JMenuItem[] getMenuActions() {
        return this.m_actions;
    }

    public Toolbar getSubToolbar() {
        return this.toolbar;
    }

    public final String getName() {
        return DEFAULT_TITLE;
    }

    protected void setPreferences() {
    }

    public void onConnectionClosed(String keycah) {
        this.cbx.removeItem(keycah);
    }

    public void onConnectionOpened(String keycah) {
        this.cbx.addItem(keycah);
    }

    public String getActiveConnection() {
        return this.cbx.getSelectedIndex() == -1 ? null : this.cbx.getSelectedItem().toString();
    }

    public void setActiveConnection(String keycah) {
        this.cbx.setSelectedItem(keycah);
    }

    private class ActionReverseSyntax
    extends AbstractAction {
        ActionReverseSyntax() {
            this.putValue("Name", "reverse syntax");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientCommandEditor.this.getActiveConnection() == null) {
                Application.alert("SQLeonardo", "No connection!");
                return;
            }
            String sql = ClientCommandEditor.this.control.getSelectedText();
            if (Text.isEmpty(sql)) {
                Application.alert("SQLeonardo", "Nothing selected!");
                return;
            }
            try {
                ConnectionHandler ch;
                ArrayList schemas;
                QueryModel qm = SQLParser.toQueryModel(sql);
                if (!Preferences.getBoolean("querybuilder.use-schema") && (schemas = (ArrayList)(ch = ConnectionAssistant.getHandler(ClientCommandEditor.this.getActiveConnection())).getObject("$schema_names")).size() > 0) {
                    Object schema = JOptionPane.showInputDialog(Application.window, "schema:", "SQLeonardo", -1, null, schemas.toArray(), null);
                    if (schema == null) {
                        return;
                    }
                    qm.setSchema(schema.toString());
                }
                ClientQueryBuilder cqb = new ClientQueryBuilder(ClientCommandEditor.this.getActiveConnection());
                Application.window.add(cqb);
                cqb.setModel(qm);
            }
            catch (IOException e) {
                Application.println(e, true);
            }
        }
    }

    private class ActionSave
    extends MDIActions.AbstractBase {
        private ActionSave() {
            this.setIcon("icon.111");
            this.setTooltip("save");
        }

        public void actionPerformed(ActionEvent ae) {
            String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(currentDirectory);
            fc.setFileSelectionMode(0);
            fc.setFileFilter(new FileFilter(this){
                private final /* synthetic */ ActionSave this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".sql");
                }

                public String getDescription() {
                    return "script files (*.sql)";
                }
            });
            if (fc.showSaveDialog(Application.window) == 0) {
                Preferences.set("lastDirectory", fc.getCurrentDirectory().toString());
                String filename = fc.getSelectedFile().toString();
                if (fc.getFileFilter().getDescription().endsWith("(*.sql)") && !filename.endsWith(".sql")) {
                    filename = filename + ".sql";
                }
                this.save(filename);
            }
        }

        private void save(String filename) {
            try {
                Document doc = ClientCommandEditor.this.control.getDocument();
                FileWriter out = new FileWriter(filename);
                out.write(doc.getText(0, doc.getLength()));
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (BadLocationException ble) {
                Application.println(ble, false);
            }
            catch (IOException ioe) {
                Application.println(ioe, false);
            }
        }
    }

    private class ActionOpen
    extends MDIActions.AbstractBase {
        private ActionOpen() {
            this.setIcon("icon.110");
            this.setTooltip("open");
        }

        public void actionPerformed(ActionEvent ae) {
            String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(currentDirectory);
            fc.setFileSelectionMode(0);
            fc.setMultiSelectionEnabled(true);
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".sql");
                }

                public String getDescription() {
                    return "script files (*.sql)";
                }
            });
            if (fc.showOpenDialog(Application.window) == 0) {
                Preferences.set("lastDirectory", fc.getCurrentDirectory().toString());
                PlainDocument doc = new PlainDocument();
                for (int i = 0; i < fc.getSelectedFiles().length; ++i) {
                    String filename = fc.getSelectedFiles()[i].toString();
                    try {
                        this.load(doc, filename);
                        doc.insertString(doc.getLength(), "\n", null);
                        continue;
                    }
                    catch (BadLocationException ble) {
                        Application.println(ble, false);
                        continue;
                    }
                    catch (IOException ioe) {
                        Application.println(ioe, false);
                    }
                }
                ClientCommandEditor.this.control.setDocument(doc);
            }
        }

        private void load(PlainDocument doc, String filename) throws IOException, BadLocationException {
            int nch;
            FileReader in = new FileReader(filename);
            char[] buff = new char[4096];
            while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                doc.insertString(doc.getLength(), new String(buff, 0, nch), null);
            }
            ((Reader)in).close();
        }
    }

    private class ActionClearOutput
    extends AbstractAction {
        ActionClearOutput() {
            this.putValue("Name", "clear response area");
        }

        public void actionPerformed(ActionEvent ae) {
            ClientCommandEditor.this.control.clearResponse();
        }
    }

    private class ActionClearInput
    extends AbstractAction {
        ActionClearInput() {
            this.putValue("Name", "clear request area");
        }

        public void actionPerformed(ActionEvent ae) {
            ClientCommandEditor.this.control.setDocument(new PlainDocument());
        }
    }

    private class ActionCommand
    extends AbstractAction {
        ActionCommand() {
            this.putValue("Name", "new command...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientCommandEditor.this.getActiveConnection() != null) {
                new DialogCommand(ClientCommandEditor.this.getActiveConnection(), null).show();
            } else {
                Application.alert("SQLeonardo", "No connection!");
            }
        }
    }
}

