/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.io.File;
import javax.swing.JFileChooser;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;
import net.charabia.jsmoothgen.application.gui.util.SortedEditableList;

public class EditableListFileEditor
implements SortedEditableList.Editor {
    private File m_rootDir;
    private JFileChooser m_fileChooser = new JFileChooser();

    public void setFileChooser(JFileChooser chooser) {
        this.m_fileChooser = chooser;
    }

    public JFileChooser getFileChooser() {
        return this.m_fileChooser;
    }

    public void setRootDir(File dir) {
        this.m_rootDir = dir;
        this.m_fileChooser.setCurrentDirectory(dir);
    }

    public File getRootDir() {
        return this.m_rootDir;
    }

    public Object createNewItem(SortedEditableList selist) {
        if (this.m_fileChooser.showOpenDialog(selist) == 0) {
            File[] files = this.m_fileChooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (this.m_rootDir == null) continue;
                files[i] = f = JSmoothModelPersistency.makePathRelativeIfPossible(this.m_rootDir, f);
            }
            return files;
        }
        return null;
    }

    public Object editItem(SortedEditableList selist, Object item) {
        this.m_fileChooser.setSelectedFile((File)item);
        if (this.m_fileChooser.showOpenDialog(selist) == 0) {
            File f = this.m_fileChooser.getSelectedFile();
            if (this.m_rootDir != null) {
                f = JSmoothModelPersistency.makePathRelativeIfPossible(this.m_rootDir, f);
            }
            return f;
        }
        return null;
    }

    public boolean removeItem(SortedEditableList selist, Object item) {
        return true;
    }
}

