/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.net.xmlrpc.RPCServerProxy;
import groovy.net.xmlrpc.XMLRPCCallFailureException;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;

public class XMLRPCServerProxy
extends RPCServerProxy {
    static final String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    private URL serverURL;

    public XMLRPCServerProxy(String serverURL) throws MalformedURLException {
        this.serverURL = new URL(serverURL);
    }

    public Object invokeMethod(String name, Object args) {
        if ("invokeMethod".equals(name)) {
            return super.invokeMethod(name, args);
        }
        Object[] params = args instanceof List ? ((List)args).toArray() : (Object[])args;
        int numberOfParams = params.length;
        if (numberOfParams != 0 && params[numberOfParams - 1] instanceof Closure) {
            --numberOfParams;
        }
        try {
            byte[] request = XMLRPCMessageProcessor.emitCall(new StringBuffer(xmlDeclaration), name, params, numberOfParams).toString().getBytes("ISO-8859-1");
            URLConnection connection = this.serverURL.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setAllowUserInteraction(false);
            connection.setRequestProperty("Content-Length", Integer.toString(request.length));
            connection.setRequestProperty("Content-Type", "text/xml");
            OutputStream requestStream = connection.getOutputStream();
            requestStream.write(request);
            requestStream.flush();
            requestStream.close();
            XMLRPCMessageProcessor responseParser = new XMLRPCMessageProcessor();
            try {
                responseParser.parseMessage(connection.getInputStream());
            }
            catch (XMLRPCFailException e) {
                throw new XMLRPCCallFailureException((Object)e.getFaultString(), new Integer(e.getFaultCode()));
            }
            List response = responseParser.getParams();
            if (response == null) {
                throw new XMLRPCCallFailureException((Object)"Empty response from server", new Integer(0));
            }
            if (numberOfParams == params.length) {
                return response.get(0);
            }
            Closure closure = (Closure)params[numberOfParams];
            closure.setDelegate(this);
            return closure.call(new Object[]{response.get(0)});
        }
        catch (IOException e) {
            throw new XMLRPCCallFailureException((Object)e.getMessage(), new Integer(0));
        }
        catch (XMLRPCFailException e) {
            throw new XMLRPCCallFailureException((Object)e.getFaultString(), (Object)e.getCause());
        }
    }
}

