/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.http;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import uk.co.wilson.net.MinMLSocketServer;
import uk.co.wilson.net.MinMLThreadPool;
import uk.co.wilson.net.http.MinMLHTTPServer;

public class HTTPServer
extends GroovyObjectSupport {
    protected static final byte[] userAgent = "User-Agent: Groovy Simple Web Server\r\n".getBytes();
    private final int minWorkers;
    private final int maxWorkers;
    private final int maxKeepAlives;
    private final int workerIdleLife;
    private final int socketReadTimeout;
    private MinMLSocketServer server = null;
    private Closure getClosure = null;
    private Closure headClosure = null;
    private Closure postClosure = null;
    private Closure putClosure = null;

    public HTTPServer(int minWorkers, int maxWorkers, int maxKeepAlives, int workerIdleLife, int socketReadTimeout) {
        this.minWorkers = minWorkers;
        this.maxWorkers = maxWorkers;
        this.maxKeepAlives = maxKeepAlives;
        this.workerIdleLife = workerIdleLife;
        this.socketReadTimeout = socketReadTimeout;
    }

    public HTTPServer() {
        this(2, 10, 8, 60000, 60000);
    }

    public void setProperty(String property, Object newValue) {
        if ("get".equalsIgnoreCase(property) && newValue instanceof Closure) {
            this.getClosure = (Closure)((Closure)newValue).clone();
        } else if ("head".equalsIgnoreCase(property) && newValue instanceof Closure) {
            this.headClosure = (Closure)((Closure)newValue).clone();
        } else if ("post".equalsIgnoreCase(property) && newValue instanceof Closure) {
            this.postClosure = (Closure)((Closure)newValue).clone();
        } else if ("put".equalsIgnoreCase(property) && newValue instanceof Closure) {
            this.putClosure = (Closure)((Closure)newValue).clone();
        } else {
            super.setProperty(property, newValue);
        }
    }

    public void startServer(ServerSocket serverSocket) throws IOException {
        if (this.server != null) {
            this.stopServer();
        }
        final MinMLHTTPServer server = new MinMLHTTPServer(serverSocket, this.minWorkers, this.maxWorkers, this.maxKeepAlives, this.workerIdleLife, this.socketReadTimeout){

            protected MinMLThreadPool.Worker makeNewWorker() {
                return new MinMLHTTPServer.HTTPWorker(){

                    protected void processGet(InputStream in, OutputStream out, String uri, String version) throws Exception {
                        out.write(version.getBytes());
                        out.write(okMessage);
                        out.write(userAgent);
                        out.write(host);
                        if (HTTPServer.this.getClosure != null) {
                            HTTPServer.this.getClosure.call(new Object[]{in, out, uri, version});
                        }
                    }

                    protected void processHead(InputStream in, OutputStream out, String uri, String version) throws Exception {
                        out.write(version.getBytes());
                        out.write(okMessage);
                        out.write(userAgent);
                        out.write(host);
                        if (HTTPServer.this.headClosure != null) {
                            HTTPServer.this.headClosure.call(new Object[]{in, out, uri, version});
                        }
                    }

                    protected void processPost(InputStream in, OutputStream out, String uri, String version) throws Exception {
                        out.write(version.getBytes());
                        out.write(okMessage);
                        out.write(userAgent);
                        out.write(host);
                        if (HTTPServer.this.postClosure != null) {
                            HTTPServer.this.postClosure.call(new Object[]{in, out, uri, version});
                        }
                    }

                    protected void processPut(InputStream in, OutputStream out, String uri, String version) throws Exception {
                        out.write(version.getBytes());
                        out.write(okMessage);
                        out.write(userAgent);
                        out.write(host);
                        if (HTTPServer.this.putClosure != null) {
                            HTTPServer.this.putClosure.call(new Object[]{in, out, uri, version});
                        }
                    }
                };
            }
        };
        this.server = server;
        Thread startingThread = new Thread(){

            public void run() {
                server.start();
            }
        };
        startingThread.setDaemon(false);
        startingThread.setName("HTTP Server main thread");
        startingThread.start();
    }

    public void stopServer() throws IOException {
        this.server.shutDown();
    }
}

