/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Literal;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

public class Id
extends ExpBase
implements Cloneable {
    private final String[] names;
    private final boolean[] keys;

    Id(String s, boolean key) {
        this.names = new String[]{s};
        this.keys = new boolean[]{key};
    }

    Id(String s) {
        this(s, false);
    }

    private Id(String[] names, boolean[] keys) {
        this.names = names;
        this.keys = keys;
    }

    public Object clone() {
        return this;
    }

    public int getCategory() {
        return 0;
    }

    public Type getTypeX() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return Util.quoteMdxIdentifier(this.toStringArray());
    }

    public String[] toStringArray() {
        return (String[])this.names.clone();
    }

    public String getElement(int i) {
        return this.names[i];
    }

    public Id append(String s, boolean key) {
        String[] newNames = new String[this.names.length + 1];
        boolean[] newKeys = new boolean[this.keys.length + 1];
        System.arraycopy(this.names, 0, newNames, 0, this.names.length);
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        newNames[newNames.length - 1] = s;
        newKeys[newKeys.length - 1] = key;
        return new Id(newNames, newKeys);
    }

    public void append(String s) {
        this.append(s, false);
    }

    public Exp accept(Validator validator) {
        Exp element;
        if (this.names.length == 1) {
            String s = this.names[0];
            if (validator.getFunTable().isReserved(s)) {
                return Literal.createSymbol(s.toUpperCase());
            }
        }
        if ((element = Util.lookup(validator.getQuery(), this.names, true)) == null) {
            return null;
        }
        return element.accept(validator);
    }

    public void unparse(PrintWriter pw) {
        for (int i = 0; i < this.names.length; ++i) {
            String s = this.names[i];
            if (i > 0) {
                pw.print(".");
            }
            if (this.keys[i]) {
                pw.print("&[" + Util.mdxEncodeString(s) + "]");
                continue;
            }
            pw.print("[" + Util.mdxEncodeString(s) + "]");
        }
    }

    public Object evaluate(Evaluator evaluator) {
        return evaluator.visit(this);
    }

    public boolean dependsOn(Dimension dimension) {
        throw new UnsupportedOperationException();
    }
}

