/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.QueryPart;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

public class FunCall
extends ExpBase {
    private final String fun;
    private Exp[] args;
    private FunDef funDef;
    private final Syntax syntax;
    private Type type;

    public FunCall(String fun, Exp[] args) {
        this(fun, Syntax.Function, args);
    }

    public FunCall(String fun, Syntax syntax, Exp[] args) {
        this.fun = fun;
        this.args = args;
        this.syntax = syntax;
        if (syntax == Syntax.Braces) {
            Util.assertTrue(fun.equals("{}"));
        } else if (syntax == Syntax.Parentheses) {
            Util.assertTrue(fun.equals("()"));
        } else if (syntax == Syntax.Internal) {
            Util.assertTrue(fun.startsWith("$"));
        } else {
            Util.assertTrue(!fun.startsWith("$") && !fun.equals("{}") && !fun.equals("()"));
        }
    }

    public Object clone() {
        return new FunCall(this.fun, this.syntax, ExpBase.cloneArray(this.args));
    }

    public String getFunName() {
        return this.fun;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public Exp getArg(int index) {
        return this.args[index];
    }

    public Exp[] getArgs() {
        return this.args;
    }

    public final int getArgCount() {
        return this.args.length;
    }

    public final boolean isCallTo(String funName) {
        return this.fun.equalsIgnoreCase(funName);
    }

    public boolean isCallToTuple() {
        return this.getSyntax() == Syntax.Parentheses;
    }

    public boolean isCallToCrossJoin() {
        return this.fun.equalsIgnoreCase("CROSSJOIN") || this.fun.equals("*");
    }

    public Object[] getChildren() {
        return this.args;
    }

    public void replaceChild(int i, QueryPart with) {
        this.args[i] = (Exp)((Object)with);
    }

    public void removeChild(int iPosition) {
        Exp[] newArgs = new Exp[this.args.length - 1];
        int j = 0;
        for (int i = 0; i < this.args.length; ++i) {
            if (i == iPosition) {
                ++i;
            }
            if (j != newArgs.length) {
                newArgs[j] = this.args[i];
            }
            ++j;
        }
        this.args = newArgs;
    }

    public FunDef getFunDef() {
        return this.funDef;
    }

    public final int getCategory() {
        return this.funDef.getReturnCategory();
    }

    public final Type getTypeX() {
        return this.type;
    }

    public Exp accept(Validator validator) {
        FunTable funTable = validator.getFunTable();
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = validator.validate(this.args[i], false);
        }
        this.funDef = funTable.getDef(this, validator);
        return this.funDef.validateCall(validator, this);
    }

    public void unparse(PrintWriter pw) {
        this.funDef.unparse(this.args, pw);
    }

    public int addAtPosition(Exp e, int iPosition) {
        if (this.isCallToCrossJoin()) {
            Exp left = this.args[0];
            Exp right = this.args[1];
            int nLeft = left.addAtPosition(e, iPosition);
            if (nLeft == -1) {
                return -1;
            }
            if (nLeft == iPosition) {
                this.args[0] = new FunCall("CrossJoin", Syntax.Function, new Exp[]{left, e});
                return -1;
            }
            Util.assertTrue(nLeft < iPosition, "left tree had enough dimensions, yet still failed to place expression");
            int nRight = right.addAtPosition(e, iPosition - nLeft);
            return nRight == -1 ? -1 : nLeft + nRight;
        }
        if (this.isCallToTuple()) {
            Exp[] newArgs = new Exp[this.args.length + 1];
            if (iPosition == 0) {
                newArgs[0] = e;
                for (int i = 0; i < this.args.length; ++i) {
                    newArgs[i + 1] = this.args[i];
                }
            } else if (iPosition < 0 || iPosition >= this.args.length) {
                for (int i = 0; i < this.args.length; ++i) {
                    newArgs[i] = this.args[i];
                }
                newArgs[this.args.length] = e;
            } else {
                int i;
                for (i = 0; i < iPosition; ++i) {
                    newArgs[i] = this.args[i];
                }
                newArgs[iPosition] = e;
                for (i = iPosition + 1; i < newArgs.length; ++i) {
                    newArgs[i] = this.args[i - 1];
                }
            }
            this.args = newArgs;
            return -1;
        }
        if (this.getSyntax() == Syntax.Braces && this.args[0] instanceof FunCall && ((FunCall)this.args[0]).isCallToTuple()) {
            return 1;
        }
        return this.args[0].addAtPosition(e, iPosition);
    }

    public Object evaluate(Evaluator evaluator) {
        return evaluator.visit(this);
    }

    public boolean dependsOn(Dimension dimension) {
        return this.funDef.callDependsOn(this, dimension);
    }

    public void setType(Type type) {
        this.type = type;
    }
}

