/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.skeleton;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import net.charabia.jsmoothgen.skeleton.SkeletonProperty;

public class SkeletonPropertyEditor
extends JPanel {
    private SkelPropTableModel m_model;
    private Vector m_columnNames = new Vector();
    private JScrollPane jScrollPane1;
    private JMenuItem m_menuAddItem;
    private JMenuItem m_menuRemoveItem;
    private JPopupMenu m_popupMenu;
    private JTable m_table;
    static /* synthetic */ Class class$java$lang$Object;

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Id";
            }
            case 1: {
                return "Label";
            }
            case 2: {
                return "Description";
            }
            case 3: {
                return "Type";
            }
            case 4: {
                return "Value";
            }
        }
        return "pouet";
    }

    public SkeletonPropertyEditor() {
        this.m_model = new SkelPropTableModel();
        this.initComponents();
        this.m_table.setModel(this.m_model);
    }

    public void setModel(SkeletonProperty[] sprops) {
        if (sprops == null) {
            sprops = new SkeletonProperty[]{};
        }
        SkelPropTableModel model = new SkelPropTableModel(sprops);
        this.m_table.setModel(model);
        this.m_model = model;
        this.m_table.createDefaultColumnsFromModel();
        TableColumn type = this.m_table.getColumnModel().getColumn(3);
        type.setHeaderValue("POUET");
        JComboBox<String> typeCombo = new JComboBox<String>();
        typeCombo.addItem(SkeletonProperty.TYPE_STRING);
        typeCombo.addItem(SkeletonProperty.TYPE_TEXTAREA);
        typeCombo.addItem(SkeletonProperty.TYPE_BOOLEAN);
        type.setCellEditor(new DefaultCellEditor(typeCombo));
    }

    private void initComponents() {
        this.m_popupMenu = new JPopupMenu();
        this.m_menuAddItem = new JMenuItem();
        this.m_menuRemoveItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.m_table = new JTable();
        this.m_menuAddItem.setText("Add item");
        this.m_menuAddItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonPropertyEditor.this.m_menuAddItemActionPerformed(evt);
            }
        });
        this.m_popupMenu.add(this.m_menuAddItem);
        this.m_menuRemoveItem.setText("RemoveItems");
        this.m_menuRemoveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonPropertyEditor.this.m_menuRemoveItemActionPerformed(evt);
            }
        });
        this.m_popupMenu.add(this.m_menuRemoveItem);
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.m_table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.m_table.setTableHeader(null);
        this.m_table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SkeletonPropertyEditor.this.tableMousePressed(evt);
            }

            public void mousePressed(MouseEvent evt) {
                SkeletonPropertyEditor.this.tableMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                SkeletonPropertyEditor.this.tableMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.m_table);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void m_menuRemoveItemActionPerformed(ActionEvent evt) {
        int selr = this.m_table.getSelectedRow();
        if (selr != -1) {
            this.m_model.removeRow(selr);
        }
    }

    private void m_menuAddItemActionPerformed(ActionEvent evt) {
        SkeletonProperty prop = new SkeletonProperty();
        int selr = this.m_table.getSelectedRow();
        if (selr >= 0) {
            this.m_model.add(prop, selr);
        } else {
            this.m_model.add(prop);
        }
    }

    private void tableMousePressed(MouseEvent evt) {
        System.out.println("pressed !");
        if (evt.isPopupTrigger()) {
            System.out.println("trigger !");
            this.showPopupMenu(evt);
        }
    }

    public void showPopupMenu(MouseEvent evt) {
        int r = this.m_table.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (r != -1) {
            this.m_table.setRowSelectionInterval(r, r);
        }
        this.m_popupMenu.show(this, evt.getX(), evt.getY());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SkelPropTableModel
    extends AbstractTableModel {
        Vector m_props = new Vector();

        public SkelPropTableModel(SkeletonProperty[] props) {
            for (int i = 0; i < props.length; ++i) {
                this.m_props.add(props[i]);
            }
        }

        public SkelPropTableModel() {
            this.m_props.add(new SkeletonProperty());
        }

        public void add(SkeletonProperty prop) {
            this.m_props.addElement(prop);
            this.fireTableRowsInserted(this.m_props.size() - 1, this.m_props.size());
            this.fireTableStructureChanged();
        }

        public void add(SkeletonProperty prop, int row) {
            this.m_props.insertElementAt(prop, row);
            this.fireTableRowsInserted(row, row);
            this.fireTableStructureChanged();
        }

        public void removeRow(int row) {
            this.m_props.removeElementAt(row);
            this.fireTableRowsDeleted(row, row);
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$Object == null ? (class$java$lang$Object = SkeletonPropertyEditor.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public String getColumnName(int column) {
            return "TEST";
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this.m_props.size();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            SkeletonProperty sp = (SkeletonProperty)this.m_props.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return sp.getIdName();
                }
                case 1: {
                    return sp.getLabel();
                }
                case 2: {
                    return sp.getDescription();
                }
                case 3: {
                    return sp.getType();
                }
                case 4: {
                    return sp.getValue();
                }
            }
            return "";
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            SkeletonProperty sp = (SkeletonProperty)this.m_props.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    sp.setIdName(aValue.toString());
                    break;
                }
                case 1: {
                    sp.setLabel(aValue.toString());
                    break;
                }
                case 2: {
                    sp.setDescription(aValue.toString());
                    break;
                }
                case 3: {
                    sp.setType(aValue.toString());
                    break;
                }
                case 4: {
                    sp.setValue(aValue.toString());
                }
            }
        }
    }
}

