/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.mdxbuilder.dnd.TransferableMdxBuilderTreeNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.DefaultMBTArgNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTFunctionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTPopUpActions;
import rex.graphics.mdxeditor.mdxfunctions.MdxFunction;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MBTArgSetNode
extends DefaultMBTArgNode
implements LanguageChangedListener {
    private static String childrenIndent = "  ";
    static ImageIcon icon = S.getAppIcon("MBTArgSetNode.gif");

    public MBTArgSetNode() {
        I18n.addOnLanguageChangedListener(this);
    }

    public MBTArgSetNode(String _argName) {
        super(false, _argName, false);
        I18n.addOnLanguageChangedListener(this);
    }

    public MBTArgSetNode(String _argName, boolean _respawnArg) {
        super(false, _argName, _respawnArg);
        I18n.addOnLanguageChangedListener(this);
    }

    public MBTArgSetNode(boolean _isHeadArg, String _argName) {
        super(_isHeadArg, _argName, false);
        I18n.addOnLanguageChangedListener(this);
    }

    public MBTArgSetNode(boolean _isHeadArg, String _argName, boolean _respawnArg, boolean _optionalArg) {
        super(_isHeadArg, _argName, _respawnArg, _optionalArg);
        I18n.addOnLanguageChangedListener(this);
    }

    public String getToolTip() {
        return "SET NODE:" + this.getArgName();
    }

    public String getMdx(String indent) {
        if (this.getChildren() == null) {
            return "";
        }
        StringBuffer mdx = new StringBuffer("");
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (mdx.length() == 0) {
                mdx.append(this.getChild(i).getMdx(indent + childrenIndent));
                continue;
            }
            mdx.append("\n" + this.addCommaAfterBlanks(this.getChild(i).getMdx(indent + childrenIndent)));
        }
        if (mdx.indexOf("\n") == -1) {
            return indent + "{" + mdx.toString().trim() + "}";
        }
        return indent + "{" + "\n" + mdx + "\n" + indent + "}";
    }

    void setAcceptableFlavorsArray() {
        this.acceptableFlavorsMimeTypes = new String[]{TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_LEVEL_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_DIMENSION_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_HIERARCHY_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_MEASURE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.DIMENSION_TREE_NODE_MEMBER_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_SET_FUNCTION_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_NAMED_SET_NODE_FLAVOR_STRING, TransferableMdxBuilderTreeNode.MDX_BUILDER_TREE_CALCULATED_MEMBER_NODE_FLAVOR_STRING};
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public void handleDrop(Object droppedData, DefaultMutableTreeNode containerNode, DefaultTreeModel treeModel) {
        if (droppedData instanceof MdxFunction) {
            this.addMdxFunctionChild((MdxFunction)droppedData, containerNode, treeModel);
        } else if (droppedData instanceof MBTFunctionNode) {
            this.moveMBTFunctionNode((MBTFunctionNode)droppedData, containerNode, treeModel);
        } else if (droppedData instanceof DimensionTreeElement) {
            if (this.membersFromDifferentDimensionPresent(this, ((DimensionTreeElement)droppedData).getDimensionUniqueName()) > 0) {
                JOptionPane.showMessageDialog(null, I18n.getString("msgText.setMember"), I18n.getString("msgTitle.addMember"), 1);
            } else {
                try {
                    this.addChildAndMBTMembersNode(droppedData, containerNode, treeModel);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                this.addChildAndMBTMembersNode(droppedData, containerNode, treeModel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.maybeRespawnOnDrop(containerNode, treeModel);
    }

    public String[] getPopUpActionList() {
        return new String[]{MBTPopUpActions.DELETE_CHILDREN};
    }

    public void handlePopUpAction(String action, DefaultMutableTreeNode actionNode, DefaultTreeModel treeModel) {
        if (action.equals(MBTPopUpActions.DELETE_CHILDREN)) {
            this.removeAllChildrenFromTheTree(actionNode, treeModel);
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        MBTPopUpActions.popUpCaptions.put(MBTPopUpActions.DELETE_CHILDREN, I18n.getString("menu.deleteChildren"));
    }
}

