/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.Collection;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.view.JRDesignViewer;
import net.sf.jasperreports.view.JRPreviewBuilder;

public class JasperDesignViewer
extends JFrame {
    private JRDesignViewer viewer = null;
    private boolean isExitOnClose = true;
    protected JasperPrint jasperPrint;
    private JPanel pnlMain;

    public JasperDesignViewer(String sourceFile, boolean isXMLFile) throws JRException {
        this(sourceFile, isXMLFile, true);
    }

    public JasperDesignViewer(InputStream is, boolean isXMLFile) throws JRException {
        this(is, isXMLFile, true);
    }

    public JasperDesignViewer(JasperPrint jasperPrint) {
        this(jasperPrint, true);
    }

    public JasperDesignViewer(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(sourceFile, isXMLFile, isExitOnClose, null);
    }

    public JasperDesignViewer(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this(is, isXMLFile, isExitOnClose, null);
    }

    public JasperDesignViewer(JasperPrint jasperPrint, boolean isExitOnClose) {
        this(jasperPrint, isExitOnClose, null);
    }

    public JasperDesignViewer(String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.loadReport(sourceFile, isXMLFile);
        this.viewer = new JRDesignViewer(this.jasperPrint, isXMLFile, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperDesignViewer(InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.loadReport(is, isXMLFile);
        this.viewer = new JRDesignViewer(this.jasperPrint, isXMLFile, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperDesignViewer(JasperPrint jrPrint, boolean isExitOnClose, Locale locale) {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRDesignViewer(jrPrint, locale);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    private void initComponents() {
        int width;
        this.pnlMain = new JPanel();
        this.setTitle("JasperViewer");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/jricon.GIF")).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JasperDesignViewer.this.exitForm();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenResolution = toolkit.getScreenResolution();
        float zoom = (float)screenResolution / 72.0f;
        int height = (int)(550.0f * zoom);
        if ((double)height > screenSize.getHeight()) {
            height = (int)screenSize.getHeight();
        }
        if ((double)(width = (int)(750.0f * zoom)) > screenSize.getWidth()) {
            width = (int)screenSize.getWidth();
        }
        Dimension dimension = new Dimension(width, height);
        this.setSize(dimension);
        this.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
    }

    void exitForm() {
        if (this.isExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.viewer.clear();
            this.viewer = null;
            this.getContentPane().removeAll();
            this.dispose();
        }
    }

    public void setZoomRatio(float zoomRatio) {
        this.viewer.setZoomRatio(zoomRatio);
    }

    public void setFitWidthZoomRatio() {
        this.viewer.setFitWidthZoomRatio();
    }

    public void setFitPageZoomRatio() {
        this.viewer.setFitPageZoomRatio();
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        if (args.length == 0) {
            JasperDesignViewer.usage();
            return;
        }
        for (int k = 0; args.length > k; ++k) {
            if (args[k].startsWith("-F")) {
                fileName = args[k].substring(2);
            }
            if (!args[k].startsWith("-XML")) continue;
            isXMLFile = true;
        }
        try {
            JasperDesignViewer.viewReport(fileName, isXMLFile);
        }
        catch (JRException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("JasperViewer usage:");
        System.out.println("\tjava JasperViewer -XML -Ffile");
    }

    public static void viewReport(String sourceFile, boolean isXMLFile) throws JRException {
        JasperDesignViewer.viewReport(sourceFile, isXMLFile, true, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile) throws JRException {
        JasperDesignViewer.viewReport(is, isXMLFile, true, null);
    }

    public static void viewReport(JasperPrint jasperPrint) {
        JasperDesignViewer.viewReport(jasperPrint, true, null);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperDesignViewer.viewReport(sourceFile, isXMLFile, isExitOnClose, null);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperDesignViewer.viewReport(is, isXMLFile, isExitOnClose, null);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose) {
        JasperDesignViewer.viewReport(jasperPrint, isExitOnClose, null);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        JasperDesignViewer jasperViewer = new JasperDesignViewer(sourceFile, isXMLFile, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose, Locale locale) throws JRException {
        JasperDesignViewer jasperViewer = new JasperDesignViewer(is, isXMLFile, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose, Locale locale) {
        JasperDesignViewer jasperViewer = new JasperDesignViewer(jasperPrint, isExitOnClose, locale);
        jasperViewer.setVisible(true);
    }

    private void loadReport(String fileName, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(fileName);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(fileName));
        }
    }

    private void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        if (isXmlReport) {
            JasperDesign jasperDesign = JRXmlLoader.load(is);
            this.setReport(jasperDesign);
        } else {
            this.setReport((JRReport)JRLoader.loadObject(is));
        }
    }

    private void loadReport(JRReport rep) throws JRException {
        this.setReport(rep);
    }

    private void setReport(JRReport report) throws JRException {
        if (report instanceof JasperDesign) {
            this.verifyDesign((JasperDesign)report);
        }
        this.jasperPrint = new JRPreviewBuilder(report).getJasperPrint();
    }

    private void verifyDesign(JasperDesign jasperDesign) throws JRException {
        Collection brokenRules = JasperCompileManager.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            throw new JRValidationException(brokenRules);
        }
    }
}

