/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import net.sf.jasperreports.engine.JRAbstractRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRTypeSniffer;

public class JRImageRenderer
extends JRAbstractRenderer {
    private static final long serialVersionUID = 10200L;
    private byte[] imageData = null;
    private String imageLocation = null;
    private byte onErrorType = 1;
    private byte imageType = 0;
    private transient SoftReference awtImageRef = null;

    private JRImageRenderer(byte[] imageData, byte onErrorType) {
        this.imageData = imageData;
        this.onErrorType = onErrorType;
        if (imageData != null) {
            this.imageType = JRTypeSniffer.getImageType(imageData);
        }
    }

    private JRImageRenderer(String imageLocation, byte onErrorType) {
        this.imageLocation = imageLocation;
        this.onErrorType = onErrorType;
    }

    public static ClassLoader getClassLoader() {
        return JRResourcesUtil.getThreadClassLoader();
    }

    public static void setClassLoader(ClassLoader classLoader) {
        JRResourcesUtil.setThreadClassLoader(classLoader);
    }

    public static JRImageRenderer getInstance(byte[] imageData) {
        return JRImageRenderer.getInstance(imageData, (byte)1);
    }

    public static JRImageRenderer getInstance(byte[] imageData, byte onErrorType) {
        return new JRImageRenderer(imageData, onErrorType);
    }

    public static JRRenderable getInstance(String imageLocation) throws JRException {
        return JRImageRenderer.getInstance(imageLocation, (byte)1, true);
    }

    public static JRRenderable getInstance(String imageLocation, byte onErrorType) throws JRException {
        return JRImageRenderer.getInstance(imageLocation, onErrorType, true);
    }

    public static JRRenderable getInstance(String imageLocation, byte onErrorType, boolean isLazy) throws JRException {
        return JRImageRenderer.getInstance(imageLocation, onErrorType, isLazy, null, null);
    }

    public static JRRenderable getInstance(String imageLocation, byte onErrorType, boolean isLazy, ClassLoader classLoader) throws JRException {
        return JRImageRenderer.getInstance(imageLocation, onErrorType, isLazy, classLoader);
    }

    public static JRRenderable getInstance(String imageLocation, byte onErrorType, boolean isLazy, ClassLoader classLoader, URLStreamHandlerFactory urlHandlerFactory) throws JRException {
        if (imageLocation == null) {
            return null;
        }
        if (isLazy) {
            return new JRImageRenderer(imageLocation, onErrorType);
        }
        try {
            byte[] data = JRLoader.loadBytesFromLocation(imageLocation, classLoader, urlHandlerFactory);
            return new JRImageRenderer(data, onErrorType);
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getInstance(Image img, byte onErrorType) throws JRException {
        return JRImageRenderer.getInstance(img, (byte)2, onErrorType);
    }

    public static JRRenderable getInstance(Image image, byte imageType, byte onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRImageLoader.loadImageDataFromAWTImage(image, imageType), onErrorType);
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getInstance(InputStream is, byte onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(is), onErrorType);
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getInstance(URL url, byte onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(url), onErrorType);
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    public static JRRenderable getInstance(File file, byte onErrorType) throws JRException {
        try {
            return new JRImageRenderer(JRLoader.loadBytes(file), onErrorType);
        }
        catch (JRException e) {
            return JRImageRenderer.getOnErrorRenderer(onErrorType, e);
        }
    }

    private static JRImageRenderer getOnErrorRenderer(byte onErrorType, JRException e) throws JRException {
        JRImageRenderer renderer = null;
        switch (onErrorType) {
            case 3: {
                renderer = new JRImageRenderer("net/sf/jasperreports/engine/images/noimage.GIF", 1);
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw e;
            }
        }
        return renderer;
    }

    public Image getImage() throws JRException {
        Image awtImage = null;
        if (this.awtImageRef == null || this.awtImageRef.get() == null) {
            try {
                awtImage = JRImageLoader.loadImage(this.getImageData());
                this.awtImageRef = new SoftReference<Image>(awtImage);
            }
            catch (JRException e) {
                return JRImageRenderer.getOnErrorRenderer(this.onErrorType, e).getImage();
            }
        }
        return (Image)this.awtImageRef.get();
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public byte getType() {
        return 0;
    }

    public byte getImageType() {
        return this.imageType;
    }

    public Dimension2D getDimension() throws JRException {
        Image img = this.getImage();
        return new Dimension(img.getWidth(null), img.getHeight(null));
    }

    public byte[] getImageData() throws JRException {
        if (this.imageData == null) {
            try {
                this.imageData = JRLoader.loadBytesFromLocation(this.imageLocation);
            }
            catch (JRException e) {
                this.imageData = JRImageRenderer.getOnErrorRenderer(this.onErrorType, e).getImageData();
            }
        }
        return this.imageData;
    }

    public void render(Graphics2D grx, Rectangle2D rectanle) throws JRException {
        Image img = this.getImage();
        grx.drawImage(img, (int)rectanle.getX(), (int)rectanle.getY(), (int)rectanle.getWidth(), (int)rectanle.getHeight(), null);
    }
}

