/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.olap.type.CubeType;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

public class TypeUtil {
    public static Hierarchy typeToHierarchy(Type type) {
        if (type instanceof MemberType) {
            return ((MemberType)type).getHierarchy();
        }
        if (type instanceof LevelType) {
            return ((LevelType)type).getHierarchy();
        }
        if (type instanceof HierarchyType) {
            return ((HierarchyType)type).getHierarchy();
        }
        if (type instanceof DimensionType) {
            return ((DimensionType)type).getHierarchy();
        }
        throw Util.newInternal("not an mdx object");
    }

    public static Level typeToLevel(Type type) {
        if (type instanceof LevelType) {
            return ((LevelType)type).getLevel();
        }
        throw Util.newInternal("not an mdx object");
    }

    public static Type stripSetType(Type type) {
        while (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        return type;
    }

    public static Type toMemberType(Type type) {
        if ((type = TypeUtil.stripSetType(type)) instanceof DimensionType) {
            DimensionType dimensionType = (DimensionType)type;
            return new MemberType(dimensionType.getHierarchy(), dimensionType.getLevel(), null);
        }
        if (type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            return new MemberType(hierarchyType.getHierarchy(), hierarchyType.getLevel(), null);
        }
        if (type instanceof LevelType) {
            LevelType levelType = (LevelType)type;
            return new MemberType(levelType.getHierarchy(), levelType.getLevel(), null);
        }
        return type;
    }

    public static boolean isUnionCompatible(Type type1, Type type2) {
        if (type1 instanceof MemberType) {
            MemberType memberType1 = (MemberType)type1;
            if (type2 instanceof MemberType) {
                MemberType memberType2 = (MemberType)type2;
                Hierarchy hierarchy1 = memberType1.getHierarchy();
                Hierarchy hierarchy2 = memberType2.getHierarchy();
                if (hierarchy1 == null || hierarchy2 == null || hierarchy2.getUniqueName().equals(hierarchy1.getUniqueName())) {
                    return true;
                }
            }
            return false;
        }
        if (type1 instanceof TupleType) {
            TupleType tupleType1 = (TupleType)type1;
            if (type2 instanceof TupleType) {
                TupleType tupleType2 = (TupleType)type2;
                if (tupleType1.elementTypes.length == tupleType2.elementTypes.length) {
                    for (int i = 0; i < tupleType1.elementTypes.length; ++i) {
                        if (TypeUtil.isUnionCompatible(tupleType1.elementTypes[i], tupleType2.elementTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean canEvaluate(Type type) {
        return !(type instanceof SetType) && !(type instanceof CubeType) && !(type instanceof LevelType);
    }

    public static boolean isSet(Type type) {
        return type instanceof SetType;
    }
}

